/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCharStreamOnFileChunk;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseInputStreamOnFileChunk;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideInsensitive
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.24.1.1  $";
    boolean tempFilesAreReady = false;
    protected File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;
    int maxMem;
    BaseConnection connection;

    public BaseImplResultSetClientSideInsensitive(int n, BaseConnection baseConnection) {
        if (n == 0) {
            n = 0x200000;
        }
        this.maxMem = n;
        this.connection = baseConnection;
        this.rowDataBuff = new UtilPagedTempBuffer(n);
        this.rowPositionBuff = new UtilPagedTempBuffer(16);
        this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
    }

    public BaseImplResultSetClientSideInsensitive(BaseConnection baseConnection) {
        this(2048, baseConnection);
    }

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n) {
        this.maxLongDataSize = n;
    }

    private void setupTempFiles() throws SQLException {
        if (this.tempFilesAreReady) {
            return;
        }
        try {
            this.longDataFileHandle = UtilTempFile.createTempFile((String)"scb_");
            try {
                this.longDataFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideInsensitive.this.longDataFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            this.tempFilesAreReady = true;
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038, "TMPDIR");
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideInsensitive.this.longDataFileHandle.delete();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        boolean bl = this.fetch(n);
        if (bl) {
            this.fetch(n + 1);
        }
        if (bl) {
            bl = n > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n - 1);
        }
        return bl;
    }

    private boolean fetch(int n) throws SQLException {
        boolean bl = true;
        if (n > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n - this.rowsFetchedFromSubResultSet, false, 0);
        }
        return bl;
    }

    boolean fetchAndCache(int n, boolean bl, int n2) throws SQLException {
        boolean bl2 = true;
        for (int i = 0; bl2 && i < n; ++i) {
            if (this.endOfResultSetReached) {
                bl2 = false;
            } else if (!bl) {
                bl2 = this.subImplResultSet.next();
            }
            if (bl2) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow(n2);
                bl = false;
                n2 = 0;
                continue;
            }
            this.endOfResultSetReached = true;
            this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
        }
        return bl2;
    }

    void cacheCurrentRow(int n) throws SQLException {
        try {
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            for (int i = n; i < this.columns.count(0); ++i) {
                BaseColumn baseColumn = this.columns.get(i + 1);
                BaseData baseData = this.subImplResultSet.getData(i + 1, baseColumn.baseDataType);
                if (baseData.isNull()) {
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(-1);
                    continue;
                }
                if (baseData.getType() == 2 || baseData.getType() > 100 && baseData.getType() < 200) {
                    byte[] byArray = baseData.getBytesNoConvert();
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(byArray.length);
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                    if (baseData.getType() == 110) {
                        this.rowDataBuff.writeInt(baseData.getOracleTZScale());
                        this.rowDataBuff.writeInt(baseData.getOracleFetchTSWTZasTimestamp() ? 1 : 0);
                        continue;
                    }
                    if (baseData.getType() != 111) continue;
                    this.rowDataBuff.writeInt(baseData.getOracleTZHours());
                    this.rowDataBuff.writeInt(baseData.getOracleTZMinutes());
                    continue;
                }
                if (baseData.getType() == 15 || baseData.getType() == 17 || baseData.getType() == 14) {
                    this.cacheBinaryStream(baseData.getType(), (InputStream)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 19) {
                    this.cacheBlob((BaseImplBlob)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 18 || baseData.getType() == 16) {
                    this.cacheCharacterStream(18, (Reader)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 20) {
                    this.cacheClob((BaseImplClob)baseData.getObject());
                    continue;
                }
                this.rowDataBuff.writeInt(baseData.getType());
                String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                int n2 = string.length();
                this.rowDataBuff.writeInt(n2 * 2);
                int n3 = 0;
                while (n3 < n2) {
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n3) >>> 8 & 0xFF));
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n3++) >>> 0 & 0xFF));
                }
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039, "TMPDIR");
        }
    }

    private void cacheBinaryStream(int n, InputStream inputStream) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n2 = n == 17 ? (this.maxLongDataSize != 0 ? this.maxLongDataSize * 2 : 2048) : (this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024);
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray, 0, n2);
        while (n3 != -1) {
            this.longDataFile.write(byArray, 0, n3);
            l += (long)n3;
            if (this.maxLongDataSize != 0) {
                if (n3 >= n2) break;
                n2 = this.maxLongDataSize - (int)l;
            }
            n3 = inputStream.read(byArray, 0, n2);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheCharacterStream(int n, Reader reader) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n2 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n2];
        int n3 = reader.read(cArray, 0, n2);
        while (n3 != -1) {
            for (int i = 0; i < n3; ++i) {
                this.longDataFile.writeChar(cArray[i]);
            }
            l += (long)(n3 * 2);
            if (this.maxLongDataSize != 0) {
                if (n3 >= n2) break;
                n2 = this.maxLongDataSize - (int)(l / 2L);
            }
            n3 = reader.read(cArray, 0, n2);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(19);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.setupTempFiles();
        this.rowDataBuff.writeInt(20);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    boolean getCachedRow(int n) throws SQLException {
        boolean bl = false;
        try {
            long l = n * 8;
            long l2 = this.rowPositionBuff.readLong((long)((int)l));
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            block15: for (int i = 0; i < this.columns.count(0); ++i) {
                int n2;
                int n3;
                int n4 = this.rowDataBuff.readInt(l2);
                int n5 = this.rowDataBuff.readInt(l2 += 4L);
                if (n5 == -1) {
                    l2 += 4L;
                    this.rowData[i].setNull(n4);
                    continue;
                }
                if (n4 == 2) {
                    this.rowData[i].setBytes(this.rowDataBuff.read(l2 += 4L, n5));
                    l2 += (long)n5;
                    continue;
                }
                if (n4 > 100 && n4 < 200) {
                    byte[] byArray = this.rowDataBuff.read(l2 += 4L, n5);
                    l2 += (long)n5;
                    if (n4 == 110) {
                        n3 = this.rowDataBuff.readInt(l2);
                        n2 = this.rowDataBuff.readInt(l2 += 4L) == 1 ? 1 : 0;
                        l2 += 4L;
                        this.rowData[i].setNativeOracleTimestampWithTimeZone(byArray, byArray.length, n3, n2 != 0);
                        continue;
                    }
                    if (n4 == 111) {
                        n3 = this.rowDataBuff.readInt(l2);
                        n2 = this.rowDataBuff.readInt(l2 += 4L);
                        l2 += 4L;
                        this.rowData[i].setNativeOracleTimestampWithLocalTimeZone(byArray, byArray.length, n3, n2);
                        continue;
                    }
                    this.rowData[i].setNativeBytes(byArray, n5, n4);
                    continue;
                }
                if (n4 == 15 || n4 == 17 || n4 == 14) {
                    this.getCachedBinaryStream(n4, l2, this.rowData[i]);
                    l2 += 16L;
                    continue;
                }
                if (n4 == 18) {
                    this.getCachedCharStream(n4, l2, this.rowData[i]);
                    l2 += 16L;
                    continue;
                }
                if (n4 == 19) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l2), this.rowData[i]);
                    l2 += 8L;
                    continue;
                }
                if (n4 == 20) {
                    this.getCachedClob(this.rowDataBuff.readLong(l2), this.rowData[i]);
                    l2 += 8L;
                    continue;
                }
                l2 += 4L;
                stringBuffer.setLength(0);
                char c = '\u0000';
                int n6 = 0;
                while (n6 < n5) {
                    n3 = this.rowDataBuff.read(l2 + (long)n6++);
                    n2 = this.rowDataBuff.read(l2 + (long)n6++);
                    c = (char)(((n3 & 0xFF) << 8) + ((n2 & 0xFF) << 0));
                    stringBuffer.append(c);
                }
                l2 += (long)n5;
                if (n4 > 200) {
                    this.rowData[i].setNativeString(stringBuffer.toString(), n4);
                } else {
                    this.rowData[i].setString(stringBuffer.toString());
                }
                switch (n4) {
                    case 1: {
                        this.rowData[i].setByte(this.rowData[i].getByte(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 3: {
                        this.rowData[i].setShort(this.rowData[i].getShort(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 4: {
                        this.rowData[i].setInteger(this.rowData[i].getInteger(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 5: {
                        this.rowData[i].setLong(this.rowData[i].getLong(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 6: {
                        this.rowData[i].setFloat(this.rowData[i].getFloat(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 7: {
                        this.rowData[i].setDouble(this.rowData[i].getDouble(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 8: 
                    case 21: {
                        this.rowData[i].setBigDecimal(this.rowData[i].getBigDecimal(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 9: {
                        this.rowData[i].setBoolean(this.rowData[i].getBoolean(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 11: {
                        this.rowData[i].setDate(this.rowData[i].getDate(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 12: {
                        this.rowData[i].setTime(this.rowData[i].getTime(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 13: {
                        this.rowData[i].setTimestamp(this.rowData[i].getTimestamp(this.implStatement.implConnection.exceptions));
                    }
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
        return bl;
    }

    private void getCachedBinaryStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, l2, l3);
        baseData.setData(n, baseInputStreamOnFileChunk);
    }

    private void getCachedCharStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, l2, l3);
        baseData.setData(n, baseCharStreamOnFileChunk);
    }

    private void getCachedBlob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.setBlob(this.subImplResultSet.readBlob(this.longDataFile));
    }

    private void getCachedClob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.setClob(this.subImplResultSet.readClob(this.longDataFile));
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            for (int i = 0; i < this.columns.count(0); ++i) {
                BaseColumn baseColumn = this.columns.get(i + 1);
                this.rowData[i] = new BaseData(this.connection);
            }
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        BaseData baseData = this.rowData[n - 1];
        Object object = baseData.getObject();
        if (object instanceof BaseInputStreamOnFileChunk) {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = (BaseInputStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseInputStreamOnFileChunk(baseInputStreamOnFileChunk.file, baseInputStreamOnFileChunk.offset, baseInputStreamOnFileChunk.length));
        } else if (object instanceof BaseCharStreamOnFileChunk) {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = (BaseCharStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseCharStreamOnFileChunk(baseCharStreamOnFileChunk.file, baseCharStreamOnFileChunk.offset, baseCharStreamOnFileChunk.length));
        }
        return baseData;
    }

    public boolean setupForNextResultSetInMultipleResult(int n) throws SQLException {
        boolean bl = this.rowDataBuff.getSize() == 0L;
        boolean bl2 = n == -1;
        boolean bl3 = false;
        if (n == -1) {
            n = 0;
        }
        if (bl) {
            this.tempFilesAreReady = false;
            if (!bl2) {
                bl3 = true;
            }
        }
        this.fetchAndCache(Integer.MAX_VALUE, bl3, n);
        if (bl && !bl2) {
            this.getCachedRow(0);
            this.cursorPosition = 1;
        }
        return true;
    }
}

