/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class BaseColumnsImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   1.0.1.0  $";
    private BaseColumn[] resultSetMetaData;
    private String catalogName;
    private String tableOwner;
    private String tableName;

    public BaseColumnsImplResultSet(ResultSetMetaData resultSetMetaData, String string, String string2, String string3) throws SQLException {
        this.catalogName = string;
        this.tableOwner = string2;
        this.tableName = string3;
        this.cursorPosition = 0;
        this.resultSetMetaData = ((BaseResultSetMetaData)resultSetMetaData).columns.getColumnArray();
        this.maxCursorPosition = resultSetMetaData.getColumnCount();
    }

    public void close() throws SQLException {
        this.reset();
    }

    public int getColumnAccess() {
        return 2;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        BaseData baseData = new BaseData(null);
        BaseColumn baseColumn = this.resultSetMetaData[this.cursorPosition - 1];
        switch (n) {
            case 1: {
                baseData.setString(this.catalogName);
                break;
            }
            case 2: {
                baseData.setString(this.tableOwner);
                break;
            }
            case 3: {
                baseData.setString(this.tableName);
                break;
            }
            case 4: {
                baseData.setString(baseColumn.name);
                break;
            }
            case 5: {
                baseData.setInteger(baseColumn.type);
                break;
            }
            case 6: {
                baseData.setString(baseColumn.typeName.toUpperCase());
                break;
            }
            case 7: {
                baseData.setInteger(baseColumn.precision);
                break;
            }
            case 8: {
                baseData.setInteger(0);
                break;
            }
            case 9: {
                int n3 = baseColumn.type;
                if (n3 == 3 || n3 == 91 || n3 == 93) {
                    baseData.setInteger(baseColumn.scale);
                    break;
                }
                baseData.setNull(4);
                break;
            }
            case 10: {
                int n4 = baseColumn.type;
                if (n4 == 7 || n4 == 8 || n4 == 3) {
                    baseData.setInteger(10);
                    break;
                }
                baseData.setNull(4);
                break;
            }
            case 11: {
                baseData.setInteger(baseColumn.isNullable);
                break;
            }
            case 12: {
                baseData.setNull(1);
                break;
            }
            case 13: {
                baseData.setNull(1);
                break;
            }
            case 14: {
                baseData.setNull(4);
                break;
            }
            case 15: {
                baseData.setNull(4);
                break;
            }
            case 16: {
                int n5 = baseColumn.type;
                if (n5 == 1 || n5 == 2005 || n5 == 12 || n5 == -1) {
                    baseData.setInteger(baseColumn.precision);
                    break;
                }
                baseData.setNull(4);
                break;
            }
            case 17: {
                baseData.setInteger(this.cursorPosition);
                break;
            }
            case 18: {
                baseData.setString(baseColumn.isNullable == 1 ? "YES" : "NO");
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                baseData.setNull(1);
            }
        }
        return baseData;
    }
}

