/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.TupleSourceIterator;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.sql.util.ValueIteratorProvider;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SubqueryProcessorUtility {
    private List processorPlans;
    private List valueIteratorProviders;
    private List correlatedReferences;
    private int currentIndex = 0;
    private ProcessorPlan currentPlan;
    private TupleSourceID currentID;
    private List tupleSources = new ArrayList();

    SubqueryProcessorUtility() {
    }

    void setPlansAndValueProviders(List subqueryProcessorPlans, List valueIteratorProviders) {
        this.processorPlans = subqueryProcessorPlans;
        this.valueIteratorProviders = valueIteratorProviders;
    }

    void setCorrelatedReferences(List correlatedReferences) {
        this.correlatedReferences = correlatedReferences;
    }

    List getSubqueryPlans() {
        return this.processorPlans;
    }

    List getValueIteratorProviders() {
        return this.valueIteratorProviders;
    }

    List getCorrelatedReferences() {
        return this.correlatedReferences;
    }

    boolean acceptID(int nodeID) {
        if (this.currentPlan == null) {
            return false;
        }
        return this.currentPlan.canHandleData(nodeID);
    }

    void setTupleSource(TupleSource tupleSource, int nodeID) {
        this.currentPlan.connectTupleSource(tupleSource, nodeID);
    }

    void reset() {
        this.currentIndex = 0;
        this.currentPlan = null;
        this.currentID = null;
        for (int i = 0; i < this.processorPlans.size(); ++i) {
            ProcessorPlan plan = (ProcessorPlan)this.processorPlans.get(i);
            plan.reset();
        }
    }

    void open(CommandContext processorContext, int batchSize, ProcessorDataManager dataManager, BufferManager bufferManager) throws MetaMatrixComponentException {
        Iterator plans = this.processorPlans.iterator();
        while (plans.hasNext()) {
            ProcessorPlan plan = (ProcessorPlan)plans.next();
            CommandContext subContext = (CommandContext)processorContext.clone();
            subContext.setOutputBatchSize(batchSize);
            plan.initialize(subContext, dataManager, bufferManager);
        }
    }

    void close(BufferManager bufferManager) throws MetaMatrixComponentException {
        Iterator i = this.tupleSources.iterator();
        while (i.hasNext()) {
            TupleSourceID tsID = (TupleSourceID)i.next();
            try {
                bufferManager.removeTupleSource(tsID);
            }
            catch (TupleSourceNotFoundException e) {}
        }
        this.tupleSources.clear();
    }

    void process(Map elementMap, List currentTuple, BufferManager bufferManager, String groupName) throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.currentPlan == null && this.correlatedReferences != null) {
            this.close(bufferManager);
            Iterator refs = this.correlatedReferences.iterator();
            while (refs.hasNext()) {
                Reference ref = (Reference)refs.next();
                ref.setData(elementMap, currentTuple);
            }
        }
        while (this.currentPlan != null || this.currentIndex < this.processorPlans.size()) {
            TupleBatch batch;
            if (this.currentPlan == null) {
                this.currentPlan = (ProcessorPlan)this.processorPlans.get(this.currentIndex);
                List schema = this.currentPlan.getOutputElements();
                this.currentID = bufferManager.createTupleSource(schema, TypeRetrievalUtil.getTypeNames((List)schema), groupName, 1);
                this.tupleSources.add(this.currentID);
                this.currentPlan.open();
            }
            IndexedTupleSource subqueryResults = null;
            do {
                batch = this.currentPlan.nextBatch();
                SubqueryProcessorUtility.flushBatch(bufferManager, batch, this.currentID);
            } while (!batch.getTerminationFlag());
            this.currentPlan.close();
            this.currentPlan.reset();
            try {
                bufferManager.setStatus(this.currentID, 2);
                subqueryResults = bufferManager.getTupleSource(this.currentID);
            }
            catch (TupleSourceNotFoundException e) {
                throw new MetaMatrixComponentException("ERR.015.006.0029", QueryExecPlugin.Util.getString("ERR.015.006.0029", (Object)this.currentID));
            }
            ValueIteratorProvider vip = (ValueIteratorProvider)this.valueIteratorProviders.get(this.currentIndex);
            TupleSourceIterator iterator = new TupleSourceIterator(subqueryResults, 0);
            vip.setValueIterator((ValueIterator)iterator);
            this.currentID = null;
            this.currentPlan = null;
            ++this.currentIndex;
        }
        if (this.correlatedReferences != null) {
            this.currentIndex = 0;
        }
    }

    private static void flushBatch(BufferManager bufferManager, TupleBatch batch, TupleSourceID tsID) throws MetaMatrixComponentException {
        if (batch != null && batch.getRowCount() > 0) {
            try {
                bufferManager.addTupleBatch(tsID, batch);
            }
            catch (TupleSourceNotFoundException e) {
                throw new MetaMatrixComponentException("ERR.015.006.0029", QueryExecPlugin.Util.getString("ERR.015.006.0029", (Object)tsID));
            }
        }
    }
}

