/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.sqlserver;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.jdbcx.sqlserver.SQLServerImplXAResource;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilType4SecurityContext;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class SQLServerDataSource
extends BaseXADataSource {
    private static String footprint = "$Revision:   3.25.1.2  $";
    boolean alwaysReportTriggerResults = false;
    String authenticationMethod = "auto";
    String codePageOverride = "";
    boolean enableCancelTimeout = false;
    int hostProcess = 0;
    String netAddress = "000000000000";
    int packetSize = 127;
    int longDataCacheSize = 2048;
    String programName = "";
    String receiveStringParameterType = "nvarchar";
    String selectMethod = "direct";
    boolean sendStringParametersAsUnicode = true;
    boolean snapshotSerializable = false;
    String transactionMode = "implicit";
    String describeParameters = "noDescribe";
    boolean useServerSideUpdatableCursors = false;
    String WSID = "";
    String XATransactionGroup = "";
    String encryptionMethod = "";
    String trustStore = "";
    String trustStorePassword = "";
    boolean validateServerCertificate = true;
    String hostNameInCertificate = "";
    String XMLDescribeType = "LONGVARCHAR";
    int defaultScale = 4;

    public SQLServerDataSource() {
        this.setConnectionRetryCount(5);
        this.setAlternateServers("");
        this.setDatabaseName("");
        this.setBatchPerformanceWorkaround(false);
        this.setServerName("");
        this.setUser("");
        this.setResultsetMetaDataOptions(0);
        this.setJavaDoubleToString(false);
        this.setConnectionRetryDelay(1);
        this.setPassword("");
        this.setInsensitiveResultSetBufferSize(2048);
        this.setMaxPooledStatements(0);
        this.setPortNumber(1433);
        this.setLoadBalancing(false);
    }

    public boolean getAlwaysReportTriggerResults() {
        return this.alwaysReportTriggerResults;
    }

    public void setAlwaysReportTriggerResults(boolean bl) {
        this.alwaysReportTriggerResults = bl;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string;
    }

    public String getCodePageOverride() {
        return this.codePageOverride;
    }

    public void setCodePageOverride(String string) {
        this.codePageOverride = string;
    }

    public boolean getEnableCancelTimeout() {
        return this.enableCancelTimeout;
    }

    public void setEnableCancelTimeout(boolean bl) {
        this.enableCancelTimeout = bl;
    }

    public int getHostProcess() {
        return this.hostProcess;
    }

    public void setHostProcess(int n) {
        this.hostProcess = n;
    }

    public String getNetAddress() {
        return this.netAddress;
    }

    public void setNetAddress(String string) {
        this.netAddress = string;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int n) {
        this.packetSize = n;
    }

    public int getLongDataCacheSize() {
        return this.longDataCacheSize;
    }

    public void setLongDataCacheSize(int n) {
        this.longDataCacheSize = n < -1 ? 2048 : n;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String string) {
        this.programName = string;
    }

    public String getReceiveStringParameterType() {
        return this.receiveStringParameterType;
    }

    public void setReceiveStringParameterType(String string) {
        this.receiveStringParameterType = string;
    }

    public String getSelectMethod() {
        return this.selectMethod;
    }

    public void setSelectMethod(String string) {
        this.selectMethod = string;
    }

    public boolean getSendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    public void setSendStringParametersAsUnicode(boolean bl) {
        this.sendStringParametersAsUnicode = bl;
    }

    public boolean getSnapshotSerializable() {
        return this.snapshotSerializable;
    }

    public void setSnapshotSerializable(boolean bl) {
        this.snapshotSerializable = bl;
    }

    public String getTransactionMode() {
        return this.transactionMode;
    }

    public void setTransactionMode(String string) {
        this.transactionMode = string;
    }

    public String getDescribeParameters() {
        return this.describeParameters;
    }

    public void setDescribeParameters(String string) {
        this.describeParameters = string;
    }

    public boolean getUseServerSideUpdatableCursors() {
        return this.useServerSideUpdatableCursors;
    }

    public void setUseServerSideUpdatableCursors(boolean bl) {
        this.useServerSideUpdatableCursors = bl;
    }

    public String getWSID() {
        return this.WSID;
    }

    public void setWSID(String string) {
        this.WSID = string;
    }

    public String getXATransactionGroup() {
        return this.XATransactionGroup;
    }

    public void setXATransactionGroup(String string) {
        this.XATransactionGroup = string;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(String string) {
        this.encryptionMethod = string;
    }

    public final String getTrustStore() {
        return this.trustStore;
    }

    public final void setTrustStore(String string) {
        this.trustStore = string;
    }

    public final String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public final void setTrustStorePassword(String string) {
        this.trustStorePassword = string;
    }

    public final boolean getValidateServerCertificate() {
        return this.validateServerCertificate;
    }

    public final void setValidateServerCertificate(boolean bl) {
        this.validateServerCertificate = bl;
    }

    public String getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    public void setHostNameInCertificate(String string) {
        this.hostNameInCertificate = string;
    }

    public String getXMLDescribeType() {
        return this.XMLDescribeType;
    }

    public void setXMLDescribeType(String string) {
        this.XMLDescribeType = string == null ? "LONGVARCHAR" : string;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(int n) {
        this.defaultScale = n;
    }

    protected void implAddProperties(Reference reference) {
        try {
            reference.add(new StringRefAddr("alwaysReportTriggerResults", new Boolean(this.alwaysReportTriggerResults).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.authenticationMethod != null) {
            reference.add(new StringRefAddr("authenticationMethod", this.authenticationMethod));
        }
        if (this.codePageOverride != null) {
            reference.add(new StringRefAddr("codePageOverride", this.codePageOverride));
        }
        try {
            reference.add(new StringRefAddr("enableCancelTimeout", new Boolean(this.enableCancelTimeout).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reference.add(new StringRefAddr("hostProcess", Integer.toString(this.hostProcess)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.netAddress != null) {
            reference.add(new StringRefAddr("netAddress", this.netAddress));
        }
        try {
            reference.add(new StringRefAddr("packetSize", Integer.toString(this.packetSize)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.programName != null) {
            reference.add(new StringRefAddr("programName", this.programName));
        }
        if (this.receiveStringParameterType != null) {
            reference.add(new StringRefAddr("receiveStringParameterType", this.receiveStringParameterType));
        }
        if (this.selectMethod != null) {
            reference.add(new StringRefAddr("selectMethod", this.selectMethod));
        }
        try {
            reference.add(new StringRefAddr("sendStringParametersAsUnicode", new Boolean(this.sendStringParametersAsUnicode).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reference.add(new StringRefAddr("snapshotSerializable", new Boolean(this.snapshotSerializable).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.transactionMode != null) {
            reference.add(new StringRefAddr("transactionMode", this.transactionMode));
        }
        if (this.describeParameters != null) {
            reference.add(new StringRefAddr("describeParameters", this.describeParameters));
        }
        try {
            reference.add(new StringRefAddr("useServerSideUpdatableCursors", new Boolean(this.useServerSideUpdatableCursors).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.WSID != null) {
            reference.add(new StringRefAddr("WSID", this.WSID));
        }
        if (this.XATransactionGroup != null) {
            reference.add(new StringRefAddr("XATransactionGroup", this.XATransactionGroup));
        }
        if (this.encryptionMethod != null) {
            reference.add(new StringRefAddr("encryptionMethod", this.encryptionMethod));
        }
        if (this.trustStore != null) {
            reference.add(new StringRefAddr("trustStore", this.trustStore));
        }
        if (this.trustStorePassword != null) {
            reference.add(new StringRefAddr("trustStorePassword", this.trustStorePassword));
        }
        try {
            reference.add(new StringRefAddr("validateServerCertificate", new Boolean(this.validateServerCertificate).toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hostNameInCertificate != null) {
            reference.add(new StringRefAddr("hostNameInCertificate", this.hostNameInCertificate));
        }
        if (this.XMLDescribeType != null) {
            reference.add(new StringRefAddr("XMLDescribeType", this.XMLDescribeType));
        }
        try {
            reference.add(new StringRefAddr("longDataCacheSize", Integer.toString(this.longDataCacheSize)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reference.add(new StringRefAddr("defaultScale", Integer.toString(this.defaultScale)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String implGetPropertyNameValuePairs() throws SQLException {
        String string = "";
        try {
            string = string + "alwaysReportTriggerResults=" + new Boolean(this.alwaysReportTriggerResults).toString() + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.authenticationMethod != null) {
            string = string + "authenticationMethod=" + this.authenticationMethod + ";";
        }
        if (this.codePageOverride != null) {
            string = string + "codePageOverride=" + this.codePageOverride + ";";
        }
        try {
            string = string + "enableCancelTimeout=" + new Boolean(this.enableCancelTimeout).toString() + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + "hostProcess=" + Integer.toString(this.hostProcess) + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.netAddress != null) {
            string = string + "netAddress=" + this.netAddress + ";";
        }
        try {
            string = string + "packetSize=" + Integer.toString(this.packetSize) + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.programName != null) {
            string = string + "programName=" + this.programName + ";";
        }
        if (this.receiveStringParameterType != null) {
            string = string + "receiveStringParameterType=" + this.receiveStringParameterType + ";";
        }
        if (this.selectMethod != null) {
            string = string + "selectMethod=" + this.selectMethod + ";";
        }
        try {
            string = string + "sendStringParametersAsUnicode=" + new Boolean(this.sendStringParametersAsUnicode).toString() + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + "snapshotSerializable=" + new Boolean(this.snapshotSerializable).toString() + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.transactionMode != null) {
            string = string + "transactionMode=" + this.transactionMode + ";";
        }
        if (this.describeParameters != null) {
            string = string + "describeParameters=" + this.describeParameters + ";";
        }
        try {
            string = string + "useServerSideUpdatableCursors=" + new Boolean(this.useServerSideUpdatableCursors).toString() + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.WSID != null) {
            string = string + "WSID=" + this.WSID + ";";
        }
        if (this.XATransactionGroup != null) {
            string = string + "XATransactionGroup=" + this.XATransactionGroup + ";";
        }
        if (this.encryptionMethod != null) {
            string = string + "encryptionMethod=" + this.encryptionMethod + ";";
        }
        if (this.trustStore != null) {
            string = string + ";trustStore=" + this.trustStore;
        }
        if (this.trustStorePassword != null) {
            string = string + ";trustStorePassword=" + this.trustStorePassword;
        }
        if (this.hostNameInCertificate != null) {
            string = string + ";hostNameInCertificate=" + this.hostNameInCertificate + ";";
        }
        string = string == null ? "validateServerCertificate=" + this.validateServerCertificate : string + ";validateServerCertificate=" + this.validateServerCertificate;
        if (this.XMLDescribeType != null) {
            string = string + ";XMLDescribeType=" + this.XMLDescribeType;
        }
        try {
            string = string + ";longDataCacheSize=" + Integer.toString(this.longDataCacheSize) + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + ";defaultScale=" + Integer.toString(this.defaultScale) + ";";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected BaseImplXAResource createImplXAResource(BaseConnection baseConnection) {
        return new SQLServerImplXAResource(this, baseConnection);
    }

    public String getAuthenticatedUser(String string) {
        String string2 = "MSSQLSvc/" + this.getServerName() + ":" + this.getPortNumber();
        if (this.authenticationMethod.equalsIgnoreCase("ntlm")) {
            return "";
        }
        if (this.authenticationMethod.equalsIgnoreCase("kerberos")) {
            return UtilType4SecurityContext.getPrincipalName();
        }
        if (string != null && string.length() > 0) {
            return "";
        }
        if (this.authenticationMethod.equalsIgnoreCase("type2")) {
            return "";
        }
        if (this.authenticationMethod.equalsIgnoreCase("type4")) {
            return UtilType4SecurityContext.getPrincipalName();
        }
        if (this.authenticationMethod.equalsIgnoreCase("none") || this.authenticationMethod.equalsIgnoreCase("UserIdPassword")) {
            return "";
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                UtilSecurityContextCreator.createType2SecurityContext((String)string2, (String)this.getLoadLibraryPath());
                return "";
            }
            catch (UtilException utilException) {
                return UtilType4SecurityContext.getPrincipalName();
            }
        }
        return UtilType4SecurityContext.getPrincipalName();
    }
}

