/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public abstract class TDSRPCExecuteRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   3.19.1.0  $";
    protected boolean isPreparedStatement;
    protected String sql;
    protected TDSRPCParameter userParamDefinitionsParam;
    protected TDSRPCParameter stmtParam;
    private static final int FOR_PREPARED_EXECUTE = 0;
    private static final int FOR_UNPREPARED_EXECUTE = 1;

    public TDSRPCExecuteRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, boolean bl) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter);
        this.isPreparedStatement = bl;
        this.prepareSubmitted = false;
        this.sql = null;
        this.createRPCParameters();
    }

    public void createUserParameters(UtilVectorUnsynced utilVectorUnsynced, int n, boolean bl, int n2) {
        this.baseParamSets = utilVectorUnsynced;
        this.maxPrecision = n;
        this.sendStringParametersAsUnicode = bl;
        this.receiveStringParameterType = n2;
        if (utilVectorUnsynced == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)utilVectorUnsynced.get(0);
        int n3 = baseParameters.count();
        for (int i = 1; i <= n3; ++i) {
            this.addUserParameter(new TDSRPCParameter(this.conn, n));
        }
    }

    public final void setSQL(String string) {
        this.sql = string;
    }

    protected void createRPCParameters() {
        this.stmtParam = new TDSRPCParameter(this.conn, this.maxPrecision);
        this.prepareHandleParam = new TDSRPCParameter(this.conn, this.maxPrecision);
        this.userParamDefinitionsParam = new TDSRPCParameter(this.conn, this.maxPrecision);
    }

    public void reset() {
        super.reset();
        this.prepareSubmitted = false;
    }

    protected void doPrepExec(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        if (this.conn.getTDSVersion() == 1) {
            this.submitPrepare(sQLServerImplStatement, baseWarnings);
            this.submitExecute(sQLServerImplStatement, baseWarnings);
        } else {
            this.submitPrepExec(sQLServerImplStatement, baseWarnings);
        }
    }

    protected abstract void setupExecute(BaseWarnings var1) throws SQLException;

    protected abstract void setupUnpreparedExecute(BaseWarnings var1) throws SQLException;

    protected abstract void submitPrepare(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitPrepExec(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitExecute(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    protected abstract void submitUnpreparedExecute(SQLServerImplStatement var1, BaseWarnings var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        String string = null;
        if (this.prepareSubmitted && this.prepareHandleParam.data.isNull) {
            this.readPrepareHandle(baseWarnings);
        }
        if (this.baseParamSets != null && this.baseParamSets.size() > 1) {
            SQLException sQLException = null;
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                int n;
                int n2 = this.baseParamSets.size();
                for (n = 0; n < n2; ++n) {
                    BaseParameters baseParameters = (BaseParameters)this.baseParamSets.get(n);
                    try {
                        this.processUserParameters(baseParameters);
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                        break;
                    }
                    if (this.prepareHandleParam.data.isNull) {
                        string = this.createParameterFormatString(0);
                        this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                        this.submitPrepare(sQLServerImplStatement, baseWarnings);
                        this.reset();
                        this.setupExecute(baseWarnings);
                    } else if (this.hasParmameterFormatStringChangedSincePrepare()) {
                        string = this.createParameterFormatString(1);
                        this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                        this.setupUnpreparedExecute(baseWarnings);
                    } else {
                        this.setupExecute(baseWarnings);
                    }
                    this.encodeRPCCall(n == 0);
                }
                if (n > 0) {
                    this.submitRequest(sQLServerImplStatement);
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
        } else if (this.isPreparedStatement) {
            if (this.baseParamSets != null) {
                this.processUserParameters((BaseParameters)this.baseParamSets.get(0));
            }
            if (this.prepareHandleParam.data.isNull) {
                string = this.createParameterFormatString(0);
                this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                this.doPrepExec(sQLServerImplStatement, baseWarnings);
                this.prepareSubmitted = true;
            } else if (this.hasParmameterFormatStringChangedSincePrepare()) {
                string = this.createParameterFormatString(1);
                this.userParamDefinitionsParam.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, string);
                this.submitUnpreparedExecute(sQLServerImplStatement, baseWarnings);
            } else {
                this.submitExecute(sQLServerImplStatement, baseWarnings);
            }
        } else {
            this.submitUnpreparedExecute(sQLServerImplStatement, baseWarnings);
        }
    }

    private void processUserParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null) {
            return;
        }
        int n = baseParameters.count();
        TDSRPCParameter tDSRPCParameter = null;
        for (int i = 1; i <= n; ++i) {
            tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(i - 1);
            tDSRPCParameter.initializeUserParam(i, baseParameters, this.sendStringParametersAsUnicode, this.receiveStringParameterType);
        }
    }

    private boolean hasParmameterFormatStringChangedSincePrepare() {
        if (this.prepareHandleParam.data.isNull) {
            return true;
        }
        int n = this.userParameters.size();
        for (int i = 1; i <= n; ++i) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(i - 1);
            if (!tDSRPCParameter.hasStateChanged()) continue;
            return true;
        }
        return false;
    }

    private String createParameterFormatString(int n) {
        int n2 = this.userParameters.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n2; ++i) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.get(i - 1);
            if (n == 0) {
                tDSRPCParameter.recordState();
            }
            if (i != 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(tDSRPCParameter.paramName);
            stringBuffer.append(" ");
            stringBuffer.append(tDSRPCParameter.nativeTypeName);
        }
        return stringBuffer.toString();
    }
}

