/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.EndPoint;
import com.metamatrix.sequelink.net.EndPointGenerator;
import com.metamatrix.sequelink.net.NetAttributes;
import com.metamatrix.sequelink.net.NetMessage;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.tools.LogInputOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Properties;

public class TrEndPoint {
    private static final int kSTA_INACTIVE = 0;
    private static final int kSTA_XFER = 1;
    private static final int kSTA_INREL = 2;
    private static final int kSTA_ENDED = 3;
    private static final int kSTA_ABORTED = 4;
    private EndPoint endPoint;
    private InputStream eis;
    private DataInput dis;
    private OutputStream eos;
    private DataOutput dos;
    public int state = 0;

    TrEndPoint() {
    }

    public final void connect(NetAttributes netAttributes) throws NetworkException {
        int n;
        if (this.state != 0) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        try {
            n = netAttributes.getPortNumberAsInt();
        }
        catch (NumberFormatException numberFormatException) {
            NetworkException networkException = NetMessage.Message.getNetworkException(7722);
            NetworkException networkException2 = new NetworkException(numberFormatException.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
        Properties properties = new Properties();
        String string = netAttributes.getCipherSuites();
        if (string != null) {
            properties.put("ciphersuites", string);
        }
        if ((string = netAttributes.getCertificateCheck()) != null) {
            properties.put("certificatecheck", string);
        }
        if ((string = netAttributes.getSSLDebug()) != null) {
            properties.put("ssldebug", string);
        }
        if ((string = netAttributes.getSSLVersions()) != null) {
            properties.put("sslversions", string);
        }
        this.endPoint = EndPointGenerator.MakeEndPoint(netAttributes.getNetworkProtocol(), netAttributes.getServerName(), n, properties);
        try {
            this.eos = this.endPoint.getOutputStream();
            this.eis = this.endPoint.getInputStream();
        }
        catch (NetworkException networkException) {
            this.close();
            networkException.fillInStackTrace();
            throw networkException;
        }
        this.dos = new DataOutputStream(this.eos);
        this.dis = new DataInputStream(this.eis);
        String string2 = netAttributes.getSequeLinkLogFile();
        if (string2 != null) {
            LogInputOutputStream logInputOutputStream = new LogInputOutputStream(string2, (DataInputStream)this.dis, (DataOutputStream)this.dos);
            this.dos = logInputOutputStream;
            this.dis = logInputOutputStream;
        }
        this.state = 1;
    }

    public final void close() throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        this.endPoint.close();
        this.state = 3;
    }

    private final void abort() {
        this.state = 4;
    }

    public final void recv(byte[] byArray, int n, int n2) throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        if (n < 0) {
            throw NetMessage.Message.getNetworkException(7723);
        }
        if (n2 <= 0) {
            throw NetMessage.Message.getNetworkException(7724);
        }
        if (n + n2 > byArray.length) {
            throw NetMessage.Message.getNetworkException(7725);
        }
        try {
            this.dis.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.abort();
            NetworkException networkException = NetMessage.Message.getNetworkException(7726);
            NetworkException networkException2 = new NetworkException(iOException.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
    }

    public final void recv(byte[] byArray) throws NetworkException {
        this.recv(byArray, 0, byArray.length);
    }

    public final void send(byte[] byArray, int n) throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        try {
            this.dos.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            this.abort();
            NetworkException networkException = NetMessage.Message.getNetworkException(7727);
            NetworkException networkException2 = new NetworkException(iOException.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
    }

    public InetAddress getLocalAddress() throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        return this.endPoint.getLocalAddress();
    }

    public int getLocalPort() throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        return this.endPoint.getLocalPort();
    }

    public InetAddress getRemoteAddress() throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        return this.endPoint.getInetAddress();
    }

    public int getRemotePort() throws NetworkException {
        if (this.state != 1) {
            throw NetMessage.Message.getNetworkException(7721);
        }
        return this.endPoint.getPort();
    }

    public int available() throws NetworkException {
        int n;
        DataInputStream dataInputStream = new DataInputStream((InputStream)((Object)this.dis));
        try {
            n = dataInputStream.available();
        }
        catch (IOException iOException) {
            this.abort();
            NetworkException networkException = NetMessage.Message.getNetworkException(7728);
            NetworkException networkException2 = new NetworkException(iOException.toString());
            networkException.setNextException(networkException2);
            throw networkException;
        }
        return n;
    }
}

