/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net.ssl;

import com.metamatrix.sequelink.net.EndPoint;
import com.metamatrix.sequelink.net.NetMessage;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.ServerEndPoint;
import com.metamatrix.sequelink.net.ssl.IAIKSSLEndPoint;
import com.metamatrix.sequelink.security.SLCrypto;
import com.metamatrix.sequelink.util.InputDialog;
import com.metamatrix.sequelink.util.Port;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLServerSocket;
import iaik.security.ssl.SSLSocket;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class IAIKSSLServerEndPoint
implements ServerEndPoint {
    private SSLServerContext serverContext;
    private SSLServerSocket serverSocket;
    private String serverCertFile;
    private String privateKeyFile;
    private OutputStream debugStream;
    private boolean isClosed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAIKSSLServerEndPoint(int n2, int n3, Properties properties) throws NetworkException {
        CertificateFactory certificateFactory;
        X509Certificate[] x509CertificateArray;
        SLCrypto.init();
        this.serverContext = new SSLServerContext();
        CipherSuite[] cipherSuiteArray = IAIKSSLEndPoint.MakeSuiteList(properties.getProperty("ciphersuites"));
        this.serverContext.setEnabledCipherSuites(cipherSuiteArray);
        int[] nArray = IAIKSSLEndPoint.MakeVersionsList(properties.getProperty("sslversions"));
        this.serverContext.setAllowedProtocolVersions(nArray[0], nArray[1]);
        this.serverContext.setRandomGenerator(SLCrypto.getRandom());
        this.checkProperties(cipherSuiteArray, properties);
        if (this.serverCertFile != null) {
            try {
                Object object;
                x509CertificateArray = null;
                certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
                FileInputStream fileInputStream = new FileInputStream(this.serverCertFile);
                try {
                    object = certificateFactory.generateCertificates(fileInputStream);
                    Object[] objectArray = object.toArray();
                    x509CertificateArray = new X509Certificate[objectArray.length];
                    for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                        x509CertificateArray[i2] = (X509Certificate)objectArray[i2];
                    }
                    x509CertificateArray = IAIKSSLServerEndPoint.orderCertificateChain(x509CertificateArray);
                }
                catch (CertificateException certificateException) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fileInputStream = new FileInputStream(this.serverCertFile);
                    x509CertificateArray = new X509Certificate[]{(X509Certificate)certificateFactory.generateCertificate(fileInputStream)};
                }
                finally {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception) {}
                }
                object = this.getPrivateKey(properties, this.privateKeyFile);
                this.serverContext.addServerCredentials(x509CertificateArray, (PrivateKey)object);
            }
            catch (CertificateException certificateException) {
                NetworkException networkException = NetMessage.Message.getSSLNetworkException(certificateException.getMessage(), 7932);
                throw networkException;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                NetworkException networkException = NetMessage.Message.getSSLNetworkException(noSuchProviderException.getMessage(), 7932);
                throw networkException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                NetworkException networkException = NetMessage.Message.getSSLNetworkException(fileNotFoundException.getMessage(), 7932);
                throw networkException;
            }
        }
        try {
            this.serverSocket = new SSLServerSocket(n2, n3, this.serverContext);
            this.isClosed = false;
        }
        catch (IOException iOException) {
            certificateFactory = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7925);
            throw certificateFactory;
        }
        x509CertificateArray = properties.getProperty("ssldebug");
        if ("true".equalsIgnoreCase((String)x509CertificateArray) || "1".equals(x509CertificateArray)) {
            this.setDebugStream(System.out);
        }
    }

    public EndPoint accept() throws NetworkException {
        try {
            SSLSocket sSLSocket = (SSLSocket)this.serverSocket.accept();
            if (this.debugStream != null) {
                sSLSocket.setDebugStream(this.debugStream);
            }
            try {
                return new IAIKSSLEndPoint(sSLSocket);
            }
            catch (NetworkException networkException) {
                try {
                    sSLSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw networkException;
            }
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7927);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw NetMessage.Message.getSSLNetworkException(nullPointerException.toString(), 7921);
        }
    }

    public synchronized void close() throws NetworkException {
        try {
            this.serverSocket.close();
            this.isClosed = true;
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7926);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw NetMessage.Message.getSSLNetworkException(nullPointerException.toString(), 7921);
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public void setDebugStream(OutputStream outputStream) throws NetworkException {
        this.debugStream = outputStream;
    }

    private void checkProperties(CipherSuite[] cipherSuiteArray, Properties properties) throws NetworkException {
        boolean bl = false;
        boolean bl2 = false;
        CipherSuiteList cipherSuiteList = new CipherSuiteList(CipherSuite.CS_RSA);
        cipherSuiteList.add(CipherSuite.CS_RSA_EXPORT);
        cipherSuiteList.add(CipherSuite.CS_RSA_EXPORT1024);
        cipherSuiteList.add(CipherSuite.CS_RSA_WITH_NULL);
        CipherSuiteList cipherSuiteList2 = new CipherSuiteList(CipherSuite.CS_DHE_DSS);
        cipherSuiteList2.add(CipherSuite.CS_DHE_DSS_EXPORT);
        cipherSuiteList2.add(CipherSuite.CS_DHE_DSS_EXPORT1024);
        for (int i2 = cipherSuiteArray.length - 1; i2 >= 0; --i2) {
            if (cipherSuiteList2.contains(cipherSuiteArray[i2])) {
                bl2 = true;
                break;
            }
            if (!cipherSuiteList.contains(cipherSuiteArray[i2])) continue;
            bl = true;
            break;
        }
        if (bl && bl2) {
            throw NetMessage.Message.getSSLNetworkException(7940);
        }
        if (bl2) {
            String string = properties.getProperty("DSS_certificate");
            if (string == null || "".compareTo(string) == 0) {
                throw NetMessage.Message.getSSLNetworkException(7942);
            }
            string = properties.getProperty("DSS_privatekey");
            if (string == null || "".compareTo(string) == 0) {
                throw NetMessage.Message.getSSLNetworkException(7943);
            }
            string = properties.getProperty("RSA_certificate");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7946);
            }
            string = properties.getProperty("RSA_privatekey");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7947);
            }
            this.serverCertFile = properties.getProperty("DSS_certificate");
            this.privateKeyFile = properties.getProperty("DSS_privatekey");
        } else if (bl) {
            String string = properties.getProperty("RSA_certificate");
            if (string == null || "".compareTo(string) == 0) {
                throw NetMessage.Message.getSSLNetworkException(7944);
            }
            string = properties.getProperty("RSA_privatekey");
            if (string == null || "".compareTo(string) == 0) {
                throw NetMessage.Message.getSSLNetworkException(7945);
            }
            string = properties.getProperty("DSS_certificate");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7948);
            }
            string = properties.getProperty("DSS_privatekey");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7949);
            }
            this.serverCertFile = properties.getProperty("RSA_certificate");
            this.privateKeyFile = properties.getProperty("RSA_privatekey");
        } else {
            String string = properties.getProperty("RSA_certificate");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7946);
            }
            string = properties.getProperty("RSA_privatekey");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7947);
            }
            string = properties.getProperty("DSS_certificate");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7948);
            }
            string = properties.getProperty("DSS_privatekey");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7949);
            }
            string = properties.getProperty("passphrasedialog");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7950);
            }
            string = properties.getProperty("passphrase");
            if (string != null) {
                throw NetMessage.Message.getSSLNetworkException(7951);
            }
            this.serverCertFile = null;
            this.privateKeyFile = null;
        }
        if (properties.getProperty("passphrase") != null && properties.getProperty("passphrasedialog") != null) {
            throw NetMessage.Message.getSSLNetworkException(7952);
        }
    }

    private void erasePrivateKey(byte[] byArray) {
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateKey getPrivateKey(Properties properties, String string) throws NetworkException {
        try {
            String string2 = this.getPassphrase(properties);
            if (string2 == null) {
                FileInputStream fileInputStream = new FileInputStream(string);
                ASN1 aSN1 = new ASN1((InputStream)fileInputStream);
                ASN1Object aSN1Object = aSN1.toASN1Object();
                PrivateKey privateKey = PrivateKeyInfo.getPrivateKey((ASN1Object)aSN1Object);
                ((InputStream)fileInputStream).close();
                if (privateKey != null) return privateKey;
                throw NetMessage.Message.getSSLNetworkException(7938);
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((InputStream)fileInputStream);
                PrivateKey privateKey = encryptedPrivateKeyInfo.decrypt(string2);
                ((InputStream)fileInputStream).close();
                PrivateKey privateKey2 = privateKey;
                return privateKey2;
            }
            finally {
                string2 = null;
                System.gc();
            }
        }
        catch (CodingException codingException) {
            codingException.printStackTrace();
            throw NetMessage.Message.getSSLNetworkException(codingException.getMessage(), 7939);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw NetMessage.Message.getSSLNetworkException(noSuchAlgorithmException.getMessage(), 7939);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw NetMessage.Message.getSSLNetworkException(invalidKeyException.getMessage(), 7939);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            throw NetMessage.Message.getSSLNetworkException(generalSecurityException.getMessage(), 7939);
        }
        catch (IOException iOException) {
            throw NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7939);
        }
    }

    private String getPassphrase(Properties properties) throws NetworkException {
        String string = properties.getProperty("passphrase");
        if (string != null) {
            if ("".equalsIgnoreCase(string)) {
                return null;
            }
            return string;
        }
        if ("NO".equalsIgnoreCase(properties.getProperty("passphrasedialog"))) {
            System.out.println(NetMessage.Message.getMessage("comline.epph"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (string == null || string.length() == 0) {
                    if (string != null) {
                        System.out.println(NetMessage.Message.getMessage("comline.reepph"));
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7937);
            }
            finally {
                bufferedReader = null;
                System.gc();
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                System.out.println();
            }
        } else {
            System.out.println(NetMessage.Message.getMessage("comline.epphid"));
            Port port = new Port();
            InputDialog inputDialog = new InputDialog(port, NetMessage.Message.getMessage("dialog.title"), NetMessage.Message.getMessage("dialog.message"), true);
            try {
                string = (String)port.recv();
            }
            catch (InterruptedException interruptedException) {
                throw NetMessage.Message.getSSLNetworkException(interruptedException.toString(), 7954);
            }
            finally {
                inputDialog.destroy();
                inputDialog = null;
                System.gc();
            }
        }
        if (string == null) {
            throw NetMessage.Message.getSSLNetworkException(7956);
        }
        return string;
    }

    private static X509Certificate[] orderCertificateChain(X509Certificate[] x509CertificateArray) throws NetworkException {
        int n2;
        Principal principal;
        int n3 = -1;
        block0: for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            principal = x509CertificateArray[i2].getSubjectDN();
            for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                if (i2 != n2 && ((Object)principal).equals(x509CertificateArray[n2].getIssuerDN())) continue block0;
            }
            n3 = i2;
            break;
        }
        if (n3 < 0) {
            throw NetMessage.Message.getSSLNetworkException(7957);
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
        x509CertificateArray2[0] = x509CertificateArray[n3];
        x509CertificateArray[n3] = null;
        principal = x509CertificateArray2[0].getIssuerDN();
        for (n2 = 1; n2 < x509CertificateArray.length; ++n2) {
            int n4;
            block6: {
                for (n4 = 0; n4 < x509CertificateArray.length; ++n4) {
                    if (x509CertificateArray[n4] == null || !((Object)principal).equals(x509CertificateArray[n4].getSubjectDN())) {
                        continue;
                    }
                    break block6;
                }
                throw NetMessage.Message.getSSLNetworkException(7957);
            }
            x509CertificateArray2[n2] = x509CertificateArray[n4];
            principal = x509CertificateArray[n4].getIssuerDN();
            x509CertificateArray[n4] = null;
        }
        return x509CertificateArray2;
    }
}

