/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetCrypto;
import com.metamatrix.sequelink.net.NetOutput;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.BufferManager;
import com.metamatrix.sequelink.util.OutputStreamOnByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NetOutputStream
extends NetOutput {
    private int preambleSize;
    protected byte[] buf;
    protected int begin;
    protected int end;
    protected int position;

    NetOutputStream(int n2) {
        this.preambleSize = n2;
        this.begin = n2;
        this.buf = BufferManager.GetBuffer();
        this.end = this.buf.length;
        this.position = n2;
    }

    public final void write(int n2) throws IOException {
        if (this.position >= this.end) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        this.buf[this.position++] = (byte)n2;
    }

    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        while (this.position + n3 > this.buf.length) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        System.arraycopy(byArray, n2, this.buf, this.position, n3);
        this.position += n3;
    }

    public final int write(InputStream inputStream, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        if (this.position == this.end) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        int n3 = Math.min(this.end - this.position, n2);
        n3 = inputStream.read(this.buf, this.position, n3);
        this.position += n3;
        return n3;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n2) throws IOException {
        if (n2 < this.begin) {
            throw new IOException();
        }
        if (n2 > this.end) {
            throw new IOException();
        }
        this.position = n2;
    }

    public final int getFreeSpace() {
        return this.end - this.position;
    }

    public int getIncrement() {
        return BufferManager.getIncrement();
    }

    final OutputStream getCurrentHeader() {
        return new OutputStreamOnByteArray(this.buf, 0, this.preambleSize);
    }

    final byte[] getCurrentBuffer() {
        return this.buf;
    }

    final void reset() {
        BufferManager.ReturnBuffer(this.buf);
        this.buf = BufferManager.GetBuffer();
        this.end = this.buf.length;
        this.position = this.preambleSize;
    }

    final int getSize() {
        return this.position - this.begin;
    }

    public void close() {
        if (this.buf != null) {
            BufferManager.ReturnBuffer(this.buf);
        }
        this.buf = null;
    }

    public void encrypt(NetCrypto netCrypto) throws NetworkException {
        int n2 = this.position - this.begin;
        int n3 = netCrypto.getEncryptionOutputSize(n2);
        if (this.buf.length < n3 + this.begin) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf, n3 + this.begin);
        }
        int n4 = netCrypto.encrypt(this.buf, this.begin, n2, this.buf, this.begin);
        this.position = n4 + this.begin;
    }
}

