/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.cert;

import com.metamatrix.sequelink.cert.CertificateCheckerInterface;
import com.metamatrix.sequelink.net.NetMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class AcceptAllCertificateChecker
implements CertificateCheckerInterface {
    public void checkCertificate(byte[][] byArray) throws SecurityException {
        if (byArray != null) {
            System.out.println(NetMessage.Message.getMessage("ssl.certaccepted"));
            CertificateFactory certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new SecurityException(NetMessage.Message.getMessage("ssl.err.parsecert", noSuchProviderException.toString()));
            }
            catch (CertificateException certificateException) {
                throw new SecurityException(NetMessage.Message.getMessage("ssl.err.parsecert", certificateException.toString()));
            }
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[i2]);
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    ((InputStream)byteArrayInputStream).close();
                    string = x509Certificate.getSubjectDN().getName();
                }
                catch (Exception exception) {
                    string = exception.toString();
                }
                System.out.println("    " + (i2 + 1) + ": " + string);
            }
        } else {
            System.out.println(NetMessage.Message.getMessage("ssl.nocert"));
        }
    }
}

