/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BasePreparedStatement;
import com.metamatrix.jdbc.slbase.BaseStatementPool;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BasePreparedStatementPoolable
implements Statement,
PreparedStatement {
    BasePreparedStatement realPreparedStatement;
    BaseStatementPool pool;
    BaseExceptions exceptions;

    BasePreparedStatementPoolable(BasePreparedStatement basePreparedStatement, BaseStatementPool baseStatementPool) {
        this.realPreparedStatement = basePreparedStatement;
        this.realPreparedStatement.cleanUpDuringFinalization = false;
        this.pool = baseStatementPool;
        this.exceptions = basePreparedStatement.exceptions;
    }

    protected SQLException closedException() {
        return this.exceptions.getException(6009);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            BaseConnection baseConnection = this.realPreparedStatement.connection;
            synchronized (baseConnection) {
                if (this.realPreparedStatement != null) {
                    this.pool.putPreparedStatement(this.realPreparedStatement);
                    this.realPreparedStatement = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.realPreparedStatement.executeQuery(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.realPreparedStatement.getMaxFieldSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        try {
            this.realPreparedStatement.setMaxFieldSize(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.realPreparedStatement.getMaxRows();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setMaxRows(int n2) throws SQLException {
        try {
            this.realPreparedStatement.setMaxRows(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setEscapeProcessing(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.realPreparedStatement.getQueryTimeout();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setQueryTimeout(int n2) throws SQLException {
        try {
            this.realPreparedStatement.setQueryTimeout(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void cancel() throws SQLException {
        try {
            this.realPreparedStatement.cancel();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realPreparedStatement.getWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realPreparedStatement.clearWarnings();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.realPreparedStatement.setCursorName(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSet();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.realPreparedStatement.getUpdateCount();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.realPreparedStatement.getMoreResults();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFetchDirection(int n2) throws SQLException {
        try {
            this.realPreparedStatement.setFetchDirection(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.realPreparedStatement.getFetchDirection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFetchSize(int n2) throws SQLException {
        try {
            this.realPreparedStatement.setFetchSize(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.realPreparedStatement.getFetchSize();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetConcurrency();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetType();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.realPreparedStatement.addBatch(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.realPreparedStatement.clearBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.realPreparedStatement.executeBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.realPreparedStatement.getConnection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean getMoreResults(int n2) throws SQLException {
        try {
            return this.realPreparedStatement.getMoreResults(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.realPreparedStatement.getGeneratedKeys();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, int n2) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, nArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate(string, stringArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, int n2) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, nArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            return this.realPreparedStatement.execute(string, stringArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.realPreparedStatement.getResultSetHoldability();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            return this.realPreparedStatement.executeQuery();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.realPreparedStatement.execute();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n2, n3, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setBoolean(n2, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        try {
            this.realPreparedStatement.setByte(n2, by);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setShort(int n2, short s2) throws SQLException {
        try {
            this.realPreparedStatement.setShort(n2, s2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setInt(int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setInt(n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        try {
            this.realPreparedStatement.setLong(n2, l2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        try {
            this.realPreparedStatement.setFloat(n2, f2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        try {
            this.realPreparedStatement.setDouble(n2, d2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realPreparedStatement.setBigDecimal(n2, bigDecimal);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setString(int n2, String string) throws SQLException {
        try {
            this.realPreparedStatement.setString(n2, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            this.realPreparedStatement.setBytes(n2, byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n2, date);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTime(int n2, Time time) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n2, time);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n2, timestamp);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setAsciiStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setUnicodeStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setBinaryStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object, n3, n4);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setCharacterStream(n2, reader, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        try {
            this.realPreparedStatement.setRef(n2, ref);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            this.realPreparedStatement.setBlob(n2, blob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            this.realPreparedStatement.setClob(n2, clob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setArray(int n2, Array array) throws SQLException {
        try {
            this.realPreparedStatement.setArray(n2, array);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n2, date, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n2, time, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n2, timestamp, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        try {
            this.realPreparedStatement.setURL(n2, uRL);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getParameterMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }
}

