/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseClob;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BaseClobOutputStream
extends OutputStream {
    private BaseClob clob;
    private BaseImplClob implClob;
    private Object synchronizer;
    private BaseExceptions exceptions;
    private long curPosition;
    private boolean asciiStream;

    public BaseClobOutputStream(BaseClob baseClob, BaseImplClob baseImplClob, long l2, Object object, BaseExceptions baseExceptions) {
        this.clob = baseClob;
        this.implClob = baseImplClob;
        this.synchronizer = object;
        this.exceptions = baseExceptions;
        this.curPosition = l2 >= 1L ? l2 : 1L;
        this.asciiStream = false;
    }

    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosed();
            if (n3 == 0) {
                return;
            }
            if (n2 < 0 || n2 + n3 > byArray.length) {
                String[] stringArray = new String[]{new String("write")};
                SQLException sQLException = this.exceptions.getException(6069, stringArray);
                throw new IOException(sQLException.getMessage());
            }
            try {
                int n4 = 0;
                switch (this.implClob.getCharacterEncoding()) {
                    case 1: {
                        if (!this.isAsciiStream()) {
                            byArray = this.UCS2BytesToAsciiBytes(byArray);
                            n3 /= 2;
                            n2 /= 2;
                        }
                        n4 = this.implClob.writeData(this.curPosition, byArray, n2, n3);
                        break;
                    }
                    case 2: {
                        if (this.isAsciiStream()) {
                            byArray = this.AsciiBytesToUCS2Bytes(byArray);
                            n3 *= 2;
                            n2 *= 2;
                        }
                        if (n3 % 2 != 0) {
                            String[] stringArray = new String[]{new String("write")};
                            SQLException sQLException = this.exceptions.getException(6069, stringArray);
                            throw new IOException(sQLException.getMessage());
                        }
                        n4 = this.implClob.writeData(this.curPosition, byArray, n2, n3 /= 2);
                        break;
                    }
                    default: {
                        SQLException sQLException = this.exceptions.getException(6070);
                        throw new IOException(sQLException.getMessage());
                    }
                }
                this.curPosition += (long)n3;
                if (n4 != n3) {
                    throw this.exceptions.getException(6079);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }

    public void close() throws IOException {
        this.implClob = null;
    }

    public void setAsciiStream(boolean bl) {
        this.asciiStream = bl;
    }

    public boolean isAsciiStream() {
        return this.asciiStream;
    }

    void validateClosed() throws IOException {
        if (this.implClob == null) {
            SQLException sQLException = this.exceptions.getException(6009);
            throw new IOException(sQLException.getMessage());
        }
    }

    private byte[] AsciiBytesToUCS2Bytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2 * 2] = 0;
            byArray2[i2 * 2 + 1] = byArray[i2];
        }
        return byArray2;
    }

    private byte[] UCS2BytesToAsciiBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = byArray[i2 * 2] != 0 ? 63 : byArray[i2 * 2 + 1];
        }
        return byArray2;
    }
}

