/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseSQLColumnSpecification;
import com.metamatrix.jdbc.base.BaseSQLEscapeProcessor;
import com.metamatrix.jdbc.base.BaseSQLFromSpecificationGenerator;
import com.metamatrix.jdbc.base.BaseSQLListManipulator;
import com.metamatrix.jdbc.base.BaseSQLListPartManipulator;
import com.metamatrix.jdbc.base.BaseSQLParameterProcessor;
import com.metamatrix.jdbc.base.BaseSQLParenExpListManipulator;
import com.metamatrix.jdbc.base.BaseSQLParser;
import com.metamatrix.jdbc.base.BaseSQLPredicateParamProcessor;
import com.metamatrix.jdbc.base.BaseSQLStringGenerator;
import com.metamatrix.jdbc.base.BaseSQLTableReference;
import com.metamatrix.jdbc.base.BaseSQLTreeNode;
import com.metamatrix.jdbc.base.BaseSQLTreeNodeSearch;
import com.metamatrix.jdbc.base.BaseSQLTreePreOrderTraverser;
import com.metamatrix.util.UtilStringStream;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public final class BaseSQL {
    private static String footprint = "$Revision:   3.41.1.2  $";
    public static final int PROCESS_NONE = 0;
    public static final int PROCESS_PARAMS = 1;
    public static final int PROCESS_ESCAPES = 2;
    public static final int PROCESS_FULL = 4;
    public static final int PROCESS_PREDICATES = 8;
    public static final int PROCESS_TABLES = 16;
    public static final int SQL_UNKNOWN = 0;
    public static final int SQL_DML_SELECT = 1;
    public static final int SQL_DDL_CREATE_TABLE = 2;
    public static final int SQL_DML_CALL = 3;
    public static final int SQL_DML_INSERT_TABLE = 4;
    public static final int SQL_DML_UPDATE_TABLE = 5;
    public static final int SQL_DML_DELETE_TABLE = 6;
    private String originalSQL;
    private boolean hasForUpdate = false;
    private boolean hasReadOnly = false;
    BaseEscapeTranslator escapeTranslator;
    private int processLevel;
    private boolean intoIsOptional = false;
    private char quote;
    private int type;
    private BaseSQLTreeNode treeRoot;
    private UtilVectorUnsynced createTableColumnSpecificationNodes;
    private BaseSQLListPartManipulator selectListManipulator;
    private boolean hasEscape = false;
    private boolean hasParameter = false;
    private int parameterCount = -1;
    private boolean isBatch = false;
    private UtilVectorUnsynced originalSQLs;
    private int currentBatch = 0;
    private BaseExceptions exceptions;
    private BaseSQLTreeNode updateTableRootNode;
    private BaseSQLTreeNode updateNamesRootNode;
    private BaseSQLTreeNode updateValuesRootNode;
    private BaseSQLTreeNode updateNameValuesRootNode;
    private UtilVectorUnsynced updateNames;
    private int updateNamesCount;
    private UtilVectorUnsynced updateValues;
    private int updateValuesCount;
    private BaseSQLListPartManipulator updateNameValues;
    private int updateNamesValuesCount;
    private UtilVectorUnsynced parameterNodes;
    private UtilVectorUnsynced tableInfo;

    public BaseSQL(String string, int n, char c, boolean bl, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        try {
            this.originalSQL = string;
            this.processLevel = n;
            this.quote = c;
            this.intoIsOptional = bl;
            this.escapeTranslator = baseEscapeTranslator;
            this.exceptions = baseExceptions;
            this.processSQL();
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(throwable.toString());
        }
    }

    public BaseSQL(String string, BaseSQL baseSQL) throws SQLException {
        this.originalSQL = string;
        this.processLevel = baseSQL.processLevel;
        this.quote = baseSQL.quote;
        this.intoIsOptional = baseSQL.intoIsOptional;
        this.escapeTranslator = baseSQL.escapeTranslator;
        this.exceptions = baseSQL.exceptions;
        this.processSQL();
    }

    public BaseSQL(BaseSQL baseSQL, int n) throws SQLException {
        this.originalSQL = baseSQL.originalSQL;
        this.processLevel = n;
        this.quote = baseSQL.quote;
        this.intoIsOptional = baseSQL.intoIsOptional;
        this.escapeTranslator = baseSQL.escapeTranslator;
        this.exceptions = baseSQL.exceptions;
        this.processSQL();
    }

    public BaseSQL(char c, boolean bl, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        this.quote = c;
        this.intoIsOptional = bl;
        this.escapeTranslator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.isBatch = true;
    }

    public BaseEscapeTranslator getEscapeTranslator() {
        return this.escapeTranslator;
    }

    public void setEscapeTranslator(BaseEscapeTranslator baseEscapeTranslator) {
        this.escapeTranslator = baseEscapeTranslator;
    }

    public void dumpTree() throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        baseSQLTreePreOrderTraverser.setExceptions(this.exceptions);
        baseSQLTreePreOrderTraverser.traverse(this.treeRoot);
    }

    void processSQL() throws SQLException {
        this.buildSQLTree();
        if (this.escapeTranslator != null && this.hasEscape) {
            BaseSQLEscapeProcessor baseSQLEscapeProcessor = new BaseSQLEscapeProcessor();
            baseSQLEscapeProcessor.processEscapes(this.treeRoot, this.escapeTranslator, this.exceptions);
        }
        this.resultType();
        if (this.hasParameter) {
            this.getParameterCount();
        }
    }

    public boolean nextBatchStatement() throws SQLException {
        boolean bl = false;
        if (this.originalSQLs != null && this.currentBatch < this.originalSQLs.size()) {
            BaseBatchSubStatement baseBatchSubStatement = (BaseBatchSubStatement)this.originalSQLs.elementAt(this.currentBatch);
            this.originalSQL = baseBatchSubStatement.originalSQL;
            this.processLevel = baseBatchSubStatement.processLevel;
            this.processSQL();
            ++this.currentBatch;
        }
        return bl;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public int batchSize() {
        return this.originalSQLs.size();
    }

    public void addToBatch(String string, int n) {
        if (this.originalSQLs == null) {
            this.originalSQLs = new UtilVectorUnsynced();
        }
        BaseBatchSubStatement baseBatchSubStatement = new BaseBatchSubStatement();
        baseBatchSubStatement.originalSQL = string;
        baseBatchSubStatement.processLevel = n;
        this.originalSQLs.addElement(baseBatchSubStatement);
    }

    public void clearBatch() {
        this.originalSQLs.setSize(0);
        this.currentBatch = 0;
    }

    public String getOriginal() {
        return this.originalSQL;
    }

    public String getVerb() throws SQLException {
        BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
        return baseSQLStringGenerator.generateSQL(this.treeRoot, true, this.exceptions);
    }

    public int getType() {
        return this.type;
    }

    public boolean isStatementSuitableForAutoGeneratedKeys() {
        if ((this.processLevel & 4) != 0) {
            BaseSQLTreeNode baseSQLTreeNode = this.treeRoot;
            if (baseSQLTreeNode.type == 1001) {
                int n = 0;
                for (baseSQLTreeNode = baseSQLTreeNode.leftMostChild(); baseSQLTreeNode != null; baseSQLTreeNode = baseSQLTreeNode.getRightSibling()) {
                    if (baseSQLTreeNode.type != 1002) continue;
                    if (++n > 1) {
                        return false;
                    }
                    if (baseSQLTreeNode.leftMostChild() == null || baseSQLTreeNode.leftMostChild().type == 1004) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isCallEscapeStatement() {
        BaseSQLTreeNode baseSQLTreeNode = this.treeRoot;
        if (baseSQLTreeNode.type == 1001) {
            baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
            if (baseSQLTreeNode.type == 1002) {
                baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
                if (baseSQLTreeNode.type == 1006) {
                    baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
                    if (baseSQLTreeNode.type == 8210 || baseSQLTreeNode.type == 8209) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String getFormatted() {
        try {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            String string = baseSQLStringGenerator.generateSQL(this.treeRoot, false, this.exceptions);
            return string;
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public void getFormatted(UtilStringStream utilStringStream, UtilTransliterator utilTransliterator) throws SQLException {
        BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
        baseSQLStringGenerator.generateSQL(this.treeRoot, utilStringStream, utilTransliterator, this.exceptions);
    }

    public String getFormattedForSelectFakePrepare() throws SQLException {
        if (this.getType() == 1) {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            String string = baseSQLStringGenerator.generateSQLWhereZeroEqualOne(this.treeRoot, this.exceptions);
            return string;
        }
        return null;
    }

    void replaceSelectListWithString(String string) throws SQLException {
        this.selectListManipulator = new BaseSQLListPartManipulator();
        this.selectListManipulator.replaceSelectList(this.treeRoot, string, this.exceptions);
        this.selectListManipulator = null;
    }

    void setUpdateTableNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateTableRootNode = baseSQLTreeNode;
    }

    void addToUpdateTableNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateTableRootNode.setNextChild(baseSQLTreeNode);
    }

    void setUpdateValuesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateValuesRootNode = baseSQLTreeNode;
    }

    void setUpdateNamesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateNamesRootNode = baseSQLTreeNode;
    }

    void setUpdateNameValuesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateNameValuesRootNode = baseSQLTreeNode;
    }

    public String getUpdateTableSpecification() {
        String string = null;
        try {
            if (this.updateTableRootNode != null) {
                BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
                string = baseSQLStringGenerator.generateSQL(this.updateTableRootNode, false, this.exceptions);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String getUpdateColumnSpecification(int n) {
        try {
            if (this.type == 5) {
                if (this.updateNameValuesRootNode != null && this.updateNameValues == null) {
                    this.updateNameValues = new BaseSQLListPartManipulator();
                    this.updateNamesValuesCount = this.updateNameValues.countElements(this.updateNameValuesRootNode, this.exceptions);
                }
                if (n <= this.updateNamesValuesCount) {
                    int n2 = 0;
                    UtilVectorUnsynced utilVectorUnsynced = null;
                    for (int i = 0; n2 < n && i < this.updateNamesValuesCount; ++i) {
                        utilVectorUnsynced = this.updateNameValues.getElementNodes(i);
                        if (!this.selectColumnSpecificationContainsNode(utilVectorUnsynced, 1018)) continue;
                        ++n2;
                        if (n2 >= n) continue;
                        utilVectorUnsynced = null;
                    }
                    if (utilVectorUnsynced != null) {
                        return this.buildFromParts(utilVectorUnsynced, "=");
                    }
                }
            } else if (this.type == 4 && this.updateValuesRootNode != null) {
                if (this.updateNames == null) {
                    this.updateNames = new UtilVectorUnsynced();
                    this.updateNamesCount = this.getFirstTopLevelParenExpListCount(this.updateNamesRootNode, this.updateNames);
                }
                if (this.updateValues == null) {
                    this.updateValues = new UtilVectorUnsynced();
                    this.updateValuesCount = this.getFirstTopLevelParenExpListCount(this.updateValuesRootNode, this.updateValues);
                }
                UtilVectorUnsynced utilVectorUnsynced = null;
                int n3 = 0;
                int n4 = 0;
                if (n <= this.updateValuesCount) {
                    while (n4 < n) {
                        if ((utilVectorUnsynced = this.getFirstTopLevelParenExpListElementNodes(this.updateValues, n3++)) == null) {
                            return null;
                        }
                        if (!this.selectColumnSpecificationContainsNode(utilVectorUnsynced, 1018)) continue;
                        ++n4;
                    }
                }
                if (n3 != 0) {
                    if (n3 > this.updateNamesCount) {
                        return Integer.toString(n3);
                    }
                    utilVectorUnsynced = this.getFirstTopLevelParenExpListElementNodes(this.updateNames, n3 - 1);
                    return this.buildFromParts(utilVectorUnsynced, null);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    private void buildSQLTree() throws SQLException {
        BaseSQLParser baseSQLParser = null;
        int n = 0;
        this.hasParameter = this.containsParameterMarker();
        this.hasEscape = this.containsEscape();
        if ((this.processLevel & 4) != 0) {
            n |= 4;
        }
        if ((this.processLevel & 8) != 0) {
            n |= 8;
        }
        if ((this.processLevel & 0x10) != 0) {
            n |= 0x10;
        }
        if (this.hasParameter) {
            n |= 1;
            this.parameterNodes = new UtilVectorUnsynced();
        }
        if (this.hasEscape && ((this.processLevel & 4) != 0 || (this.processLevel & 2) != 0)) {
            n |= 2;
        }
        baseSQLParser = new BaseSQLParser(this.escapeTranslator, n, this.intoIsOptional);
        baseSQLParser.setUp(this, this.exceptions);
        this.treeRoot = baseSQLParser.parse(this.originalSQL, '\"');
        this.tableInfo = baseSQLParser.tableInfo;
    }

    public int getParameterCount() {
        try {
            if (this.parameterCount == -1) {
                if (this.hasParameter) {
                    this.parameterNodes = new UtilVectorUnsynced();
                    BaseSQLParameterProcessor baseSQLParameterProcessor = new BaseSQLParameterProcessor();
                    this.parameterNodes = baseSQLParameterProcessor.getParameterNodes(this.treeRoot, this.exceptions);
                    this.parameterCount = this.parameterNodes == null ? 0 : this.parameterNodes.size();
                } else {
                    this.parameterCount = 0;
                }
            }
            return this.parameterCount;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getStatementCount() {
        int n = 0;
        for (BaseSQLTreeNode baseSQLTreeNode = this.treeRoot.leftMostChild(); baseSQLTreeNode != null; baseSQLTreeNode = baseSQLTreeNode.getRightSibling()) {
            if (baseSQLTreeNode.type != 1002) continue;
            ++n;
        }
        return n;
    }

    public void setParameter(int n, String string) {
        if (this.parameterNodes != null) {
            ((BaseSQLTreeNode)this.parameterNodes.elementAt((int)n)).value = string;
        }
    }

    public String getStringPreceedingParameter(int n) {
        String string = null;
        if (this.parameterCount > 0) {
            BaseSQLTreeNode baseSQLTreeNode = (BaseSQLTreeNode)this.parameterNodes.elementAt(n);
            for (baseSQLTreeNode = baseSQLTreeNode.getPrevious(); baseSQLTreeNode != null && baseSQLTreeNode.type == 1020; baseSQLTreeNode = baseSQLTreeNode.getPrevious()) {
            }
            if (baseSQLTreeNode != null) {
                string = baseSQLTreeNode.value;
            }
        }
        return string;
    }

    public boolean resultType() throws SQLException {
        boolean bl;
        String string = this.getVerb();
        if (this.isCallEscapeStatement()) {
            bl = true;
            this.type = 3;
        } else if (string.equalsIgnoreCase("select") || string.equalsIgnoreCase("with") || string.equalsIgnoreCase("xquery") || string.equalsIgnoreCase("values")) {
            bl = true;
            this.type = 1;
        } else if (string.equalsIgnoreCase("create table")) {
            bl = false;
            this.type = 2;
        } else if (string.equalsIgnoreCase("insert")) {
            bl = false;
            this.type = 4;
        } else if (string.equalsIgnoreCase("update")) {
            bl = false;
            this.type = 5;
        } else if (string.equalsIgnoreCase("delete")) {
            bl = false;
            this.type = 6;
        } else {
            bl = false;
            this.type = 0;
        }
        return bl;
    }

    public int getCreateTableColumnSpecificationCount() {
        if (this.getType() != 2) {
            return -1;
        }
        try {
            this.createTableColumnSpecificationNodes = new UtilVectorUnsynced();
            return this.getFirstTopLevelParenExpListCount(this.treeRoot, this.createTableColumnSpecificationNodes);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public UtilVectorUnsynced getCreateTableColumnSpecification(int n) {
        try {
            if (this.createTableColumnSpecificationNodes == null) {
                return null;
            }
            return this.getFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void setCreateTableColumnSpecification(int n, String string) {
        try {
            if (this.createTableColumnSpecificationNodes != null) {
                this.setFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n, string);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getFirstTopLevelParenExpListCount(BaseSQLTreeNode baseSQLTreeNode, UtilVectorUnsynced utilVectorUnsynced) throws SQLException {
        BaseSQLParenExpListManipulator baseSQLParenExpListManipulator = new BaseSQLParenExpListManipulator();
        utilVectorUnsynced.addElement(baseSQLParenExpListManipulator);
        return baseSQLParenExpListManipulator.countElements(baseSQLTreeNode, this.exceptions);
    }

    public int getFirstTopLevelParenExpListCount(UtilVectorUnsynced utilVectorUnsynced) throws SQLException {
        return this.getFirstTopLevelParenExpListCount(this.treeRoot, utilVectorUnsynced);
    }

    public UtilVectorUnsynced getFirstTopLevelParenExpListElement(UtilVectorUnsynced utilVectorUnsynced, int n) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        return baseSQLListManipulator.getElement(n);
    }

    public UtilVectorUnsynced getFirstTopLevelParenExpListElementNodes(UtilVectorUnsynced utilVectorUnsynced, int n) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        return baseSQLListManipulator.getElementNodes(n);
    }

    public void setFirstTopLevelParenExpListElement(UtilVectorUnsynced utilVectorUnsynced, int n, String string) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        baseSQLListManipulator.setElement(n, string + " ", this.exceptions);
    }

    public String getSelectList() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = this.getSelectColumnSpecificationCount();
            for (int i = 0; i < n; ++i) {
                UtilVectorUnsynced utilVectorUnsynced = this.getSelectColumnSpecification(i);
                int n2 = utilVectorUnsynced.size();
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append((String)utilVectorUnsynced.elementAt(j));
                }
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getSelectColumnSpecificationCount() throws SQLException {
        if (this.getType() != 1) {
            return -1;
        }
        this.selectListManipulator = new BaseSQLListPartManipulator();
        return this.selectListManipulator.countElements(this.treeRoot, this.exceptions);
    }

    public UtilVectorUnsynced getSelectColumnSpecification(int n) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return null;
        }
        return this.selectListManipulator.getElement(n);
    }

    public void setSelectColumnSpecification(int n, String string) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return;
        }
        this.selectListManipulator.setElement(n, string + " ", this.exceptions);
    }

    public boolean selectColumnSpecificationContainsValue(UtilVectorUnsynced utilVectorUnsynced, String string) {
        int n = utilVectorUnsynced.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase((String)utilVectorUnsynced.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean selectColumnSpecificationContainsNode(UtilVectorUnsynced utilVectorUnsynced, int n) {
        int n2 = utilVectorUnsynced.size();
        for (int i = 0; i < n2; ++i) {
            if (n != ((BaseSQLTreeNode)utilVectorUnsynced.elementAt((int)i)).type) continue;
            return true;
        }
        return false;
    }

    public String buildFromParts(UtilVectorUnsynced utilVectorUnsynced, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = utilVectorUnsynced.size();
        BaseSQLTreeNode baseSQLTreeNode = null;
        for (int i = 0; i < n; ++i) {
            baseSQLTreeNode = (BaseSQLTreeNode)utilVectorUnsynced.elementAt(i);
            if (baseSQLTreeNode.value == null) continue;
            if (string != null && string.equals(baseSQLTreeNode.value)) break;
            stringBuffer.append(baseSQLTreeNode.value);
        }
        return stringBuffer.toString();
    }

    public String getSingleTableFromSpecification(boolean bl) throws SQLException {
        String string = null;
        if (this.getType() == 1) {
            BaseSQLFromSpecificationGenerator baseSQLFromSpecificationGenerator = new BaseSQLFromSpecificationGenerator();
            baseSQLFromSpecificationGenerator.generate(this.treeRoot, this.exceptions);
            int n = baseSQLFromSpecificationGenerator.getSpecificationObjectCount();
            if (n > 0) {
                string = "";
                boolean bl2 = true;
                int n2 = 1;
                boolean bl3 = false;
                for (int i = 0; i < n; ++i) {
                    String string2 = baseSQLFromSpecificationGenerator.getSpecificationObject(i);
                    char c = string2.charAt(0);
                    if (i % 2 == 0 && (c == '.' || c == ':')) {
                        n2 = 0;
                    }
                    if (i % 2 == n2 && c != '.' && c != ':') {
                        if (bl) {
                            string = string + " ";
                        } else {
                            bl2 = false;
                        }
                    }
                    if (i > 0 && c == '(') {
                        bl3 = true;
                    } else if (c == ')') {
                        bl3 = false;
                    }
                    if (!bl3 && c == ',') {
                        string = null;
                        break;
                    }
                    if (!bl2) continue;
                    if (string.length() > 0 && ".: (,".indexOf(string.charAt(string.length() - 1)) < 0 && ".: ),".indexOf(c) < 0) {
                        string = string + " ";
                    }
                    string = string + string2;
                }
            }
        }
        return string;
    }

    public String getSingleTableFromSpecification() throws SQLException {
        return this.getSingleTableFromSpecification(false);
    }

    protected boolean lookForSelectNodeType(int n) {
        boolean bl = false;
        if (this.getType() == 1) {
            BaseSQLTreeNodeSearch baseSQLTreeNodeSearch = new BaseSQLTreeNodeSearch();
            try {
                if (baseSQLTreeNodeSearch.search(this.treeRoot, n, this.exceptions) != null) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean hasForReadOnly() {
        return this.hasReadOnly;
    }

    void hasForReadOnly(boolean bl) {
        this.hasReadOnly = bl;
    }

    public boolean hasForUpdate() {
        return this.hasForUpdate;
    }

    void hasForUpdate(boolean bl) {
        this.hasForUpdate = bl;
    }

    public boolean hasGroupBy() {
        return this.lookForSelectNodeType(1010);
    }

    public boolean hasWhereClause() {
        boolean bl = false;
        switch (this.getType()) {
            case 1: 
            case 5: 
            case 6: {
                BaseSQLTreeNodeSearch baseSQLTreeNodeSearch = new BaseSQLTreeNodeSearch();
                try {
                    BaseSQLTreeNode baseSQLTreeNode = baseSQLTreeNodeSearch.search(this.treeRoot, 1009, this.exceptions);
                    if (baseSQLTreeNode == null || baseSQLTreeNode.leftMostChild == null) break;
                    bl = true;
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            case 0: 
            case 4: {
                bl = this.originalSQL.toLowerCase().indexOf("where") != -1;
            }
        }
        return bl;
    }

    public boolean hasHaving() {
        return this.lookForSelectNodeType(1013);
    }

    public boolean hasSetOperation() {
        return this.lookForSelectNodeType(1011);
    }

    public boolean hasOrderBy() {
        return this.lookForSelectNodeType(1012);
    }

    public boolean hasAggregateOrParameterInSelectList(String[] stringArray) throws SQLException {
        if (stringArray == null) {
            return false;
        }
        int n = this.getSelectColumnSpecificationCount();
        for (int i = 0; i < n; ++i) {
            UtilVectorUnsynced utilVectorUnsynced = this.getSelectColumnSpecification(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.selectColumnSpecificationContainsValue(utilVectorUnsynced, stringArray[j]) && !this.selectColumnSpecificationContainsValue(utilVectorUnsynced, "?")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSelectDistinct() throws SQLException {
        UtilVectorUnsynced utilVectorUnsynced;
        int n = this.getSelectColumnSpecificationCount();
        return n > 0 && this.selectColumnSpecificationContainsValue(utilVectorUnsynced = this.getSelectColumnSpecification(0), "DISTINCT");
    }

    private boolean containsParameterMarker() {
        return this.originalSQL.indexOf(63) != -1;
    }

    private boolean containsEscape() {
        return this.originalSQL.indexOf(123) != -1;
    }

    public UtilVectorUnsynced getPredicateParamColumnDefinitions() {
        return new BaseSQLPredicateParamProcessor().getDescribeSelectStatements(this.treeRoot, this.exceptions);
    }

    public UtilVectorUnsynced getSelectTables() {
        try {
            if (this.getType() == 1) {
                Object object;
                if (this.tableInfo == null) {
                    object = new BaseSQL(this, 20);
                    this.tableInfo = ((BaseSQL)object).tableInfo;
                }
                if (this.tableInfo != null && this.tableInfo.size() > 0) {
                    object = new UtilVectorUnsynced();
                    int n = this.tableInfo.size();
                    for (int i = 0; i < n; ++i) {
                        Object var5_5 = null;
                        BaseSQLTableReference baseSQLTableReference = new BaseSQLTableReference();
                        BaseSQLTreeNode baseSQLTreeNode = (BaseSQLTreeNode)((Object[])this.tableInfo.elementAt(i))[0];
                        baseSQLTreeNode = baseSQLTreeNode.leftMostChild;
                        while (baseSQLTreeNode != null) {
                            baseSQLTableReference.addPart(baseSQLTreeNode.value);
                            baseSQLTreeNode = baseSQLTreeNode.rightSibling;
                        }
                        baseSQLTreeNode = (BaseSQLTreeNode)((Object[])this.tableInfo.elementAt(i))[1];
                        if (baseSQLTreeNode != null) {
                            baseSQLTableReference.setCorrelation(baseSQLTreeNode.value);
                        }
                        ((UtilVectorUnsynced)object).add(baseSQLTableReference);
                    }
                    return object;
                }
                return null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    public BaseSQLColumnSpecification[] getSelectColumns() {
        try {
            int n;
            if (this.getType() == 1 && (n = this.getSelectColumnSpecificationCount()) > 0) {
                BaseSQLColumnSpecification[] baseSQLColumnSpecificationArray = new BaseSQLColumnSpecification[n];
                for (int i = 0; i < n; ++i) {
                    baseSQLColumnSpecificationArray[i] = new BaseSQLColumnSpecification(this.getSelectColumnSpecification(i));
                }
                return baseSQLColumnSpecificationArray;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    class BaseBatchSubStatement {
        String originalSQL;
        int processLevel;

        BaseBatchSubStatement() {
        }
    }
}

