/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplClobCached;
import com.metamatrix.util.UtilBoyerMooreSearchStrategy;
import com.metamatrix.util.UtilBruteForceSearchStrategy;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSearchStrategy;
import java.sql.SQLException;

public class BaseImplClobSearchable
extends BaseImplClobCached {
    private static String footprint = "$Revision:   3.2.1.0  $";
    private UtilSearchStrategy searchStrategy = new UtilBoyerMooreSearchStrategy();

    public BaseImplClobSearchable(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public long find(String string, long l) throws SQLException {
        UtilSearchStrategy utilSearchStrategy = this.searchStrategy;
        if (string.length() == 1) {
            utilSearchStrategy = new UtilBruteForceSearchStrategy();
        }
        if (l > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6068);
        }
        this.fetchDataToCache(l, new Long(this.getLength() - (l - 1L)).intValue());
        int n = new Long(l).intValue();
        char[] cArray = string.toCharArray();
        try {
            int n2 = utilSearchStrategy.find(this.getCachedData(), cArray, n);
            return n2;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public boolean supportsSearch() {
        return true;
    }
}

