/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.pbe;

import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.random.SecRandom;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int c = 1;
    private int a = 8;
    private SecureRandom b;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.b = secureRandom;
        if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
            this.a = ((PBEGenParameterSpec)algorithmParameterSpec).getSaltLength();
            this.c = ((PBEGenParameterSpec)algorithmParameterSpec).getIterationCount();
            return;
        }
        throw new InvalidAlgorithmParameterException("param must be an instance of PBEGenParameterSpec.");
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.b = secureRandom;
        this.a = n2;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.b == null) {
            this.b = SecRandom.getDefault();
        }
        byte[] byArray = new byte[this.a];
        this.b.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, this.c);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE", "IAIK");
            algorithmParameters.init(pBEParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }
}

