/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilSmallDecimal;
import com.metamatrix.util.UtilStringFunctions;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideUpdatable
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.15.2.0  $";
    private String tableName;
    private BaseColumns columns;
    private BaseData[] keyValues;
    private boolean[] keyValueObtained;
    private BaseData[] updatedValues;
    private BaseConnection connection;
    private PreparedStatement updateStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement insertStatement;
    private int[] previousUpdateColumns;
    private int[] previousDeleteColumns;
    private int[] previousInsertColumns;
    boolean onInsertRow;
    String identifierQuote;

    BaseImplResultSetClientSideUpdatable(BaseConnection baseConnection, String string, BaseColumns baseColumns, String string2) throws SQLException {
        this.connection = baseConnection;
        this.tableName = string;
        this.columns = baseColumns;
        this.identifierQuote = string2;
        this.onInsertRow = false;
    }

    public void close() throws SQLException {
        super.close();
        if (this.updateStatement != null) {
            this.updateStatement.close();
        }
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        if (this.insertStatement != null) {
            this.insertStatement.close();
        }
    }

    public int getConcurrency() {
        return 1008;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.updatedValues != null && this.updatedValues[n - 1] != null) {
            return this.updatedValues[n - 1];
        }
        if (this.onInsertRow) {
            String[] stringArray = new String[]{Integer.toString(n)};
            throw this.exceptions.getException(6102, stringArray);
        }
        if (this.subImplResultSet.getColumnAccess() == 1) {
            this.cacheKeyDataUpToColumn(n);
        }
        BaseData baseData = this.subImplResultSet.getData(n, n2);
        this.setupKeyValues();
        if (this.keyValues[n - 1] == null) {
            this.keyValues[n - 1] = new BaseData(this.connection);
        }
        this.keyValues[n - 1].populate(baseData);
        this.keyValueObtained[n - 1] = true;
        return baseData;
    }

    private void cacheKeyDataUpToColumn(int n) throws SQLException {
        this.setupKeyValues();
        --n;
        for (int i = 0; i < n; ++i) {
            if (this.keyValueObtained[i] || !this.columns.get((int)(i + 1)).isKey) continue;
            BaseData baseData = this.subImplResultSet.getData(i + 1, this.columns.get((int)(i + 1)).baseDataType);
            if (this.keyValues[i] == null) {
                this.keyValues[i] = new BaseData(this.connection);
            }
            this.keyValues[i].populate(baseData);
            this.keyValueObtained[i] = true;
        }
    }

    public void updateData(int n, BaseData baseData) throws SQLException {
        if (this.subImplResultSet.getColumnAccess() == 1 && !this.onInsertRow) {
            this.cacheKeyDataUpToColumn(n + 1);
        }
        this.setupUpdatedValues();
        this.updatedValues[n - 1] = baseData;
    }

    public void updateRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.setupUpdatedValues();
        if (this.getUpdatedValuesCount() == 0) {
            return;
        }
        this.updateStatement = this.executeStatement(this.updateStatement, this.previousUpdateColumns, "UPDATE " + this.tableName + " set ", " = ? ", true, "", "WHERE ", 6057, 6056);
    }

    public void cancelUpdates() throws SQLException {
        if (this.updatedValues != null) {
            for (int i = 0; i < this.updatedValues.length; ++i) {
                this.updatedValues[i] = null;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.deleteStatement = this.executeStatement(this.deleteStatement, this.previousDeleteColumns, "DELETE FROM " + this.tableName, null, false, " ", " WHERE ", 6057, 6059);
    }

    public void prepareInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = true;
    }

    public void cancelInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = false;
    }

    public void insertRow() throws SQLException {
        this.setupPreviousColumnsLists();
        String string = "INSERT INTO " + this.tableName;
        this.setupUpdatedValues();
        int n = this.columns.count(1);
        boolean bl = false;
        if (this.getUpdatedValuesCount() == 0) {
            switch (this.connection.implConnection.getEmptyRowInsertSyntax()) {
                case 1: {
                    string = string + " default values";
                    break;
                }
                case 2: {
                    string = string + " values ()";
                    break;
                }
                case 3: {
                    string = string + " values (";
                    int n2 = this.columns.count(1);
                    for (int i = 0; i < n2; ++i) {
                        if (i != 0) {
                            string = string + ",";
                        }
                        string = string + "default";
                    }
                    string = string + " )";
                    break;
                }
                case 4: {
                    string = string + " values (";
                    int n3 = this.columns.count(1);
                    for (int i = 0; i < n3; ++i) {
                        if (i != 0) {
                            string = string + ",";
                        }
                        string = string + "NULL";
                    }
                    string = string + " )";
                    break;
                }
                default: {
                    throw this.implStatement.implConnection.exceptions.getException(6076);
                }
            }
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "", false, "", null, 6062, 0);
        } else {
            string = string + " (";
            for (int i = 0; i < n; ++i) {
                BaseColumn baseColumn = this.columns.get(i + 1);
                if (this.updatedValues[i] == null) continue;
                if (bl) {
                    string = string + ", ";
                } else {
                    bl = true;
                }
                string = string + this.identifierQuote + baseColumn.name + this.identifierQuote;
            }
            string = string + ") VALUES (";
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "? ", false, ")", null, 6062, 0);
        }
    }

    public PreparedStatement executeStatement(PreparedStatement preparedStatement, int[] nArray, String string, String string2, boolean bl, String string3, String string4, int n, int n2) throws SQLException {
        int n3;
        String[] stringArray;
        BaseColumn baseColumn;
        int n4 = 0;
        int n5 = this.getUpdatedValuesCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        n4 = this.columns.count(0);
        if (string4 != null) {
            this.cacheKeyDataUpToColumn(n4 + 1);
            n7 = this.columns.count(3);
        }
        if (this.statementNeedsBuilding(preparedStatement, nArray)) {
            for (int i = 0; i < n4; ++i) {
                baseColumn = this.columns.get(i + 1);
                if (string2 != null && i < this.updatedValues.length && this.updatedValues[i] != null) {
                    boolean bl3 = true;
                    if (bl) {
                        string = string + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote;
                    }
                    string = string + string2;
                    if (++n6 < n5 && bl3) {
                        string = string + ", ";
                    }
                }
                if (string4 == null || !baseColumn.isKey) continue;
                string4 = this.keyValueObtained[i] && this.keyValues[i].isNull() ? string4 + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote + " IS NULL " : string4 + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote + " = ? ";
                if (n8 < n7 - 1) {
                    string4 = string4 + "and ";
                }
                ++n8;
            }
            String string5 = string + string3;
            if (string4 != null) {
                string5 = string5 + string4;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            stringArray = this.connection.statementPool;
            this.connection.statementPool = null;
            preparedStatement = this.connection.prepareStatement(string5);
            this.connection.statementPool = stringArray;
            bl2 = true;
        }
        n6 = 0;
        n8 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            baseColumn = this.columns.get(n3 + 1);
            if (string2 != null && n3 < this.updatedValues.length && this.updatedValues[n3] != null) {
                this.setParameter(preparedStatement, n6 + 1, this.updatedValues[n3], baseColumn, false);
                ++n6;
            }
            if (string4 == null || !this.keyValueObtained[n3] || !baseColumn.isKey || this.keyValues[n3].isNull()) continue;
            this.setParameter(preparedStatement, n5 + n8 + 1, this.keyValues[n3], baseColumn, true);
            ++n8;
        }
        this.cacheBoundColumns(nArray);
        n3 = 0;
        try {
            n3 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (bl2) {
                preparedStatement.close();
            }
            throw this.implStatement.implConnection.exceptions.getException(sQLException, n);
        }
        if (n3 > 1) {
            stringArray = new String[]{Integer.toString(n3)};
            this.warnings.add(n2, stringArray);
        } else if (n3 != 1) {
            throw this.implStatement.implConnection.exceptions.getException(n);
        }
        return preparedStatement;
    }

    private void setupKeyValues() {
        if (this.keyValues == null) {
            int n = this.columns.count(0);
            this.keyValues = new BaseData[n];
            this.keyValueObtained = new boolean[n];
        }
    }

    private void setupUpdatedValues() {
        if (this.updatedValues == null) {
            this.updatedValues = new BaseData[this.columns.count(1)];
        }
    }

    private void setupPreviousColumnsLists() {
        int n = this.columns.count(0) * 2 + 1;
        if (this.previousDeleteColumns == null) {
            this.previousDeleteColumns = new int[n];
            this.previousDeleteColumns[0] = 0;
        }
        if (this.previousInsertColumns == null) {
            this.previousInsertColumns = new int[n];
            this.previousInsertColumns[0] = 0;
        }
        if (this.previousUpdateColumns == null) {
            this.previousUpdateColumns = new int[n];
            this.previousUpdateColumns[0] = 0;
        }
    }

    private int getUpdatedValuesCount() {
        int n = 0;
        if (this.updatedValues != null) {
            for (int i = 0; i < this.updatedValues.length; ++i) {
                if (this.updatedValues[i] == null) continue;
                ++n;
            }
        }
        return n;
    }

    private int getKeyValuesCount() {
        int n = 0;
        if (this.keyValues != null) {
            for (int i = 0; i < this.keyValues.length; ++i) {
                if (!this.keyValueObtained[i] || this.keyValues[i].isNull()) continue;
                ++n;
            }
        }
        return n;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, BaseData baseData, BaseColumn baseColumn, boolean bl) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        BaseCharacterStreamWrapper baseCharacterStreamWrapper = null;
        if (baseData.isNull()) {
            preparedStatement.setNull(n, baseColumn.type);
        } else {
            switch (baseData.getType()) {
                case 15: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getASCIIStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setAsciiStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseData.getCharacterStreamReader(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setCharacterStream(n, (Reader)baseCharacterStreamWrapper, (int)baseCharacterStreamWrapper.numTotalCharsInReader);
                    break;
                }
                case 14: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getBinaryStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setBinaryStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 21: {
                    preparedStatement.setDouble(n, ((UtilSmallDecimal)baseData.getObject()).doubleValue());
                    break;
                }
                default: {
                    Object object = baseData.getObject();
                    if (object instanceof BaseTimestamp) {
                        object = ((BaseTimestamp)object).getTimestamp();
                    }
                    preparedStatement.setObject(n, object);
                }
            }
        }
    }

    private boolean statementNeedsBuilding(PreparedStatement preparedStatement, int[] nArray) {
        int n;
        int n2;
        if (preparedStatement == null) {
            return true;
        }
        if (nArray[0] != this.getUpdatedValuesCount() + this.getKeyValuesCount()) {
            return true;
        }
        if (this.updatedValues != null) {
            for (n2 = 0; n2 < this.updatedValues.length; ++n2) {
                if (this.updatedValues[n2] == null) continue;
                for (n = 0; n < nArray[0] && nArray[n + 1] != n2; ++n) {
                }
                if (n != nArray[0]) continue;
                return true;
            }
        }
        if (this.keyValues != null) {
            for (n2 = 0; n2 < this.keyValues.length; ++n2) {
                if (!this.keyValueObtained[n2] || this.keyValues[n2].isNull()) continue;
                for (n = 0; n < nArray[0] && nArray[n + 1] != n2 + 10000; ++n) {
                }
                if (n != nArray[0]) continue;
                return true;
            }
        }
        return false;
    }

    private void cacheBoundColumns(int[] nArray) {
        int n;
        int n2 = 1;
        if (this.updatedValues != null) {
            for (n = 0; n < this.updatedValues.length; ++n) {
                if (this.updatedValues[n] == null) continue;
                nArray[n2] = n;
                ++n2;
            }
        }
        if (this.keyValues != null) {
            for (n = 0; n < this.keyValues.length; ++n) {
                if (!this.keyValueObtained[n] || this.keyValues[n].isNull()) continue;
                nArray[n2] = n + 10000;
                ++n2;
            }
        }
        nArray[0] = n2 - 1;
    }

    private void commonUpdateInitialize() {
        if (this.keyValueObtained != null) {
            for (int i = 0; i < this.keyValueObtained.length; ++i) {
                this.keyValueObtained[i] = false;
            }
        }
        this.updatedValues = null;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.fetchAtPosition(n);
    }

    protected boolean next() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.next();
    }

    protected boolean previous() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.previous();
    }

    protected boolean absolute(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.absolute(n);
    }

    protected boolean relative(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.relative(n);
    }

    protected void refreshRow() throws SQLException {
        this.subImplResultSet.refreshRow();
    }

    protected boolean first() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.first();
    }

    protected boolean last() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.last();
    }

    protected void beforeFirst() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.beforeFirst();
    }

    protected void afterLast() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.afterLast();
    }

    protected boolean isBeforeFirst() throws SQLException {
        return this.subImplResultSet.isBeforeFirst();
    }

    protected boolean isAfterLast() throws SQLException {
        return this.subImplResultSet.isAfterLast();
    }

    protected boolean isFirst() throws SQLException {
        return this.subImplResultSet.isFirst();
    }

    protected boolean isLast() throws SQLException {
        return this.subImplResultSet.isLast();
    }

    protected int getRow() throws SQLException {
        return this.subImplResultSet.getRow();
    }

    protected boolean isCursorPositionValid() throws SQLException {
        return this.subImplResultSet.isCursorPositionValid();
    }
}

