/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.util;

import com.metamatrix.sequelink.util.UtilMessage;
import java.io.IOException;
import java.io.InputStream;

public class BinaryStreamToAsciiStream
extends InputStream {
    private InputStream in;
    boolean isClosed = false;
    boolean hibyte = true;
    boolean markHibyte;
    int i;
    private static final byte[] Digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public BinaryStreamToAsciiStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return (this.hibyte ? 0 : 1) + this.in.available() * 2;
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.in.close();
    }

    public synchronized void mark(int n2) {
        this.markHibyte = this.hibyte;
        this.in.mark((n2 + 1) / 2);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.hibyte) {
            this.i = this.in.read();
            if (this.i == -1) {
                return -1;
            }
            this.hibyte = false;
            return Digits[this.i >> 4 & 0xF];
        }
        this.hibyte = true;
        return Digits[this.i & 0xF];
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        this.in.reset();
        this.hibyte = true;
        if (!this.markHibyte) {
            this.read();
            this.hibyte = false;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.stream.closed"));
        }
    }
}

