/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseMessages;
import java.sql.SQLException;
import java.sql.SQLWarning;

public final class BaseWarnings {
    private BaseMessages messages;
    private BaseWarning firstWarning;
    private BaseWarning lastWarning;

    public BaseWarnings(BaseMessages baseMessages) throws SQLException {
        this.messages = baseMessages;
        this.firstWarning = null;
        this.lastWarning = null;
    }

    public void add(int n2, String[] stringArray, String string, int n3) {
        BaseWarning baseWarning = new BaseWarning(n2, stringArray, string, new Integer(n3));
        this.addToList(baseWarning);
    }

    public void add(int n2) {
        BaseWarning baseWarning = new BaseWarning(n2, null, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n2, String[] stringArray) {
        BaseWarning baseWarning = new BaseWarning(n2, stringArray, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n2, String[] stringArray, String string) {
        BaseWarning baseWarning = new BaseWarning(n2, stringArray, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n2, String string) {
        BaseWarning baseWarning = new BaseWarning(n2, null, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n2, String string, int n3) {
        BaseWarning baseWarning = new BaseWarning(n2, null, string, new Integer(n3));
        this.addToList(baseWarning);
    }

    private void addToList(BaseWarning baseWarning) {
        if (null == this.firstWarning) {
            this.firstWarning = baseWarning;
        }
        if (null != this.lastWarning) {
            this.lastWarning.setNextWarning(baseWarning);
        }
        this.lastWarning = baseWarning;
    }

    public SQLWarning createSQLWarning(BaseWarning baseWarning) {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        boolean bl = true;
        while (baseWarning != null) {
            SQLWarning sQLWarning3 = null;
            String string = "";
            if (baseWarning.SQLstate != null) {
                string = baseWarning.SQLstate;
            }
            sQLWarning3 = baseWarning.vendorCode != null ? new SQLWarning(this.messages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, true), string, baseWarning.vendorCode) : new SQLWarning(this.messages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, false), string);
            if (bl) {
                sQLWarning2 = sQLWarning = sQLWarning3;
                bl = false;
            } else {
                sQLWarning2.setNextWarning(sQLWarning3);
                sQLWarning2 = sQLWarning3;
            }
            baseWarning = baseWarning.nextWarning;
        }
        return sQLWarning;
    }

    public SQLWarning get() {
        return this.createSQLWarning(this.firstWarning);
    }

    public void clear() {
        this.firstWarning = null;
        this.lastWarning = null;
    }

    private class BaseWarning {
        int reasonKey;
        String[] reasonArgs;
        String SQLstate;
        Integer vendorCode;
        BaseWarning nextWarning = null;

        public BaseWarning(int n2, String[] stringArray, String string, Integer n3) {
            this.reasonKey = n2;
            this.reasonArgs = stringArray;
            this.SQLstate = string;
            this.vendorCode = n3;
        }

        public void setNextWarning(BaseWarning baseWarning) {
            this.nextWarning = baseWarning;
        }
    }
}

