/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.SPDU;
import com.metamatrix.sequelink.net.SPDUConnect;
import com.metamatrix.sequelink.net.SPDUEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class SPDUConnectEncoder
extends SPDUEncoder {
    private static final int kVERSION_PARLEN = 3;
    private static final int kPROTOCOL_PARLEN = 3;
    private static final int kFUREQ_PARLEN = 4;
    private static final int kMAXTDUSZ_PARLEN = 10;
    private static final int kUSERDATA_PARLEN = 3;
    private SPDUConnect spdu;

    SPDUConnectEncoder(OutputStream outputStream, SPDUConnect sPDUConnect) throws NetworkException {
        super(outputStream, sPDUConnect);
        this.spdu = sPDUConnect;
        this.encodeVersion();
        this.encodeProtocolOptions();
        this.encodeFuReq();
        this.encodeMaxTduSize();
        this.encodeCallingSelector();
        this.encodeCalledSelector();
        this.encodeUserDataLen();
    }

    public int size() {
        return this.dos.size();
    }

    public static final int getLen(SPDUConnect sPDUConnect) {
        byte[] byArray = sPDUConnect.getCallingSelector();
        byte[] byArray2 = sPDUConnect.getCalledSelector();
        int n2 = 2 + byArray.length;
        int n3 = 2 + byArray2.length;
        return SPDUEncoder.getLen(sPDUConnect) + 3 + 3 + 4 + 10 + n2 + n3 + 3;
    }

    private void encodeVersion() throws NetworkException {
        try {
            this.dos.writeByte(5);
            this.dos.writeByte(1);
            this.dos.writeByte(1);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeProtocolOptions() throws NetworkException {
        try {
            this.dos.writeByte(2);
            this.dos.writeByte(1);
            this.dos.writeByte((byte)this.spdu.getProtocolOptions());
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeFuReq() throws NetworkException {
        short s2 = (short)this.spdu.getFuReq();
        try {
            this.dos.writeByte(3);
            this.dos.writeByte(2);
            this.dos.writeShort(s2);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeMaxTduSize() throws NetworkException {
        try {
            this.dos.writeByte(4);
            this.dos.writeByte(8);
            this.dos.writeInt(this.spdu.getMaxSendTduSize());
            this.dos.writeInt(this.spdu.getMaxRecvTduSize());
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeCallingSelector() throws NetworkException {
        byte[] byArray = this.spdu.getCallingSelector();
        try {
            this.dos.writeByte(7);
            this.dos.writeByte((byte)byArray.length);
            this.dos.write(byArray);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeCalledSelector() throws NetworkException {
        byte[] byArray = this.spdu.getCalledSelector();
        try {
            this.dos.writeByte(8);
            this.dos.writeByte((byte)byArray.length);
            this.dos.write(byArray);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeUserDataLen() throws NetworkException {
        short s2 = (short)this.spdu.getUserDataLen();
        try {
            this.dos.writeByte(9);
            this.dos.writeShort(s2);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }
}

