/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.IIOP;
import com.metamatrix.sequelink.net.IIOPFormat;
import com.metamatrix.sequelink.net.IIOPOctetSequence;
import com.metamatrix.sequelink.net.IIOPRequest;
import com.metamatrix.sequelink.net.IIOPString;
import com.metamatrix.sequelink.net.NetByteOrder;
import com.metamatrix.sequelink.net.NetworkException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IIOPEncoder {
    OutputStream os;
    DataOutputStream dos;
    IIOPRequest iiop;
    IIOPFormat iiopFormat;

    IIOPEncoder(OutputStream outputStream, IIOPRequest iIOPRequest) throws NetworkException {
        this.iiopFormat = new IIOPFormat(iIOPRequest);
        this.os = outputStream;
        this.dos = new DataOutputStream(outputStream);
        this.iiop = iIOPRequest;
        this.encodeProtocolIdentifier();
        this.encodeHeader();
        this.encodeMessage();
    }

    public int size() {
        return this.dos.size();
    }

    private void encodeProtocolIdentifier() throws NetworkException {
        try {
            this.dos.write(IIOP.protoId);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void encodeHeader() throws NetworkException {
        try {
            this.dos.writeByte(this.iiopFormat.getMajorVersion());
            this.dos.writeByte(this.iiopFormat.getMinorVersion());
            this.dos.writeByte(this.iiopFormat.getFlag());
            this.dos.writeByte(this.iiopFormat.getMsgTypeByte());
            this.dos.writeInt(this.iiopFormat.getMsgLen());
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void encodeMessage() throws NetworkException {
        switch (this.iiop.getMsgType()) {
            case 0: {
                this.encodeRequestMessage();
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
    }

    private void encodeRequestMessage() throws NetworkException {
        try {
            this.dos.writeInt(this.iiopFormat.getServiceContext());
            this.dos.writeInt(this.iiop.getRequestId());
            this.dos.write(this.iiopFormat.getReply());
            int n2 = 0;
            this.dos.write(n2);
            this.dos.write(n2);
            this.dos.write(n2);
            IIOPOctetSequence iIOPOctetSequence = new IIOPOctetSequence(this.iiop.getObjectKey(), this.iiop.isBigEndian());
            this.dos.write(iIOPOctetSequence.getIIOPOctetSequence());
            IIOPString iIOPString = new IIOPString(this.iiop.getOperation(), this.iiop.isBigEndian());
            this.dos.write(iIOPString.getIIOPString());
            this.dos.writeInt(this.iiopFormat.getPrincipal());
            this.dos.writeInt(NetByteOrder.htonl(this.iiop.getDataLen(), this.iiop.isBigEndian()));
            this.dos.writeByte(0);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531);
        }
    }
}

