/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

public final class BaseResultSetFilterDescriptor {
    private int[] filterColumns;
    private Object[] filterValues;
    private boolean[] patterns;

    public BaseResultSetFilterDescriptor(int[] nArray, Object[] objectArray, boolean[] blArray, boolean bl) {
        this.filterColumns = nArray;
        this.filterValues = objectArray;
        this.patterns = blArray;
        if (bl) {
            this.stripDoubleQuotesFromValues();
        }
    }

    private void stripDoubleQuotesFromValues() {
        int n2 = this.filterValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.filterValues[i2];
            if (!(object instanceof String) || object == null || ((String)object).length() <= 0) continue;
            String string = (String)object;
            int n3 = string.length() - 1;
            if (string.charAt(0) != '\"' || string.charAt(n3) != '\"' || n3 <= 0) continue;
            string = string.substring(1, n3);
            this.filterValues[i2] = string;
        }
    }

    public int getRestrictionCount() {
        int n2 = 0;
        if (this.filterColumns != null) {
            n2 = this.filterColumns.length;
        }
        return n2;
    }

    public boolean allRestrictionsSatified() {
        int n2 = this.getRestrictionCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.filterValues[i2] == null) continue;
            return false;
        }
        return true;
    }

    public Object getRestriction(int n2) {
        int n3 = this.getRestrictionCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.filterColumns[i2] != n2) continue;
            return this.filterValues[i2];
        }
        return null;
    }

    public boolean isPattern(int n2) {
        return this.patterns[this.getIndex(n2)];
    }

    public Object getRestrictionByIndex(int n2) {
        return this.filterValues[n2];
    }

    public void setRestrictionByIndex(int n2, Object object) {
        this.filterValues[n2] = object;
    }

    public boolean isPatternByIndex(int n2) {
        return this.patterns[n2];
    }

    public int getRestrictionColumnByIndex(int n2) {
        return this.filterColumns[n2];
    }

    public void removeRestriction(int n2) {
        this.filterValues[this.getIndex((int)n2)] = null;
    }

    public void removeAllRestrictions() {
        int n2 = this.getRestrictionCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.filterValues[i2] = null;
        }
    }

    private int getIndex(int n2) {
        int n3 = this.getRestrictionCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.filterColumns[i2] != n2) continue;
            return i2;
        }
        return 0;
    }

    public void setPattern(int n2, boolean bl) {
        this.patterns[this.getIndex((int)n2)] = bl;
    }
}

