/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.sequelink.SequeLinkImplClob;
import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.slbase.BaseClob;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;

public class SequeLinkClobParameter
extends SequeLinkParameter {
    private SequeLinkImplConnection implCon;

    public SequeLinkClobParameter(StatementContext statementContext, int n2, int n3, BaseExceptions baseExceptions, SequeLinkImplConnection sequeLinkImplConnection) throws SQLException {
        super(statementContext, n2, 2005, 0, n3, baseExceptions);
        this.baseDataType = 20;
        this.implCon = sequeLinkImplConnection;
        if (!sequeLinkImplConnection.supportsLobsNatively()) {
            throw baseExceptions.getException(6024);
        }
    }

    protected void setBindInfo() throws SQLException {
        this.sqlnkType = 5;
        this.sqlnkSize = this.stmtCtxt.getLobLocatorSize();
    }

    protected void convertDataIn() throws SQLException {
        throw this.exceptions.getException(6024);
    }

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        Clob clob = this.bdIn.getClobNoConvert();
        SequeLinkImplClob sequeLinkImplClob = clob instanceof BaseClob ? (SequeLinkImplClob)((BaseClob)clob).getNativeImplClob() : (SequeLinkImplClob)((Object)clob);
        sspOutputStream.writeSSPBinaryType(sequeLinkImplClob.getLocator());
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.bdOut.setClob(new SequeLinkImplClob(this.implCon, sspInputStream.readSSPBinaryType(), this.encoding, this.ut));
    }
}

