/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.CertificateResponse;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.ResponderID;
import iaik.x509.ocsp.Response;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.extensions.Nonce;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Enumeration;

public class BasicOCSPResponse
extends Response {
    static /* synthetic */ Class j;
    static /* synthetic */ Class k;
    private boolean h;
    private byte[] b;
    private X509Certificate[] l;
    private AlgorithmID c;
    private OCSPExtensions i;
    private SingleResponse[] d;
    private ChoiceOfTime g;
    private ResponderID f;
    private int a;
    private ASN1 e;
    public static final ObjectID responseType = new ObjectID("1.3.6.1.5.5.7.48.1.1", "id-pkix-ocsp-basic");

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.c();
        this.e.writeTo(outputStream);
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.c();
        Signature signature = this.c.getSignatureInstance(string);
        try {
            byte[] byArray = this.e.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.b)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.verify(publicKey, null);
    }

    public X509Certificate verify() throws OCSPException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        X509Certificate[] x509CertificateArray = null;
        if (this.l == null || this.l.length <= 0) {
            throw new OCSPException("Cannot verify request. No certificates included.");
        }
        x509CertificateArray = Util.arrangeCertificateChain(this.l, false);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            this.verify(x509CertificateArray[0].getPublicKey());
            return x509CertificateArray[0];
        }
        throw new OCSPException("Cannot verify request. Cannot build chain from included certs.");
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append("ResponderID: " + this.f + "\n");
        stringBuffer.append("ProducedAt: " + this.g + "\n");
        if (bl) {
            int n2 = 0;
            while (n2 < this.d.length) {
                stringBuffer.append("singleResponse " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(this.d[n2].toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("singleResponses: " + this.d.length);
        }
        stringBuffer.append("\n");
        if (this.i != null) {
            if (bl) {
                stringBuffer.append(this.i);
            } else {
                stringBuffer.append("Extensions: " + this.i.countExtensions());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("Signature algorithm: " + this.c + "\n");
        if (this.l != null) {
            stringBuffer.append("certificates: " + this.l.length + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        this.c();
        return this.e.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign response! No signature algorithm specified!");
        }
        this.c = algorithmID;
        Signature signature = this.c.getSignatureInstance(string);
        ASN1Object aSN1Object = this.a();
        signature.initSign(privateKey);
        try {
            signature.update(DerCoder.encode(aSN1Object));
            this.b = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.b);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            if (this.l != null && this.l.length > 0) {
                sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.l)));
            }
            this.e = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.toString());
        }
        catch (SignatureException signatureException) {
            throw new OCSPException(signatureException.toString());
        }
        this.e();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, OCSPException {
        this.sign(algorithmID, privateKey, null);
    }

    public void setSingleResponses(SingleResponse[] singleResponseArray) {
        this.d = singleResponseArray;
        this.d();
        if (this.d != null) {
            int n2 = 0;
            while (n2 < this.d.length) {
                if (this.d[n2].getReqCert().getType() != 0) {
                    this.a = 2;
                    return;
                }
                ++n2;
            }
        }
    }

    private void e() {
        this.h = false;
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot set signature! No signature algorithm specified!");
        }
        if (byArray == null || byArray.length == 0) {
            throw new OCSPException("Cannot set empty signature value!");
        }
        this.c = algorithmID;
        this.b = byArray;
        ASN1Object aSN1Object = this.a();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.b);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            if (this.l != null && this.l.length > 0) {
                sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.l)));
            }
            this.e = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.toString());
        }
        this.e();
    }

    public void setResponderID(ResponderID responderID) {
        this.f = responderID;
        this.d();
    }

    public void setProducedAt(Date date) {
        this.g = new ChoiceOfTime(date);
        this.g.setEncodingType(ASN.GeneralizedTime);
        this.d();
    }

    public void setNonce(byte[] byArray) throws X509ExtensionException {
        this.addExtension(new Nonce(byArray));
    }

    private void d() {
        this.h = true;
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.l = x509CertificateArray;
        this.d();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.i == null ? false : this.i.removeExtension(objectID);
        if (bl) {
            this.d();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.i != null) {
            this.i.removeAllExtensions();
            this.d();
        }
        this.i = null;
    }

    public Enumeration listExtensions() {
        if (this.i == null) {
            return null;
        }
        return this.i.listExtensions();
    }

    private void b() throws X509ExtensionException, CodingException {
        ASN1Object aSN1Object;
        int n2 = 0;
        ASN1Object aSN1Object2 = this.e.getComponentAt(0);
        this.c = new AlgorithmID(this.e.getComponentAt(1));
        ASN1Object aSN1Object3 = this.e.getComponentAt(2);
        this.b = (byte[])((BIT_STRING)aSN1Object3).getValue();
        if (this.e.countComponents() == 4) {
            this.l = (X509Certificate[])ASN.parseSequenceOf((ASN1Object)this.e.getComponentAt(3).getValue(), k != null ? k : (k = BasicOCSPResponse.a("iaik.x509.X509Certificate")));
        }
        if ((aSN1Object = aSN1Object2.getComponentAt(0)).isA(ASN.CON_SPEC) && aSN1Object.getAsnType().getTag() == 0) {
            BigInteger bigInteger = (BigInteger)((ASN1Object)aSN1Object.getValue()).getValue();
            this.a = bigInteger.intValue() + 1;
            ++n2;
        }
        this.f = new ResponderID(aSN1Object2.getComponentAt(n2));
        this.g = new ChoiceOfTime(aSN1Object2.getComponentAt(1 + n2));
        aSN1Object = aSN1Object2.getComponentAt(2 + n2);
        this.d = (SingleResponse[])ASN.parseSequenceOf(aSN1Object, j != null ? j : (j = BasicOCSPResponse.a("iaik.x509.ocsp.SingleResponse")));
        int n3 = 3 + n2;
        if (n3 < aSN1Object2.countComponents()) {
            aSN1Object = aSN1Object2.getComponentAt(n3);
            this.i = new OCSPExtensions((ASN1Object)aSN1Object.getValue());
        }
        this.e.clearASN1Object();
        this.e();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.i == null) {
            return false;
        }
        return this.i.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.i == null) {
            return false;
        }
        return this.i.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getTBSResponseData() throws CodingException {
        try {
            if (this.e != null && this.e.toByteArray() != null) {
                return this.e.getFirstObject();
            }
            return DerCoder.encode(this.a());
        }
        catch (OCSPException oCSPException) {
            throw new CodingException(oCSPException.toString());
        }
    }

    public SingleResponse[] getSingleResponses() {
        return this.d;
    }

    public SingleResponse getSingleResponse(ReqCert reqCert) throws OCSPException {
        return (SingleResponse)this.getCertificateResponse(reqCert);
    }

    public SingleResponse getSingleResponse(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        return (SingleResponse)this.getCertificateResponse(x509Certificate, x509Certificate2, generalName);
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.c;
    }

    public byte[] getSignature() {
        return this.b;
    }

    public ObjectID getResponseType() {
        return responseType;
    }

    public ResponderID getResponderID() {
        return this.f;
    }

    public Date getProducedAt() {
        if (this.g == null) {
            return null;
        }
        return this.g.getDate();
    }

    public byte[] getNonce() throws X509ExtensionInitException {
        Nonce nonce = (Nonce)this.getExtension(Nonce.oid);
        if (nonce == null) {
            return null;
        }
        return nonce.getValue();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.i == null) {
            return null;
        }
        return this.i.getExtension(objectID);
    }

    public byte[] getEncoded() {
        this.c();
        return this.e.toByteArray();
    }

    public X509Certificate[] getCertificates() {
        return this.l;
    }

    public CertificateResponse getCertificateResponse(ReqCert reqCert) throws OCSPException {
        if (this.d != null) {
            Object object;
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.d.length) {
                object2 = this.d[n2];
                if (((SingleResponse)object2).isResponseFor(reqCert)) {
                    return object2;
                }
                if (reqCert.getType() != ((SingleResponse)object2).getReqCert().getType()) {
                    bl = true;
                } else if (!bl2 && reqCert.getType() == 0) {
                    object = (CertID)reqCert.getReqCert();
                    CertID certID = (CertID)((SingleResponse)object2).getReqCert().getReqCert();
                    if (!((CertID)object).getHashAlgorithm().equals(certID.getHashAlgorithm())) {
                        bl2 = true;
                    }
                }
                ++n2;
            }
            if (bl || bl2) {
                object2 = "No response found, but some responses have ";
                object = bl2 ? "certIDs with different hash algorithms" : "";
                object2 = String.valueOf(object2) + (String)(bl ? "different ReqCert types " + (bl2 ? "or " + (String)object : "") : (bl2 ? object : ""));
                throw new OCSPException((String)object2);
            }
        }
        return null;
    }

    public CertificateResponse getCertificateResponse(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        if (this.d != null) {
            Throwable throwable = null;
            int n2 = 0;
            while (n2 < this.d.length) {
                block6: {
                    SingleResponse singleResponse = this.d[n2];
                    try {
                        if (singleResponse.isResponseFor(x509Certificate, x509Certificate2, generalName)) {
                            return singleResponse;
                        }
                    }
                    catch (OCSPException oCSPException) {
                        if (throwable != null) break block6;
                        throwable = oCSPException;
                    }
                }
                ++n2;
            }
            if (throwable != null) {
                throw new OCSPException("Cannot check single responses. " + throwable.getMessage());
            }
        }
        return null;
    }

    public void decode(byte[] byArray) throws CodingException {
        try {
            this.e = new ASN1(byArray);
            this.b();
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.toString());
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            this.e = new ASN1(inputStream);
            this.b();
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new IOException(x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.e = new ASN1(aSN1Object);
        try {
            this.b();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private ASN1Object a() throws OCSPException {
        if (this.f == null) {
            throw new OCSPException("Responder ID not set!");
        }
        if (this.g == null) {
            throw new OCSPException("ProducedAt date not set!");
        }
        if (this.d == null || this.d.length == 0) {
            throw new OCSPException("No single responses set!");
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a - 1)));
            }
            sEQUENCE.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(this.g.toASN1Object());
            sEQUENCE.addComponent(ASN.createSequenceOf(this.d));
            if (this.i != null) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.i.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new OCSPException(exception.toString());
        }
    }

    public int countSingleResponses() {
        return this.d.length;
    }

    public int countExtensions() {
        if (this.i == null) {
            return 0;
        }
        return this.i.countExtensions();
    }

    public boolean containsCertificates() {
        return this.l != null && this.l.length > 0;
    }

    private void c() {
        if (this.h) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.i == null) {
            this.i = new OCSPExtensions();
        }
        this.i.addExtension(v3Extension);
        this.d();
    }

    public BasicOCSPResponse(byte[] byArray) throws CodingException {
        this.decode(byArray);
    }

    public BasicOCSPResponse(InputStream inputStream) throws CodingException, IOException {
        this.decode(inputStream);
    }

    public BasicOCSPResponse() {
        this.a = 1;
        this.e = new ASN1();
        this.d();
    }
}

