/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.SecretKey;

public class EnvelopedDataStream
implements ContentStream {
    static /* synthetic */ Class a;
    protected int block_size = -1;
    protected SecretKey symmetric_key;
    protected EncryptedContentInfoStream encrypted_content_info;
    protected Vector recipient_infos = new Vector();
    protected int version = 0;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(n2), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (bl) {
            int n2 = 0;
            while (n2 < this.recipient_infos.size()) {
                stringBuffer.append("\nRecipientInfo " + (n2 + 1) + ":{\n");
                stringBuffer.append(((RecipientInfo)this.recipient_infos.elementAt(n2)).toString());
                stringBuffer.append("\n}");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.recipient_infos.size() + "\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(String.valueOf(this.encrypted_content_info.toString()) + "}");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        Object object;
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.recipient_infos == null) {
            throw new PKCSException("No recipients specified.");
        }
        if (this.symmetric_key != null) {
            object = this.recipient_infos.elements();
            while (object.hasMoreElements()) {
                ((RecipientInfo)object.nextElement()).encryptKey(this.symmetric_key);
            }
        }
        this.encrypted_content_info.setBlockSize(n2);
        object = new SEQUENCE(true);
        try {
            ((ConstructedType)object).addComponent(new INTEGER(this.version));
            ((ConstructedType)object).addComponent(ASN.createSetOf(this.recipient_infos));
            ((ConstructedType)object).addComponent(this.encrypted_content_info.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return object;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        SecretKey secretKey = ((RecipientInfo)this.recipient_infos.elementAt(n2)).decryptKey(privateKey);
        this.encrypted_content_info.setupCipher(secretKey);
    }

    public void setupCipher(Key key) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        this.encrypted_content_info.setupCipher(key);
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.recipient_infos = Util.getVector(recipientInfoArray);
    }

    public void setBlockSize(int n2) {
        this.block_size = n2;
    }

    public int getVersion() {
        return this.version;
    }

    public RecipientInfo[] getRecipientInfos() {
        return (RecipientInfo[])Util.toArray(this.recipient_infos, a != null ? a : (a = EnvelopedDataStream.a("iaik.pkcs.pkcs7.RecipientInfo")));
    }

    public RecipientInfo getRecipientInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.recipient_infos.elements();
        while (enumeration.hasMoreElements()) {
            RecipientInfo recipientInfo = (RecipientInfo)enumeration.nextElement();
            IssuerAndSerialNumber issuerAndSerialNumber = recipientInfo.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber == null || !issuerAndSerialNumber.isIssuerOf(x509Certificate)) continue;
            return recipientInfo;
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.encrypted_content_info.getInputStream();
    }

    public Object getEncryptedContentInfo() {
        return this.encrypted_content_info;
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_envelopedData;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        try {
            this.recipient_infos = Util.getVector((RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(derInputStream), a != null ? a : (a = EnvelopedDataStream.a("iaik.pkcs.pkcs7.RecipientInfo"))));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.encrypted_content_info = new EncryptedContentInfoStream(derInputStream);
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        this.recipient_infos.addElement(recipientInfo);
    }

    public EnvelopedDataStream(RecipientInfo[] recipientInfoArray, EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.recipient_infos = Util.getVector(recipientInfoArray);
        this.encrypted_content_info = encryptedContentInfoStream;
    }

    public EnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this();
        this.encrypted_content_info = new EncryptedContentInfoStream(ObjectID.pkcs7_data, inputStream);
        this.symmetric_key = this.encrypted_content_info.setupCipher(algorithmID, n2);
    }

    public EnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.encrypted_content_info = new EncryptedContentInfoStream(ObjectID.pkcs7_data, inputStream);
        this.symmetric_key = this.encrypted_content_info.setupCipher(algorithmID);
    }

    public EnvelopedDataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    protected EnvelopedDataStream() {
    }
}

