/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.util;

import com.metamatrix.sequelink.net.NetOutput;
import com.metamatrix.sequelink.util.BufferManager;
import com.metamatrix.sequelink.util.UtilMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileOutputStream
extends NetOutput {
    private RandomAccessFile raf;
    long position;

    public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
    }

    public void write(int n) throws IOException {
        this.raf.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.raf.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.raf.write(byArray, n, n2);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        byte[] byArray = BufferManager.GetBuffer(n);
        try {
            n = inputStream.read(byArray, 0, n);
            this.raf.write(byArray, 0, n);
        }
        finally {
            BufferManager.ReturnBuffer(byArray);
        }
        return n;
    }

    public int getPosition() throws IOException {
        long l = this.raf.getFilePointer();
        if (l > Integer.MAX_VALUE) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.raf.oor"));
        }
        return (int)l;
    }

    public void setPosition(int n) throws IOException {
        this.raf.seek(n);
    }

    public int getFreeSpace() {
        return 0;
    }

    public int getIncrement() {
        return 0;
    }
}

