/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.SPDU;
import com.metamatrix.sequelink.net.SPDUFormat;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SPDUDecoder
extends SPDUFormat {
    protected DataInputStream dis;
    private SPDU spdu;

    public SPDUDecoder(InputStream inputStream) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        byte[] byArray = this.decodeSessionKey();
        int n = this.decodeSpduType();
        this.spdu = new SPDU(n, byArray);
    }

    public SPDUDecoder(SPDU sPDU, InputStream inputStream) {
        this.dis = new DataInputStream(inputStream);
        this.spdu = sPDU;
    }

    public SPDU getSpdu() {
        return this.spdu;
    }

    private byte[] decodeSessionKey() throws NetworkException {
        byte[] byArray;
        try {
            byte by = this.dis.readByte();
            byArray = new byte[by];
            if (by > 0) {
                this.dis.readFully(byArray);
            }
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        return byArray;
    }

    private int decodeSpduType() throws NetworkException {
        byte by;
        try {
            by = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
        return SPDUDecoder.getSpduType(by);
    }

    protected int decodeTag(int n) throws NetworkException {
        try {
            byte by = this.dis.readByte();
            if (n != by) {
                throw SPDU.getException(7574);
            }
            byte by2 = this.dis.readByte();
            switch (by2) {
                case 1: {
                    return this.dis.readByte();
                }
                case 2: {
                    return this.dis.readShort();
                }
                case 4: {
                    return this.dis.readInt();
                }
            }
            throw SPDU.getException(7575);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }
}

