/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.sequelink.describe.VariableDescriptor;

public class SequeLinkParamDescribe {
    private VariableDescriptor[] describe;
    private int position;
    private int mode;
    private int type;
    private String typeName;
    private int precision;
    private int scale;
    private int nullable;
    private boolean signed;
    private String encoding;
    private boolean isBadDescribeParam54;

    public SequeLinkParamDescribe(VariableDescriptor[] variableDescriptorArray, int n, boolean bl) {
        this.position = n;
        this.describe = variableDescriptorArray;
        this.isBadDescribeParam54 = bl;
        this.type = this._getType();
        this.encoding = this._getEncoding();
        this.precision = this._getPrecision();
        this.scale = this._getScale();
        this.typeName = this._getTypeName();
        this.nullable = this._isNullable();
        this.signed = this._isSigned();
        this.mode = this._getMode();
        this.describe = null;
    }

    public int getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int isNullable() {
        return this.nullable;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getMode() {
        return this.mode;
    }

    public String getTypeClassName() {
        String string;
        switch (this.type) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private int _getLength() {
        VariableDescriptor variableDescriptor = this.describe[4];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private int _getType() {
        VariableDescriptor variableDescriptor = this.describe[0];
        int n = (Integer)variableDescriptor.getInfo();
        if (n == -8) {
            n = 1;
        } else if (n == -9) {
            n = 12;
        } else if (n == -10) {
            n = -1;
        }
        return n;
    }

    private String _getTypeName() {
        VariableDescriptor variableDescriptor = this.describe[1];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private int _getPrecision() {
        int n;
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                n = this._getLength();
                break;
            }
            case 2: 
            case 3: {
                n = this._getLength();
                if (this.isBadDescribeParam54) break;
                int n2 = this._getScale();
                if (n2 > 0) {
                    if (this._isSigned()) {
                        n -= 2;
                        break;
                    }
                    --n;
                    break;
                }
                if (n2 == 0) {
                    if (!this._isSigned()) break;
                    --n;
                    break;
                }
                --n;
                break;
            }
            case 4: {
                n = 10;
                break;
            }
            case 6: 
            case 8: {
                n = 15;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 7: {
                n = 7;
                break;
            }
            case 91: {
                n = 10;
                break;
            }
            case 92: {
                n = 8;
                break;
            }
            case 93: {
                n = this._getLength();
                break;
            }
            case -6: {
                n = 3;
                break;
            }
            case -7: {
                n = 1;
                break;
            }
            case -5: {
                n = this._isSigned() ? 19 : 20;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int _getScale() {
        VariableDescriptor variableDescriptor = this.describe[5];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private int _isNullable() {
        VariableDescriptor variableDescriptor = this.describe[3];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }

    private boolean _isSigned() {
        VariableDescriptor variableDescriptor = this.describe[2];
        int n = (Integer)variableDescriptor.getInfo();
        return n == 0;
    }

    private String _getEncoding() {
        VariableDescriptor variableDescriptor = this.describe[7];
        String string = (String)variableDescriptor.getInfo();
        return string;
    }

    private int _getMode() {
        VariableDescriptor variableDescriptor = this.describe[6];
        int n = (Integer)variableDescriptor.getInfo();
        return n;
    }
}

