/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseBatchUpdateException;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetClientSideInsensitive;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerCallAnalyzer;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSet;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSetServerSideCursor;
import com.metamatrix.jdbc.sqlserver.tds.TDSCancelRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCCallRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCCursorExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCNonCursorExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.util.UtilVectorUnsynced;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public final class SQLServerImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.69.1.5  $";
    TDSRequest request;
    TDSConnection conn;
    public SQLServerByteOrderedDataWriter writer;
    public SQLServerByteOrderedDataReader reader;
    SQLServerImplResultSet resultSet;
    protected BaseImplResultSetClientSideInsensitive generatedKeyImplResult;
    protected BaseColumns keyColumns;
    int resultSetScrollType;
    int resultSetConcurrency;
    public BaseExceptions exceptions;
    BaseBatchUpdateException bbup = null;
    boolean procHasReturnParam;
    boolean isPreparedStatement;
    boolean firstExecute;
    String databaseAtPrepareTime = null;
    private boolean encodeProcInRPC;
    String procName;
    boolean isBatchRequest;
    private BigDecimal autoGeneratedKeyValue;
    private static final int PREPARE_OPERATION = 1;
    private static final int EXECUTE_OPERATION = 2;
    private static final int EXECUTESQL_OPERATION = 3;
    boolean filterTriggers;
    boolean setRowCount;
    SQLServerCallAnalyzer callAnalyzer;
    int resultTypeReported;
    private boolean cancelOnNextRead = false;
    private boolean cancelableWork = false;

    public SQLServerImplStatement(TDSConnection tDSConnection, int n, int n2, BaseExceptions baseExceptions) {
        this.conn = tDSConnection;
        this.exceptions = baseExceptions;
        this.resultSetScrollType = n;
        this.resultSetConcurrency = n2;
        this.writer = this.conn.getWriter();
        this.reader = this.conn.createReader();
        this.initFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCancelableWork() {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            return this.cancelableWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelableWork(boolean bl) {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            this.cancelableWork = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCancelOnNextRead() {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            return this.cancelOnNextRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelOnNextRead(boolean bl) {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            this.cancelOnNextRead = bl;
        }
    }

    private void initFields() {
        this.request = null;
        this.resultSet = null;
        this.isPreparedStatement = false;
        this.firstExecute = true;
        this.encodeProcInRPC = false;
        this.procName = null;
        this.procHasReturnParam = false;
    }

    protected void setSQL(BaseSQL baseSQL) throws SQLException {
        if (this.request != null) {
            try {
                this.processAnyCancelReply();
                this.request.unprepare(this.warnings);
                if (this.conn.getTDSVersion() > 2 && !this.conn.connection.exposedAutoCommitMode && this.conn.sqlHasTransactionKeyword) {
                    this.conn.currentlyRegisteredRequest.readTransactionDescriptor(this.warnings);
                }
                this.request.discardReplyBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initFields();
        super.setSQL(baseSQL);
        this.filterTriggers = this.shouldFilterTriggerResults();
        this.setRowCount = this.shouldSetRowCount();
        this.conn.sqlHasTransactionKeyword = false;
        if (this.conn.getTDSVersion() > 2 && !this.conn.connection.exposedAutoCommitMode) {
            this.conn.sqlHasTransactionKeyword = this.statementHasTransaction();
        }
    }

    public void close() throws SQLException {
        if (this.request != null) {
            this.processAnyCancelReply();
            this.discardUnmaterializedResultSet();
            this.request.unprepare(this.warnings);
            this.request.discardReplyBytes();
        }
        this.reader.close();
    }

    public void reset() throws SQLException {
        if (this.request != null) {
            if (this.request.prepareSubmitted && this.request.prepareHandleParam.data.isNull) {
                this.request.readPrepareHandle(this.warnings);
            }
            this.processAnyCancelReply();
            this.request.discardReplyBytes();
        }
        super.reset();
    }

    public void checkForProcedureParameters() throws SQLException {
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n = 1;
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        while (n != 12 && n != 11) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 17) continue;
            switch (n) {
                case 1: {
                    this.procName = "";
                    this.procHasReturnParam = false;
                    this.encodeProcInRPC = false;
                    if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                        n = 2;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 2: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 3;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 3: {
                    if (baseSQLToken.type == 7) {
                        this.procHasReturnParam = true;
                        n = 4;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 4: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 5: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 5) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 6;
                        break;
                    }
                    if (baseSQLToken.type == 15) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 7;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 9;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 6: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    if (baseSQLToken.type == 5) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 6;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 7: {
                    if (baseSQLToken.type == 16) {
                        try {
                            Integer.parseInt(baseSQLToken.value);
                            this.procName = this.procName + baseSQLToken.value;
                            n = 8;
                        }
                        catch (Exception exception) {
                            n = 11;
                        }
                        break;
                    }
                    n = 11;
                    break;
                }
                case 8: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 9;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 9: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 1) {
                        n = 10;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 10: {
                    n = baseSQLToken.type == 8 ? 9 : 11;
                }
            }
        }
        if (n == 12) {
            this.encodeProcInRPC = true;
        } else {
            this.procHasReturnParam = false;
            this.encodeProcInRPC = false;
            this.procName = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelWithStatus(int n) throws SQLException {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            if (this.conn.getCancelPendingStatement() != null || n == 0 && !this.getCancelableWork()) {
                return false;
            }
            TDSCancelRequest tDSCancelRequest = new TDSCancelRequest(this.conn, this.reader, this.writer);
            tDSCancelRequest.submitRequest(null);
            this.conn.setCancelPendingStatement(this);
            if (n == 0) {
                this.setCancelOnNextRead(true);
            }
            return true;
        }
    }

    private void unprepare() throws SQLException {
        if (this.request != null) {
            this.request.unprepare(this.warnings);
        }
    }

    public int getRequiredSQLProcessing(String string) {
        return 4;
    }

    public void prepare() throws SQLException {
        this.isPreparedStatement = true;
    }

    public void returnOutputParams() throws SQLException {
        int n = this.sql.getParameterCount();
        BaseParameters baseParameters = null;
        if (this.parameterSets == null) {
            return;
        }
        baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        int n2 = 0;
        if (baseParameters.parameterOrder == 2) {
            for (int i = 1; i <= n; ++i) {
                BaseParameter baseParameter = baseParameters.get(i, 2);
                if (baseParameter == null) continue;
                if (i == 1 && this.procHasReturnParam && this.encodeProcInRPC) {
                    ((TDSRPCRequest)this.request).populateReturnParam(baseParameter);
                    continue;
                }
                ((TDSRPCRequest)this.request).populateOuputParam(baseParameter, ++n2);
            }
        } else {
            boolean bl = false;
            for (int i = 1; i <= n; ++i) {
                BaseParameter baseParameter = baseParameters.get(i, 2);
                if (baseParameter == null) continue;
                if (this.procHasReturnParam && !bl && this.encodeProcInRPC && baseParameter.name.equalsIgnoreCase("@RETURN_VALUE")) {
                    bl = true;
                    ((TDSRPCRequest)this.request).populateReturnParam(baseParameter);
                    continue;
                }
                ((TDSRPCRequest)this.request).populateOuputParam(baseParameter, ++n2);
            }
        }
    }

    public void execute() throws SQLException {
        Object object;
        this.generatedKeyImplResult = null;
        this.keyColumns = null;
        this.isBatchRequest = false;
        this.resultTypeReported = 0;
        if (this.setRowCount) {
            if (this.maxRows != ((SQLServerImplConnection)this.implConnection).maxRows) {
                object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                ((TDSExecuteRequest)object).setSQL("SET ROWCOUNT " + this.maxRows);
                ((TDSExecuteRequest)object).submitRequest(null);
                ((TDSRequest)object).processReply(3, this.warnings);
                ((TDSRequest)object).discardReplyBytes();
                ((SQLServerImplConnection)this.implConnection).maxRows = this.maxRows;
            }
        } else if (0 != ((SQLServerImplConnection)this.implConnection).maxRows) {
            object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
            ((TDSExecuteRequest)object).setSQL("SET ROWCOUNT 0");
            ((TDSExecuteRequest)object).submitRequest(null);
            ((TDSRequest)object).processReply(3, this.warnings);
            ((TDSRequest)object).discardReplyBytes();
            ((SQLServerImplConnection)this.implConnection).maxRows = 0;
        }
        if (this.maxFieldSize == 0) {
            SQLServerImplConnection cfr_ignored_0 = (SQLServerImplConnection)this.implConnection;
            this.maxFieldSize = SQLServerImplConnection.defaultMaxFieldSize;
        }
        if (this.maxFieldSize != ((SQLServerImplConnection)this.implConnection).maxFieldSize) {
            object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
            ((TDSExecuteRequest)object).setSQL("SET TEXTSIZE " + this.maxFieldSize);
            ((TDSExecuteRequest)object).submitRequest(null);
            ((TDSRequest)object).processReply(3, this.warnings);
            ((TDSRequest)object).discardReplyBytes();
            ((SQLServerImplConnection)this.implConnection).maxFieldSize = this.maxFieldSize;
        }
        if (this.isPreparedStatement) {
            if (!this.firstExecute && !this.databaseAtPrepareTime.equalsIgnoreCase(this.conn.getCatalog())) {
                this.firstExecute = true;
            }
            if (this.firstExecute) {
                this.checkForProcedureParameters();
                if (this.encodeProcInRPC) {
                    this.createCallRequest();
                } else {
                    this.createPreparedRequest();
                }
                this.firstExecute = false;
                this.databaseAtPrepareTime = this.conn.getCatalog();
            }
        } else {
            this.createUnpreparedRequest();
        }
        if (this.request instanceof TDSRPCCursorExecuteRequest) {
            ((TDSRPCCursorExecuteRequest)this.request).setFetchSize(this.getMaxRows(), this.fetchSize);
        }
        if (!this.isPreparedStatement) {
            if (this.requireServerSideCursor()) {
                ((TDSRPCExecuteRequest)this.request).setSQL(this.sql.getFormatted());
            } else {
                object = this.sql.getFormatted();
                if (this.autoGeneratedKeysRequested) {
                    object = (String)object + this.getScopeIdentitySQL();
                } else if (this.requestedKeyColumns != null) {
                    object = this.getSqlWithOutputClause();
                }
                ((TDSExecuteRequest)this.request).setSQL((String)object);
            }
        }
        try {
            this.request.execute(this, this.warnings);
            this.setCancelableWork(false);
        }
        catch (SQLException sQLException) {
            this.setCancelableWork(false);
            this.setCancelOnNextRead(false);
            if (sQLException.getMessage().indexOf("DDTEK1") != -1) {
                this.conn.close();
                throw sQLException;
            }
            throw sQLException;
        }
        this.isBatchRequest = false;
    }

    public String getScopeIdentitySQL() {
        if (this.conn.getTDSVersion() == 1) {
            return " select @@identity";
        }
        return " select SCOPE_IDENTITY()";
    }

    public void executeBatch() throws SQLException, BatchUpdateException {
        if (this.isSimpleSelect()) {
            throw this.exceptions.getException(6053);
        }
        if (!this.firstExecute && !this.databaseAtPrepareTime.equalsIgnoreCase(this.conn.getCatalog())) {
            this.firstExecute = true;
        }
        if (this.firstExecute) {
            this.checkForProcedureParameters();
            if (this.encodeProcInRPC) {
                this.createCallRequest();
            } else {
                this.createPreparedRequest();
            }
            this.firstExecute = false;
            this.databaseAtPrepareTime = this.conn.getCatalog();
        }
        try {
            this.bbup = null;
            this.request.execute(this, this.warnings);
            this.setCancelableWork(false);
        }
        catch (SQLException sQLException) {
            this.setCancelableWork(false);
            this.setCancelOnNextRead(false);
            if (sQLException.getMessage().indexOf("DDTEK1") != -1) {
                this.conn.close();
                throw sQLException;
            }
            if (sQLException.getMessage().indexOf("SOCKETTIMEOUT") != -1) {
                throw sQLException;
            }
            if (sQLException.getSQLState() != null && sQLException.getSQLState().startsWith("08")) {
                throw sQLException;
            }
            this.bbup = new BaseBatchUpdateException(sQLException, new int[0]);
        }
        this.isBatchRequest = true;
    }

    public int[] getBatchRowsAffectedCount() throws SQLException {
        int[] nArray = new int[this.parameterSets.size()];
        int n = 0;
        int[] nArray2 = new int[1];
        boolean bl = false;
        while (!bl) {
            try {
                bl = this.request.getResultOfSingleExecuteInBatch(nArray2, this.warnings);
                if (bl) continue;
                nArray[n++] = nArray2[0];
            }
            catch (SQLException sQLException) {
                if (this.bbup == null) {
                    this.bbup = new BaseBatchUpdateException(sQLException, null);
                } else {
                    this.bbup.setNextException(sQLException);
                }
                if (n >= nArray.length) continue;
                nArray[n++] = -3;
            }
        }
        if (this.bbup == null) {
            return nArray;
        }
        if (n == nArray.length) {
            this.bbup.setUpdateCounts(nArray);
            throw this.bbup;
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[i];
        }
        this.bbup.setUpdateCounts(nArray3);
        throw this.bbup;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.databaseMetaDataResultSet == 3 || this.databaseMetaDataResultSet == 4) {
            return baseColumns;
        }
        BaseColumns baseColumns2 = this.request == null ? this.getColumnInfoBeforeExecute() : this.request.getColumnDescriptions();
        if (baseColumns == null) {
            return baseColumns2;
        }
        if (this.databaseMetaDataResultSet == 8) {
            BaseColumn baseColumn = baseColumns.get(1);
            BaseColumn baseColumn2 = baseColumns2.get(1);
            baseColumn.displaySize = baseColumn2.displaySize;
        } else {
            for (int i = 1; i <= baseColumns.count(1); ++i) {
                if (i > baseColumns2.count(0)) continue;
                BaseColumn baseColumn = baseColumns.get(i);
                BaseColumn baseColumn3 = baseColumns2.get(i);
                baseColumn.displaySize = baseColumn3.displaySize;
            }
        }
        return baseColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextResultType() throws SQLException {
        try {
            this.discardUnmaterializedResultSet();
            if (this.isBatchRequest) {
                int n = this.resultTypeReported = 3;
                return n;
            }
            if (this.requestedKeyColumns != null && this.generatedKeyImplResult == null) {
                this.request.processReply(1, this.warnings);
                this.generatedKeyImplResult = new BaseImplResultSetClientSideInsensitive(this.conn.connection);
                this.generatedKeyImplResult.setImplStatement(this);
                this.keyColumns = this.describeColumns(null);
                this.generatedKeyImplResult.setColumns(this.keyColumns);
                BaseImplResultSet baseImplResultSet = this.getNextResultSet();
                baseImplResultSet.setImplStatement(this);
                this.generatedKeyImplResult.setSubResultSet(baseImplResultSet);
                this.generatedKeyImplResult.setupForNextResultSetInMultipleResult(-1);
                int n = this.getNextResultType();
                return n;
            }
            if (this.request instanceof TDSRPCCursorExecuteRequest && !((TDSRPCCursorExecuteRequest)this.request).getExecutingSQLDirectly()) {
                int n = this.resultTypeReported = this.request.getResultType();
                return n;
            }
            switch (this.resultTypeReported) {
                case 0: {
                    if (this.filterTriggers) {
                        this.request.processReply(5, this.warnings);
                        break;
                    }
                    this.request.processReply(1, this.warnings);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.resultSet = null;
                    this.request.processReply(1, this.warnings);
                }
            }
            if (this.request.getResultType() == 1) {
                this.returnOutputParams();
            }
            int n = this.resultTypeReported = this.request.getResultType();
            return n;
        }
        finally {
            if (this.getCancelOnNextRead()) {
                this.setCancelableWork(false);
                this.setCancelOnNextRead(false);
                throw this.implConnection.exceptions.getException(6078, "HY008");
            }
        }
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        if (this.requestedKeyColumns != null) {
            return this.keyColumns;
        }
        if (!this.filterTriggers) {
            this.request.processReply(5, this.warnings);
        }
        try {
            this.autoGeneratedKeyValue = this.request.getColumn((int)1).data.getBigDecimal(null);
        }
        catch (Exception exception) {
            this.autoGeneratedKeyValue = null;
        }
        if (this.autoGeneratedKeyValue != null) {
            BaseColumns baseColumns = this.request.getColumnDescriptions();
            BaseColumn baseColumn = baseColumns.get(1);
            baseColumn.label = "IDENTITYCOL";
            baseColumn.name = "IDENTITYCOL";
            return baseColumns;
        }
        return null;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        if (this.requestedKeyColumns != null) {
            return this.generatedKeyImplResult;
        }
        return new SQLServerAutoGeneratedKeyResultSet();
    }

    protected String getSqlWithOutputClause() throws SQLException {
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        String string = "";
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
        while (baseSQLToken.type != 6) {
            String string2;
            if (baseSQLToken.type == 9 && ((string2 = baseSQLToken.value.toLowerCase()).equals("values") || string2.equals("select"))) {
                string = string + "output inserted." + this.requestedKeyColumns[0] + " ";
                for (int i = 1; i < this.requestedKeyColumns.length; ++i) {
                    string = string + ", inserted." + this.requestedKeyColumns[i] + " ";
                }
            }
            string = string + baseSQLToken.value;
            baseSQLToken = baseSQLScanner.getNextToken();
        }
        return string;
    }

    public BaseImplResultSet getNextResultSet() {
        if (this.request instanceof TDSRPCCursorExecuteRequest) {
            this.resultSet = this.getConnection().getImplResultSetServerSideCursor();
            if (this.resultSet == null) {
                this.resultSet = new SQLServerImplResultSetServerSideCursor();
            }
            ((SQLServerImplResultSetServerSideCursor)this.resultSet).initialize((TDSRPCCursorExecuteRequest)this.request, this.longDataCacheSize);
        } else {
            this.resultSet = this.getConnection().getImplResultSet();
            if (this.resultSet == null) {
                this.resultSet = new SQLServerImplResultSet();
            }
            this.resultSet.initialize(this.request, this.longDataCacheSize);
        }
        return this.resultSet;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.request != null) {
            return this.request.getNumRowsAffected();
        }
        return 0;
    }

    private boolean isSimpleSelect() {
        return this.sql.getType() == 1;
    }

    private boolean mustDescribeOutputParameters() {
        if (this.parameterSets != null && this.parameterSets.size() == 1 && this.getImplConnection().receiveStringParameterType == 2) {
            BaseParameters baseParameters = null;
            baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            int n = baseParameters.count();
            for (int i = 1; i <= n; ++i) {
                BaseParameter baseParameter = baseParameters.getOutput(i);
                if (baseParameter == null || baseParameter.sqlType != 1 && baseParameter.sqlType != 12 && baseParameter.sqlType != -1 && baseParameter.sqlType != 2005 && baseParameter.sqlType != -2 && baseParameter.sqlType != -3 && baseParameter.sqlType != -4 && baseParameter.sqlType != 2004) continue;
                return true;
            }
        }
        return false;
    }

    void obtainNativeParamInfo(UtilVectorUnsynced utilVectorUnsynced) {
        try {
            this.pstmt.determineParameterMetaData();
            BaseParameters baseParameters = null;
            baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            int n = baseParameters.count();
            block10: for (int i = 0; i < n; ++i) {
                String string = baseParameters.getParameterInfo((int)i).nativeTypeName;
                baseParameters.parametersIn[i].transliterator = baseParameters.getParameterInfo((int)i).transliterator;
                TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)utilVectorUnsynced.get(i);
                switch (string.length()) {
                    case 7: {
                        baseParameters.parametersIn[i].nativeType = 39;
                        continue block10;
                    }
                    case 8: {
                        baseParameters.parametersIn[i].nativeType = -25;
                        continue block10;
                    }
                    case 4: {
                        if (string.equalsIgnoreCase("TEXT")) {
                            baseParameters.parametersIn[i].nativeType = 35;
                            continue block10;
                        }
                        baseParameters.parametersIn[i].nativeType = 39;
                        continue block10;
                    }
                    case 5: {
                        if (string.equalsIgnoreCase("NTEXT")) {
                            baseParameters.parametersIn[i].nativeType = 99;
                            continue block10;
                        }
                        baseParameters.parametersIn[i].nativeType = -17;
                        continue block10;
                    }
                    case 12: {
                        if (!string.equalsIgnoreCase("VARCHAR(MAX)")) continue block10;
                        baseParameters.parametersIn[i].nativeType = 39;
                        tDSRPCParameter.maxLength = 65535;
                        continue block10;
                    }
                    case 13: {
                        if (!string.equalsIgnoreCase("NVARCHAR(MAX)")) continue block10;
                        baseParameters.parametersIn[i].nativeType = -25;
                        tDSRPCParameter.maxLength = 65535;
                        continue block10;
                    }
                    default: {
                        baseParameters.parametersIn[i].nativeType = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean useServerSideCursor() {
        return this.getImplConnection().useServerSideCursor;
    }

    private boolean shouldFilterTriggerResults() throws SQLException {
        if (this.getImplConnection().alwaysReportTriggerResults) {
            return false;
        }
        if (this.sql.getStatementCount() > 1) {
            return false;
        }
        if (this.sql.getType() == 4 || this.sql.getType() == 5 || this.sql.getType() == 6) {
            boolean bl = false;
            if (this.conn.getDatabaseMajorVersion() >= 9) {
                bl = true;
            }
            return !this.isSpecialStatement(bl, false);
        }
        if (this.conn.getDatabaseMajorVersion() >= 9) {
            String string = this.sql.getVerb().toLowerCase();
            if (string.startsWith("create") || string.equals("alter") || string.equals("drop")) {
                return !this.isSpecialStatement(false, true);
            }
            if (string.equals("grant") || string.equals("deny") || string.equals("revoke")) {
                return !this.isSpecialStatement(false, false);
            }
        }
        return false;
    }

    private boolean shouldSetRowCount() {
        if (this.sql.getStatementCount() > 1) {
            return false;
        }
        if (this.sql.getType() == 1) {
            return !this.isSpecialStatement(false, false);
        }
        return false;
    }

    public boolean isSpecialStatement(boolean bl, boolean bl2) {
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        boolean bl3 = false;
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        while (true) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 6) {
                return false;
            }
            if (baseSQLToken.type == 17 || baseSQLToken.type == 2 || baseSQLToken.type != 9) continue;
            if (bl3) {
                String string = baseSQLToken.value.toLowerCase();
                if (string.equals("exec") || string.equals("execute") || bl && string.equals("output")) {
                    return true;
                }
                if (!bl2 || !string.equals("create") && !string.equals("insert") && !string.equals("delete") && !string.equals("update") && !string.equals("select") && !string.equals("drop")) continue;
                return true;
            }
            bl3 = true;
        }
    }

    public boolean statementHasTransaction() {
        String string;
        BaseSQLToken baseSQLToken;
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        do {
            baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type != 6) continue;
            return false;
        } while (baseSQLToken.type == 17 || baseSQLToken.type == 2 || baseSQLToken.type != 9 || !(string = baseSQLToken.value.toLowerCase()).equals("commit") && !string.equals("rollback"));
        return true;
    }

    public boolean supportsScrolling(int n) {
        if (n == 1004 || n == 1005) {
            if (this.resultSetConcurrency == 1007) {
                return true;
            }
            return this.getImplConnection().useServerSideUpdatableCursors;
        }
        return false;
    }

    public boolean supportsUpdates() {
        return this.getImplConnection().useServerSideUpdatableCursors;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    private SQLServerImplConnection getImplConnection() {
        return (SQLServerImplConnection)this.implConnection;
    }

    private SQLServerConnection getConnection() {
        return this.getImplConnection().connection;
    }

    private BaseColumns getColumnInfoBeforeExecute() {
        BaseColumns baseColumns = null;
        if (this.isSimpleSelect()) {
            BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
            String string = this.sql.getFormatted();
            String string2 = "SET FMTONLY ON ";
            baseSQLScanner.setup(string, '\'', '\"');
            if (this.sql.getParameterCount() > 0) {
                while (true) {
                    BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                    if (baseSQLToken.type != 6) {
                        if (baseSQLToken.type == 8) {
                            string2 = string2 + "null";
                            continue;
                        }
                        string2 = string2 + baseSQLToken.value;
                        continue;
                    }
                    break;
                }
            } else {
                string2 = string2 + string;
            }
            string2 = string2 + " SET FMTONLY OFF";
            try {
                TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                tDSExecuteRequest.setSQL(string2);
                tDSExecuteRequest.submitRequest(null);
                tDSExecuteRequest.processReply(1, this.warnings);
                tDSExecuteRequest.discardReplyBytes();
                baseColumns = tDSExecuteRequest.getColumnDescriptions();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseColumns;
    }

    private boolean requireServerSideCursor() {
        if (this.isSimpleSelect()) {
            if (this.useServerSideCursor()) {
                return true;
            }
            if (this.supportsScrolling(this.resultSetScrollType)) {
                return true;
            }
            if (this.sql.hasForUpdate()) {
                return true;
            }
            if (this.sql.hasForReadOnly()) {
                return true;
            }
            if (this.getImplConnection().useServerSideUpdatableCursors && this.resultSetConcurrency == 1008) {
                return true;
            }
        }
        return false;
    }

    private void createUnpreparedRequest() {
        if (this.requireServerSideCursor()) {
            this.request = this.createCursorRequest();
            ((TDSRPCRequest)this.request).setMaxPrecision(this.getImplConnection().maxPrecision);
        } else {
            this.request = new TDSExecuteRequest(this.conn, this.reader, this.writer);
        }
    }

    private void createPreparedRequest() throws SQLException {
        TDSRPCExecuteRequest tDSRPCExecuteRequest = this.requireServerSideCursor() ? this.createCursorRequest() : new TDSRPCNonCursorExecuteRequest(this.conn, this.reader, this.writer, this.isPreparedStatement);
        tDSRPCExecuteRequest.createUserParameters(this.parameterSets, this.getImplConnection().maxPrecision, this.getImplConnection().sendStringParametersAsUnicode, this.getImplConnection().receiveStringParameterType);
        if (this.mustDescribeOutputParameters()) {
            this.callAnalyzer = new SQLServerCallAnalyzer(this.exceptions, this.conn, this.reader, this.writer, this.sql, tDSRPCExecuteRequest.getUserParameters(), false);
            this.callAnalyzer.describeOuputParams();
        }
        if (((SQLServerImplConnection)this.implConnection).describeParameters && this.parameterSets != null && this.parameterSets.size() == 1) {
            this.obtainNativeParamInfo(tDSRPCExecuteRequest.getUserParameters());
        }
        this.changeParameterMarkers();
        String string = this.sql.getFormatted();
        if (this.autoGeneratedKeysRequested) {
            string = string + this.getScopeIdentitySQL();
        } else if (this.requestedKeyColumns != null) {
            string = this.getSqlWithOutputClause();
        }
        tDSRPCExecuteRequest.setSQL(string);
        this.request = tDSRPCExecuteRequest;
    }

    private TDSRPCCursorExecuteRequest createCursorRequest() {
        int n = ((SQLServerImplConnection)this.implConnection).lockingModeConcurrency;
        boolean bl = ((SQLServerImplConnection)this.implConnection).useServerSideUpdatableCursors;
        if (!bl && this.sql.hasForUpdate() && n == 1) {
            n = 0;
            this.warnings.add(7020);
        }
        String string = null;
        try {
            string = this.sql.getSingleTableFromSpecification();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TDSRPCCursorExecuteRequest(this.conn, this.reader, this.writer, this.isPreparedStatement, this.resultSetScrollType, this.resultSetConcurrency, string, bl, n, this.sql.hasForUpdate(), this.sql.hasForReadOnly());
    }

    private void createCallRequest() throws SQLException {
        TDSRPCCallRequest tDSRPCCallRequest = new TDSRPCCallRequest(this.conn, this.reader, this.writer, this.procName, this.procHasReturnParam);
        tDSRPCCallRequest.createUserParameters(this.parameterSets, this.getImplConnection().maxPrecision, this.getImplConnection().sendStringParametersAsUnicode, this.getImplConnection().receiveStringParameterType);
        if (this.mustDescribeOutputParameters()) {
            this.callAnalyzer = new SQLServerCallAnalyzer(this.exceptions, this.conn, this.reader, this.writer, this.sql, tDSRPCCallRequest.getUserParameters(), true);
            this.callAnalyzer.describeOuputParams();
        }
        this.request = tDSRPCCallRequest;
    }

    private void changeParameterMarkers() throws SQLException {
        for (int i = 1; i <= this.sql.getParameterCount(); ++i) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            String string = new String("@P" + i + " ");
            this.procHasReturnParam = false;
            String string2 = this.sql.getStringPreceedingParameter(i - 1);
            if (string2 != null && ((string2 = string2.trim().toUpperCase()).endsWith("EXEC") || string2.endsWith("EXECUTE"))) {
                this.procHasReturnParam = true;
            }
            if (!this.procHasReturnParam && baseParameters.get(i, 2) != null) {
                string = string + " OUTPUT";
            }
            this.sql.setParameter(i - 1, string);
        }
    }

    private void discardUnmaterializedResultSet() throws SQLException {
        if (this.resultTypeReported == 2 && this.resultSet == null) {
            this.resultSet = new SQLServerImplResultSet();
            this.resultSet.setImplStatement(this);
            this.resultSet.initialize(this.request, this.longDataCacheSize);
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processCancelResponse() throws SQLException {
        this.request.clearCancelReply();
    }

    public void processAnyCancelReply() throws SQLException {
        if (this.conn.getCancelPendingStatement() != null) {
            if (this.implConnection.cancelPending) {
                this.implConnection.socketActivityPostCancel();
            } else {
                this.conn.getCancelPendingStatement().processCancelResponse();
            }
            this.resultTypeReported = 0;
        }
    }

    class SQLServerAutoGeneratedKeyResultSet
    extends BaseImplResultSet {
        boolean returnedTheRow = false;

        SQLServerAutoGeneratedKeyResultSet() {
        }

        public boolean fetchAtPosition(int n) throws SQLException {
            if (this.returnedTheRow) {
                return false;
            }
            this.returnedTheRow = true;
            return true;
        }

        public BaseData getData(int n, int n2) throws SQLException {
            return new BaseData(8, SQLServerImplStatement.this.autoGeneratedKeyValue, SQLServerImplStatement.this.conn.connection);
        }

        public void close() throws SQLException {
        }
    }
}

