/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.extensions;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseStatementPool;
import com.metamatrix.jdbc.extensions.ExtStatementPoolMonitorMBean;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ExtStatementPoolMonitor
implements ExtStatementPoolMonitorMBean {
    public static final int TYPE_PREPARED_STATEMENT = 1;
    public static final int TYPE_CALLABLE_STATEMENT = 2;
    private static final String DDTEK_STMT_POOL_HDR = "[DDTEK_STMT_POOL]";
    private static final String DDTEK_STMT_POOL_VERSION_TAG = "VERSION";
    private static final String DDTEK_STMT_POOL_VERSION_VALUE = "1";
    private static final String STMT_ENTRY = "[STMT_ENTRY]";
    private static final String SQLTEXT_START = "SQL_TEXT=[";
    private static final String SQLTEXT_END = "]";
    private static final String STATEMENT_TYPE = "STATEMENT_TYPE=";
    private static final String RESULTSET_TYPE = "RESULTSET_TYPE=";
    private static final String RESULTSET_CONCURRENCY = "RESULTSET_CONCURRENCY=";
    private static final String AUTOGENERATEDKEYSREQUESTED = "AUTOGENERATEDKEYSREQUESTED=";
    private static final String REQUESTEDKEYCOLUMNS = "REQUESTEDKEYCOLUMNS=";
    private static final String PREPARED_STATEMENT_TEXT = "Prepared Statement";
    private static final String CALLABLE_STATEMENT_TEXT = "Callable Statement";
    private static final String FORWARD_ONLY_RESULTSET_TEXT = "Forward Only";
    private static final String SCROLL_INSENSITIVE_RESULTSET_TEXT = "Scroll Insensitive";
    private static final String SCROLL_SENSITIVE_RESULTSET_TEXT = "Scroll Sensitive";
    private static final String READ_ONLY_CONCURRENCY_TEXT = "Read Only";
    private static final String UPDATEABLE_CONCURRENCY_TEXT = "Updateable";
    private static final String UNKNOWN = "Unknown";
    private static final char NEW_LINE = '\n';
    private BaseStatementPool stmtPool;
    private String name;
    private BaseConnection connection;
    private char[] readBuf;
    private StringBuffer writeBuf;
    private UtilTransliterator transliterator;
    private int[] retVal;

    public ExtStatementPoolMonitor(BaseStatementPool baseStatementPool, String string, BaseConnection baseConnection) {
        this.stmtPool = baseStatementPool;
        this.name = string;
        this.connection = baseConnection;
        this.readBuf = new char[2048];
        this.writeBuf = new StringBuffer();
        this.retVal = new int[1];
    }

    public String getName() {
        return this.name;
    }

    public int getCurrentSize() {
        return this.stmtPool.getPoolSize();
    }

    public long getHitCount() {
        return this.stmtPool.getNumHits();
    }

    public long getMissCount() {
        return this.stmtPool.getNumMisses();
    }

    public int getMaxSize() {
        return this.stmtPool.getMaxPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int n) {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.stmtPool.setMaxPoolSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyPool() {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.stmtPool.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCounts() {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.stmtPool.resetCounts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList poolEntries(int n, int n2, int n3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ArrayList<String> arrayList = new ArrayList<String>(this.stmtPool.getPoolSize());
            for (BaseStatementPool.BasePoolListNode basePoolListNode = this.stmtPool.getHead(); basePoolListNode != null; basePoolListNode = basePoolListNode.getPrevious()) {
                int n4 = basePoolListNode.getStatementType();
                int n5 = basePoolListNode.getStatement().getRequestedResultSetType();
                int n6 = basePoolListNode.getStatement().getRequestedResultSetConcurrency();
                if (n != -1 && n != n4 || n2 != -1 && n2 != n5 || n3 != -1 && n3 != n6) continue;
                arrayList.add(this.getStatementInfoString(basePoolListNode, false));
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStatements(File file) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.importStatements(fileInputStream);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{file.getAbsolutePath()};
                throw this.connection.getExceptions().getException(6127, stringArray);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStatements(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                this.importStatements(fileInputStream);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6127, stringArray);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStatements(InputStream inputStream) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            BufferedReader bufferedReader = null;
            try {
                this.stmtPool.setCountingEnabled(false);
                if (this.transliterator == null) {
                    this.transliterator = UtilTransliterator.GetNewTransliterator((String)"UTF-8");
                }
                bufferedReader = new BufferedReader(this.transliterator.decodeAsReader(inputStream));
                this.readHeader(bufferedReader);
                Statement statement = null;
                while ((statement = this.readStatement(bufferedReader)) != null) {
                    statement.close();
                }
            }
            catch (UtilException utilException) {
                throw this.connection.getExceptions().getException((Exception)((Object)utilException));
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                this.stmtPool.setCountingEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(File file) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                this.exportStatements(fileOutputStream);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{file.getAbsolutePath()};
                throw this.connection.getExceptions().getException(6131, stringArray);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                this.exportStatements(fileOutputStream);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6131, stringArray);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(OutputStream outputStream) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                if (this.transliterator == null) {
                    this.transliterator = UtilTransliterator.GetNewTransliterator((String)"UTF-8");
                }
                this.writeHeader(bufferedOutputStream);
                BaseConnection baseConnection2 = this.connection;
                synchronized (baseConnection2) {
                    for (BaseStatementPool.BasePoolListNode basePoolListNode = this.stmtPool.getHead(); basePoolListNode != null; basePoolListNode = basePoolListNode.getPrevious()) {
                        String string = this.getStatementInfoString(basePoolListNode, true);
                        byte[] byArray = this.transliterator.encode(string, this.retVal);
                        bufferedOutputStream.write(byArray, 0, this.retVal[0]);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
            }
            catch (UtilException utilException) {
                throw this.connection.getExceptions().getException((Exception)((Object)utilException));
            }
            catch (IOException iOException) {
                throw this.connection.getExceptions().getException(iOException);
            }
            finally {
                try {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeHeader(OutputStream outputStream) throws SQLException, IOException, UtilException {
        this.writeBuf.setLength(0);
        this.writeBuf.append(DDTEK_STMT_POOL_HDR);
        this.writeBuf.append('\n');
        this.writeBuf.append("VERSION=1");
        this.writeBuf.append('\n');
        byte[] byArray = this.transliterator.encode(this.writeBuf.toString(), this.retVal);
        outputStream.write(byArray, 0, this.retVal[0]);
    }

    private String getStatementTypeStr(int n) {
        switch (n) {
            case 1: {
                return PREPARED_STATEMENT_TEXT;
            }
            case 2: {
                return CALLABLE_STATEMENT_TEXT;
            }
        }
        return UNKNOWN;
    }

    private String getResultSetTypeStr(int n) {
        switch (n) {
            case 1003: {
                return FORWARD_ONLY_RESULTSET_TEXT;
            }
            case 1004: {
                return SCROLL_INSENSITIVE_RESULTSET_TEXT;
            }
            case 1005: {
                return SCROLL_SENSITIVE_RESULTSET_TEXT;
            }
        }
        return UNKNOWN;
    }

    private String getResultSetConcurrencyStr(int n) {
        switch (n) {
            case 1007: {
                return READ_ONLY_CONCURRENCY_TEXT;
            }
            case 1008: {
                return UPDATEABLE_CONCURRENCY_TEXT;
            }
        }
        return UNKNOWN;
    }

    private String getStatementInfoString(BaseStatementPool.BasePoolListNode basePoolListNode, boolean bl) throws SQLException {
        char c;
        String string = basePoolListNode.getStatement().getImplStatement().getSql().getOriginal();
        this.writeBuf.setLength(0);
        if (bl) {
            c = '\n';
            this.writeBuf.append(c);
            this.writeBuf.append(STMT_ENTRY);
            this.writeBuf.append(c);
            this.writeBuf.append(SQLTEXT_START);
            this.writeBuf.append(c);
            this.writeBuf.append(string);
            this.writeBuf.append(c);
            this.writeBuf.append(SQLTEXT_END);
        } else {
            c = ';';
            this.writeBuf.append(SQLTEXT_START);
            this.writeBuf.append(string);
            this.writeBuf.append(SQLTEXT_END);
        }
        this.writeBuf.append(c);
        this.writeBuf.append(STATEMENT_TYPE + this.getStatementTypeStr(basePoolListNode.getStatementType()));
        this.writeBuf.append(c);
        this.writeBuf.append(RESULTSET_TYPE + this.getResultSetTypeStr(basePoolListNode.getStatement().getRequestedResultSetType()));
        this.writeBuf.append(c);
        this.writeBuf.append(RESULTSET_CONCURRENCY + this.getResultSetConcurrencyStr(basePoolListNode.getStatement().getRequestedResultSetConcurrency()));
        this.writeBuf.append(c);
        this.writeBuf.append(AUTOGENERATEDKEYSREQUESTED + basePoolListNode.getStatement().getAutoGeneratedKeysRequested());
        this.writeBuf.append(c);
        this.writeBuf.append(REQUESTEDKEYCOLUMNS);
        String[] stringArray = basePoolListNode.getStatement().getRequestedKeyColumns();
        if (stringArray != null && stringArray.length > 0) {
            this.writeBuf.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                this.writeBuf.append("," + stringArray[i]);
            }
        }
        this.writeBuf.append(c);
        return this.writeBuf.toString();
    }

    private void readHeader(BufferedReader bufferedReader) throws SQLException {
        try {
            String string = bufferedReader.readLine().trim();
            if (!string.equals(DDTEK_STMT_POOL_HDR)) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string2 = bufferedReader.readLine().trim();
            int n = string2.indexOf(DDTEK_STMT_POOL_VERSION_TAG);
            if (n == -1) {
                String[] stringArray = new String[]{string2};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            if ((n = string2.indexOf(61, n + 1)) == -1) {
                String[] stringArray = new String[]{string2};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string3 = string2.substring(n + 1);
            if (!string3.equals(DDTEK_STMT_POOL_VERSION_VALUE)) {
                String[] stringArray = new String[]{string3, DDTEK_STMT_POOL_VERSION_VALUE};
                throw this.connection.getExceptions().getException(6129, stringArray);
            }
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{iOException.getMessage()};
            throw this.connection.getExceptions().getException(6128, stringArray);
        }
    }

    private Statement readStatement(BufferedReader bufferedReader) throws SQLException {
        try {
            int n;
            int n2;
            int n3;
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            while (string.length() == 0) {
                string = bufferedReader.readLine();
            }
            if (!string.equalsIgnoreCase(STMT_ENTRY)) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string2 = "";
            string = bufferedReader.readLine();
            if (!string.equalsIgnoreCase(SQLTEXT_START)) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            string = bufferedReader.readLine();
            while (!string.equalsIgnoreCase(SQLTEXT_END)) {
                string2 = string2 + string;
                string = bufferedReader.readLine();
            }
            string = bufferedReader.readLine();
            int n4 = string.indexOf(STATEMENT_TYPE);
            if (n4 == -1) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string3 = string.substring(STATEMENT_TYPE.length() + n4);
            if (string3.equalsIgnoreCase(PREPARED_STATEMENT_TEXT)) {
                n3 = 1;
            } else if (string3.equalsIgnoreCase(CALLABLE_STATEMENT_TEXT)) {
                n3 = 2;
            } else {
                String[] stringArray = new String[]{string3};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            string = bufferedReader.readLine();
            n4 = string.indexOf(RESULTSET_TYPE);
            if (n4 == -1) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string4 = string.substring(RESULTSET_TYPE.length() + n4);
            if (string4.equalsIgnoreCase(FORWARD_ONLY_RESULTSET_TEXT)) {
                n2 = 1003;
            } else if (string4.equalsIgnoreCase(SCROLL_INSENSITIVE_RESULTSET_TEXT)) {
                n2 = 1004;
            } else if (string4.equalsIgnoreCase(SCROLL_SENSITIVE_RESULTSET_TEXT)) {
                n2 = 1005;
            } else {
                String[] stringArray = new String[]{string4};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            string = bufferedReader.readLine();
            n4 = string.indexOf(RESULTSET_CONCURRENCY);
            if (n4 == -1) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string5 = string.substring(RESULTSET_CONCURRENCY.length() + n4);
            if (string5.equalsIgnoreCase(READ_ONLY_CONCURRENCY_TEXT)) {
                n = 1007;
            } else if (string5.equalsIgnoreCase(UPDATEABLE_CONCURRENCY_TEXT)) {
                n = 1008;
            } else {
                String[] stringArray = new String[]{string5};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            string = bufferedReader.readLine();
            n4 = string.indexOf(AUTOGENERATEDKEYSREQUESTED);
            if (n4 == -1) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string6 = string.substring(AUTOGENERATEDKEYSREQUESTED.length() + n4);
            boolean bl = false;
            if (string6.equalsIgnoreCase("true")) {
                bl = true;
            }
            if ((n4 = (string = bufferedReader.readLine()).indexOf(REQUESTEDKEYCOLUMNS)) == -1) {
                String[] stringArray = new String[]{string};
                throw this.connection.getExceptions().getException(6128, stringArray);
            }
            String string7 = string.substring(REQUESTEDKEYCOLUMNS.length() + n4);
            ArrayList<String> arrayList = new ArrayList<String>();
            n4 = 0;
            int n5 = 0;
            if (string7.length() > 0) {
                n4 = string7.indexOf(44, n4);
                while (n4 != -1) {
                    arrayList.add(string7.substring(n5, n4));
                    n5 = n4 + 1;
                    n4 = string7.indexOf(44, n5);
                }
                arrayList.add(string7.substring(n5));
            }
            int n6 = arrayList.size();
            String[] stringArray = null;
            if (n6 > 0) {
                stringArray = new String[n6];
                for (int i = 0; i < n6; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
            }
            if (!(!bl && stringArray == null || n3 == 1 && n2 == 1003 && n == 1007)) {
                throw this.connection.getExceptions().getException(6130);
            }
            PreparedStatement preparedStatement = null;
            preparedStatement = n3 == 1 ? (bl ? this.connection.prepareStatement(string2, 1) : (stringArray != null ? this.connection.prepareStatement(string2, stringArray) : this.connection.prepareStatement(string2, n2, n))) : this.connection.prepareCall(string2, n2, n);
            return preparedStatement;
        }
        catch (IOException iOException) {
            throw this.connection.getExceptions().getException(6128);
        }
    }
}

