/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.internal.xml.XmlDocumentBuilderImpl;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.transformation.InputBinding;
import com.metamatrix.metamodels.transformation.InputParameter;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xsd.XsdBuilderOptions;
import com.metamatrix.metamodels.xsd.XsdSchemaBuilderImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory;
import com.metamatrix.modeler.internal.mapping.factory.ModelMapperFactory;
import com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import com.metamatrix.modeler.mapping.factory.MappingClassBuilderStrategy;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.webservice.util.WebServiceBuildOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;

public class GenerateXsdHelper {
    public static boolean HEADLESS = false;
    private static final String DOC_SUFFIX = UiConstants.Util.getString("GenerateXsdWizard.docSuffix");
    private static final String OUTPUT_SUFFIX = UiConstants.Util.getString("GenerateXsdWizard.outSuffix");
    private static final String INSTANCE_SUFFIX = UiConstants.Util.getString("GenerateXsdWizard.instanceSuffix");
    private static final String NESTED_SUFFIX = UiConstants.Util.getString("GenerateXsdWizard.nestedSuffix");
    private static final String IN_MSG = UiConstants.Util.getString("GenerateXsdWizard.inMsg");
    private static final String OUT_MSG = UiConstants.Util.getString("GenerateXsdWizard.outMsg");
    private static final String DOCUMENT_SUFFIX = UiConstants.Util.getString("GenerateXsdWizard.documentSuffix");
    private static final String GET_PREFIX = UiConstants.Util.getString("GenerateXsdWizard.getPrefix");
    private static final String XSD_EXTENSION = ".xsd";
    private static final String XMI_EXTENSION = ".xmi";
    private final XsdSchemaBuilderImpl xsdBuilder;
    private final XsdBuilderOptions ops;
    private final MultiStatus result;
    private final PluginUtil Util = UiConstants.Util;
    private MtkXmiResourceImpl xmlResource;
    private ModelResource xmlModelResource;
    private final HashMap outputToInputMappings = new HashMap();
    private IProgressMonitor monitor;

    public GenerateXsdHelper(XsdSchemaBuilderImpl xsdBuilder, XsdBuilderOptions ops, MultiStatus result) {
        ArgCheck.isNotNull((Object)xsdBuilder);
        ArgCheck.isNotNull((Object)ops);
        this.xsdBuilder = xsdBuilder;
        this.ops = ops;
        this.result = result == null ? new MultiStatus("com.metamatrix.modeler.ui", 0, this.Util.getString("GenerateXsdWizard.result"), null) : result;
    }

    public HashMap execute(IProgressMonitor monitor) {
        boolean doSave;
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        boolean genSql = this.ops.genSql();
        boolean genWS = this.ops.genWs();
        boolean buildXml = this.ops.genXml();
        boolean bl = doSave = !genSql && !genWS;
        if (buildXml) {
            HashMap xsdMappings = this.xsdBuilder.getOutputToInputMappings();
            this.buildDocuments(this.ops, this.xsdBuilder.getRootElements(), xsdMappings, doSave);
        }
        monitor.worked(1);
        if (genSql) {
            this.generateSql(this.ops);
        }
        return this.outputToInputMappings;
    }

    private void buildDocuments(XsdBuilderOptions ops, Collection roots, HashMap xsdMappings, boolean doSave) {
        if (roots == null || roots.isEmpty()) {
            return;
        }
        boolean genWs = ops.genWs();
        this.monitor.beginTask(this.Util.getString("GenerateXsdWizard.buildingDocs", roots.size()), roots.size());
        XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl();
        XmlDocumentFactory factory = XmlDocumentFactory.eINSTANCE;
        Iterator iter = roots.iterator();
        while (iter.hasNext()) {
            XSDElementDeclaration schemaRootElement = (XSDElementDeclaration)iter.next();
            if (this.xmlResource == null) {
                this.initDocResources(schemaRootElement, ops);
            }
            Object inputGlobalElement = xsdMappings.get(schemaRootElement);
            try {
                XmlDocument document = factory.createXmlDocument();
                document.setName(schemaRootElement.getName() + DOCUMENT_SUFFIX);
                if (this.xmlResource != null) {
                    this.xmlResource.getContents().add((Object)document);
                }
                if (genWs) {
                    this.outputToInputMappings.put(document, inputGlobalElement);
                }
                XmlRoot docRoot = factory.createXmlRoot();
                docRoot.setName(schemaRootElement.getName());
                docRoot.setXsdComponent((XSDComponent)schemaRootElement);
                document.setRoot(docRoot);
                builder.buildDocument((XmlElement)docRoot, this.monitor);
                if (HEADLESS) continue;
                ITreeToRelationalMapper mapper = ModelMapperFactory.createModelMapper((EObject)document);
                new MappingClassFactory(mapper).generateMappingClasses((EObject)docRoot, MappingClassBuilderStrategy.compositorStrategy, true);
            }
            catch (Exception e) {
                String msg = this.Util.getString("GenerateXsdWizard.errBuild");
                this.addStatus(4, msg, e);
            }
        }
        if (doSave) {
            this.doSave();
        }
    }

    private void addStatus(int severity, String msg, Throwable ex) {
        this.result.add((IStatus)new Status(severity, this.result.getPlugin(), 0, msg, ex));
    }

    private void initDocResources(XSDElementDeclaration element, XsdBuilderOptions ops) {
        String fileName;
        String parentLocation = ops.getParentPath();
        String mdlName = null;
        if (ops.genOutput()) {
            mdlName = ops.getOutputModelName();
            mdlName = mdlName.replaceAll(XSD_EXTENSION, new String());
            fileName = parentLocation + File.separator + mdlName + DOC_SUFFIX + XMI_EXTENSION;
        } else {
            mdlName = element.getName();
            fileName = parentLocation + File.separator + element.getName() + DOC_SUFFIX + XMI_EXTENSION;
        }
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        File check = new File(fileName);
        if (check.exists()) {
            String fileExists = this.Util.getString("GenerateXsdWizard.docExists", (Object)fileName);
            this.addStatus(4, fileExists, null);
            return;
        }
        if (HEADLESS) {
            try {
                Container cntr = ModelerCore.getModelContainer();
                this.xmlResource = (MtkXmiResourceImpl)cntr.getOrCreateResource(URI.createFileURI((String)fileName));
            }
            catch (Exception err) {
                this.addStatus(4, err.getMessage(), err);
            }
        } else {
            IFile resource = wsroot.getFileForLocation((IPath)new Path(fileName));
            this.xmlModelResource = ModelerCore.create((IFile)resource);
            if (this.xmlModelResource != null) {
                try {
                    this.addStatus(1, this.Util.getString("GenerateXsdWizard.newModel", (Object)resource.getName()), null);
                    this.xmlResource = (MtkXmiResourceImpl)this.xmlModelResource.getEmfResource();
                }
                catch (ModelerCoreException err) {
                    this.Util.log(4, (Throwable)err, err.getMessage());
                }
            }
        }
        if (this.xmlResource != null) {
            try {
                ModelAnnotation ma = this.xmlModelResource.getModelAnnotation();
                ma.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/XmlDocument");
                ma.setModelType(ModelType.VIRTUAL_LITERAL);
            }
            catch (ModelerCoreException err) {
                String msg = this.Util.getString("GenerateXsdWizard.errModelImport");
                this.addStatus(4, msg, err);
            }
        }
    }

    private void generateSql(XsdBuilderOptions ops) {
        boolean genWs = ops.genWs();
        HashMap nameMap = this.buildRootNameMap(ops);
        Collection mappingRoots = this.getMappingRoots();
        if (nameMap.isEmpty() || mappingRoots.isEmpty()) {
            return;
        }
        this.monitor.beginTask(this.Util.getString("GenerateXsdWizard.genSqlSts", mappingRoots.size()), mappingRoots.size());
        Iterator mappingRootIt = mappingRoots.iterator();
        while (mappingRootIt.hasNext()) {
            TransformationMappingRoot nextRoot = (TransformationMappingRoot)mappingRootIt.next();
            EObject target = nextRoot.getTarget();
            if (!(target instanceof MappingClass)) continue;
            MappingClass mc = (MappingClass)target;
            RelationalEntity source = (RelationalEntity)nameMap.get(mc.getName());
            if (source == null) {
                source = this.deepSearchNameMap(nameMap, mc.getName());
            }
            if (source instanceof ProcedureResult) {
                TransformationHelper.createTransformation((EObject)target, (EObject)((ProcedureResult)source).getProcedure());
            } else {
                TransformationHelper.createTransformation((EObject)target, (EObject)source);
            }
            this.generateSql(mc, source, nextRoot);
        }
        if (!genWs) {
            this.doSave();
        }
    }

    private RelationalEntity deepSearchNameMap(HashMap nameMap, String mcName) {
        if (mcName == null || nameMap == null) {
            return null;
        }
        Iterator keys = nameMap.keySet().iterator();
        String match = null;
        while (match == null && keys.hasNext()) {
            String next = (String)keys.next();
            if (!mcName.startsWith(next)) continue;
            match = next;
        }
        if (match != null) {
            return (RelationalEntity)nameMap.get(match);
        }
        return null;
    }

    public void doSave() {
        if (this.xmlModelResource != null) {
            try {
                this.xmlModelResource.save(this.monitor, true);
                this.xmlModelResource.getEmfResource().setModified(false);
            }
            catch (Exception e) {
                String saveError = this.Util.getString("GenerateXsdWizard.errSave");
                this.addStatus(4, saveError, e);
            }
            this.monitor.worked(1);
        }
    }

    private void generateSql(MappingClass mc, RelationalEntity source, TransformationMappingRoot root) {
        String defaultSql = "SELECT * FROM ";
        StringBuffer newSql = new StringBuffer("SELECT * FROM ");
        ArrayList<MappingClassColumn> mappingsForProcParams = new ArrayList<MappingClassColumn>();
        try {
            Iterator mcCols = mc.getColumns().iterator();
            int index = 0;
            int outCount = 0;
            boolean isProc = false;
            Procedure proc = null;
            List outCols = this.getOutParams(source);
            while (mcCols.hasNext()) {
                MappingClassColumn next = (MappingClassColumn)mcCols.next();
                if (source instanceof ProcedureResult) {
                    ProcedureResult procResult = (ProcedureResult)source;
                    isProc = true;
                    proc = procResult.getProcedure();
                    if (index >= procResult.getColumns().size()) {
                        mappingsForProcParams.add(next);
                    }
                } else if (source instanceof Procedure) {
                    isProc = true;
                    proc = (Procedure)source;
                    if (outCount++ >= outCols.size()) {
                        mappingsForProcParams.add(next);
                    }
                }
                ++index;
            }
            if (isProc && proc != null) {
                EObject parent = proc.eContainer();
                if (parent != null) {
                    newSql.append(TransformationHelper.getSqlEObjectFullName((EObject)parent));
                    newSql.append(".");
                } else {
                    String modelName = ModelerCore.getModelEditor().getModelName(proc);
                    newSql.append(modelName);
                    newSql.append(".");
                }
                newSql.append(proc.getName());
            } else {
                newSql.append(TransformationHelper.getSqlEObjectFullName((EObject)source));
                if (!this.ops.isFlat()) {
                    XmlDocument doc;
                    TreeMappingAdapter tma;
                    List parents;
                    EObject target;
                    MappingClassSet mcs = mc.getMappingClassSet();
                    EObject eObject = target = mcs == null ? null : mcs.getTarget();
                    if (target instanceof XmlDocument && (parents = (tma = new TreeMappingAdapter((EObject)(doc = (XmlDocument)target))).getParentMappingClasses(mc, (EObject)doc, false)).size() > 0) {
                        Collection cols = this.getInputColumns(parents, source);
                        this.addInputColsAndCriteria(cols, mc, newSql, source);
                    }
                }
            }
            this.updateElementsForParams(mappingsForProcParams, (MappingRoot)root);
            TransformationHelper.setSelectSqlString((Object)root, (String)newSql.toString(), (boolean)false, (Object)this);
            AttributeMappingHelper.updateAttributeMappings((Object)root, (Object)this);
        }
        catch (Exception e) {
            String msg = this.Util.getString("GenerateXsdWizard.errSql");
            this.addStatus(4, msg, e);
            TransformationHelper.setSelectSqlString((Object)root, (String)"SELECT * FROM ", (boolean)false, (Object)this);
        }
    }

    private void addInputColsAndCriteria(Collection inputCols, MappingClass mc, StringBuffer sql, RelationalEntity source) {
        InputSet is = mc.getInputSet();
        Iterator cols = inputCols.iterator();
        StringBuffer crit = new StringBuffer();
        if (cols.hasNext()) {
            crit.append(" where ");
        }
        int colCount = 0;
        while (cols.hasNext()) {
            MappingClassColumn nextCol = (MappingClassColumn)cols.next();
            String colName = nextCol.getName();
            InputParameter nxt = TransformationFactory.eINSTANCE.createInputParameter();
            nxt.setName(colName);
            nxt.setType(nextCol.getType());
            is.getInputParameters().add((Object)nxt);
            InputBinding binding = TransformationFactory.eINSTANCE.createInputBinding();
            binding.setInputParameter(nxt);
            binding.setMappingClassColumn(nextCol);
            binding.setMappingClassSet(mc.getMappingClassSet());
            crit.append("input.");
            crit.append(colName);
            crit.append("=");
            crit.append(TransformationHelper.getSqlEObjectFullName((EObject)source));
            crit.append(".");
            crit.append(this.getPKColName(source, colCount, colName));
            ++colCount;
            if (!cols.hasNext()) continue;
            crit.append(" and ");
        }
        if (colCount > 1) {
            String msg = UiConstants.Util.getString("GenerateXsdHelper.criteriaAssumptions", (Object)mc.getName());
            this.addStatus(2, msg, null);
        }
        if (crit.length() > 0) {
            sql.append(crit.toString());
        }
    }

    private String getPKColName(RelationalEntity source, int index, String defaultName) {
        EList pkCols;
        if (source instanceof BaseTable && ((BaseTable)source).getPrimaryKey() != null && (pkCols = ((BaseTable)source).getPrimaryKey().getColumns()).size() > index) {
            Column col = (Column)pkCols.get(index);
            return col.getName();
        }
        return defaultName;
    }

    private Collection getInputColumns(List mcs, RelationalEntity source) {
        for (int i = mcs.size(); i > 0; --i) {
            MappingClass mc = (MappingClass)mcs.get(i - 1);
            Collection result = this.getInputColumns(mc, source);
            if (result.size() == 0) continue;
            return result;
        }
        return new ArrayList();
    }

    private Collection getInputColumns(MappingClass mc, RelationalEntity source) {
        PrimaryKey pk;
        ArrayList<MappingClassColumn> result = new ArrayList<MappingClassColumn>();
        if (source instanceof BaseTable && (pk = ((BaseTable)source).getPrimaryKey()) != null && !pk.getForeignKeys().isEmpty()) {
            Iterator fks = pk.getForeignKeys().iterator();
            while (fks.hasNext()) {
                ForeignKey nxtFK = (ForeignKey)fks.next();
                Collection fkColNames = this.getFKColNames(nxtFK);
                Iterator cols = mc.getColumns().iterator();
                while (cols.hasNext()) {
                    MappingClassColumn col = (MappingClassColumn)cols.next();
                    String name = col.getName();
                    if (!fkColNames.contains(name)) continue;
                    result.add(col);
                    if (result.size() != fkColNames.size()) continue;
                    return result;
                }
                result.clear();
            }
        }
        return result;
    }

    final Collection getFKColNames(ForeignKey fk) {
        HashSet<String> result = new HashSet<String>();
        Iterator cols = fk.getColumns().iterator();
        while (cols.hasNext()) {
            Column col = (Column)cols.next();
            result.add(col.getName());
        }
        return result;
    }

    private HashMap buildRootNameMap(XsdBuilderOptions ops) {
        Collection roots = ops.getRoots();
        if (roots == null || roots.isEmpty()) {
            return new HashMap();
        }
        StringNameValidator nameValidator = new StringNameValidator();
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, Object> nameMap = new HashMap<String, Object>(roots.size());
        Iterator rootIt = roots.iterator();
        while (rootIt.hasNext()) {
            RelationalEntity next = (RelationalEntity)rootIt.next();
            String nestedName = next.getName() + NESTED_SUFFIX;
            String globalName = next.getName() + INSTANCE_SUFFIX;
            String nestedUniqueName = nameValidator.createValidUniqueName(nestedName, names);
            if (nestedUniqueName == null) {
                nestedUniqueName = nestedName;
            }
            names.add(nestedUniqueName);
            nameMap.put(nestedUniqueName, next);
            String globalUniqueName = nameValidator.createValidUniqueName(globalName, names);
            if (globalUniqueName == null) {
                globalUniqueName = globalName;
            }
            names.add(globalUniqueName);
            nameMap.put(globalUniqueName, next);
            if (!ops.genInput() || !(next instanceof ProcedureResult)) continue;
            Procedure proc = ((ProcedureResult)next).getProcedure();
            nameMap.put(proc.getName(), proc);
        }
        return nameMap;
    }

    private List getOutParams(RelationalEntity entity) {
        ArrayList<ProcedureParameter> result = new ArrayList<ProcedureParameter>();
        if (entity instanceof Procedure) {
            Procedure proc = (Procedure)entity;
            Iterator params = proc.getParameters().iterator();
            while (params.hasNext()) {
                ProcedureParameter next = (ProcedureParameter)params.next();
                DirectionKind dir = next.getDirection();
                if (dir != DirectionKind.OUT_LITERAL && dir != DirectionKind.INOUT_LITERAL) continue;
                result.add(next);
            }
        }
        return result;
    }

    private void updateElementsForParams(Collection theMappingColumns, MappingRoot root) {
        MappingRoot treeRoot = this.getTreeMappingRoot(root);
        if (treeRoot == null) {
            return;
        }
        EList columnMappings = treeRoot.getNested();
        if (!columnMappings.isEmpty()) {
            int size = columnMappings.size();
            for (int i = 0; i < size; ++i) {
                Mapping mapping = (Mapping)columnMappings.get(i);
                Iterator columns = mapping.getInputs().iterator();
                while (columns.hasNext()) {
                    MappingClassColumn mappingColumn = (MappingClassColumn)columns.next();
                    if (!theMappingColumns.contains(mappingColumn)) continue;
                    Iterator outputs = mapping.getOutputs().iterator();
                    while (outputs.hasNext()) {
                        XmlElement element = (XmlElement)outputs.next();
                        element.setExcludeFromDocument(true);
                    }
                }
            }
        }
    }

    private MappingRoot getTreeMappingRoot(MappingRoot root) {
        TransformationContainer cntr = null;
        for (MappingRoot parent = root; parent != null && cntr == null; parent = parent.eContainer()) {
            if (!(parent instanceof TransformationContainer)) continue;
            cntr = (TransformationContainer)parent;
        }
        if (cntr == null) {
            return null;
        }
        Iterator roots = cntr.getTransformationMappings().iterator();
        while (roots.hasNext()) {
            Object next = roots.next();
            if (!(next instanceof TreeMappingRoot)) continue;
            TreeMappingRoot tmr = (TreeMappingRoot)next;
            if (!root.getOutputs().containsAll((Collection)tmr.getInputs())) continue;
            return tmr;
        }
        return null;
    }

    private Collection getMappingRoots() {
        if (this.xmlResource == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet mappingRoots = new HashSet();
        Iterator rsrcIt = this.xmlResource.getContents().iterator();
        while (rsrcIt.hasNext()) {
            Object next = rsrcIt.next();
            if (!(next instanceof TransformationContainer)) continue;
            TransformationContainer tc = (TransformationContainer)next;
            mappingRoots.addAll(tc.getTransformationMappings());
        }
        return mappingRoots;
    }

    private ModelProject getModelProject(EObject eObj) {
        Resource rsrc = eObj.eResource();
        ModelProject prj = null;
        if (rsrc == null) {
            return null;
        }
        ModelResource mr = ModelerCore.getModelEditor().findModelResource(rsrc);
        if (mr != null) {
            prj = mr.getModelProject();
        }
        return prj;
    }

    public Collection createWebServiceBuildOptions(HashMap outDocToInElementMappings, XsdBuilderOptions ops) {
        ArgCheck.isNotNull((Object)outDocToInElementMappings);
        ArgCheck.isNotNull((Object)ops);
        if (!ops.genWs()) {
            return Collections.EMPTY_LIST;
        }
        String rootModelName = ops.getRootModelName();
        String wsModelName = ops.getWsModelName();
        ArrayList<WebServiceBuildOptions> options = new ArrayList<WebServiceBuildOptions>();
        Iterator mappings = outDocToInElementMappings.entrySet().iterator();
        ModelProject project = null;
        while (mappings.hasNext()) {
            WebServiceBuildOptions option = new WebServiceBuildOptions();
            Map.Entry next = mappings.next();
            XmlDocument outDoc = (XmlDocument)next.getKey();
            if (outDoc == null || outDoc.getRoot() == null) continue;
            XmlRoot root = outDoc.getRoot();
            XSDElementDeclaration inElement = (XSDElementDeclaration)next.getValue();
            XSDElementDeclaration outElement = (XSDElementDeclaration)root.getXsdComponent();
            option.setModel((Object)wsModelName);
            if (project == null) {
                project = this.getModelProject((EObject)outDoc);
            }
            option.setCurrentProject(project);
            option.setOperationOutputMessageElem(outElement);
            option.setOperationOutputXmlDoc(outDoc);
            option.setOperationOutputMessageName(outElement.getName() + OUT_MSG);
            if (inElement != null) {
                option.setOperationInputMessageElem(inElement);
                option.setOperationInputMessageName(inElement.getName() + IN_MSG);
            }
            String interfaceName = null;
            interfaceName = rootModelName != null ? rootModelName + "_" + root.getName() : root.getName();
            int osIndex = interfaceName.indexOf(OUTPUT_SUFFIX);
            if (osIndex > -1) {
                interfaceName = interfaceName.substring(0, osIndex);
            }
            option.setInterface((Object)interfaceName);
            String operationName = GET_PREFIX + root.getName();
            int onIndex = operationName.indexOf(OUTPUT_SUFFIX);
            if (onIndex > -1) {
                operationName = operationName.substring(0, onIndex);
            }
            option.setOperationName(operationName);
            if (project != null && outElement != null) {
                options.add(option);
                continue;
            }
            if (HEADLESS) {
                options.add(option);
                continue;
            }
            String msg = this.Util.getString("GenerateXsdWizard.invalidWsOption", (Object)root.getName());
            this.addStatus(4, msg, null);
        }
        Object[] optionsArray = options.toArray();
        Arrays.sort(optionsArray);
        ArrayList<Object> sortedOptions = new ArrayList<Object>(options.size());
        for (int i = 0; i < optionsArray.length; ++i) {
            sortedOptions.add(optionsArray[i]);
        }
        return sortedOptions;
    }
}

