/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class TDSHeaderOutputStream
extends FilterOutputStream {
    private static final byte TLS_CHANGE_CHIPHER = 20;
    private static final byte TLS_ALERT = 21;
    private static final byte TLS_HANDSHAKE = 22;
    private static final byte TLS_APP_DATA = 23;
    private static final byte SSL_V2_HELLO = -128;
    boolean writeHeader = false;
    boolean encrypted = false;
    byte[] header = new byte[]{18, 1, 0, 0, 0, 0, 0, 0};
    ArrayList buffers = new ArrayList();
    int totalLength = 0;

    public TDSHeaderOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeBuffers() throws IOException {
        if (this.buffers.size() > 0) {
            for (int i = 0; i < this.buffers.size(); ++i) {
                byte[] byArray = (byte[])this.buffers.get(i);
                this.buffers.set(i, null);
                this.out.write(byArray, 0, byArray.length);
            }
            this.buffers.clear();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.writeHeader) {
            if (this.buffers.size() == 0) {
                this.totalLength = n2 + 8;
                this.header[2] = (byte)((this.totalLength & 0xFF00) >> 8);
                this.header[3] = (byte)((this.totalLength & 0xFF) >> 0);
                this.buffers.add(this.header);
            } else {
                this.totalLength += n2;
                this.header[2] = (byte)((this.totalLength & 0xFF00) >> 8);
                this.header[3] = (byte)((this.totalLength & 0xFF) >> 0);
            }
            byte by = byArray[0];
            switch (by) {
                case 22: {
                    if (this.encrypted) {
                        if (this.buffers.size() > 0) {
                            this.writeBuffers();
                        }
                        this.out.write(byArray, n, n2);
                        this.flush();
                        break;
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    this.buffers.add(byArray2);
                    break;
                }
                case -128: 
                case 21: 
                case 23: {
                    if (this.buffers.size() > 0) {
                        this.writeBuffers();
                    }
                    this.out.write(byArray, n, n2);
                    this.flush();
                    break;
                }
                case 20: {
                    this.encrypted = true;
                }
                default: {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    this.buffers.add(byArray3);
                    break;
                }
            }
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    public void setWriteHeader(boolean bl) {
        this.writeHeader = bl;
    }
}

