/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.util.UtilStringFunctions;
import java.sql.SQLException;

public class OracleImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.44.1.3  $";
    OracleImplConnection oic = null;

    public OracleImplDatabaseMetaData(OracleImplConnection oracleImplConnection) throws SQLException {
        this.oic = oracleImplConnection;
        this.databaseProductVersion = oracleImplConnection.oracleServerVersionString;
        int n = (int)(oracleImplConnection.oracleServerVersion / 100000000L);
        this.databaseMajorVersion = new Integer(n);
        n = (int)((oracleImplConnection.oracleServerVersion - (long)(n * 100000000)) / 1000000L);
        this.databaseMinorVersion = new Integer(n);
        this.supportsFullOuterJoins = oracleImplConnection.oracleServerVersion >= 900000000L ? Boolean.TRUE : Boolean.FALSE;
        this.schemaTerm = "user";
        this.procedureTerm = "function";
        this.catalogTerm = "Database";
        this.databaseProductName = "Oracle";
        this.isReadOnly = Boolean.FALSE;
        this.nullsAreSortedHigh = Boolean.TRUE;
        this.nullsAreSortedLow = Boolean.FALSE;
        this.nullsAreSortedAtStart = Boolean.FALSE;
        this.nullsAreSortedAtEnd = Boolean.FALSE;
        this.nullPlusNonNullIsNull = Boolean.TRUE;
        this.storesUpperCaseIdentifiers = Boolean.TRUE;
        this.storesLowerCaseIdentifiers = Boolean.FALSE;
        this.storesMixedCaseIdentifiers = Boolean.FALSE;
        this.storesUpperCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesLowerCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesMixedCaseQuotedIdentifiers = Boolean.FALSE;
        this.SQLKeywords = "ACCESS,AUDIT,BLOB,BFILE,CLOB,CLUSTER,COMMENT,COMPRESS,EXCLUSIVE,FILE,IDENTIFIED,INCREMENT,INITIAL,LOCK,LONG,MAXEXTENTS,MINUS,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOWAIT,NUMBER,OFFLINE,ONLINE,PCTFREE,RAW,RENAME,RESOURCE,ROW,ROWID,ROWLABEL,ROWNUM,SHARE,START,SUCCESSFUL,SYNONYM,SYSDATE,TRIGGER,UID,VALIDATE,VARCHAR2";
        this.numericFunctions = "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
        this.stringFunctions = "ASCII,BIT_LENGTH,CHAR,CONCAT,INSERT,LEFT,LOCATE,LOCATE2,LTRIM,LCASE,LENGTH,OCTET_LENGTH,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
        this.systemFunctions = "IFNULL,USER";
        this.timeDateFunctions = "NOW,CURDATE,CURRENT_DATE,CURRENT_TIMESTAMP,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,MONTH,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,DAYNAME,MONTHNAME";
        this.supportsAlterTableWithAddColumn = Boolean.TRUE;
        this.supportsAlterTableWithDropColumn = Boolean.TRUE;
        this.supportsColumnAliasing = Boolean.TRUE;
        this.supportsTableCorrelationNames = Boolean.TRUE;
        this.supportsDifferentTableCorrelationNames = Boolean.TRUE;
        this.supportsExpressionsInOrderBy = Boolean.TRUE;
        this.supportsOrderByUnrelated = Boolean.TRUE;
        this.supportsGroupBy = Boolean.TRUE;
        this.supportsGroupByUnrelated = Boolean.TRUE;
        this.supportsGroupByBeyondSelect = Boolean.TRUE;
        this.supportsLikeEscapeClause = Boolean.TRUE;
        this.supportsNonNullableColumns = Boolean.TRUE;
        this.supportsMinimumSQLGrammar = Boolean.TRUE;
        this.supportsCoreSQLGrammar = Boolean.TRUE;
        this.supportsExtendedSQLGrammar = Boolean.TRUE;
        this.supportsANSI92EntryLevelSQL = Boolean.TRUE;
        this.supportsANSI92IntermediateSQL = Boolean.FALSE;
        this.supportsANSI92FullSQL = Boolean.FALSE;
        this.supportsOuterJoins = Boolean.TRUE;
        this.supportsLimitedOuterJoins = Boolean.TRUE;
        this.supportsSchemasInDataManipulation = Boolean.TRUE;
        this.supportsSchemasInProcedureCalls = Boolean.TRUE;
        this.supportsSchemasInTableDefinitions = Boolean.TRUE;
        this.supportsSchemasInIndexDefinitions = Boolean.TRUE;
        this.supportsSchemasInPrivilegeDefinitions = Boolean.TRUE;
        this.isCatalogAtStart = Boolean.FALSE;
        this.supportsCatalogsInDataManipulation = Boolean.TRUE;
        this.supportsCatalogsInProcedureCalls = Boolean.TRUE;
        this.supportsCatalogsInTableDefinitions = Boolean.FALSE;
        this.supportsCatalogsInIndexDefinitions = Boolean.FALSE;
        this.supportsCatalogsInPrivilegeDefinitions = Boolean.FALSE;
        this.supportsPositionedDelete = Boolean.FALSE;
        this.supportsPositionedUpdate = Boolean.FALSE;
        this.supportsSelectForUpdate = Boolean.FALSE;
        this.supportsStoredProcedures = Boolean.TRUE;
        this.supportsSubqueriesInComparisons = Boolean.TRUE;
        this.supportsSubqueriesInExists = Boolean.TRUE;
        this.supportsSubqueriesInIns = Boolean.TRUE;
        this.supportsSubqueriesInQuantifieds = Boolean.TRUE;
        this.supportsCorrelatedSubqueries = Boolean.TRUE;
        this.supportsUnion = Boolean.TRUE;
        this.supportsUnionAll = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.TRUE;
        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
        this.supportsOpenStatementsAcrossCommit = Boolean.TRUE;
        this.supportsOpenStatementsAcrossRollback = Boolean.TRUE;
        this.dataDefinitionCausesTransactionCommit = Boolean.TRUE;
        this.dataDefinitionIgnoredInTransactions = Boolean.FALSE;
        this.maxConnections = new Integer(0);
        this.maxStatements = new Integer(0);
        this.maxColumnsInGroupBy = new Integer(255);
        this.maxColumnsInOrderBy = new Integer(255);
        this.maxColumnsInSelect = new Integer(0);
        this.maxColumnsInTable = new Integer(1000);
        this.maxTablesInSelect = new Integer(0);
        this.maxColumnsInIndex = new Integer(32);
        this.maxRowSize = new Integer(2000);
        this.maxBinaryLiteralLength = new Integer(0);
        this.maxCharLiteralLength = new Integer(0);
        this.maxProcedureNameLength = new Integer(61);
        this.maxCursorNameLength = new Integer(30);
        this.maxColumnNameLength = new Integer(30);
        this.maxSchemaNameLength = new Integer(30);
        this.maxCatalogNameLength = new Integer(128);
        this.maxTableNameLength = new Integer(30);
        this.maxUserNameLength = new Integer(30);
        this.maxStatementLength = new Integer(65535);
        this.maxIndexLength = new Integer(0);
        this.identifierQuoteString = "\"";
        this.procedureTerm = "procedure";
        this.catalogSeparator = "@";
        this.searchStringEscape = "\\";
        this.extraNameCharacters = "$#";
        this.supportsTransactions = Boolean.TRUE;
        this.supportsMultipleTransactions = Boolean.TRUE;
        this.supportsResultSetTypeScrollInsensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
        this.supportsResultSetTypeScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollSensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.othersUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.updatesAreDetectedForwardOnly = Boolean.FALSE;
        this.deletesAreDetectedForwardOnly = Boolean.FALSE;
        this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        this.supportsBatchUpdates = Boolean.FALSE;
        this.usesLocalFiles = Boolean.FALSE;
        this.usesLocalFilePerTable = Boolean.FALSE;
        this.supportsIntegrityEnhancementFacility = Boolean.TRUE;
        this.doesMaxRowSizeIncludeBlobs = Boolean.FALSE;
        this.supportsConvert = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadCommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadUncommited = Boolean.FALSE;
        this.supportsTransactionIsolationLevelRepeatableRead = Boolean.FALSE;
        this.supportsTransactionIsolationLevelSerializable = Boolean.TRUE;
        this.defaultTransactionIsolation = new Integer(2);
        this.allProceduresAreCallable = Boolean.TRUE;
        this.allTablesAreSelectable = Boolean.TRUE;
        this.supportsMixedCaseIdentifiers = Boolean.FALSE;
        this.supportsMixedCaseQuotedIdentifiers = Boolean.TRUE;
        this.supportsMultipleResultSets = Boolean.TRUE;
        this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.FALSE;
        this.supportsDataManipulationTransactionsOnly = Boolean.FALSE;
        this.supportsSavepoints = Boolean.TRUE;
        this.locatorsUpdateCopy = Boolean.FALSE;
        this.supportsNamedParameters = Boolean.FALSE;
        this.supportsMultipleOpenResults = Boolean.TRUE;
        this.supportsGetGeneratedKeys = Boolean.TRUE;
        this.supportsResultSetHoldability = Boolean.FALSE;
        this.resultSetHoldability = new Integer(1);
        this.maxClientAppName = new Integer(64);
    }

    protected String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        boolean bl;
        boolean bl2 = (this.catalogOptions & 1) != 0;
        this.oic.returnSynonyms = bl = (this.catalogOptions & 2) != 0;
        String string = ",";
        String string2 = null;
        switch (n) {
            case 1: {
                String string3;
                String string4;
                String string5;
                String string6 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string7 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                if (string7 == null) {
                    string7 = "%";
                }
                if ((string5 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)))) == null) {
                    string5 = "%";
                }
                String[] stringArray = (String[])baseResultSetFilterDescriptor.getRestriction(4);
                if (bl2) {
                    string4 = "SELECT null AS TABLE_CAT, ao.owner AS TABLE_SCHEM, ao.object_name AS TABLE_NAME, decode(ao.owner, 'SYSTEM', 'SYSTEM TABLE', 'SYS', 'SYSTEM TABLE', ao.object_type) as TABLE_TYPE, atc.comments AS TABLE_REMARKS, null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as SELF_REF_COLNAM, null as REF_GENERATION ";
                    string3 = "FROM all_objects ao, all_tab_comments atc ";
                } else {
                    string4 = "SELECT null AS TABLE_CAT, ao.owner AS TABLE_SCHEM, ao.object_name AS TABLE_NAME, decode(ao.owner, 'SYSTEM', 'SYSTEM TABLE', 'SYS', 'SYSTEM TABLE', ao.object_type) as TABLE_TYPE, NULL AS TABLE_REMARKS, null as TYPE_CAT, null as TYPE_SCHEM, null as TYPE_NAME, null as REF_GENERATION, null as TABLE_CATALOG ";
                    string3 = "FROM all_objects ao ";
                }
                String string8 = "WHERE ao.owner LIKE '" + string7 + "' ESCAPE '\\' AND " + "ao.object_name LIKE '" + string5 + "' ESCAPE '\\' AND ";
                boolean bl3 = false;
                boolean bl4 = false;
                if (stringArray != null) {
                    boolean bl5 = false;
                    string8 = string8 + "ao.object_type IN ('bosgalm'";
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("SYNONYM")) {
                            bl3 = true & bl;
                            continue;
                        }
                        if (stringArray[i].equals("SYSTEM") || stringArray[i].equals("SYSTEM TABLE")) {
                            string8 = string8 + ", 'TABLE'";
                            bl4 = true;
                            continue;
                        }
                        if (!stringArray[i].equals("TABLE") && !stringArray[i].equals("VIEW")) continue;
                        string8 = string8 + ", '" + stringArray[i] + "'";
                        bl5 = true;
                    }
                    string8 = string8 + ") ";
                    if (bl4 && !bl5) {
                        string8 = string8 + "and ao.owner in ('SYS', 'SYSTEM') ";
                    } else if (!bl4 && bl5) {
                        string8 = string8 + "and ao.owner not in ('SYS', 'SYSTEM') ";
                    }
                } else {
                    string8 = string8 + "ao.object_type IN ('TABLE', 'VIEW') ";
                    bl3 = true & bl;
                }
                if (bl2) {
                    string8 = string8 + " AND ao.owner = atc.owner (+) " + "AND ao.object_name = atc.table_name (+) ";
                }
                string2 = string4 + string3 + string8;
                if (string6 != null && string6.length() > 0) {
                    string2 = string2 + " AND 1=0 ";
                }
                String string9 = "";
                if (bl3) {
                    string9 = bl2 ? "UNION SELECT null, asy.owner, asy.synonym_name, 'SYNONYM', atc.comments, null, null, null, null, null FROM all_synonyms asy, all_objects ao, all_tab_comments atc WHERE asy.owner LIKE '" + string7 + "' ESCAPE '\\' AND " + "asy.synonym_name LIKE '" + string5 + "' ESCAPE '\\' AND " + "asy.table_owner = ao.owner AND asy.table_name = ao.object_name AND " + "ao.object_type IN ('TABLE', 'VIEW') AND ao.owner = atc.owner (+) " + "AND ao.object_name = atc.table_name (+) " : "UNION SELECT null, asy.owner, asy.synonym_name, 'SYNONYM', NULL, null, null, null, null, null FROM all_synonyms asy, all_objects ao WHERE asy.owner LIKE '" + string7 + "' ESCAPE '\\' AND " + "asy.synonym_name LIKE '" + string5 + "' ESCAPE '\\' AND " + "asy.table_owner = ao.owner AND asy.table_name = ao.object_name AND " + "ao.object_type IN ('TABLE', 'VIEW') ";
                }
                if (string6 != null && string6.length() > 0) {
                    string9 = string9 + " AND 1=0 ";
                }
                string2 = string2 + string9 + "ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 2: {
                String string10;
                String string11;
                String string12 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string13 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                if (string13 == null) {
                    string13 = "%";
                }
                if ((string11 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)))) == null) {
                    string11 = "%";
                }
                if ((string10 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(4)))) == null) {
                    string10 = "%";
                }
                String string14 = string12 == null || string12.length() == 0 ? "" : " 1=0 AND ";
                boolean bl6 = true;
                try {
                    bl6 = ((OracleImplConnection)super.getImplConnection()).getAllowMaxFloat();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = 0;
                try {
                    n2 = ((OracleImplConnection)super.getImplConnection()).getNumberPrecisionScaleOption();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string2 = bl2 ? "SELECT NULL AS table_cat, t.owner AS table_schem,t.table_name AS table_name,t.column_name AS column_name, DECODE (t.data_type, 'CHAR', 1, 'CLOB', 2005, 'BLOB', 2004, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 93,'RAW', -3, 'LONG RAW', -4, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 8, 'XMLTYPE',2005, 'BFILE',2004,'NCHAR',1, 'NVARCHAR2',12, 'NCLOB', 2005, 'ROWID', 12, 'UROWID', 12," + (bl6 ? "'FLOAT', 3" : "'FLOAT', 8") + ", 1111)" + " AS data_type, " + "t.data_type AS type_name, " + "decode(t.data_type, 'NUMBER', decode(t.data_precision, null, decode(t.data_scale, null, " + (n2 == 0 ? "0" : "38") + ", 0, 38, t.data_scale), t.data_precision), " + (bl6 ? "'FLOAT', trunc(t.data_precision*0.30103, 0)" : "'FLOAT', 15") + ", 'CLOB',2147483647, 'NCLOB', 2147483647, 'LONG', 2147483647, 'BLOB', 2147483647, 'LONG RAW', " + "2147483647, 'BFILE', 2147483647, 'DATE', 19, 'ROWID', 18, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 15, 'UROWID', t.data_length, " + "decode(t.data_length, 0, 1, t.data_length)) as column_size, " + "0 AS buffer_length, " + "decode(t.data_type, 'NUMBER', decode(t.data_scale, null, decode(t.data_precision, null, " + (n2 == 0 ? "0" : "127") + ",null), t.data_scale), " + (bl6 ? "'FLOAT', -127" : "'FLOAT', NULL") + ",'DATE', 0, NULL) AS decimal_digits, " + "decode(t.data_type, 'BINARY_FLOAT', 10, 'BINARY_DOUBLE', 10, 'FLOAT', 10, 'NUMBER', 10, NULL) AS num_prec_radix, " + "DECODE (t.nullable, 'N', 0, 1) AS nullable, acc.comments AS remarks," + "data_default AS column_def, null AS sql_data_type, null AS sql_datetime_sub, " + "decode(t.data_type, 'VARCHAR2', decode(t.data_length, 0, 1, t.data_length), 'CHAR', " + "t.data_length, 'NCHAR', t.data_length, 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', " + "2147483647, 'BFILE', 2147483647,  'UROWID', t.data_length, NULL) AS char_octet_length, " + "t.column_id AS ordinal_position, " + "DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable, " + "null as SCOPE_CATLOG, null as SCOPE_SCHEMA, null as SCOPE_TABLE, null as SOURCE_DATA_TYPE " + "FROM all_tab_columns t, all_col_comments acc " + "WHERE t.owner LIKE '" + string13 + "' ESCAPE '\\' AND " + string14 + "t.table_name LIKE '" + string11 + "' ESCAPE '\\' AND " + "t.column_name LIKE '" + string10 + "' ESCAPE '\\'  AND " + "t.owner = acc.owner(+) AND t.table_name = acc.table_name(+) AND t.column_name = acc.column_name(+)" : "SELECT NULL AS table_cat, t.owner AS table_schem,t.table_name AS table_name,t.column_name AS column_name, DECODE (t.data_type, 'CHAR', 1, 'CLOB', 2005, 'BLOB', 2004, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 93,'RAW', -3, 'LONG RAW', -4, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 8, 'XMLTYPE',2005, 'BFILE',2004,'NCHAR',1, 'NVARCHAR2',12, 'NCLOB', 2005, 'ROWID', 12, 'UROWID', 12," + (bl6 ? "'FLOAT', 3" : "'FLOAT', 8") + ", 1111) " + " AS data_type, " + "t.data_type AS type_name, " + "decode(t.data_type, 'NUMBER', decode(t.data_precision, null, decode(t.data_scale, null, " + (n2 == 0 ? "0" : "38") + ", 0, 38, t.data_scale), t.data_precision), " + (bl6 ? "'FLOAT', trunc(t.data_precision*0.30103, 0)" : "'FLOAT', 15") + ", 'CLOB',2147483647, 'NCLOB', 2147483647, 'LONG', 2147483647, 'BLOB', 2147483647, 'LONG RAW', " + "2147483647, 'BFILE', 2147483647, 'DATE', 19, 'ROWID', 18, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 15, 'UROWID', t.data_length," + "decode(t.data_length, 0, 1, t.data_length)) as column_size, " + "0 AS buffer_length, " + "decode(t.data_type, 'NUMBER', decode(t.data_scale, null, decode(t.data_precision, null, " + (n2 == 0 ? "0" : "127") + ",null), t.data_scale), " + (bl6 ? "'FLOAT', -127" : "'FLOAT', NULL") + ",'DATE', 0, NULL) AS decimal_digits, " + "decode(t.data_type, 'BINARY_FLOAT', 10, 'BINARY_DOUBLE', 10, 'FLOAT', 10, 'NUMBER', 10, NULL) AS num_prec_radix, " + "DECODE (t.nullable, 'N', 0, 1) AS nullable, NULL AS remarks," + "NULL AS column_def, null AS sql_data_type, null AS sql_datetime_sub, " + "decode(t.data_type, 'VARCHAR2', decode(t.data_length, 0, 1, t.data_length), 'CHAR', " + "t.data_length, 'NCHAR', t.data_length, 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', " + "2147483647, 'BFILE', 2147483647, 'UROWID', t.data_length, NULL) AS char_octet_length, " + "t.column_id AS ordinal_position, " + "DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable, " + "null as SCOPE_CATLOG, null as SCOPE_SCHEMA, null as SCOPE_TABLE, null as SOURCE_DATA_TYPE " + "FROM all_tab_columns t " + "WHERE t.owner LIKE '" + string13 + "' ESCAPE '\\' AND " + string14 + "t.table_name LIKE '" + string11 + "' ESCAPE '\\' AND " + "t.column_name LIKE '" + string10 + "' ESCAPE '\\' ";
                if (bl) {
                    String string15 = " UNION ALL SELECT NULL, asy.owner, asy.synonym_name , t.column_name, DECODE (t.data_type, 'CHAR', 1, 'CLOB', 2005, 'BLOB', 2004, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 93,'RAW', -3, 'LONG RAW', -4, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 8, 'XMLTYPE',2005, 'BFILE',2004,'NCHAR',1, 'NVARCHAR2',12, 'NCLOB', 2005, 'ROWID', 12, 'UROWID', 12," + (bl6 ? "'FLOAT', 3" : "'FLOAT', 8") + ", 1111), " + "t.data_type, " + "decode(t.data_type, 'NUMBER', decode(t.data_precision, null, decode(t.data_scale, null, 0, 0, 38, t.data_scale), t.data_precision), " + (bl6 ? "'FLOAT', trunc(t.data_precision*0.30103, 0)" : "'FLOAT', 15") + ", 'CLOB',2147483647, 'NCLOB', 2147483647, 'LONG', 2147483647, 'BLOB', 2147483647, 'LONG RAW'," + "2147483647, 'BFILE', 2147483647, 'DATE', 19, 'ROWID', 18, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 15, 'UROWID', t.data_length, " + "decode(t.data_length, 0, 1, t.data_length)), " + "0, " + "decode(t.data_type, 'NUMBER', nvl(t.data_scale, 0), 'DATE', 0, " + (bl6 ? "'FLOAT', -127" : "'FLOAT', NULL") + ", NULL) AS decimal_digits, " + "decode(t.data_type, 'FLOAT', 10, 'NUMBER', 10, NULL), " + "DECODE (t.nullable, 'N', 0, 1), ";
                    string15 = bl2 ? string15 + "acc.comments, data_default, null, null, decode(t.data_type, 'VARCHAR2', decode(t.data_length, 0, 1, t.data_length), 'CHAR', " + "t.data_length, 'NCHAR', t.data_length, 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', " + "2147483647, 'BFILE', 2147483647, NULL), t.column_id, DECODE (t.nullable, 'N', 'NO', 'YES'), " + "null, null, null, null " + "FROM all_synonyms asy, all_tab_columns t, all_col_comments acc " + "WHERE t.table_name = asy.table_name AND t.owner = asy.table_owner AND " + "t.column_name LIKE '" + string10 + "' ESCAPE '\\' AND " + "asy.owner LIKE '" + string13 + "' ESCAPE '\\' AND " + string14 + "asy.synonym_name LIKE '" + string11 + "' ESCAPE '\\' " + "AND t.owner = acc.owner(+) AND t.table_name = acc.table_name(+) AND t.column_name = acc.column_name(+)" + "ORDER BY table_schem, table_name, ordinal_position " : string15 + "NULL, NULL, null, null, decode(t.data_type, 'VARCHAR2', decode(t.data_length, 0, 1, t.data_length), 'CHAR', " + "t.data_length, 'NCHAR', t.data_length, 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', " + "2147483647, 'BFILE', 2147483647, NULL), t.column_id, DECODE (t.nullable, 'N', 'NO', 'YES'), " + "null, null, null, null " + "FROM all_synonyms asy, all_tab_columns t " + "WHERE t.table_name = asy.table_name AND t.owner = asy.table_owner AND " + "t.column_name LIKE '" + string10 + "' ESCAPE '\\' AND " + "asy.owner LIKE '" + string13 + "' ESCAPE '\\' AND " + string14 + "asy.synonym_name LIKE '" + string11 + "' ESCAPE '\\' " + "ORDER BY table_schem, table_name, ordinal_position ";
                    string2 = string2 + string15;
                } else {
                    string2 = string2 + " ORDER BY table_schem, table_name, ordinal_position ";
                }
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 5: {
                String string16;
                String string17 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string18 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                if (string18 == null) {
                    string18 = "%";
                }
                if ((string16 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)))) == null) {
                    string16 = "%";
                }
                String string19 = "SELECT NULL AS procedure_cat, owner AS procedure_schem, object_name AS procedure_name, NULL, NULL, NULL, NULL AS remarks, DECODE(object_type, 'PROCEDURE', 1, 'FUNCTION', 2, 0) AS procedure_type FROM all_objects WHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION') AND owner LIKE '" + string18 + "' ESCAPE '\\' AND " + "object_name LIKE '" + string16 + "' ESCAPE '\\' ";
                if (string17 != null && string17.length() > 0) {
                    string2 = string19 + "AND 1=0";
                } else {
                    String string20 = "SELECT NULL AS procedure_cat, owner AS procedure_schem, package_name || '.' || object_name AS procedure_name, NULL, NULL, NULL, NULL AS remarks, 1 AS procedure_type FROM all_arguments WHERE argument_name IS NULL  AND data_type IS NULL AND ";
                    String string21 = "SELECT NULL AS procedure_cat, owner AS procedure_schem, package_name || '.' || object_name AS procedure_name, NULL, NULL, NULL, NULL AS remarks, 1 AS procedure_type FROM all_arguments WHERE argument_name IS NOT NULL AND position = 1 AND position = sequence AND ";
                    String string22 = "SELECT NULL AS procedure_cat, owner AS procedure_schem, package_name || '.' || object_name AS procedure_name, NULL, NULL, NULL, NULL AS remarks, 2 AS procedure_type FROM all_arguments WHERE argument_name IS NULL AND in_out = 'OUT' AND ";
                    String string23 = "SELECT NULL AS procedure_cat, c.owner AS procedure_schem, c.synonym_name AS procedure_name, NULL, NULL, NULL, NULL AS remarks, DECODE(a.object_type, 'PROCEDURE', 1, 'FUNCTION', 2, 0) AS procedure_type from sys.all_objects a, sys.all_synonyms c WHERE c.table_owner = a.owner and c.table_name = a.object_name and a.object_type IN ('FUNCTION','PROCEDURE') and a.status = 'VALID' AND c.synonym_name LIKE '" + string16 + "' ESCAPE '\\' AND  " + "a.owner LIKE '" + string18 + "' ESCAPE '\\' ";
                    String string24 = "package_name IS NOT NULL AND package_name || '.' || object_name LIKE '" + string16 + "' ESCAPE '\\' AND owner LIKE '" + string18 + "' ESCAPE '\\'";
                    string2 = bl ? string19 + " UNION " + string20 + string24 + " UNION " + string21 + string24 + " UNION " + string22 + string24 + " UNION " + string23 : string19 + " UNION " + string20 + string24 + " UNION " + string21 + string24 + " UNION " + string22 + string24;
                }
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 6: {
                String string25;
                String string26;
                String string27 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string28 = string27 == null || string27.length() == 0 ? "" : " 1=2 AND ";
                String string29 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                if (string29 == null) {
                    string29 = "%";
                }
                if ((string26 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)))) == null) {
                    string26 = "%";
                }
                if ((string25 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(4)))) == null) {
                    string25 = "%";
                }
                String string30 = "nvl(arg.argument_name, 'RETURN_VALUE'), decode(arg.in_out, 'IN', 1, 'OUT', decode(arg.argument_name, NULL, 5, 4), 'IN/OUT', 2, 2), decode(arg.data_type, 'BLOB', -4, 'LONG RAW', -4, 'BFILE', -4, 'RAW', -3, 'CLOB', -1, 'LONG', -1, 'NCLOB', -1, 'CHAR', 1, 'NCHAR', 1, 'NUMBER', 3, 'FLOAT', decode(arg.data_precision, NULL, 6, 3), 'DATE', 93, 'TIMESTAMP', 93, 'TIMESTAMP WITH TIME ZONE', 93, 'TIMESTAMP WITH LOCAL TIME ZONE', 93, 'VARCHAR2', 12, 'NVARCHAR2', 12, 12), decode(arg.data_type, 'BINARY_INTEGER', 'VARCHAR2', 'PL/SQL RECORD', 'VARCHAR2', 'PL/SQL BOOLEAN', 'VARCHAR2', 'PL/SQL TABLE', 'VARCHAR2', 'MLSLABEL', 'VARCHAR2', 'TABLE', 'VARCHAR2', 'VARRAY', 'VARCHAR2', 'REF', 'VARCHAR2', 'OBJECT', 'VARCHAR2', arg.data_type), decode(arg.data_type, 'NUMBER', nvl(arg.data_precision, 38), 'FLOAT', decode(arg.data_precision, NULL, 15, 38), 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', 2147483647, 'BLOB', 2147483647, 'LONG RAW', 2147483647, 'BFILE', 2147483647, 'DATE', 19, 'TIMESTAMP', 19, 'TIMESTAMP WITH TIME ZONE', 19, 'TIMESTAMP WITH LOCAL TIME ZONE', 19,'VARCHAR2', 4000, 'CHAR', 2000, 'NCHAR', 2000, 'NVARCHAR2', 2000, 'RAW', 2000, 'BINARY_INTEGER', 4000, 'PL/SQL RECORD', 4000, 'PL/SQL BOOLEAN', 4000, 'PL/SQL TABLE', 4000, 'MLSLABEL', 4000, 'TABLE', 4000, 'VARRAY', 4000, 'REF', 4000, 'OBJECT', 4000, arg.data_length), decode(arg.data_type, 'NUMBER', nvl(arg.data_precision, 38) + decode(nvl(arg.data_scale, 0), 0, 1, 2), 'FLOAT', decode(arg.data_precision, NULL, 8, 39), 'CLOB', 2147483647, 'NCLOB', 2147483647, 'LONG', 2147483647, 'BLOB', 2147483647, 'LONG RAW', 2147483647, 'BFILE', 2147483647, 'DATE', 16, 'TIMESTAMP', 16, 'TIMESTAMP WITH TIME ZONE', 16, 'TIMESTAMP WITH LOCAL TIME ZONE', 16, 'VARCHAR2', 4000, 'CHAR', 2000, 'NCHAR', 2000, 'NVARCHAR2', 2000, 'RAW', 2000, 'BINARY_INTEGER', 4000, 'PL/SQL RECORD', 4000, 'PL/SQL BOOLEAN', 4000, 'PL/SQL TABLE', 4000, 'MLSLABEL', 4000, 'TABLE', 4000, 'VARRAY', 4000, 'REF', 4000, 'OBJECT', 4000, arg.data_length), decode(arg.data_type, 'CLOB', NULL, 'NCLOB', NULL, 'LONG', NULL, 'BLOB', NULL, 'LONG RAW', NULL, 'BFILE', NULL, 'DATE', 0, 'NUMBER', nvl(arg.data_scale, 0), 'FLOAT', 0, arg.data_scale), decode(arg.data_type, 'FLOAT', 10, 'NUMBER', 10, NULL), 1, NULL, ";
                String string31 = "select null, obj.owner, obj.object_name, " + string30 + "arg.position from all_objects obj, all_arguments arg " + "where obj.object_type in ('FUNCTION','PROCEDURE') and obj.status = 'VALID' and " + string28 + "obj.owner like '" + string29 + "' escape '\\' and " + "obj.object_name like '" + string26 + "' escape '\\' and " + "obj.object_id = arg.object_id and " + " (arg.argument_name like '" + string25 + "' escape '\\' OR arg.argument_name is null) and " + "arg.data_type <> 'REF CURSOR' and arg.data_level = 0 ";
                String string32 = "select null, obj.owner, arg.package_name || '.' || arg.object_name, " + string30 + "arg.position " + "from all_objects obj, all_arguments arg " + "where obj.object_type = 'PACKAGE' and obj.status = 'VALID' and " + "obj.owner like '" + string29 + "' escape '\\' and " + string28 + "arg.package_name || '.' || arg.object_name like '" + string26 + "' escape '\\' and " + "obj.object_id = arg.object_id and " + "((exists(select object_id from all_arguments arg3 where arg3.argument_name is null and " + "  arg3.data_level = 0 and arg3.object_id = arg.object_id and arg3.object_name = arg.object_name) and " + "  arg.argument_name is not null and (arg.overload is null or arg.overload = 1) ) or " + " (exists(select object_id from all_arguments arg3 where arg3.argument_name is null and " + "  arg3.data_level = 0 and arg3.object_id = arg.object_id and arg3.object_name = arg.object_name) and " + "  arg.argument_name is null and (arg.overload is null or " + "  arg.overload = 1) ) or " + " (not exists(select object_id from all_arguments arg3 where arg3.argument_name is null and " + "  arg3.data_level = 0 and arg3.object_id = arg.object_id and arg3.object_name = arg.object_name) and " + "  (arg.overload is null or arg.overload = 1)  and " + "(arg.argument_name like '" + string25 + "' escape '\\' OR arg.argument_name is null) ) " + ") and arg.data_type <> 'REF CURSOR' and " + "arg.data_level = 0 ";
                String string33 = "select null, syn.owner, syn.synonym_name, " + string30 + "arg.position " + "from all_objects obj, all_synonyms syn, all_arguments arg " + "where syn.table_owner = obj.owner and syn.table_name = obj.object_name and " + string28 + "syn.db_link is null and obj.status = 'VALID' and obj.object_type in ('FUNCTION','PROCEDURE') and " + "syn.owner like '" + string29 + "' escape '\\' and " + "syn.synonym_name like '" + string26 + "' escape '\\' and " + "obj.object_id = arg.object_id and " + "(arg.argument_name like '" + string25 + "' escape '\\' OR arg.argument_name is null) and " + "arg.data_type <> 'REF CURSOR' and arg.data_level = 0 ";
                string2 = bl ? string31 + " union all " + string32 + " union all " + string33 + " order by 2, 3, 14" : string31 + " union all " + string32 + " order by 2, 3, 14";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 16: {
                String string34;
                String string35 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string36 = string35 == null || string35.length() == 0 ? "" : " AND 1=2 ";
                String string37 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                if (string37 == null) {
                    string37 = "%";
                }
                if ((string34 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)))) == null) {
                    string34 = "%";
                }
                string2 = "SELECT NULL AS table_cat, table_schema AS table_schem, table_name,  grantor, grantee, privilege, grantable AS is_grantable FROM all_tab_privs WHERE table_schema LIKE '" + string37 + "' ESCAPE '\\' AND " + "table_name LIKE '" + string34 + "' ESCAPE '\\' " + string36 + " union select NULL AS table_cat, owner as table_schema,table_name, 'SYS',owner," + " privs.privilege as privilege," + " 'YES' from sys.all_tab_columns, " + "(SELECT 'DELETE' as privilege from dual union" + " SELECT 'INSERT' as privilege from dual union" + " SELECT 'REFERENCES' as privilege from dual union" + " SELECT 'SELECT'  as privilege from dual union" + " SELECT 'UPDATE'  as privilege from dual) privs" + " WHERE  owner not in('SYS','SYSTEM') and " + " owner LIKE '" + string37 + "' ESCAPE '\\' AND " + " table_name LIKE '" + string34 + "' ESCAPE '\\'" + string36 + "ORDER BY table_schem, table_name, privilege";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 9: {
                String string38 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string39 = string38 == null || string38.length() == 0 ? "" : " AND 1=2 ";
                String string40 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                String string41 = string40 == null ? "" : "table_schema = '" + string40 + "' AND ";
                String string42 = string40 == null ? "" : "owner = '" + string40 + "' AND ";
                String string43 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)));
                String string44 = string43 == null ? "" : "table_name = '" + string43 + "'";
                String string45 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(4)));
                if (string45 == null) {
                    string45 = "%";
                }
                string2 = "SELECT NULL AS table_cat, table_schema, table_name, column_name, grantor, grantee, privilege, grantable AS is_grantable FROM all_col_privs WHERE " + string41 + string44 + " AND column_name LIKE '" + string45 + "' ESCAPE '\\' " + string39 + " union select NULL AS table_cat, owner as table_schema,table_name, column_name,'SYS',owner," + " privs.privilege as privilege," + " 'YES' from sys.all_tab_columns, " + "(SELECT 'INSERT' as privilege from dual union" + " SELECT 'REFERENCES' as privilege from dual union" + " SELECT 'SELECT'  as privilege from dual union" + " SELECT 'UPDATE'  as privilege from dual) privs" + " WHERE  owner not in('SYS','SYSTEM') and " + string42 + string44 + " AND column_name LIKE '" + string45 + "' ESCAPE '\\' " + string39 + " ORDER BY table_schema, table_name, column_name, privilege";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 14: {
                String string46 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string47 = string46 == null || string46.length() == 0 ? "" : " AND 1=2 ";
                String string48 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                String string49 = string48 == null ? "" : "k.owner = '" + string48 + "' AND ";
                String string50 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)));
                String string51 = string50 == null ? "" : "k.table_name = '" + string50 + "' AND ";
                string2 = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k WHERE k.constraint_type = 'P' AND " + string51 + string49 + "k.constraint_name = c.constraint_name AND k.table_name = c.table_name " + string47 + "AND k.owner = c.owner ";
                if (bl) {
                    String string52 = "UNION SELECT NULL AS table_cat, s.owner AS table_schem, s.synonym_name, c.column_name, c.position AS key_seq,  c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k,all_synonyms s WHERE k.constraint_type = 'P' AND s.synonym_name ='" + string50 + "'" + " AND (s.owner = " + "'" + string48 + "'" + " OR s.owner='PUBLIC') " + "AND k.constraint_name = c.constraint_name AND k.table_name = c.table_name " + string47 + "AND k.owner = c.owner " + "AND c.table_name=s.table_name AND c.owner=s.table_owner ORDER BY column_name";
                    string2 = string2 + string52;
                } else {
                    string2 = string2 + "ORDER BY column_name";
                }
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 12: {
                String string53 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(5)));
                String string54 = string53 == null || string53.length() == 0 ? "" : " AND 1=2 ";
                String string55 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(6)));
                String string56 = string55 == null ? "" : "f.owner = :V1 AND ";
                String string57 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(7)));
                String string58 = string57 == null ? "" : "f.table_name = :V2 AND ";
                string2 = "SELECT NULL AS pktable_cat, p.owner as pktable_schem, p.table_name as pktable_name, pc.column_name as pkcolumn_name, NULL as fktable_cat, f.owner as fktable_schem, f.table_name as fktable_name, fc.column_name as fkcolumn_name, fc.position as key_seq, NULL as update_rule, decode (f.delete_rule, 'CASCADE', 0, 3) as delete_rule, f.constraint_name as fk_name, p.constraint_name as pk_name, decode(f.deferred, 'DEFERRED', 5, 'IMMEDIATE', 6, 6) FROM all_cons_columns pc, all_constraints p, all_cons_columns fc, all_constraints f WHERE " + string58 + string56 + "f.constraint_type = 'R' AND p.owner = f.r_owner " + "AND p.constraint_name = f.r_constraint_name AND p.constraint_type IN ('P', 'U') AND " + "pc.owner = p.owner AND pc.constraint_name = p.constraint_name " + "AND pc.table_name = p.table_name AND fc.owner = f.owner " + "AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name " + string54 + "AND fc.position = pc.position ";
                if (bl) {
                    String string59 = "UNION SELECT NULL AS pktable_cat, p.owner as pktable_schem, p.table_name as pktable_name,pc.column_name as pkcolumn_name, NULL as fktable_cat, s.owner as fktable_schem, s.synonym_name as fktable_name,fc.column_name as fkcolumn_name, fc.position as key_seq, NULL as update_rule, decode (f.delete_rule, 'CASCADE', 0, 3) as delete_rule, f.constraint_name as fk_name, p.constraint_name as pk_name, decode(f.deferred, 'DEFERRED', 5, 'IMMEDIATE', 6, 6) FROM all_cons_columns pc, all_constraints p, all_cons_columns fc, all_constraints f , all_synonyms s WHERE s.synonym_name = :V3 AND (s.owner = :V4 OR s.owner = 'PUBLIC') AND f.constraint_type = 'R' AND p.owner = f.r_owner AND p.constraint_name = f.r_constraint_name AND p.constraint_type IN ('P', 'U') AND pc.owner = p.owner AND pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name AND fc.owner = f.owner AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name AND " + string54 + "fc.position = pc.position  " + "AND f.table_name=s.table_name AND f.owner=s.table_owner ORDER BY pktable_schem, pktable_name, key_seq";
                    string2 = string2 + string59;
                } else {
                    string2 = string2 + "ORDER BY pktable_schem, pktable_name, key_seq";
                }
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 11: {
                String string60 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string61 = string60 == null || string60.length() == 0 ? "" : " AND 1=2 ";
                String string62 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                String string63 = string62 == null ? "" : "p.owner = '" + string62 + "' AND ";
                String string64 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)));
                String string65 = string64 == null ? "" : "p.table_name = '" + string64 + "' AND ";
                string2 = "SELECT NULL AS pktable_cat, p.owner as pktable_schem, p.table_name as pktable_name, pc.column_name as pkcolumn_name, NULL as fktable_cat, f.owner as fktable_schem, f.table_name as fktable_name, fc.column_name as fkcolumn_name, fc.position as key_seq, NULL as update_rule, decode (f.delete_rule, 'CASCADE', 0, 3) as delete_rule, f.constraint_name as fk_name, p.constraint_name as pk_name, decode(f.deferred, 'DEFERRED', 5, 'IMMEDIATE', 6, 6) FROM all_cons_columns pc, all_constraints p, all_cons_columns fc, all_constraints f WHERE " + string65 + string63 + "f.constraint_type = 'R' AND p.owner = f.r_owner " + "AND p.constraint_name = f.r_constraint_name AND p.constraint_type = 'P' AND " + "pc.owner = p.owner AND pc.constraint_name = p.constraint_name " + "AND pc.table_name = p.table_name AND fc.owner = f.owner " + string61 + "AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name " + "AND fc.position = pc.position ";
                if (bl) {
                    String string66 = "UNION SELECT NULL AS pktable_cat, s.owner as pktable_schem, s.synonym_name as pktable_name,pc.column_name as pkcolumn_name, NULL as fktable_cat, f.owner as fktable_schem, f.table_name as fktable_name,fc.column_name as fkcolumn_name, fc.position as key_seq, NULL as update_rule, decode (f.delete_rule, 'CASCADE', 0, 3) as delete_rule, f.constraint_name as fk_name, p.constraint_name as pk_name, decode(f.deferred, 'DEFERRED', 5, 'IMMEDIATE', 6, 6) FROM all_cons_columns pc, all_constraints p, all_cons_columns fc, all_constraints f, all_synonyms s WHERE s.synonym_name = '" + string64 + "' AND (s.owner = '" + string62 + "' OR s.owner = 'PUBLIC')AND f.constraint_type = 'R' AND p.owner = " + "f.r_owner AND p.constraint_name = f.r_constraint_name AND p.constraint_type = 'P' AND pc.owner = p.owner AND " + "pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name AND fc.owner = f.owner " + string61 + "AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name AND fc.position = pc.position " + "AND p.table_name=s.table_name AND p.owner=s.table_owner " + "ORDER BY fktable_schem, fktable_name, key_seq";
                    string2 = string2 + string66;
                } else {
                    string2 = string2 + "ORDER BY fktable_schem, fktable_name, key_seq";
                }
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 10: {
                String string67 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string68 = string67 == null || string67.length() == 0 ? "" : " AND 1=2 ";
                String string69 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                String string70 = string69 == null ? "" : "p.owner = '" + string69 + "' AND ";
                String string71 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)));
                String string72 = string71 == null ? "" : "p.table_name = '" + string71 + "' AND ";
                String string73 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(5)));
                String string74 = string73 == null || string73.length() == 0 ? "" : " AND 1=2 ";
                String string75 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(6)));
                String string76 = string75 == null ? "" : "f.owner = '" + string75 + "' AND ";
                String string77 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(7)));
                String string78 = string77 == null ? "" : "f.table_name = '" + string77 + "' AND ";
                string2 = "SELECT NULL AS pktable_cat, p.owner as pktable_schem, p.table_name as pktable_name, pc.column_name as pkcolumn_name, NULL as fktable_cat, f.owner as fktable_schem, f.table_name as fktable_name, fc.column_name as fkcolumn_name, fc.position as key_seq, NULL as update_rule, decode (f.delete_rule, 'CASCADE', 0, 3) as delete_rule, f.constraint_name as fk_name, p.constraint_name as pk_name, decode(f.deferred, 'DEFERRED', 5, 'IMMEDIATE', 6, 6) as deferrability FROM all_cons_columns pc, all_constraints p, all_cons_columns fc, all_constraints f WHERE " + string72 + string70 + string78 + string76 + "f.constraint_type = 'R' AND p.owner = f.r_owner " + string68 + string74 + "AND p.constraint_name = f.r_constraint_name AND p.constraint_type = 'P' AND " + "pc.owner = p.owner AND pc.constraint_name = p.constraint_name " + "AND pc.table_name = p.table_name AND fc.owner = f.owner " + "AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name " + "AND fc.position = pc.position ORDER BY pktable_schem, pktable_name, key_seq";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 13: {
                String string79 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(1)));
                String string80 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(2)));
                String string81 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(3)));
                Boolean bl7 = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
                Boolean bl8 = (Boolean)baseResultSetFilterDescriptor.getRestriction(14);
                String string82 = "select null as table_cat, i.owner as table_schem, i.table_name, 0 as non_unique, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, i.num_rows as cardinality, i.blocks as pages, null as filter_condition from all_tables i where i.table_name = '" + string81 + "' ";
                String string83 = "select null as table_cat, i.owner as table_schem, s.synonym_name, 0 as non_unique, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, i.num_rows as cardinality, i.blocks as pages, null as filter_condition from all_tables i, all_synonyms s where s.synonym_name = '" + string81 + "' " + "and i.table_name = s.table_name and i.owner = s.table_owner ";
                String string84 = "select null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'UNIQUE', 0, 1) as non_unique, null as index_qualifier, i.index_name, 1 as type, c.column_position as ordinal_position, c.column_name, null as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition from all_indexes i, all_ind_columns c where i.table_name = '" + string81 + "' " + "and i.index_name = c.index_name and i.table_owner = c.table_owner and " + "i.table_name = c.table_name and i.owner = c.index_owner ";
                String string85 = "select null , i.owner , s.synonym_name, decode (i.uniqueness, 'UNIQUE', 0, 1) as non_unique, null , i.index_name, 1 , c.column_position , c.column_name, null , i.distinct_keys , i.leaf_blocks , null from all_indexes i, all_ind_columns c, all_synonyms s where s.synonym_name = '" + string81 + "' " + "and i.table_name = s.table_name and i.table_owner = s.table_owner " + "and i.index_name = c.index_name and i.table_owner = c.table_owner and " + "i.table_name = c.table_name and i.owner = c.index_owner ";
                String string86 = "";
                String string87 = "";
                if (string80 != null) {
                    string86 = "and i.owner = '" + string80 + "' ";
                    string87 = "and i.table_owner = '" + string80 + "' ";
                }
                String string88 = string79 == null || string79.length() == 0 ? "" : "and 1 = 2 ";
                String string89 = bl7 != false ? "and i.uniqueness = 'UNIQUE' " : "";
                string2 = bl ? string82 + string86 + string88 + " UNION " + string83 + string86 + string88 + " UNION " + string84 + string87 + string88 + string89 + " UNION " + string85 + string87 + string88 + string89 + " order by non_unique, type, index_name, ordinal_position" : string82 + string86 + string88 + "UNION " + string84 + string87 + string88 + string89 + "order by non_unique, type, index_name, ordinal_position";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 7: {
                String string90;
                String string91 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(9)));
                String string92 = null;
                if (string91 != null && string91.length() != 0) {
                    string92 = string91;
                }
                if ((string90 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(10)))) == null) {
                    string90 = this.oic.getUser();
                }
                String string93 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(11)));
                Integer n3 = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
                Boolean bl9 = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
                string2 = n3 == 0 || n3 == 1 ? "SELECT 1 AS scope, RTRIM('ROWID') AS column_name, 12 AS data_type, RTRIM('ROWID') AS type_name, 18 AS column_size, 18 AS buffer_length, to_number(null) AS decimal_digits, 2 AS pseudo_column FROM (SELECT count(ROWID) FROM \"" + string90 + "\".\"" + string93 + "\")" + (string92 == null ? "" : " WHERE 1=2") : "SELECT 2 AS scope, t.column_name, DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 8, 1111) AS data_type, t.data_type AS type_name, DECODE (t.data_precision, null, t.data_length, t.data_precision) AS column_size,  0 AS buffer_length, t.data_scale AS decimal_digits, 1 AS pseudo_column FROM  all_tab_columns t, all_ind_columns i  WHERE i.table_name = '" + string93 + "' AND i.table_owner = '" + string90 + "' AND" + (bl9 != false ? "" : "t.nullable = 'N' AND ") + " t.owner = i.table_owner " + " AND t.table_name = i.table_name AND t.column_name = i.column_name " + (string92 == null ? "" : " AND 1=2 ") + " AND i.index_name = " + "(select min(index_name) from (" + "select count (*) cnt, a.index_name from all_indexes a, all_ind_columns b " + "where a.uniqueness = 'UNIQUE' and a.table_name = '" + string93 + "' AND a.table_owner = '" + string90 + "' AND a.index_name = b.index_name " + " group by a.index_name)" + "where cnt = (select min (cnt) from ( " + "select count (*) cnt, a.index_name from all_indexes a, all_ind_columns b " + "where a.uniqueness = 'UNIQUE' and a.table_name = '" + string93 + "' AND a.table_owner = '" + string90 + "' AND a.index_name = b.index_name " + " group by a.index_name)))";
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 18: {
                String string94 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(9)));
                String string95 = string94 == null || string94.length() == 0 ? "" : " AND 1=2 ";
                String string96 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(10)));
                String string97 = string96 == null ? "" : " c.owner = '" + string96 + "' AND ";
                String string98 = UtilStringFunctions.turnSingleQuotesIntoConsecutiveSingleQuotes((String)((String)baseResultSetFilterDescriptor.getRestriction(11)));
                String string99 = string98 == null ? "" : " t.table_name = '" + string98 + "' AND ";
                string2 = "SELECT 0 AS scope, t.column_name, DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4, 'FLOAT', 6, 'BINARY_FLOAT', 7, 'BINARY_DOUBLE', 8, 1111) AS data_type, c.data_type AS type_name, DECODE (c.data_precision, null, c.data_length, c.data_precision) AS column_size, 0 as buffer_length, c.data_scale as decimal_digits, 0 as pseudo_column FROM all_trigger_cols t, all_tab_columns c WHERE " + string99 + string97 + " t.table_owner = c.owner AND " + "t.table_name = c.table_name\n  AND t.column_name = c.column_name" + string95;
                baseResultSetFilterDescriptor.removeAllRestrictions();
                baseResultSetSortDescriptor.setSatisfied();
                break;
            }
            case 17: {
                string2 = "select '', '', '', '', 0, '' from dual where 1=0";
                break;
            }
            case 15: {
                string2 = "SELECT username AS TABLE_SCHEM, null AS TABLE_CATALOG FROM all_users ";
                break;
            }
            case 8: {
                string2 = "select '' as TABLE_CAT from dual";
            }
        }
        return string2;
    }

    protected BaseTypeInfos getTypeInfo() throws SQLException {
        Short s = new Short(0);
        Short s2 = new Short(1);
        Short s3 = new Short(2);
        Short s4 = new Short(3);
        Integer n = new Integer(10);
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        BaseTypeInfo baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "LONG RAW";
        baseTypeInfo.dataType = new Short(-4);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "RAW";
        baseTypeInfo.dataType = new Short(-3);
        baseTypeInfo.maxPrecision = new Integer(2000);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "LONG";
        baseTypeInfo.dataType = new Short(-1);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "CHAR";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(2000);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "NCHAR";
        baseTypeInfo.dataType = new Short(1);
        baseTypeInfo.maxPrecision = new Integer(2000);
        baseTypeInfo.literalPrefix = "N'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "NUMBER";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(38);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = "precision,scale";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(-84);
        baseTypeInfo.maximumScale = new Short(127);
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "NUMBER";
        baseTypeInfo.dataType = new Short(3);
        baseTypeInfo.maxPrecision = new Integer(38);
        baseTypeInfo.literalPrefix = null;
        baseTypeInfo.literalSuffix = null;
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = Boolean.FALSE;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = Boolean.FALSE;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(-84);
        baseTypeInfo.maximumScale = new Short(127);
        baseTypeInfo.numPrecRadix = n;
        baseTypeInfos.add(baseTypeInfo);
        if (this.databaseMajorVersion >= 10) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "BINARY_FLOAT";
            baseTypeInfo.dataType = new Short(7);
            baseTypeInfo.maxPrecision = new Integer(7);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.FALSE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = n;
            baseTypeInfos.add(baseTypeInfo);
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "BINARY_DOUBLE";
            baseTypeInfo.dataType = new Short(8);
            baseTypeInfo.maxPrecision = new Integer(15);
            baseTypeInfo.literalPrefix = null;
            baseTypeInfo.literalSuffix = null;
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = Boolean.FALSE;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = Boolean.FALSE;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = n;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "VARCHAR2";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(4000);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "NVARCHAR2";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(4000);
        baseTypeInfo.literalPrefix = "N'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s4;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "UROWID";
        baseTypeInfo.dataType = new Short(12);
        baseTypeInfo.maxPrecision = new Integer(4000);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = "max length";
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "DATE";
        baseTypeInfo.dataType = new Short(93);
        baseTypeInfo.maxPrecision = new Integer(19);
        baseTypeInfo.literalPrefix = "{ts '";
        baseTypeInfo.literalSuffix = "'}";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s3;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = new Short(0);
        baseTypeInfo.maximumScale = new Short(0);
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (this.databaseMajorVersion >= 9) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "TIMESTAMP";
            baseTypeInfo.dataType = new Short(93);
            baseTypeInfo.maxPrecision = new Integer(19);
            baseTypeInfo.literalPrefix = "{ts '";
            baseTypeInfo.literalSuffix = "'}";
            baseTypeInfo.createParams = "fractional_seconds_precision";
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = new Short(0);
            baseTypeInfo.maximumScale = new Short(9);
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "TIMESTAMP WITH TIME ZONE";
            baseTypeInfo.dataType = new Short(93);
            baseTypeInfo.maxPrecision = new Integer(19);
            baseTypeInfo.literalPrefix = "{ts '";
            baseTypeInfo.literalSuffix = "'}";
            baseTypeInfo.createParams = "fractional_seconds_precision";
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = new Short(0);
            baseTypeInfo.maximumScale = new Short(9);
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "TIMESTAMP WITH LOCAL TIME ZONE";
            baseTypeInfo.dataType = new Short(93);
            baseTypeInfo.maxPrecision = new Integer(19);
            baseTypeInfo.literalPrefix = "{ts '";
            baseTypeInfo.literalSuffix = "'}";
            baseTypeInfo.createParams = "fractional_seconds_precision";
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.FALSE;
            baseTypeInfo.searchable = s3;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = new Short(0);
            baseTypeInfo.maximumScale = new Short(9);
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "BLOB";
        baseTypeInfo.dataType = new Short(2004);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "BFILE";
        baseTypeInfo.dataType = new Short(2004);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.FALSE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "CLOB";
        baseTypeInfo.dataType = new Short(2005);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        if (this.databaseMajorVersion > 9 || this.databaseMajorVersion == 9 && this.databaseMinorVersion >= 2) {
            baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = "XMLTYPE";
            baseTypeInfo.dataType = new Short(2005);
            baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
            baseTypeInfo.literalPrefix = "xmltype('";
            baseTypeInfo.literalSuffix = "')";
            baseTypeInfo.createParams = null;
            baseTypeInfo.nullable = s2;
            baseTypeInfo.caseSensitive = Boolean.TRUE;
            baseTypeInfo.searchable = s;
            baseTypeInfo.unsignedAttribute = null;
            baseTypeInfo.fixedPrecScale = Boolean.FALSE;
            baseTypeInfo.autoIncrement = null;
            baseTypeInfo.localTypeName = baseTypeInfo.typeName;
            baseTypeInfo.minimumScale = null;
            baseTypeInfo.maximumScale = null;
            baseTypeInfo.numPrecRadix = null;
            baseTypeInfos.add(baseTypeInfo);
        }
        baseTypeInfo = new BaseTypeInfo();
        baseTypeInfo.typeName = "NCLOB";
        baseTypeInfo.dataType = new Short(2005);
        baseTypeInfo.maxPrecision = new Integer(Integer.MAX_VALUE);
        baseTypeInfo.literalPrefix = "N'";
        baseTypeInfo.literalSuffix = "'";
        baseTypeInfo.createParams = null;
        baseTypeInfo.nullable = s2;
        baseTypeInfo.caseSensitive = Boolean.TRUE;
        baseTypeInfo.searchable = s;
        baseTypeInfo.unsignedAttribute = null;
        baseTypeInfo.fixedPrecScale = Boolean.FALSE;
        baseTypeInfo.autoIncrement = null;
        baseTypeInfo.localTypeName = baseTypeInfo.typeName;
        baseTypeInfo.minimumScale = null;
        baseTypeInfo.maximumScale = null;
        baseTypeInfo.numPrecRadix = null;
        baseTypeInfos.add(baseTypeInfo);
        return baseTypeInfos;
    }

    protected BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        baseTableTypes.add("SYNONYM");
        baseTableTypes.add("SYSTEM TABLE");
        baseTableTypes.add("TABLE");
        baseTableTypes.add("VIEW");
        return baseTableTypes;
    }

    protected String getUserName() throws SQLException {
        return ((OracleImplConnection)super.getImplConnection()).getUser();
    }

    protected String getClientInfoPropertiesDescription(String string) throws SQLException {
        String string2 = "";
        if (string.equals("AccountingInfo")) {
            string2 = "Stored local to driver";
        } else if (string.equals("ApplicationName")) {
            string2 = "Stored in Client_Identifier session variable";
        } else if (string.equals("ClientHostName")) {
            string2 = "Stored local to driver";
        } else if (string.equals("ClientUser")) {
            string2 = "Stored local to driver";
        }
        return string2;
    }
}

