/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.SybaseConnection;
import com.metamatrix.jdbc.sybase.SybaseImplStatement;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSExecuteRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSLoginRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSLogoutRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSOptionCmdRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUCS2;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public class SybaseImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.51.1.3  $";
    public SybaseConnection connection;
    SybaseTDSCommunication comm;
    public String database;
    boolean useServerSideCursor;
    boolean useImplicitTransactions;
    int maxFieldSize;
    static final int defaultMaxFieldSize = Integer.MAX_VALUE;
    public UtilByteOrderedDataWriter writer;
    public UtilByteOrderedDataReader reader;
    public StringBuffer procedureCreationStatement;
    public boolean useAlternateProductInfo;
    public boolean useAlternateMetaData;
    public String errorBehavior;
    public String servicePrincipalName;
    public boolean enableCancelTimeout;

    public SybaseImplConnection(SybaseConnection sybaseConnection) {
        this.connection = sybaseConnection;
    }

    public void open() throws SQLException {
        Object object;
        boolean bl;
        Socket socket;
        int n;
        int n2;
        int n3;
        String string;
        block19: {
            String string2;
            string = this.connectProps.get("authenticationMethod");
            this.servicePrincipalName = this.connectProps.get("servicePrincipalName");
            String string3 = this.connectProps.get("useAlternateMetaData");
            this.useAlternateMetaData = false;
            if (string3 != null && string3.equalsIgnoreCase("true")) {
                this.useAlternateMetaData = true;
            }
            string3 = this.connectProps.get("replyBufferSize");
            n3 = 0;
            if (string3 != null) {
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n2 = this.connection.getLongDataCacheSize();
            string3 = this.connectProps.get("packetSize");
            n = 0;
            if (string3 != null) {
                try {
                    int n4 = Integer.parseInt(string3);
                    n = n4 > 1024 ? 524288 : (n4 == 0 ? 0 : n4 * 512);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.enableCancelTimeout = (string2 = this.connectProps.get("enableCancelTimeout")) != null && string2.equalsIgnoreCase("true");
            String string4 = this.connectProps.get("serverName");
            String string5 = this.connectProps.get("portNumber");
            if (string5 == null || string5.length() == 0) {
                throw this.exceptions.getException(7021);
            }
            socket = null;
            String string6 = this.connectProps.get("encryptionMethod").toUpperCase();
            bl = true;
            try {
                if (string6 != null && string6.equals("SSL")) {
                    boolean bl2 = false;
                    object = new String[]{"TLSv1"};
                    try {
                        socket = UtilSocketCreator.getSSLSocket((String)string4, (int)Integer.parseInt(string5), (Socket)socket, (boolean)bl2, (String[])object, (Properties)this.connectProps.getProperties());
                        break block19;
                    }
                    catch (UtilException utilException) {
                        throw this.exceptions.getException(this.exceptions.getException((Exception)((Object)utilException)), 0, 7031, "08001");
                    }
                }
                if (string6 != null && string6.length() > 0 && !string6.equalsIgnoreCase("noEncryption")) {
                    throw this.exceptions.getException(7030, "08001");
                }
                socket = UtilSocketCreator.getSocket((String)string4, (int)Integer.parseInt(string5), (Properties)this.connectProps.getProperties());
                bl = false;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{exception.getMessage()};
                throw this.exceptions.getException(6001, stringArray, "08001");
            }
        }
        this.comm = new SybaseTDSCommunication(socket, n3, n, n2, this.enableCancelTimeout, this.connectProps.socketSnoopingEnabled(), this.exceptions, this.connection, bl);
        this.writer = this.comm.getWriter();
        this.reader = this.comm.createReader();
        String string7 = this.connectProps.get("user");
        object = this.connectProps.get("password");
        SybaseTDSLoginRequest sybaseTDSLoginRequest = new SybaseTDSLoginRequest(this.comm, this.reader, this.writer, string7, (String)object, string, this.servicePrincipalName, this.exceptions);
        sybaseTDSLoginRequest.submitRequest();
        sybaseTDSLoginRequest.processReply(this.warnings);
        this.connection.setServerVersion(sybaseTDSLoginRequest.majorServerVersion, sybaseTDSLoginRequest.minorServerVersion);
        this.connection.supportsDateAndTimeTypes = sybaseTDSLoginRequest.getCapabilitiesBit(71, true);
        this.connection.supportsUniCharTypes = sybaseTDSLoginRequest.getCapabilitiesBit(66, true);
        if ((double)this.connection.getServerVersion() > 12.0 && this.connection.getPageSize() == 255) {
            this.determineAndSetPageSize();
        }
        SybaseTDSOptionCmdRequest sybaseTDSOptionCmdRequest = new SybaseTDSOptionCmdRequest(this.comm, this.reader, this.writer);
        sybaseTDSOptionCmdRequest.setOption((byte)35, Boolean.TRUE, this.warnings);
        this.quotingChar = (char)39;
        sybaseTDSOptionCmdRequest.setOption((byte)34, Boolean.TRUE, this.warnings);
        sybaseTDSOptionCmdRequest.setOption((byte)26, Boolean.FALSE, this.warnings);
        String string8 = this.connectProps.get("databaseName");
        this.database = sybaseTDSLoginRequest.getDatabase();
        if (string8 != null && string8.length() > 0 && !string8.equals(this.database)) {
            try {
                this.executeSQL("use " + string8);
                this.database = string8;
            }
            catch (SQLException sQLException) {
                String[] stringArray = new String[]{sQLException.getMessage().substring(40)};
                throw this.exceptions.getException(6001, stringArray, "08004", sQLException.getErrorCode());
            }
        }
        this.comm.supportsWideTables = sybaseTDSLoginRequest.getCapabilitiesBit(59, true);
        String string9 = this.connectProps.get("codePageOverride");
        this.setupTransliteration(this.warnings, string9);
        this.maxFieldSize = Integer.MAX_VALUE;
        this.executeSQL("set textsize " + this.maxFieldSize);
        String string10 = this.connectProps.get("selectMethod");
        this.useServerSideCursor = string10.equalsIgnoreCase("cursor");
        String string11 = this.connectProps.get("transactionMode");
        this.useImplicitTransactions = false;
        if (string11 != null) {
            this.useImplicitTransactions = string11.equalsIgnoreCase("implicit");
        }
        this.useAlternateProductInfo = BaseClassUtility.isBrandedSunDriver() ? true : new Boolean(this.connectProps.get("useAlternateProductInfo"));
        this.errorBehavior = this.connectProps.get("errorBehavior");
        this.connection.instantiateImplDatabaseMetaData(this);
    }

    public void setupTransliteration(BaseWarnings baseWarnings, String string) throws SQLException {
        if (this.connection.serverDefaultCharSet == null) {
            String string2 = "select name as DEFAULT_CHARSET from master.dbo.syscharsets where ((select value from master.dbo.sysconfigures where config=131) =  master.dbo.syscharsets.id)";
            SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string2);
            sybaseTDSExecuteRequest.submitRequest();
            sybaseTDSExecuteRequest.setProcessMode(1);
            sybaseTDSExecuteRequest.processReply(baseWarnings);
            if (sybaseTDSExecuteRequest.getRow(null)) {
                this.connection.serverDefaultCharSet = (String)sybaseTDSExecuteRequest.getColumnData(1, 10);
            }
            sybaseTDSExecuteRequest.discardReplyBytes();
        }
        try {
            this.comm.transliteratorForDefaultCharset = UtilTransliterator.GetNewTransliterator((String)this.connection.serverDefaultCharSet);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException), "08001");
        }
        if (string == null || string.length() == 0) {
            this.comm.transliteratorForCharData = this.comm.transliteratorForDefaultCharset;
        } else {
            try {
                this.comm.transliteratorForCharData = UtilTransliterator.GetNewTransliterator((String)string);
            }
            catch (UtilException utilException) {
                throw this.comm.exceptions.getException((Exception)((Object)utilException), "08001");
            }
        }
        this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
        this.writer.setTransliterator(this.comm.transliteratorForDefaultCharset);
        this.comm.ucs2Transliterator = new UtilTransliteratorForUCS2();
    }

    public void close() throws SQLException {
        SybaseTDSLogoutRequest sybaseTDSLogoutRequest = new SybaseTDSLogoutRequest(this.comm, this.reader, this.writer);
        sybaseTDSLogoutRequest.submitRequest();
        try {
            this.comm.close();
        }
        catch (Exception exception) {
            throw this.exceptions.getException(7001);
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new SybaseImplStatement(this.comm, n, n2, this.exceptions);
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public Socket getQueryTimeoutSocket() {
        return this.comm.getSocket();
    }

    public boolean supportsCancel() {
        return true;
    }

    public int getEmptyRowInsertSyntax() {
        return 2;
    }

    protected void startManualTransactionMode() throws SQLException {
        if (this.useImplicitTransactions) {
            this.executeSQL("set CHAINED on");
        } else {
            this.executeSQL("begin transaction");
        }
    }

    protected void commitTransaction() throws SQLException {
        if (this.useImplicitTransactions) {
            this.executeSQL("commit");
        } else {
            this.executeSQL("commit transaction begin transaction");
        }
    }

    protected void rollbackTransaction() throws SQLException {
        if (this.useImplicitTransactions) {
            this.executeSQL("rollback");
        } else {
            this.executeSQL("rollback transaction begin transaction");
        }
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.executeSQL("commit transaction");
    }

    protected void setSavepoint(String string) throws SQLException {
        this.executeSQL("save transaction " + string);
    }

    protected void rollbackTransaction(String string) throws SQLException {
        this.executeSQL("rollback transaction " + string);
    }

    protected String getCatalog() throws SQLException {
        return this.database;
    }

    protected void determineAndSetPageSize() {
        try {
            SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, "select @@maxpagesize");
            sybaseTDSExecuteRequest.submitRequest();
            sybaseTDSExecuteRequest.setProcessMode(1);
            sybaseTDSExecuteRequest.processReply(this.warnings);
            if (sybaseTDSExecuteRequest.getRow(null)) {
                Integer n = (Integer)sybaseTDSExecuteRequest.getColumnData(1, 4);
                this.connection.setPageSize(n);
            }
            sybaseTDSExecuteRequest.discardReplyBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setCatalog(String string) throws SQLException {
        this.executeSQL("use " + string);
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string = new String("set transaction isolation level ");
        switch (n) {
            case 1: {
                string = string + "read uncommitted";
                break;
            }
            case 2: {
                string = string + "read committed";
                break;
            }
            case 4: {
                string = string + "repeatable read";
                break;
            }
            case 8: {
                string = string + "serializable";
            }
        }
        this.executeSQL(string);
    }

    protected boolean supportsRowId() {
        return true;
    }

    protected boolean enableXlobOnLongVarX() {
        return true;
    }

    protected String[] getAggregateFunctions() {
        String[] stringArray = new String[]{"avg", "count", "max", "min", "sum"};
        return stringArray;
    }

    SybaseTDSRequest executeSQL(String string) throws SQLException {
        return this.executeSQL(string, this.warnings);
    }

    SybaseTDSRequest executeSQL(String string, BaseWarnings baseWarnings) throws SQLException {
        SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string);
        sybaseTDSExecuteRequest.submitRequest();
        sybaseTDSExecuteRequest.processReply((short)2, baseWarnings);
        return sybaseTDSExecuteRequest;
    }

    protected String setClientApplicationName(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clientapplname '" + string + "'", this.warnings);
        }
        return string;
    }

    protected String setClientHostName(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clienthostname '" + string + "'", this.warnings);
        }
        return string;
    }

    protected String setClientUser(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clientname '" + string + "'", this.warnings);
        }
        return string;
    }

    public boolean requiresUserId() {
        return false;
    }
}

