/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;

public abstract class UtilDepacketizingDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   3.6.2.0  $";
    protected UtilDataProvider dataProvider;
    protected int numBytesReadFromCurrentPacket;
    protected boolean noMoreDataToRead;
    protected int packetSize;

    public UtilDepacketizingDataProvider(UtilDataProvider utilDataProvider) {
        this.dataProvider = utilDataProvider;
        this.numBytesReadFromCurrentPacket = 0;
        this.packetSize = 1024;
        this.noMoreDataToRead = true;
    }

    public void setPacketSize(int n) {
        if (n > 0) {
            this.packetSize = n;
        }
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    protected void signalStartOfPacket() throws UtilException {
    }

    protected void signalEndOfPacket() throws UtilException {
        this.numBytesReadFromCurrentPacket = 0;
    }

    public byte getByte() throws UtilException {
        if (this.noMoreDataToRead) {
            throw new UtilException(1001);
        }
        try {
            if (this.numBytesReadFromCurrentPacket == 0) {
                this.signalStartOfPacket();
            }
            if (this.numBytesReadFromCurrentPacket < this.packetSize) {
                byte by = this.dataProvider.getByte();
                ++this.numBytesReadFromCurrentPacket;
                if (this.numBytesReadFromCurrentPacket == this.packetSize) {
                    this.signalEndOfPacket();
                }
                return by;
            }
            throw new UtilException(1001);
        }
        catch (UtilException utilException) {
            this.signalEndOfPacket();
            throw utilException;
        }
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return 0;
        }
        if (this.noMoreDataToRead) {
            throw new UtilException(1001);
        }
        try {
            int n3 = n2;
            int n4 = 0;
            while (n3 != 0 && !this.noMoreDataToRead) {
                if (this.numBytesReadFromCurrentPacket == 0) {
                    this.signalStartOfPacket();
                }
                int n5 = n3 <= this.packetSize - this.numBytesReadFromCurrentPacket ? n3 : this.packetSize - this.numBytesReadFromCurrentPacket;
                int n6 = this.dataProvider.getArrayOfBytes(byArray, n + n4, n5);
                n3 -= n6;
                this.numBytesReadFromCurrentPacket += n6;
                n4 += n6;
                if (this.numBytesReadFromCurrentPacket != this.packetSize) continue;
                this.signalEndOfPacket();
            }
            return n4;
        }
        catch (UtilException utilException) {
            this.signalEndOfPacket();
            throw utilException;
        }
    }

    public void empty() throws UtilException {
        if (!this.noMoreDataToRead) {
            byte[] byArray = new byte[1024];
            while (!this.noMoreDataToRead) {
                this.getArrayOfBytes(byArray, 0, byArray.length);
            }
        }
    }

    public int getNumBytesReadFromCurrentPacket() {
        return this.numBytesReadFromCurrentPacket;
    }

    public void receive() throws UtilException {
        this.dataProvider.receive();
        this.numBytesReadFromCurrentPacket = 0;
        this.noMoreDataToRead = false;
    }

    public boolean moreUnbufferedDataToReturn() {
        return this.dataProvider.moreUnbufferedDataToReturn();
    }

    public void reset() {
    }
}

