/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixConnection;
import com.metamatrix.jdbc.informix.InformixImplDatabaseMetaData;
import com.metamatrix.jdbc.informix.InformixImplStatement;
import com.metamatrix.jdbc.informix.InformixLocalMessages;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICursorRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLILoginRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import java.net.Socket;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.Properties;

public class InformixImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.23.1.3  $";
    InformixConnection connection;
    InformixSQLICommunication comm;
    public boolean isAutoCommit = true;
    private static int cursorNumber = 1;
    private InformixSQLIRequest staticRequest = null;
    private String host;
    private int port;
    private String server;
    public String database;
    private boolean connectedToDatabase = false;
    public String username;
    private boolean haveCachedDbaValue;
    private boolean isDba;
    public String dbDate;
    public boolean useDelimitedIdentifier;
    String password;
    String databaseProductName = "";
    String databaseProductVersion = "";
    public boolean isAnsiDatabase;
    public boolean transSupported;
    public int versionMajor;
    public int versionMinor;
    public int versionNumber;
    String codePageOverride;
    public int fetchBufferSize;

    InformixImplConnection(InformixConnection informixConnection) {
        this.connection = informixConnection;
    }

    public void open() throws SQLException {
        this.host = this.connectProps.get("serverName");
        this.server = this.connectProps.get("informixServer");
        this.database = this.connectProps.get("databaseName");
        this.username = this.connectProps.get("user");
        this.password = this.connectProps.get("password");
        this.dbDate = this.connectProps.get("dbdate");
        this.useDelimitedIdentifier = new Boolean(this.connectProps.get("useDelimitedIdentifier"));
        String string = this.connectProps.get("portNumber");
        if (string == null || string.length() == 0) {
            throw this.exceptions.getException(InformixLocalMessages.MUST_PROVIDE_PORTNUMBER);
        }
        this.port = Integer.parseInt(string);
        this.codePageOverride = this.connectProps.get("codePageOverride");
        this.fetchBufferSize = new Integer(this.connectProps.get("fetchBufferSize")).shortValue();
        if (this.server.length() == 0) {
            throw this.exceptions.getException(InformixLocalMessages.MUST_PROVIDE_SERVER);
        }
        if (this.username.length() == 0) {
            throw this.exceptions.getException(InformixLocalMessages.MUST_PROVIDE_USER);
        }
        Socket socket = null;
        Properties properties = this.connectProps.getProperties();
        try {
            socket = UtilSocketCreator.getSocket(this.host, Integer.parseInt(string), properties);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(6001, stringArray, "08001");
        }
        this.comm = new InformixSQLICommunication(socket, this, this.connectProps.socketSnoopingEnabled());
        try {
            this.comm.setBackendTransliterator(UtilTransliterator.GetNewTransliterator("ASCII"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        InformixSQLILoginRequest informixSQLILoginRequest = new InformixSQLILoginRequest(this.comm, this.username, this.password, this.server, this.database, this.isXAConnection, this.dbDate, this);
        informixSQLILoginRequest.submitRequest();
        this.databaseProductName = informixSQLILoginRequest.getDatabaseProductName();
        this.databaseProductVersion = informixSQLILoginRequest.getDatabaseProductVersion();
        this.isAnsiDatabase = informixSQLILoginRequest.getIsAnsiDatabase();
        this.transSupported = informixSQLILoginRequest.getTransSupported();
        informixSQLILoginRequest.sendSQINFO();
        this.staticRequest = new InformixSQLIRequest(this.comm, null);
        InformixImplDatabaseMetaData informixImplDatabaseMetaData = new InformixImplDatabaseMetaData();
        informixImplDatabaseMetaData.databaseName = informixSQLILoginRequest.getDatabaseName();
        informixImplDatabaseMetaData.userName = informixSQLILoginRequest.getUsername();
        this.connection.databaseMetaData = informixImplDatabaseMetaData;
        if (this.database.length() > 0) {
            this.handleDatabaseConnect();
        } else {
            this.parseDatabaseVersionString();
        }
        informixSQLILoginRequest = null;
    }

    protected boolean isDba() {
        if (this.haveCachedDbaValue) {
            return this.isDba;
        }
        this.haveCachedDbaValue = true;
        this.isDba = false;
        try {
            Statement statement = this.connection.createStatement();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select 1 from sysusers where username = '");
            stringBuffer.append(this.username);
            stringBuffer.append("' and usertype = 'D'");
            ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                this.isDba = true;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.isDba;
    }

    public void handleDatabaseConnect() throws SQLException {
        this.setupTransliteration();
        if (!this.connectedToDatabase) {
            this.determineActualDatabaseVersion();
            this.connectedToDatabase = true;
        }
    }

    private void parseDatabaseVersionString() {
        int n = this.databaseProductVersion.indexOf(46);
        int n2 = this.databaseProductVersion.indexOf(46, n + 1);
        try {
            this.versionMajor = Integer.parseInt(this.databaseProductVersion.substring(0, n));
        }
        catch (Exception exception) {
            this.versionMajor = 0;
        }
        try {
            this.versionMinor = Integer.parseInt(this.databaseProductVersion.substring(n + 1, n2));
        }
        catch (Exception exception) {
            this.versionMinor = 0;
        }
        this.versionNumber = this.versionMajor * 1000 + this.versionMinor;
        this.connection.databaseMetaData.databaseMajorVersion = new Integer(this.versionMajor);
        this.connection.databaseMetaData.databaseMinorVersion = new Integer(this.versionMinor);
        this.connection.databaseMetaData.databaseProductVersion = this.databaseProductVersion;
    }

    private void determineActualDatabaseVersion() throws SQLException {
        String string = "SELECT FIRST 1 DBINFO( 'version', 'major' ) || '.' || DBINFO( 'version', 'minor' )  || '.' || DBINFO( 'version', 'os' ) || DBINFO( 'version', 'level' ) FROM informix.systables";
        try {
            InformixSQLICursorRequest informixSQLICursorRequest = new InformixSQLICursorRequest(this.comm, null, string, 1003, 1007);
            informixSQLICursorRequest.openCursor();
            if (informixSQLICursorRequest.fetch()) {
                informixSQLICursorRequest.buildRow();
                InformixColumn informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(1);
                this.databaseProductVersion = (String)informixColumn.data;
            }
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        this.parseDatabaseVersionString();
    }

    public void setupTransliteration() throws SQLException {
        Object var1_1 = null;
        String string = "";
        try {
            if (this.codePageOverride != null && this.codePageOverride.length() > 0) {
                string = this.codePageOverride;
            } else {
                InformixSQLICursorRequest informixSQLICursorRequest = new InformixSQLICursorRequest(this.comm, null, "select site from informix.systables where tabname = ' GL_COLLATE'", 1003, 1007);
                informixSQLICursorRequest.openCursor();
                if (informixSQLICursorRequest.fetch()) {
                    informixSQLICursorRequest.buildRow();
                    InformixColumn informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(1);
                    String string2 = (String)informixColumn.data;
                    if (string2 != null) {
                        string = string2.substring(6).trim();
                    }
                }
                informixSQLICursorRequest.closeCursor();
            }
            this.comm.setBackendTransliterator(UtilTransliterator.GetNewTransliterator(string));
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException, "08001");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.staticRequest.closeConnection();
            this.staticRequest = null;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.comm.close();
            }
            catch (Exception exception) {}
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new InformixImplStatement(this, this.comm, n, n2);
    }

    protected void startManualTransactionMode() throws SQLException {
        if (!this.isAnsiDatabase) {
            this.staticRequest.startTransaction();
        }
        this.isAutoCommit = false;
    }

    protected void commitTransaction() throws SQLException {
        this.staticRequest.commitTransaction();
        if (!this.isAnsiDatabase) {
            this.staticRequest.startTransaction();
        }
    }

    protected void rollbackTransaction() throws SQLException {
        this.staticRequest.rollbackTransaction();
        if (!this.isAnsiDatabase) {
            this.staticRequest.startTransaction();
        }
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.staticRequest.commitTransaction();
        this.isAutoCommit = true;
    }

    protected String getCatalog() throws SQLException {
        return this.database;
    }

    protected void setCatalog(String string) throws SQLException {
        this.staticRequest.executeSQL("database " + string);
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string = new String("set isolation to ");
        switch (n) {
            case 1: {
                string = string + "dirty read";
                break;
            }
            case 2: {
                string = string + "committed read";
                break;
            }
            case 4: {
                string = string + "repeatable read";
                break;
            }
            case 8: {
                string = string + "repeatable read";
            }
        }
        this.staticRequest.executeSQL(string);
    }

    public int getNextCursorId() {
        return cursorNumber++;
    }

    protected String[] getAggregateFunctions() {
        String[] stringArray = new String[]{"avg", "min", "max", "sum", "unique", "range", "stdev", "variance", "count"};
        return stringArray;
    }

    protected boolean supportsRowId() {
        return true;
    }

    String formatDate(Date date, BaseTimestampEscape baseTimestampEscape) {
        if (this.dbDate == null) {
            return null;
        }
        char c = this.dbDate.length() == 5 ? (char)this.dbDate.charAt(4) : (char)'/';
        StringBuffer stringBuffer = new StringBuffer();
        GregorianCalendar gregorianCalendar = null;
        if (date != null) {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
        } else {
            stringBuffer.append('\'');
        }
        for (int i = 0; i < 4; ++i) {
            switch (this.dbDate.charAt(i)) {
                case 'D': 
                case 'd': {
                    String string;
                    if (gregorianCalendar != null) {
                        string = Integer.toString(gregorianCalendar.get(5));
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        stringBuffer.append(string);
                        break;
                    }
                    stringBuffer.append(baseTimestampEscape.getDay());
                    break;
                }
                case 'M': 
                case 'm': {
                    String string;
                    if (gregorianCalendar != null) {
                        string = Integer.toString(gregorianCalendar.get(2) + 1);
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        stringBuffer.append(string);
                        break;
                    }
                    stringBuffer.append(baseTimestampEscape.getMonth());
                    break;
                }
                case 'Y': 
                case 'y': {
                    String string = null;
                    string = gregorianCalendar != null ? String.valueOf(gregorianCalendar.get(1)) : baseTimestampEscape.getYear();
                    if (this.dbDate.charAt(++i) == '2') {
                        string = string.substring(2);
                    }
                    stringBuffer.append(string);
                }
            }
            if (i >= 3) continue;
            stringBuffer.append(c);
        }
        if (gregorianCalendar == null) {
            stringBuffer.append('\'');
        }
        return stringBuffer.toString();
    }
}

