/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilDataConsumer;
import com.metamatrix.slutil.UtilDataProvider;
import com.metamatrix.slutil.UtilDebug;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTempBuffer;
import com.metamatrix.slutil.UtilTempBufferBlock;
import com.metamatrix.slutil.UtilTempBufferInputStream;
import com.metamatrix.slutil.UtilTempBufferOutputStream;
import com.metamatrix.slutil.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class UtilPagedTempBuffer
implements UtilTempBuffer {
    private int currentBlockNum;
    private UtilTempBufferBlock[] blocks;
    private int numAllocatedBlocks;
    private int maxBlocks;
    private byte[] staticByteArray;
    private int blockSize;
    private int blockShift;
    private File tmpFileInfo;
    private RandomAccessFile tmpFile;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    long nextAvail;
    boolean overflowToDisk;
    boolean hitOutOfMemoryError;
    static final int DEFAULT_NUM_BLOCKS = 128;
    static final int DEFAULT_BLOCK_SIZE = 16;
    static final int DEFAULT_BLOCK_SHIFT = 14;
    static final String TEMP_FILE_PREFIX = "ddtb";
    static final int NUM_BITS_IN_LONG = 64;
    static final int NUM_BITS_TO_REPRESENT_1KB = 10;
    static final int NUM_BLOCKS_GROWTH_INCREMENT = 100;

    public UtilPagedTempBuffer() {
        this.setup(128, 16);
    }

    public UtilPagedTempBuffer(int n2) {
        int n3;
        int n4;
        int n5 = n2;
        if (n5 % 2 != 0) {
            n4 = n5;
            n3 = 1;
        } else {
            int n6;
            for (n6 = 1; n6 < 6 && n5 % (1 << n6 + 1) == 0; ++n6) {
            }
            n3 = 1 << n6;
            n4 = n5 / n3;
        }
        this.setup(n4, n3);
    }

    public UtilPagedTempBuffer(int n2, int n3) {
        this.setup(n2, n3);
    }

    public void setup(int n2, int n3) {
        this.blocks = null;
        this.currentBlockNum = 0;
        this.numAllocatedBlocks = 0;
        this.maxBlocks = n2;
        this.setBlockSize(n3);
        this.tmpFileInfo = null;
        this.tmpFile = null;
        this.nextAvail = 0L;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.staticByteArray = new byte[256];
        this.overflowToDisk = true;
    }

    public void setOverflowToDisk(boolean bl) {
        this.overflowToDisk = bl;
    }

    public int write(long l2, byte by) throws UtilException {
        this.staticByteArray[0] = by;
        return this.write(l2, this.staticByteArray, 0, 1);
    }

    public int write(long l2, byte[] byArray) throws UtilException {
        return this.write(l2, byArray, 0, byArray.length);
    }

    public int write(long l2, byte[] byArray, int n2, int n3) throws UtilException {
        if (l2 < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (byArray == null) {
            throw new UtilException(1023, "buffer can not be null.");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new UtilException(1023, "invalid bufferOffset.");
        }
        if (n3 < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l2 > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (n3 > byArray.length - n2) {
            n3 = byArray.length - n2;
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = (int)(l2 >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n5 = 0;
        boolean bl = false;
        while (true) {
            int n6;
            int n7;
            if ((n7 = this.blockSize - (n6 = (int)(l2 & (long)(this.blockSize - 1)))) > n3) {
                n7 = n3;
            }
            boolean bl2 = true;
            if (n7 == this.blockSize || l2 >= this.nextAvail && n6 == 0) {
                bl2 = false;
            }
            if ((utilTempBufferBlock = this.getBlock(n4, bl2)) == null) {
                bl = true;
                break;
            }
            utilTempBufferBlock.blockDirty = true;
            System.arraycopy(byArray, n2, utilTempBufferBlock.data, n6, n7);
            l2 += (long)n7;
            n5 += n7;
            if ((n3 -= n7) == 0) break;
            n2 += n7;
            ++n4;
        }
        if (l2 > this.nextAvail) {
            this.nextAvail = l2;
        }
        if (bl) {
            return -n5;
        }
        return n5;
    }

    public int write(long l2, UtilDataProvider utilDataProvider, int n2) throws UtilException {
        if (l2 < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (utilDataProvider == null) {
            throw new UtilException(1023, "dataProvider cannot be null");
        }
        if (n2 < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l2 > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = (int)(l2 >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n4 = 0;
        boolean bl = false;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l2 & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            boolean bl2 = true;
            if (n6 == this.blockSize || l2 >= this.nextAvail && n5 == 0) {
                bl2 = false;
            }
            if ((utilTempBufferBlock = this.getBlock(n3, bl2)) == null) {
                bl = true;
                break;
            }
            utilTempBufferBlock.blockDirty = true;
            int n7 = n6;
            while (n7 > 0) {
                try {
                    int n8 = utilDataProvider.getArrayOfBytes(utilTempBufferBlock.data, n5, n7);
                    n7 -= n8;
                    n5 += n8;
                    n4 += n8;
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001) {
                        if ((l2 += (long)(n6 - n7)) > this.nextAvail) {
                            this.nextAvail = l2;
                        }
                        return n4;
                    }
                    throw utilException;
                }
            }
            l2 += (long)n6;
            if ((n2 -= n6) == 0) break;
            ++n3;
        }
        if (l2 > this.nextAvail) {
            this.nextAvail = l2;
        }
        if (bl) {
            return -n4;
        }
        return n4;
    }

    public int write(long l2, UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(l2, utilDataProvider, Integer.MAX_VALUE);
    }

    public int write(UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(0L, utilDataProvider, Integer.MAX_VALUE);
    }

    public int writeInt(int n2) throws UtilException {
        this.staticByteArray[0] = (byte)(n2 >>> 24 & 0xFF);
        this.staticByteArray[1] = (byte)(n2 >>> 16 & 0xFF);
        this.staticByteArray[2] = (byte)(n2 >>> 8 & 0xFF);
        this.staticByteArray[3] = (byte)(n2 >>> 0 & 0xFF);
        return this.write(this.nextAvail, this.staticByteArray, 0, 4);
    }

    public int writeLong(long l2) throws UtilException {
        this.staticByteArray[0] = (byte)(l2 >>> 56 & 0xFFL);
        this.staticByteArray[1] = (byte)(l2 >>> 48 & 0xFFL);
        this.staticByteArray[2] = (byte)(l2 >>> 40 & 0xFFL);
        this.staticByteArray[3] = (byte)(l2 >>> 32 & 0xFFL);
        this.staticByteArray[4] = (byte)(l2 >>> 24 & 0xFFL);
        this.staticByteArray[5] = (byte)(l2 >>> 16 & 0xFFL);
        this.staticByteArray[6] = (byte)(l2 >>> 8 & 0xFFL);
        this.staticByteArray[7] = (byte)(l2 >>> 0 & 0xFFL);
        return this.write(this.nextAvail, this.staticByteArray, 0, 8);
    }

    public byte read(long l2) throws UtilException {
        int n2 = this.read(l2, this.staticByteArray, 0, 1);
        if (n2 != 1) {
            throw new UtilException(1016);
        }
        return this.staticByteArray[0];
    }

    public byte[] read(long l2, int n2) throws UtilException {
        byte[] byArray;
        int n3;
        if (l2 + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l2);
        }
        if ((n3 = this.read(l2, byArray = new byte[n2], 0, n2)) != n2) {
            throw new UtilException(1016);
        }
        return byArray;
    }

    public int read(long l2, byte[] byArray, int n2, int n3) throws UtilException {
        if (l2 < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (byArray == null) {
            throw new UtilException(1023, "dataProvider cannot be null");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new UtilException(1023, "invalid bufferOffset");
        }
        if (n3 < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l2 > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (l2 + (long)n3 > this.nextAvail) {
            n3 = (int)(this.nextAvail - l2);
        }
        if (n3 == 0) {
            return 0;
        }
        if (n2 + n3 > byArray.length) {
            throw new UtilException(1023, "insufficient space in specified buffer");
        }
        int n4 = (int)(l2 >> this.blockShift);
        int n5 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n6;
            int n7;
            if ((n7 = this.blockSize - (n6 = (int)(l2 & (long)(this.blockSize - 1)))) > n3) {
                n7 = n3;
            }
            utilTempBufferBlock = this.currentBlockNum == n4 && this.blocks[this.currentBlockNum].blockNum == n4 && this.blocks[this.currentBlockNum].data.length - n6 >= n7 ? this.blocks[this.currentBlockNum] : this.getBlock(n4, true);
            System.arraycopy(utilTempBufferBlock.data, n6, byArray, n2, n7);
            n5 += n7;
            if ((n3 -= n7) == 0) break;
            n2 += n7;
            l2 += (long)n7;
            ++n4;
        }
        return n5;
    }

    public byte readByte(long l2) throws UtilException {
        try {
            int n2 = (int)(l2 >> this.blockShift);
            int n3 = (int)(l2 & (long)(this.blockSize - 1));
            if (this.currentBlockNum == n2 && this.blocks[this.currentBlockNum].blockNum == n2) {
                return this.blocks[this.currentBlockNum].data[n3];
            }
            UtilTempBufferBlock utilTempBufferBlock = this.getBlock(n2, true);
            return utilTempBufferBlock.data[n3];
        }
        catch (Exception exception) {
            throw new UtilException(1023, exception.getMessage());
        }
    }

    public int read(long l2, UtilDataConsumer utilDataConsumer, int n2) throws UtilException {
        if (l2 < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (utilDataConsumer == null) {
            throw new UtilException(1023, "dataConsumer cannot be null");
        }
        if (n2 < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l2 > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        UtilDebug.assert("Attempting to read past end of file", l2 + (long)n2 <= this.nextAvail);
        if (l2 + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l2);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = (int)(l2 >> this.blockShift);
        int n4 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l2 & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            utilTempBufferBlock = this.getBlock(n3, true);
            utilDataConsumer.putArrayOfBytes(utilTempBufferBlock.data, n5, n6);
            n4 += n6;
            if ((n2 -= n6) == 0) break;
            l2 += (long)n6;
            ++n3;
        }
        return n4;
    }

    public int readInt(long l2) throws UtilException {
        int n2 = this.read(l2, this.staticByteArray, 0, 4);
        if (n2 != 4) {
            return -1;
        }
        int n3 = ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + ((this.staticByteArray[3] & 0xFF) << 0);
        return n3;
    }

    public long readLong(long l2) throws UtilException {
        int n2 = this.read(l2, this.staticByteArray, 0, 8);
        if (n2 != 8) {
            return -1L;
        }
        long l3 = (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + (((long)this.staticByteArray[7] & 0xFFL) << 0);
        return l3;
    }

    public InputStream getInputStream() {
        this.closeInputStream();
        this.lastInputStream = new UtilTempBufferInputStream(this);
        return this.lastInputStream;
    }

    public OutputStream getOutputStream() {
        this.closeOutputStream();
        this.lastOutputStream = new UtilTempBufferOutputStream(this);
        return this.lastOutputStream;
    }

    public void truncate(long l2) throws UtilException {
        int n2;
        this.nextAvail = l2;
        this.closeInputStream();
        this.closeOutputStream();
        for (int i2 = n2 = (int)l2 / this.blockSize + 1; i2 < this.numAllocatedBlocks; ++i2) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[i2];
            if (utilTempBufferBlock == null) continue;
            utilTempBufferBlock.reset();
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(l2);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate() throws UtilException {
        this.nextAvail = 0L;
        this.closeInputStream();
        this.closeOutputStream();
        for (int i2 = 0; i2 < this.numAllocatedBlocks; ++i2) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[i2];
            if (utilTempBufferBlock == null) continue;
            utilTempBufferBlock.reset();
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(0L);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate(boolean bl) throws UtilException {
        if (!bl) {
            this.truncate();
        } else {
            this.nextAvail = 0L;
            this.closeInputStream();
            this.closeOutputStream();
            if (this.tmpFile != null) {
                try {
                    this.tmpFile.close();
                    this.tmpFile = null;
                    this.tmpFileInfo.delete();
                    this.tmpFileInfo = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blocks != null) {
                for (int i2 = 0; i2 < this.numAllocatedBlocks; ++i2) {
                    this.blocks[i2] = null;
                }
                this.numAllocatedBlocks = 0;
                this.hitOutOfMemoryError = false;
            }
        }
    }

    public long getSize() {
        return this.nextAvail;
    }

    private void setBlockSize(int n2) {
        if (n2 == 16) {
            this.blockSize = 16384;
            this.blockShift = 14;
        } else {
            int n3;
            for (n3 = 1; n3 < 54; ++n3) {
                int n4 = n2 >> n3;
                if (n2 >> n3 != 0) continue;
                this.blockShift = n3 - 1 + 10;
                break;
            }
            if (n3 == 54) {
                UtilDebug.assert("Invalid block size specified.  Block size is in KBytes and must be a power of 2", false);
                this.blockShift = 14;
            }
            this.blockSize = 1 << this.blockShift;
            UtilDebug.assert("Blocksize should be a power of two", this.blockSize == n2 * 1024);
        }
    }

    private UtilTempBufferBlock getBlock(int n2, boolean bl) throws UtilException {
        int n3;
        if (this.hitOutOfMemoryError) {
            if (this.numAllocatedBlocks == 0) {
                throw new OutOfMemoryError();
            }
            n3 = n2 % this.numAllocatedBlocks;
        } else {
            n3 = n2 < this.maxBlocks ? n2 : n2 % this.maxBlocks;
            if (this.blocks == null || n3 >= this.blocks.length) {
                int n4 = Math.min(n3 + 100, this.maxBlocks);
                UtilTempBufferBlock[] utilTempBufferBlockArray = new UtilTempBufferBlock[n4];
                if (this.blocks != null) {
                    for (int i2 = 0; i2 < this.blocks.length; ++i2) {
                        utilTempBufferBlockArray[i2] = this.blocks[i2];
                    }
                }
                this.blocks = utilTempBufferBlockArray;
            }
        }
        if (this.blocks == null) {
            throw new OutOfMemoryError();
        }
        if (this.blocks[n3] == null) {
            try {
                this.blocks[n3] = new UtilTempBufferBlock(this.blockSize);
                ++this.numAllocatedBlocks;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.hitOutOfMemoryError = true;
                if (this.numAllocatedBlocks == 0) {
                    throw new OutOfMemoryError();
                }
                n3 = n2 % this.numAllocatedBlocks;
            }
        }
        UtilTempBufferBlock utilTempBufferBlock = this.blocks[n3];
        if (utilTempBufferBlock.blockNum != n2) {
            if (utilTempBufferBlock.blockDirty) {
                if (this.overflowToDisk) {
                    this.writeTmpFile(utilTempBufferBlock);
                } else {
                    return null;
                }
            }
            utilTempBufferBlock.blockNum = n2;
            utilTempBufferBlock.blockDirty = false;
            if (bl) {
                this.readTmpFile(utilTempBufferBlock);
                utilTempBufferBlock.blockDirty = false;
            }
        }
        this.currentBlockNum = n3;
        return this.blocks[n3];
    }

    private RandomAccessFile getTempFile() throws UtilException {
        if (this.tmpFile == null) {
            try {
                this.tmpFileInfo = UtilTempFile.createTempFile(TEMP_FILE_PREFIX);
                this.tmpFile = new RandomAccessFile(this.tmpFileInfo, "rw");
            }
            catch (IOException iOException) {
                throw new UtilException(1012, iOException.getMessage());
            }
        }
        return this.tmpFile;
    }

    private void writeTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n2 = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n2);
            randomAccessFile.write(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1013, iOException.getMessage());
        }
    }

    private void readTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n2 = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n2);
            randomAccessFile.read(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1014, iOException.getMessage());
        }
    }

    private void closeInputStream() {
        if (this.lastInputStream != null) {
            try {
                this.lastInputStream.close();
                this.lastInputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeOutputStream() {
        if (this.lastOutputStream != null) {
            try {
                this.lastOutputStream.close();
                this.lastOutputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.truncate(true);
    }
}

