/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilLocalMessages;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class UtilException
extends Exception {
    private static UtilLocalMessages messages;
    private int reason;
    private UtilException nextException;
    private boolean socketGenerated;

    public UtilException(UtilException utilException, int n2, String[] stringArray) {
        super(UtilException.getLocalizedReason(n2, stringArray));
        this.reason = n2;
        this.nextException = utilException;
    }

    public UtilException(UtilException utilException, int n2, String string) {
        super(UtilException.getLocalizedReason(n2, string));
        this.reason = n2;
        this.nextException = utilException;
    }

    public UtilException(UtilException utilException, int n2) {
        super(UtilException.getLocalizedReason(n2, (String[])null));
        this.reason = n2;
        this.nextException = utilException;
    }

    public UtilException(int n2, String[] stringArray) {
        super(UtilException.getLocalizedReason(n2, stringArray));
        this.reason = n2;
        this.nextException = null;
    }

    public UtilException(int n2, String string) {
        super(UtilException.getLocalizedReason(n2, string));
        this.reason = n2;
        this.nextException = null;
    }

    public UtilException(int n2, String string, boolean bl) {
        super(UtilException.getLocalizedReason(n2, string));
        this.socketGenerated = bl;
    }

    public UtilException(int n2) {
        super(UtilException.getLocalizedReason(n2, (String[])null));
        this.reason = n2;
        this.nextException = null;
    }

    public UtilException(int n2, boolean bl) {
        super(UtilException.getLocalizedReason(n2, (String[])null));
        this.socketGenerated = true;
    }

    public static String getLocalizedReason(int n2, String[] stringArray) {
        String string = null;
        Object[] objectArray = stringArray;
        try {
            string = messages.getString(n2, stringArray);
        }
        catch (Exception exception) {
            string = "Utility Internal Error - Could not load localized message for key: {0}";
            objectArray[0] = new String();
            objectArray[0] = Integer.toString(n2);
        }
        if (objectArray != null) {
            string = MessageFormat.format(string, objectArray);
        }
        return string;
    }

    public static String getLocalizedReason(int n2, String string) {
        String[] stringArray = new String[]{string};
        return UtilException.getLocalizedReason(n2, stringArray);
    }

    static UtilException createTransliterationFailedException(String string) throws UtilException {
        if (string == null) {
            string = "unknown";
        }
        return new UtilException(1009, string);
    }

    public int getReason() {
        return this.reason;
    }

    public boolean wasSocketGenerated() {
        return this.socketGenerated;
    }

    public void chainException(UtilException utilException) {
        this.nextException = utilException;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.metamatrix.slutil.UtilLocal");
        messages = new UtilLocalMessages();
        messages.setResourceBundle(resourceBundle);
    }
}

