/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.IIOP;
import com.metamatrix.sequelink.net.NetByteOrder;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.OutputStreamOnByteArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IIOPString {
    private byte[] javaString;
    private byte[] iiopString;

    IIOPString(byte[] byArray, boolean bl) throws NetworkException {
        this.javaString = byArray;
        this.encodeString(bl);
    }

    IIOPString(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        this.decodeString(dataInputStream, bl);
        this.encodeString(bl);
    }

    public byte[] getJavaString() {
        return this.javaString;
    }

    public byte[] getIIOPString() {
        return this.iiopString;
    }

    public static int getLengthIIOPString(byte[] byArray) {
        return IIOPString.lengthString(byArray.length);
    }

    private static int lengthString(int n2) {
        return 4 + n2 + 1;
    }

    private void encodeString(boolean bl) throws NetworkException {
        int n2 = this.javaString.length;
        int n3 = IIOPString.lengthString(n2);
        this.iiopString = new byte[n3];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.iiopString);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        int n4 = NetByteOrder.htonl(n2 + 1, bl);
        try {
            dataOutputStream.writeInt(n4);
            outputStreamOnByteArray.write(this.javaString, 0, n2);
            outputStreamOnByteArray.write(0);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void decodeString(DataInputStream dataInputStream, boolean bl) throws NetworkException {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = NetByteOrder.htonl(n2, bl);
            this.javaString = new byte[n3];
            dataInputStream.readFully(this.javaString, 0, n3);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }
}

