/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.slbase;

import com.metamatrix.jdbcx.slbase.BaseConnectionWrapper;
import com.metamatrix.jdbcx.slbase.BaseResultSetWrapper;
import com.metamatrix.jdbcx.slbase.BaseStatementWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BasePreparedStatementWrapper
extends BaseStatementWrapper
implements PreparedStatement {
    protected PreparedStatement realPreparedStatement;

    public void doClose() {
        this.realPreparedStatement = null;
        super.doClose();
    }

    BasePreparedStatementWrapper(BaseConnectionWrapper baseConnectionWrapper, PreparedStatement preparedStatement) {
        super(baseConnectionWrapper, preparedStatement);
        this.realPreparedStatement = preparedStatement;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this.realPreparedStatement.executeQuery();
            BaseResultSetWrapper baseResultSetWrapper = new BaseResultSetWrapper(this, resultSet, this.connectionWrapper);
            return baseResultSetWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            return this.realPreparedStatement.executeUpdate();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean execute() throws SQLException {
        try {
            return this.realPreparedStatement.execute();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            this.realPreparedStatement.setNull(n2, n3, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        try {
            this.realPreparedStatement.setBoolean(n2, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        try {
            this.realPreparedStatement.setByte(n2, by);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setShort(int n2, short s2) throws SQLException {
        try {
            this.realPreparedStatement.setShort(n2, s2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setInt(int n2, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setInt(n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        try {
            this.realPreparedStatement.setLong(n2, l2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        try {
            this.realPreparedStatement.setFloat(n2, f2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        try {
            this.realPreparedStatement.setDouble(n2, d2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            this.realPreparedStatement.setBigDecimal(n2, bigDecimal);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setString(int n2, String string) throws SQLException {
        try {
            this.realPreparedStatement.setString(n2, string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            this.realPreparedStatement.setBytes(n2, byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n2, date);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTime(int n2, Time time) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n2, time);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n2, timestamp);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setAsciiStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setUnicodeStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setBinaryStream(n2, inputStream, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.realPreparedStatement.clearParameters();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object, n3, n4);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        try {
            this.realPreparedStatement.setObject(n2, object);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.realPreparedStatement.addBatch();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            this.realPreparedStatement.setCharacterStream(n2, reader, n3);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        try {
            this.realPreparedStatement.setRef(n2, ref);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            this.realPreparedStatement.setBlob(n2, blob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            this.realPreparedStatement.setClob(n2, clob);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setArray(int n2, Array array) throws SQLException {
        try {
            this.realPreparedStatement.setArray(n2, array);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setDate(n2, date, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTime(n2, time, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.realPreparedStatement.setTimestamp(n2, timestamp, calendar);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        try {
            this.realPreparedStatement.setURL(n2, uRL);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.realPreparedStatement.getParameterMetaData();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.connectionWrapper.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.connectionWrapper.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

