/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink;

import com.metamatrix.jdbc.sequelink.Result;
import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.sequelink.SequeLinkImplResultSet;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkBigintColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkBinaryColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkBitColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkBlobColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkCharColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkClobColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumns;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkDatatypeColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkDateColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkDoubleColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkIntegerColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkLongvarbinaryColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkLongvarcharColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkNumericColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkPseudoColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkRealColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkTimeColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkTimestampColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkVarbinaryColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkVarcharColumn;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkBigintParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkBitParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkBlobParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkClobParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkDateParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkDoubleParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkIntegerParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkLongvarbinaryParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkLongvarcharParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkNumericParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParamDescribe;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameters;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkRealParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkStreamParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkTimeParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkTimestampParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkVarbinaryParameter;
import com.metamatrix.jdbc.sequelink.parameters.SequeLinkVarcharParameter;
import com.metamatrix.jdbc.slbase.BaseColumns;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseImplResultSet;
import com.metamatrix.jdbc.slbase.BaseImplResultSetClientSideEmpty;
import com.metamatrix.jdbc.slbase.BaseImplStatement;
import com.metamatrix.jdbc.slbase.BaseParameter;
import com.metamatrix.jdbc.slbase.BaseParameterInfo;
import com.metamatrix.jdbc.slbase.BaseParameters;
import com.metamatrix.jdbc.slbase.BaseSQL;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.describe.VariableDescriptor;
import com.metamatrix.sequelink.ssp.Diagnostic;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.util.UnSyncVector;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public final class SequeLinkImplStatement
extends BaseImplStatement {
    private SequeLinkImplConnection implCon;
    private StatementContext stmtCtxt;
    private DiagnosticList diagnosticList;
    private boolean prepared;
    private boolean sqlChanged;
    private boolean columnsAreBound;
    private boolean parametersAreBound;
    private SequeLinkColumns cursorVariables;
    private SequeLinkParameters parameterVariables;
    private int rowsInBatch;
    private int fetchFlag;
    private int fetchedFromBatch;
    private int fetchedFromCursor;
    private boolean multipleResults;
    private int rsn;
    private int[] updateCounts;
    private String rowid;
    private int myMaxRows;
    private boolean supportsCatalogs;
    private Result result;
    private boolean allowBlockFetch;
    private boolean MSSMapLongToDecimal;
    private boolean ORANumber0IsNumeric;
    private int serverVersion;
    private boolean alreadyClosed;
    private boolean prefetched;
    private boolean allowPreFetch;
    private String defaultParameterEncoding;
    private int lastAccessedColumn;
    private boolean isBadDescribeParam54;

    SequeLinkImplStatement(SequeLinkImplConnection sequeLinkImplConnection) {
        this.implCon = sequeLinkImplConnection;
        this.stmtCtxt = new StatementContext(sequeLinkImplConnection.conCtxt);
        this.diagnosticList = new DiagnosticList();
        this.allowBlockFetch = sequeLinkImplConnection.conCtxt.allowBlockFetch();
        this.MSSMapLongToDecimal = sequeLinkImplConnection.conCtxt.MSSMapLongToDecimal();
        this.ORANumber0IsNumeric = sequeLinkImplConnection.conCtxt.ORANumber0IsNumeric();
        this.serverVersion = sequeLinkImplConnection.conCtxt.getServerVersion();
        this.rowid = this._getRowIdColumnName();
        this.allowPreFetch = sequeLinkImplConnection.conCtxt.allowPreFetch();
        this.allowPreFetch &= this.allowBlockFetch;
        try {
            DiagnosticList diagnosticList = DiagnosticList.GetADummyList();
            this.defaultParameterEncoding = sequeLinkImplConnection.conCtxt.getDefaultParameterEncoding(diagnosticList);
            this.supportsCatalogs = sequeLinkImplConnection.conCtxt.supportsCatalogs(diagnosticList);
        }
        catch (SQLException sQLException) {
            this.defaultParameterEncoding = "";
            this.supportsCatalogs = true;
        }
        this.isBadDescribeParam54 = sequeLinkImplConnection.conCtxt.WABadDescribeParam54();
    }

    SequeLinkImplConnection getImplConnection() {
        return this.implCon;
    }

    public void close() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.stmtCtxt.deactivate(this.diagnosticList);
        this.addWarnings();
        if (this.cursorVariables != null) {
            this.cursorVariables.cleanUp();
            this.cursorVariables = null;
        }
        this.parameterVariables = null;
        this.updateCounts = null;
        this.diagnosticList = null;
        this.implCon = null;
        this.stmtCtxt = null;
        this.alreadyClosed = true;
    }

    private void addWarnings() {
        SQLWarning sQLWarning = this.diagnosticList.getSQLWarning();
        if (sQLWarning != null) {
            String[] stringArray = new String[]{sQLWarning.getMessage()};
            do {
                this.warnings.add(6001, stringArray, sQLWarning.getSQLState(), sQLWarning.getErrorCode());
            } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
            this.diagnosticList.clear();
        }
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        if (this.rsn == 999) {
            return new BaseImplResultSetClientSideEmpty();
        }
        this.myMaxRows = this.maxRows;
        return new SequeLinkImplResultSet(this);
    }

    private void nextResult() throws SQLException {
        this.stmtCtxt.nextResult(this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        this.addWarnings();
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.fetchFlag = this.result.isResultSet() ? 1 : 0;
        if (!this.result.isEnd()) {
            this.multipleResults = true;
        }
    }

    void closeCursor() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        if (this.alreadyClosed) {
            return;
        }
        if (this.databaseMetaDataResultSet != 0) {
            return;
        }
        this.stmtCtxt.nextResult(this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        this.addWarnings();
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.fetchFlag = this.result.isResultSet() ? 1 : 0;
        if (!this.result.isEnd()) {
            this.multipleResults = true;
            if (this.result.isResultSet()) {
                this.invalidateCursorVariables();
            }
        }
    }

    public int getNextResultType() throws SQLException {
        int n2 = this.result.getNextResultType();
        if (n2 == 104) {
            this.nextResult();
            n2 = this.result.getNextResultType();
        }
        switch (n2) {
            case 100: {
                return 3;
            }
            case 101: {
                return 2;
            }
            case 102: {
                return 0;
            }
            case 103: {
                return 1;
            }
        }
        throw new InternalError(this.getClass().getName() + " getNextResultType");
    }

    public int getNextRowsAffectedCount() throws SQLException {
        return this.result.getRowCount();
    }

    private int mapDatabaseMetaDataResultSetToRsn() {
        switch (this.databaseMetaDataResultSet) {
            case 1: {
                return 103;
            }
            case 2: {
                return 107;
            }
            case 3: {
                return 116;
            }
            case 4: {
                return 106;
            }
            case 5: {
                return 101;
            }
            case 6: {
                return 102;
            }
            case 7: {
                return 110;
            }
            case 8: {
                if (!this.supportsCatalogs) {
                    return 999;
                }
                return 105;
            }
            case 9: {
                return 108;
            }
            case 10: {
                return 115;
            }
            case 11: {
                return 114;
            }
            case 12: {
                return 113;
            }
            case 13: {
                return 117;
            }
            case 14: {
                return 112;
            }
            case 15: {
                if (this.serverVersion < 0x5030000) {
                    return 104;
                }
                return 118;
            }
            case 16: {
                return 109;
            }
            case 18: {
                return 111;
            }
        }
        return 999;
    }

    private void invalidateCursorVariables() throws SQLException {
        if (this.columnsAreBound) {
            this.stmtCtxt.freeVariables(1, this.diagnosticList);
            this.cursorVariables.cleanUp();
            this.cursorVariables = null;
            this.columnsAreBound = false;
        }
    }

    protected void setSQL(BaseSQL baseSQL) {
        super.setSQL(baseSQL);
        this.sqlChanged = true;
    }

    public void prepare() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        this.invalidateCursorVariables();
        boolean bl = this.sql.getParameterCount() != 0;
        this.stmtCtxt.associate(this.sql.getFormatted(), bl, this.diagnosticList);
        this.addWarnings();
        this.prepared = true;
        this.sqlChanged = false;
    }

    public void execute() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        if (this.multipleResults) {
            this.invalidateCursorVariables();
            this.multipleResults = false;
        }
        if (this.databaseMetaDataResultSet != 0) {
            this.rsn = this.mapDatabaseMetaDataResultSetToRsn();
        }
        if (!this.parametersAreBound) {
            this.bindParameters();
            this.parametersAreBound = true;
        }
        this.bindParameterData();
        if (this.databaseMetaDataResultSet == 0) {
            if (!this.prepared) {
                this.invalidateCursorVariables();
                this.stmtCtxt.execDirect(this.sql.getFormatted(), this.sql.resultType(), this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            } else if (this.sqlChanged) {
                this.invalidateCursorVariables();
                boolean bl = this.sql.getParameterCount() != 0;
                this.stmtCtxt.prepareAndExecute(this.sql.getFormatted(), this.sql.resultType(), bl, this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
                this.sqlChanged = false;
            } else {
                this.stmtCtxt.execute(this.sql.resultType(), this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            }
        } else {
            this.stmtCtxt.execRsn(this.rsn, this.parameterVariables.getNormalInputParams(), this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        }
        this.addWarnings();
        this.result = new Result();
        this.result.setResult(this.stmtCtxt.getResultType(), this.stmtCtxt.getRowCount());
        this.rowsInBatch = 0;
        this.fetchedFromBatch = 0;
        this.fetchedFromCursor = 0;
        this.fetchFlag = 1;
    }

    public void executeBatch() throws BatchUpdateException {
        try {
            this.updateCounts = null;
            if (this.sql.isBatch()) {
                UnSyncVector unSyncVector = new UnSyncVector();
                int n2 = this.sql.batchSize();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.sql.nextBatchStatement();
                    unSyncVector.addElement(this.sql.getFormatted());
                }
                this.updateCounts = this.implCon.executeBatch(unSyncVector, this.diagnosticList);
            } else {
                if (!this.parametersAreBound) {
                    this.bindParameters();
                    this.parametersAreBound = true;
                }
                int n3 = this.bindParameterData();
                this.updateCounts = this.stmtCtxt.executeBatch(n3, this.parameterVariables.getNormalInputParams(), this.diagnosticList);
            }
            this.addWarnings();
            this.result = new Result();
            this.result.setResult(0, -1);
            this.rowsInBatch = 0;
            this.fetchedFromBatch = 0;
            this.fetchedFromCursor = 0;
            this.fetchFlag = 1;
        }
        catch (BatchUpdateException batchUpdateException) {
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            if (this.updateCounts == null) {
                this.updateCounts = new int[0];
            }
            BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.updateCounts);
            batchUpdateException.setNextException(sQLException.getNextException());
            throw batchUpdateException;
        }
    }

    public void reset() throws SQLException {
        if (this.prefetched) {
            this.stmtCtxt.discardFetch(this.diagnosticList);
            this.prefetched = false;
        }
        this.updateCounts = null;
        this.result = null;
        this.diagnosticList.clear();
        this.rowsInBatch = 0;
        this.fetchFlag = 0;
        this.fetchedFromBatch = 0;
        this.fetchedFromCursor = 0;
        this.myMaxRows = 0;
    }

    private SequeLinkColumn makeColumn(SequeLinkColumnDescribe sequeLinkColumnDescribe, boolean bl, boolean bl2) throws SQLException {
        int n2 = sequeLinkColumnDescribe.getType();
        switch (n2) {
            case 12: {
                if (this.databaseMetaDataResultSet == 0) {
                    return new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                }
                return new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize, bl2);
            }
            case 1: {
                return new SequeLinkCharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -1: {
                if (this.maxFieldSize > 0 && this.maxFieldSize <= 4096) {
                    SequeLinkVarcharColumn sequeLinkVarcharColumn = new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarcharColumn.setType(-1);
                    return sequeLinkVarcharColumn;
                }
                int n3 = sequeLinkColumnDescribe.getPrecision();
                if (n3 <= 4096) {
                    SequeLinkVarcharColumn sequeLinkVarcharColumn = new SequeLinkVarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarcharColumn.setType(-1);
                    return sequeLinkVarcharColumn;
                }
                return new SequeLinkLongvarcharColumn(this.stmtCtxt, sequeLinkColumnDescribe);
            }
            case -3: {
                return new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -2: {
                return new SequeLinkBinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -4: {
                if (this.maxFieldSize > 0 && this.maxFieldSize <= 4096) {
                    SequeLinkVarbinaryColumn sequeLinkVarbinaryColumn = new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarbinaryColumn.setType(-4);
                    return sequeLinkVarbinaryColumn;
                }
                int n4 = sequeLinkColumnDescribe.getPrecision();
                if (n4 <= 4096) {
                    SequeLinkVarbinaryColumn sequeLinkVarbinaryColumn = new SequeLinkVarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                    sequeLinkVarbinaryColumn.setType(-4);
                    return sequeLinkVarbinaryColumn;
                }
                return new SequeLinkLongvarbinaryColumn(this.stmtCtxt, sequeLinkColumnDescribe);
            }
            case 2: 
            case 3: {
                SequeLinkNumericColumn sequeLinkNumericColumn = new SequeLinkNumericColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n2 != 2) {
                    sequeLinkNumericColumn.setType(n2);
                }
                return sequeLinkNumericColumn;
            }
            case -5: {
                return new SequeLinkBigintColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -7: {
                return new SequeLinkBitColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case -6: 
            case 4: 
            case 5: {
                SequeLinkIntegerColumn sequeLinkIntegerColumn = bl ? new SequeLinkDatatypeColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize) : new SequeLinkIntegerColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n2 != 4) {
                    sequeLinkIntegerColumn.setType(n2);
                }
                return sequeLinkIntegerColumn;
            }
            case 7: {
                return new SequeLinkRealColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 6: 
            case 8: {
                SequeLinkDoubleColumn sequeLinkDoubleColumn = new SequeLinkDoubleColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
                if (n2 != 8) {
                    sequeLinkDoubleColumn.setType(n2);
                }
                return sequeLinkDoubleColumn;
            }
            case 91: {
                return new SequeLinkDateColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 92: {
                return new SequeLinkTimeColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 93: {
                return new SequeLinkTimestampColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.maxFieldSize);
            }
            case 2004: {
                return new SequeLinkBlobColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.implCon);
            }
            case 2005: {
                return new SequeLinkClobColumn(this.stmtCtxt, sequeLinkColumnDescribe, this.implCon);
            }
        }
        throw Diagnostic.ClientCoreError(7369);
    }

    private SequeLinkParameter makeParameter(int n2, int n3, int n4, int n5) throws SQLException {
        switch (n3) {
            case 1: 
            case 12: {
                SequeLinkVarcharParameter sequeLinkVarcharParameter = new SequeLinkVarcharParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
                if (n3 != 12) {
                    sequeLinkVarcharParameter.setType(n3);
                }
                return sequeLinkVarcharParameter;
            }
            case -1: {
                return new SequeLinkLongvarcharParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case -3: 
            case -2: {
                SequeLinkVarbinaryParameter sequeLinkVarbinaryParameter = new SequeLinkVarbinaryParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
                if (n3 != -3) {
                    sequeLinkVarbinaryParameter.setType(n3);
                }
                return sequeLinkVarbinaryParameter;
            }
            case -4: {
                return new SequeLinkLongvarbinaryParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 2: 
            case 3: {
                SequeLinkNumericParameter sequeLinkNumericParameter = new SequeLinkNumericParameter(this.stmtCtxt, n2, n4, n5, this.implCon.exceptions);
                if (n3 != 2) {
                    sequeLinkNumericParameter.setType(n3);
                }
                return sequeLinkNumericParameter;
            }
            case -5: {
                if (this.MSSMapLongToDecimal) {
                    SequeLinkNumericParameter sequeLinkNumericParameter = new SequeLinkNumericParameter(this.stmtCtxt, n2, 0, n5, this.implCon.exceptions);
                    sequeLinkNumericParameter.setType(3);
                    return sequeLinkNumericParameter;
                }
                return new SequeLinkBigintParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case -7: {
                return new SequeLinkBitParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case -6: 
            case 4: 
            case 5: {
                SequeLinkIntegerParameter sequeLinkIntegerParameter = new SequeLinkIntegerParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
                if (n3 != 4) {
                    sequeLinkIntegerParameter.setType(n3);
                }
                return sequeLinkIntegerParameter;
            }
            case 7: {
                return new SequeLinkRealParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 6: 
            case 8: {
                SequeLinkDoubleParameter sequeLinkDoubleParameter = new SequeLinkDoubleParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
                if (n3 != 8) {
                    sequeLinkDoubleParameter.setType(n3);
                }
                return sequeLinkDoubleParameter;
            }
            case 91: {
                return new SequeLinkDateParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 92: {
                return new SequeLinkTimeParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 93: {
                return new SequeLinkTimestampParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 2004: {
                if (this.implCon.supportsLobsNatively()) {
                    return new SequeLinkBlobParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions, this.implCon);
                }
                return new SequeLinkLongvarbinaryParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
            case 2005: {
                if (this.implCon.supportsLobsNatively()) {
                    return new SequeLinkClobParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions, this.implCon);
                }
                return new SequeLinkLongvarcharParameter(this.stmtCtxt, n2, n5, this.implCon.exceptions);
            }
        }
        throw Diagnostic.ClientCoreError(7369);
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.cursorVariables != null) {
            this.cursorVariables.cleanUp();
        }
        this.cursorVariables = new SequeLinkColumns();
        if (baseColumns == null) {
            VariableDescriptor[][] variableDescriptorArray = this.stmtCtxt.getDescribeCursor(this.diagnosticList);
            if (variableDescriptorArray == null) {
                return null;
            }
            int n2 = variableDescriptorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2 + 1;
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(variableDescriptorArray[n3 - 1], n3, this.ORANumber0IsNumeric);
                SequeLinkColumn sequeLinkColumn = this.makeColumn(sequeLinkColumnDescribe, false, false);
                this.cursorVariables.add(sequeLinkColumn);
            }
        } else {
            int n4;
            int n5;
            int n6 = this.databaseMetaDataResultSet == 7 ? 8 : (this.databaseMetaDataResultSet == 18 ? 8 : (this.databaseMetaDataResultSet == 13 ? 13 : baseColumns.count(0)));
            int n7 = n6;
            if (this.databaseMetaDataResultSet == 15) {
                if (this.rsn == 104) {
                    n7 = 1;
                }
            } else if (this.databaseMetaDataResultSet == 2) {
                n7 = 18;
            } else if (this.databaseMetaDataResultSet == 1) {
                n7 = 5;
            }
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = n5 + 1;
                boolean bl = false;
                boolean bl2 = false;
                switch (this.databaseMetaDataResultSet) {
                    case 7: {
                        bl2 = n4 == 3;
                        break;
                    }
                    case 9: {
                        bl = n4 <= 4;
                        bl |= n4 == 8;
                        break;
                    }
                    case 2: {
                        bl = n4 <= 3;
                        bl |= n4 == 18;
                        bl2 = n4 == 5;
                        break;
                    }
                    case 10: {
                        bl = n4 >= 1 && n4 <= 8;
                        break;
                    }
                    case 11: {
                        bl = n4 >= 1 && n4 <= 8;
                        break;
                    }
                    case 12: {
                        bl = n4 >= 1 && n4 <= 8;
                        break;
                    }
                    case 13: {
                        bl = n4 <= 3;
                        bl |= n4 == 5;
                        bl |= n4 == 10;
                        break;
                    }
                    case 14: {
                        bl = n4 <= 3;
                        break;
                    }
                    case 6: {
                        bl = n4 <= 3;
                        bl2 = n4 == 6;
                        break;
                    }
                    case 5: {
                        bl = n4 <= 2;
                        break;
                    }
                    case 16: {
                        bl = n4 <= 3 || n4 == 6;
                        break;
                    }
                    case 1: {
                        bl = n4 <= 2;
                        bl |= n4 == 4;
                        break;
                    }
                    case 17: {
                        bl = n4 <= 3;
                        bl2 = n4 == 5;
                        break;
                    }
                    case 18: {
                        bl2 = n4 == 3;
                    }
                }
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(baseColumns.get(n4), n4);
                SequeLinkColumn sequeLinkColumn = this.makeColumn(sequeLinkColumnDescribe, bl2, bl);
                this.cursorVariables.add(sequeLinkColumn);
            }
            if (this.filterDescriptor != null) {
                this.filterDescriptor.removeAllRestrictions();
            }
            if (this.sortDescriptor != null) {
                this.sortDescriptor.setSatisfied();
            }
            for (n5 = n7; n5 < n6; ++n5) {
                n4 = n5 + 1;
                SequeLinkColumnDescribe sequeLinkColumnDescribe = new SequeLinkColumnDescribe(baseColumns.get(n4), n4);
                SequeLinkPseudoColumn sequeLinkPseudoColumn = new SequeLinkPseudoColumn(this.stmtCtxt, sequeLinkColumnDescribe);
                this.cursorVariables.add(sequeLinkPseudoColumn);
            }
        }
        return this.cursorVariables;
    }

    boolean fetchRow() throws SQLException {
        if (!this.columnsAreBound) {
            this.bindColumns();
            this.columnsAreBound = true;
        }
        this.lastAccessedColumn = 0;
        this.cursorVariables.clearCache();
        if (this.fetchedFromBatch < this.rowsInBatch) {
            ++this.fetchedFromBatch;
            return true;
        }
        return this.fetchBatch();
    }

    private int calculateBatchSize() {
        int n2 = !this.allowBlockFetch || this.cursorVariables.containsLongColumns() ? 1 : Integer.MAX_VALUE;
        if (this.myMaxRows > 0) {
            int n3 = this.myMaxRows - this.fetchedFromCursor;
            n2 = Math.min(n3, n2);
        }
        return n2;
    }

    private boolean fetchBatch() throws SQLException {
        if (this.fetchFlag == 0) {
            return false;
        }
        if (this.myMaxRows > 0 && this.myMaxRows == this.fetchedFromCursor) {
            return false;
        }
        this.cursorVariables.clearData();
        if (this.prefetched) {
            this.stmtCtxt.postFetch(this.diagnosticList);
            this.prefetched = false;
        } else {
            this.stmtCtxt.fetch(this.calculateBatchSize(), this.cursorVariables, this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
        }
        this.rowsInBatch = this.stmtCtxt.getRowCount();
        this.fetchedFromCursor += this.rowsInBatch;
        this.fetchFlag = this.stmtCtxt.getFetchFlag();
        if (this.allowPreFetch && this.fetchFlag == 1 && !this.cursorVariables.containsLongColumns()) {
            this.stmtCtxt.preFetch(this.calculateBatchSize(), this.cursorVariables, this.parameterVariables.getNormalOutputParams(), this.diagnosticList);
            this.prefetched = true;
        }
        if (this.rowsInBatch == 0) {
            this.fetchedFromBatch = 0;
            return false;
        }
        this.fetchedFromBatch = 1;
        return true;
    }

    private void bindColumns() throws SQLException {
        if (this.cursorVariables == null) {
            throw new InternalError(this.getClass().getName() + " bindColumns");
        }
        if (this.cursorVariables.containsNormalColumns()) {
            this.stmtCtxt.extendedDefine(this.cursorVariables.getNormalColumns(), this.diagnosticList);
        }
    }

    private SequeLinkParameter makeParameter(BaseParameter baseParameter, BaseParameter baseParameter2, int n2) throws SQLException {
        int n3;
        int n4;
        int n5;
        if (baseParameter != null && baseParameter2 != null) {
            n5 = 6;
            n4 = baseParameter2.sqlType;
            n3 = baseParameter2.scale;
        } else if (baseParameter != null) {
            n5 = 2;
            n4 = baseParameter.sqlType;
            n3 = 0;
        } else if (baseParameter2 != null) {
            n5 = 5;
            n4 = baseParameter2.sqlType;
            n3 = baseParameter2.scale;
        } else {
            throw new InternalError(this.getClass().getName() + " makeParameter");
        }
        return this.makeParameter(n2, n4, n3, n5);
    }

    private void bindParameters() throws SQLException {
        this.parameterVariables = new SequeLinkParameters();
        if (this.databaseMetaDataResultSet == 0) {
            this.bindParametersNormal();
        } else {
            this.bindParametersDDA();
        }
        if (this.parameterVariables.containsNormalParameters()) {
            this.stmtCtxt.extendedDefine(this.parameterVariables.getNormalParams(), this.diagnosticList);
        }
    }

    private void bindParametersNormal() throws SQLException {
        int n2;
        if (this.parameterSets == null) {
            return;
        }
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        if (baseParameters == null) {
            return;
        }
        int n3 = baseParameters.count();
        if (n3 == 0) {
            return;
        }
        VariableDescriptor[][] variableDescriptorArray = null;
        if (this.stmtCtxt.hasDescribeParam() && (n2 = (variableDescriptorArray = this.stmtCtxt.getDescribeParam(DiagnosticList.GetADummyList())).length) != n3) {
            throw new InternalError("Framework and SequeLink Server disagree on parameter count");
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            SequeLinkParameter sequeLinkParameter = this.makeParameter(baseParameters.get(n2, 1), baseParameters.get(n2, 2), n2);
            this.parameterVariables.add(sequeLinkParameter);
            if (variableDescriptorArray != null) {
                SequeLinkParamDescribe sequeLinkParamDescribe = new SequeLinkParamDescribe(variableDescriptorArray[n2 - 1], n2, this.isBadDescribeParam54);
                sequeLinkParameter.overrideEncoding(sequeLinkParamDescribe.getEncoding());
                continue;
            }
            sequeLinkParameter.overrideEncoding(this.defaultParameterEncoding);
        }
    }

    private boolean isCatalogParam(int n2) {
        int n3 = n2 + 1;
        switch (this.databaseMetaDataResultSet) {
            case 1: {
                return n3 == 1;
            }
            case 2: {
                return n3 == 1;
            }
            case 5: {
                return n3 == 1;
            }
            case 6: {
                return n3 == 1;
            }
            case 7: {
                return n3 == 1;
            }
            case 9: {
                return n3 == 1;
            }
            case 10: {
                return n3 == 1 || n3 == 4;
            }
            case 11: {
                return n3 == 1;
            }
            case 12: {
                return n3 == 1;
            }
            case 13: {
                return n3 == 1;
            }
            case 14: {
                return n3 == 1;
            }
            case 16: {
                return n3 == 1;
            }
            case 18: {
                return n3 == 1;
            }
        }
        return false;
    }

    private void bindParametersDDA() throws SQLException {
        int n2 = this.filterDescriptor == null ? 0 : this.filterDescriptor.getRestrictionCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            String[] stringArray;
            int n3;
            int n4;
            Object object2 = this.filterDescriptor.getRestrictionByIndex(i2);
            if (this.isCatalogParam(i2) && !this.supportsCatalogs && object2 != null) {
                throw Message.Gen.getSqlException(7474);
            }
            if (object2 == null || object2 instanceof String) {
                n4 = 12;
                n3 = 10;
            } else if (object2 instanceof Boolean) {
                n4 = -7;
                n3 = 9;
            } else if (object2 instanceof Integer) {
                n4 = 4;
                n3 = 4;
            } else if (object2 instanceof String[]) {
                stringArray = (String[])object2;
                object = new StringBuffer();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (((StringBuffer)object).length() != 0) {
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(stringArray[i3]);
                }
                if (((StringBuffer)object).length() == 0) {
                    this.rsn = 999;
                }
                object2 = ((StringBuffer)object).toString();
                n4 = 12;
                n3 = 10;
            } else {
                throw new InternalError(this.getClass().getName() + " bindParametersDDA - unexpected object " + object2.getClass().getName());
            }
            stringArray = new BaseParameter(n4, n3, object2);
            object = this.makeParameter((BaseParameter)stringArray, null, i2 + 1);
            this.parameterVariables.add((SequeLinkParameter)object);
            ((SequeLinkParameter)object).setDataIn((BaseParameter)stringArray);
        }
    }

    private int bindParameterData() throws SQLException {
        if (this.parameterSets == null) {
            return 0;
        }
        int n2 = this.parameterSets.size();
        if (n2 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(i2);
            if (baseParameters == null) {
                return n2;
            }
            int n3 = baseParameters.count();
            if (n3 == 0) {
                return n2;
            }
            int n4 = 0;
            int n5 = 0;
            UnSyncVector unSyncVector = this.parameterVariables.getInputParams();
            UnSyncVector unSyncVector2 = this.parameterVariables.getOutputParams();
            for (int i3 = 1; i3 <= n3; ++i3) {
                SequeLinkParameter sequeLinkParameter;
                BaseParameter baseParameter = baseParameters.get(i3, 1);
                BaseParameter baseParameter2 = baseParameters.get(i3, 2);
                if (baseParameter != null) {
                    sequeLinkParameter = (SequeLinkParameter)unSyncVector.elementAt(n4++);
                    if (i2 == 0 && n2 > 1) {
                        sequeLinkParameter.setBatch();
                    }
                    sequeLinkParameter.setDataIn(baseParameter);
                    if (sequeLinkParameter.isLong()) {
                        SequeLinkStreamParameter sequeLinkStreamParameter = (SequeLinkStreamParameter)sequeLinkParameter;
                        sequeLinkStreamParameter.xfer(this.diagnosticList);
                    }
                }
                if (baseParameter2 == null) continue;
                sequeLinkParameter = (SequeLinkParameter)unSyncVector2.elementAt(n5++);
                sequeLinkParameter.setDataOut(baseParameter2);
            }
        }
        return n2;
    }

    BaseData getData(int n2, int n3) throws SQLException {
        while (this.lastAccessedColumn + 1 < n2) {
            this.cursorVariables.cacheData(++this.lastAccessedColumn, this.fetchedFromBatch - 1, this.diagnosticList);
        }
        BaseData baseData = this.cursorVariables.getData(n2, n3, this.fetchedFromBatch - 1, this.diagnosticList);
        return baseData;
    }

    private String _getRowIdColumnName() {
        String string = this.implCon.getRowIdColumnName(this.diagnosticList);
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getRowIdColumnName() {
        return this.rowid;
    }

    public boolean supportsBatchStatements() {
        return true;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    public int[] getBatchRowsAffectedCount() throws SQLException {
        return this.updateCounts;
    }

    public void cancel() throws SQLException {
        this.stmtCtxt.cancel();
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.stmtCtxt.setQueryTimeout(n2, this.diagnosticList);
    }

    public int getRequiredSQLProcessing(String string) {
        if (string.indexOf(63) >= 0) {
            return 1;
        }
        return 0;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        int n2;
        if (!this.stmtCtxt.supportsDescribeParam()) {
            return;
        }
        VariableDescriptor[][] variableDescriptorArray = this.stmtCtxt.getDescribeParam(this.diagnosticList);
        int n3 = n2 = variableDescriptorArray == null ? 0 : variableDescriptorArray.length;
        if (n2 != baseParameters.count()) {
            throw new InternalError("Framework and SequeLink Server disagree on parameter count");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2 + 1;
            SequeLinkParamDescribe sequeLinkParamDescribe = new SequeLinkParamDescribe(variableDescriptorArray[i2], n4, this.isBadDescribeParam54);
            BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
            baseParameterInfo.sqlType = sequeLinkParamDescribe.getType();
            baseParameterInfo.mode = sequeLinkParamDescribe.getMode();
            baseParameterInfo.nullable = sequeLinkParamDescribe.isNullable();
            baseParameterInfo.signed = sequeLinkParamDescribe.isSigned();
            baseParameterInfo.precision = sequeLinkParamDescribe.getPrecision();
            baseParameterInfo.scale = sequeLinkParamDescribe.getScale();
            baseParameterInfo.nativeTypeName = sequeLinkParamDescribe.getTypeName();
            baseParameterInfo.typeClassName = sequeLinkParamDescribe.getTypeClassName();
            baseParameters.setParameterInfo(i2, baseParameterInfo);
        }
    }
}

