/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionContext;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.SocketConstants;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactory;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactory;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.client.SocketClientWorkerFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionContext;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstancePool;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import java.util.Properties;

public class SocketServerConnectionFactory
implements ServerConnectionFactory {
    private WorkerPool workerPool;
    private SocketServerInstancePool socketPool;
    private String productName = "Integration Server";
    private ClientSideLogonFactory clientSideLogonFactory;
    private ServiceProxyFactory serviceProxyFactory;

    public SocketServerConnectionFactory(int maxThreads, long asynchtimeToLive, SocketLog log, ClassLoader classLoader, int inputBufferSize, int outputBufferSize, boolean conserveBandwidth, ClientSideLogonFactory clientSideLogonFactory, ServiceProxyFactory serviceProxyFactory, ObjectSocketFactory objectSocketFactory) {
        this(maxThreads, asynchtimeToLive, SocketConstants.getSynchronousTTL(), log, classLoader, inputBufferSize, outputBufferSize, conserveBandwidth, clientSideLogonFactory, serviceProxyFactory, objectSocketFactory);
    }

    public SocketServerConnectionFactory(int maxThreads, long asynchtimeToLive, long synchtimeToLive, SocketLog log, ClassLoader classLoader, int inputBufferSize, int outputBufferSize, boolean conserveBandwidth, ClientSideLogonFactory clientSideLogonFactory, ServiceProxyFactory serviceProxyFactory, ObjectSocketFactory objectSocketFactory) {
        this.workerPool = new WorkerPool("SocketClientQueue", (QueueWorkerFactory)new SocketClientWorkerFactory(), maxThreads, asynchtimeToLive);
        this.socketPool = new SocketServerInstancePool(new SocketServerInstanceFactory(this.workerPool, log, synchtimeToLive, classLoader, inputBufferSize, outputBufferSize, conserveBandwidth, objectSocketFactory));
        this.clientSideLogonFactory = clientSideLogonFactory;
        this.serviceProxyFactory = serviceProxyFactory;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public ServerConnection establishConnection(String connType, Properties connProps) throws ConnectionException, CommunicationException {
        SocketServerConnection connection = new SocketServerConnection(connProps, this.socketPool, this.clientSideLogonFactory, this.serviceProxyFactory);
        try {
            int socketsPerVM = Integer.parseInt(connProps.getProperty("socketsPerVM"));
            connection.setSocketsPerVM(socketsPerVM);
        }
        catch (Exception e) {
            // empty catch block
        }
        connection.connect(this.productName);
        return connection;
    }

    public ServerConnection establishConnection(MMURL url, String productName, String appName, String serviceType, String userName, char[] password) throws ConnectionException, CommunicationException {
        ServerConnection serverConnect = null;
        Properties properties = new Properties();
        properties.setProperty("host", url.getHosts());
        properties.setProperty("port", url.getPorts());
        properties.setProperty("serverURL", url.getAppServerURL());
        properties.setProperty("ApplicationName", appName);
        properties.setProperty("serviceType", serviceType);
        properties.setProperty("user", userName);
        properties.setProperty("password", String.valueOf(password));
        this.productName = productName;
        serverConnect = this.establishConnection(null, properties);
        return serverConnect;
    }

    public ServerConnection establishConnection(MMURL url, String productName, String appName, String serviceType, String userName, char[] password, String vdbName, String vdbVersion) throws ConnectionException, CommunicationException {
        ServerConnection serverConnect = null;
        Properties properties = new Properties();
        properties.setProperty("host", url.getHosts());
        properties.setProperty("port", url.getPorts());
        properties.setProperty("serverURL", url.getAppServerURL());
        properties.setProperty("ApplicationName", appName);
        properties.setProperty("serviceType", serviceType);
        properties.setProperty("user", userName);
        properties.setProperty("password", String.valueOf(password));
        properties.setProperty("VirtualDatabaseName", vdbName);
        properties.setProperty("VirtualDatabaseVersion", vdbVersion);
        this.productName = productName;
        serverConnect = this.establishConnection(null, properties);
        return serverConnect;
    }

    public ServerConnection reestablishConnection(String contextPortableString, Properties connProps) throws CommunicationException {
        SocketServerConnectionContext socketContext = new SocketServerConnectionContext(contextPortableString);
        SocketServerConnection connection = new SocketServerConnection(connProps, this.socketPool, this.clientSideLogonFactory, this.serviceProxyFactory, socketContext);
        try {
            int socketsPerVM = Integer.parseInt(connProps.getProperty("socketsPerVM"));
            connection.setSocketsPerVM(socketsPerVM);
        }
        catch (Exception e) {
            // empty catch block
        }
        return connection;
    }

    public ServerConnection reestablishConnection(String contextPortableString, MMURL url, String productName, String appName, String serviceType, String userName, char[] password, String vdbName, String vdbVersion) throws ConnectionException, CommunicationException {
        Properties properties = new Properties();
        properties.setProperty("host", url.getHosts());
        properties.setProperty("port", url.getPorts());
        properties.setProperty("serverURL", url.getAppServerURL());
        properties.setProperty("ApplicationName", appName);
        properties.setProperty("serviceType", serviceType);
        properties.setProperty("user", userName);
        properties.setProperty("password", String.valueOf(password));
        properties.setProperty("VirtualDatabaseName", vdbName);
        properties.setProperty("VirtualDatabaseVersion", vdbVersion);
        this.productName = productName;
        return this.reestablishConnection(contextPortableString, properties);
    }

    public ServerConnectionContext createConnectionContext(String contextString) {
        return new SocketServerConnectionContext(contextString);
    }

    public SocketServerInstancePool getSocketServerInstancePool() {
        return this.socketPool;
    }
}

