/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public final class RawDSA
extends Signature {
    private static final boolean l = false;
    private static final BigInteger k;
    private static final BigInteger j;
    private byte[] f;
    private byte[] h = new byte[20];
    private int g;
    private SecureRandom c;
    private BigInteger i;
    private BigInteger d;
    private BigInteger e;
    private BigInteger a;
    private BigInteger b;

    private void a(DSAParams dSAParams) {
        this.e = dSAParams.getP();
        this.d = dSAParams.getQ();
        this.i = dSAParams.getG();
    }

    private BigInteger d(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.modInverse(this.d);
        return bigInteger3;
    }

    private BigInteger c(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.i.modPow(bigInteger, this.e);
        BigInteger bigInteger4 = this.a.modPow(bigInteger2, this.e);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.mod(this.e);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger3);
        BigInteger bigInteger5 = bigInteger4.mod(this.d);
        return bigInteger5;
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = new BigInteger(1, this.h);
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger5.mod(this.d);
        return bigInteger6;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.modInverse(this.d);
        BigInteger bigInteger4 = new BigInteger(1, this.h);
        BigInteger bigInteger5 = this.b.multiply(bigInteger2);
        BigInteger bigInteger6 = bigInteger4.add(bigInteger5);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger7.mod(this.d);
        return bigInteger8;
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.i.modPow(bigInteger, this.e);
        BigInteger bigInteger3 = bigInteger2.mod(this.d);
        return bigInteger3;
    }

    private BigInteger a() {
        BigInteger bigInteger;
        if (this.f == null) {
            int n2 = this.d.bitLength() + 8;
            bigInteger = new BigInteger(n2, this.c);
        } else {
            bigInteger = new BigInteger(1, this.f);
            bigInteger = bigInteger.subtract(k);
        }
        BigInteger bigInteger2 = bigInteger.mod(this.d.subtract(k));
        BigInteger bigInteger3 = bigInteger2.add(k);
        return bigInteger3;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.g != 20) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
        this.g = 0;
        return this.dsaVerifyRS(this.a(byArray));
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        try {
            int n4 = n2;
            while (n4 < n3) {
                this.h[this.g++] = byArray[n4];
                ++n4;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        try {
            this.h[this.g++] = by;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.g != 20) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
        this.g = 0;
        return this.a(this.dsaSignRS());
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSAParameterSpec");
        }
        this.a((DSAParameterSpec)algorithmParameterSpec);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (string.equals("KSEED")) {
            if (object == null) {
                this.f = null;
                return;
            }
            if (object instanceof byte[]) {
                this.f = (byte[])object;
                return;
            }
            if (object instanceof BigInteger) {
                this.f = ((BigInteger)object).toByteArray();
                return;
            }
            throw new InvalidParameterException("KSEED must be a either a byte array or a BigInteger");
        }
        if (string.equals("DSAParameterSpec")) {
            if (!(object instanceof DSAParameterSpec)) {
                throw new InvalidParameterException("Need a DSAParameterSpec");
            }
            try {
                this.engineSetParameter((DSAParameterSpec)object);
                return;
            }
            catch (Exception exception) {
                throw new InvalidParameterException(exception.getMessage());
            }
        }
        throw new InvalidParameterException("invalid parameter name, use KSEED or DSAParameterSpec");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPublicKey!");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.a = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            this.a(dSAParams);
        }
        this.g = 0;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPrivateKey!");
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.b = dSAPrivateKey.getX();
        this.a(dSAPrivateKey.getParams());
        this.g = 0;
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (string.equals("KSEED")) {
            return this.f;
        }
        throw new InvalidParameterException("invalid parameter, use KSEED");
    }

    public boolean dsaVerifyRS(BigInteger[] bigIntegerArray) {
        return this.dsaVerifyRS(bigIntegerArray[0], bigIntegerArray[1]);
    }

    public boolean dsaVerifyRS(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            return false;
        }
        if (bigInteger.compareTo(this.d) >= 0 || bigInteger2.compareTo(this.d) >= 0) {
            return false;
        }
        BigInteger bigInteger3 = this.d(bigInteger, bigInteger2);
        BigInteger bigInteger4 = this.a(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger5 = this.b(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger6 = this.c(bigInteger4, bigInteger5);
        return bigInteger.equals(bigInteger6);
    }

    public BigInteger[] dsaSignRS() {
        if (this.c == null) {
            this.c = SecRandom.getDefault();
        }
        BigInteger bigInteger = this.a();
        BigInteger bigInteger2 = this.a(bigInteger);
        BigInteger bigInteger3 = this.b(bigInteger, bigInteger2);
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger2, bigInteger3};
        return bigIntegerArray;
    }

    byte[] a(BigInteger[] bigIntegerArray) throws SignatureException {
        return this.a(bigIntegerArray[0], bigIntegerArray[1]);
    }

    byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(bigInteger));
        sEQUENCE.addComponent(new INTEGER(bigInteger2));
        try {
            byte[] byArray = new ASN1(sEQUENCE).toByteArray();
            return byArray;
        }
        catch (CodingException codingException) {
            throw new SignatureException();
        }
    }

    BigInteger[] a(byte[] byArray) throws SignatureException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.toASN1Object().isA(ASN.SEQUENCE) && aSN1.countComponents() == 2) {
                ASN1Object aSN1Object = aSN1.getComponentAt(0);
                ASN1Object aSN1Object2 = aSN1.getComponentAt(1);
                BigInteger bigInteger = (BigInteger)aSN1Object.getValue();
                BigInteger bigInteger2 = (BigInteger)aSN1Object2.getValue();
                BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2};
                return bigIntegerArray;
            }
        }
        catch (Exception exception) {}
        throw new SignatureException();
    }

    public RawDSA() {
        super("RawDSA");
    }

    static {
        j = BigInteger.valueOf(0L);
        k = BigInteger.valueOf(1L);
    }
}

