/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.security.cipher.CAST128WrapParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class CAST128WrapParameters
extends AlgorithmParametersSpi {
    int a;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keyLength: " + this.a + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.a = ((BigInteger)aSN1Object.getValue()).intValue();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CAST128WrapParameterSpec) {
            CAST128WrapParameterSpec cAST128WrapParameterSpec = (CAST128WrapParameterSpec)algorithmParameterSpec;
            this.a = cAST128WrapParameterSpec.getKeyLength();
            return;
        }
        throw new InvalidParameterSpecException("Parameter must be a CAST128WrapParameterSpec.");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CAST128WrapParameterSpec cAST128WrapParameterSpec = new CAST128WrapParameterSpec(this.a);
        if (!cAST128WrapParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return cAST128WrapParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(new INTEGER(this.a));
    }
}

