/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

public class IssuerAndSerialNumber {
    private BigInteger a;
    private Name b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SerialNumber: " + this.a + "\n");
        stringBuffer.append("Issuer: " + this.b + "\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent(new INTEGER(this.a));
        return sEQUENCE;
    }

    public boolean isIssuerOf(X509Certificate x509Certificate) {
        return this.b.equals(x509Certificate.getIssuerDN()) && this.a.compareTo(x509Certificate.getSerialNumber()) == 0;
    }

    public int hashCode() {
        return this.b.hashCode() + this.a.hashCode();
    }

    public BigInteger getSerialNumber() {
        return this.a;
    }

    public Name getIssuer() {
        return this.b;
    }

    public boolean equals(Object object) {
        return object instanceof IssuerAndSerialNumber && this.b.equals(((IssuerAndSerialNumber)object).b) && this.a.compareTo(((IssuerAndSerialNumber)object).a) == 0;
    }

    public IssuerAndSerialNumber(X509Certificate x509Certificate) {
        this.b = (Name)x509Certificate.getIssuerDN();
        this.a = x509Certificate.getSerialNumber();
    }

    public IssuerAndSerialNumber(Name name, BigInteger bigInteger) {
        this.b = name;
        this.a = bigInteger;
    }

    public IssuerAndSerialNumber(ASN1Object aSN1Object) throws CodingException {
        this.b = new Name(aSN1Object.getComponentAt(0));
        this.a = (BigInteger)aSN1Object.getComponentAt(1).getValue();
    }
}

