/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.ClientConnectionWithSessionId;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.server.MessageServiceAgent;
import com.metamatrix.common.comm.platform.socket.StartSessionMessage;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterfaceInterceptorStruct;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MessageFilterServiceAgent
implements ServerListener {
    private ServerListener nextServerListener;
    private Map nameToServiceInterfaceInterceptorStruct = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$ILogon;

    public MessageFilterServiceAgent(ServerListener nextServerListener) {
        this.nextServerListener = nextServerListener;
    }

    public void addServiceInterface(String name, ServiceInterfaceInterceptorStruct struct) {
        this.nameToServiceInterfaceInterceptorStruct.put(name, struct);
    }

    public void connectionAdded(ClientConnection connection) {
        if (this.nextServerListener != null) {
            this.nextServerListener.connectionAdded(connection);
        }
    }

    public void connectionRemoved(ClientConnection connection) {
        if (this.nextServerListener != null) {
            this.nextServerListener.connectionRemoved(connection);
        }
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        if (this.nextServerListener != null) {
            this.nextServerListener.receive(connection, message, messageKey);
        }
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        Message result = null;
        if (message instanceof MessageHolder) {
            ServiceInvocationStruct serviceInvocationStruct;
            ServiceInterfaceInterceptorStruct struct;
            MessageHolder requestMessage = (MessageHolder)message;
            if (requestMessage.contents instanceof ServiceInvocationStruct && (struct = (ServiceInterfaceInterceptorStruct)this.nameToServiceInterfaceInterceptorStruct.get(ServiceEndpoint.getServiceName((ServiceInvocationStruct)(serviceInvocationStruct = (ServiceInvocationStruct)requestMessage.contents)))) != null) {
                result = MessageServiceAgent.receive(connection, message, struct.serviceInterface, struct.interceptors, struct.terminalInterceptor);
                this.handleLogon(connection, serviceInvocationStruct, struct, result);
                return result;
            }
        }
        if (this.nextServerListener != null) {
            result = this.nextServerListener.receive(connection, message);
        }
        return result;
    }

    private void handleLogon(ClientConnection connection, ServiceInvocationStruct siStruct, ServiceInterfaceInterceptorStruct siiStruct, Message result) throws ApplicationException {
        Class serviceInterface = siiStruct.serviceInterface;
        String methodName = siStruct.methodName;
        if (serviceInterface.equals(class$com$metamatrix$platform$security$api$ILogon == null ? (class$com$metamatrix$platform$security$api$ILogon = MessageFilterServiceAgent.class$("com.metamatrix.platform.security.api.ILogon")) : class$com$metamatrix$platform$security$api$ILogon) && methodName.equals("logon") && connection instanceof ClientConnectionWithSessionId && result instanceof MessageHolder) {
            MessageHolder messageHolder = (MessageHolder)result;
            if (messageHolder.contents instanceof LogonResult) {
                LogonResult logonResult = (LogonResult)((MessageHolder)result).contents;
                MetaMatrixSessionID sessionID = logonResult.getSessionID();
                ClientConnectionWithSessionId settableConnection = (ClientConnectionWithSessionId)connection;
                settableConnection.setSessionId((Object)sessionID);
                if (this.nextServerListener != null) {
                    StartSessionMessage startSessionMessage = new StartSessionMessage((Serializable)sessionID);
                    this.nextServerListener.receive(connection, (Message)startSessionMessage);
                }
            }
        }
    }

    public void setNextServerListener(ServerListener nextServerListener) {
        this.nextServerListener = nextServerListener;
    }

    public String toString() {
        return "MessageFilterServiceAgent:  table = " + this.nameToServiceInterfaceInterceptorStruct + " next = " + this.nextServerListener;
    }

    public ServerListener getNextServerListener() {
        return this.nextServerListener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

