/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.XMLProcessorEnvironment;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.HashMap;
import java.util.Map;

public final class XMLPlannerEnvironment {
    public static final Integer XML_FORM_RESULTS_PROPERTY = new Integer(0);
    CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    IDGenerator idGenerator;
    GroupSymbol documentGroup;
    MappingDocument mappingDoc;
    Query xmlCommand;
    AnalysisRecord analysisRecord;
    CommandContext context;
    String xmlFormResults;
    private HashMap stagingResultsInfo = new HashMap();
    private Map globalTempMetadata = new HashMap();
    private Map stagingTableMap = new HashMap();
    private Map queryNodeMap = new HashMap();

    public XMLPlannerEnvironment(QueryMetadataInterface qmi) {
        this.metadata = qmi;
    }

    XMLProcessorEnvironment createProcessorEnvironment(Program mainProgram) {
        XMLProcessorEnvironment processorEnv = new XMLProcessorEnvironment(mainProgram);
        if (this.xmlFormResults != null) {
            processorEnv.setXMLResultsForm(this.xmlFormResults);
        }
        processorEnv.setDocumentGroup(this.documentGroup);
        return processorEnv;
    }

    TempMetadataAdapter getGlobalMetadata() {
        return new TempMetadataAdapter(this.metadata, new TempMetadataStore(this.globalTempMetadata), this.stagingTableMap, this.queryNodeMap);
    }

    public ResultSetInfo getStagingTableResultsInfo(String groupName) {
        ResultSetInfo info = (ResultSetInfo)this.stagingResultsInfo.get(groupName.toUpperCase());
        if (info == null) {
            info = new ResultSetInfo(groupName, true);
            this.stagingResultsInfo.put(info.getResultSetName().toUpperCase(), info);
        }
        return info;
    }

    public void addStagingTable(Object groupId, Object intoGroupId) {
        this.stagingTableMap.put(groupId, intoGroupId);
    }

    public boolean isStagingTable(Object groupId) {
        return this.stagingTableMap.containsKey(groupId);
    }

    public void addToGlobalMetadata(Map data) {
        this.globalTempMetadata.putAll(data);
    }

    public void addQueryNodeToMetadata(Object metadataId, QueryNode node) {
        this.queryNodeMap.put(metadataId, node);
    }

    public String unLoadResultName(String loadName) {
        return "unload_" + loadName;
    }

    public String getStagedResultName(String rsName) {
        return "autostaged_" + rsName.replace('.', '_');
    }

    public String getAliasName(String rsName) {
        String inlineViewName = rsName.replace(".".charAt(0), '_');
        return inlineViewName;
    }
}

