/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.ui.util;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Input;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.webservice.Output;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.undo.ModelerUndoManager;
import com.metamatrix.modeler.internal.ui.util.ModelObjectNotificationHelper;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelIdentifier;
import com.metamatrix.modeler.internal.webservice.ui.IInternalUiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.webservice.ui.editor.OperationObjectEditorPage;
import com.metamatrix.modeler.webservice.ui.util.WebServiceUiUtil;
import com.metamatrix.query.ui.sqleditor.SqlEditorPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;

public class WebServiceNotificationListener
implements INotifyChangedListener,
IInternalUiConstants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$webservice$ui$util$WebServiceNotificationListener == null ? (class$com$metamatrix$modeler$webservice$ui$util$WebServiceNotificationListener = WebServiceNotificationListener.class$("com.metamatrix.modeler.webservice.ui.util.WebServiceNotificationListener")) : class$com$metamatrix$modeler$webservice$ui$util$WebServiceNotificationListener));
    private static final String CONFIRM_SQLUPDATE_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "confirmSQLUpdateTitle");
    private static final String CONFIRM_SQLUPDATE_MSG = IInternalUiConstants.UTIL.getString(I18N_PFX + "confirmSQLUpdateMsg");
    static /* synthetic */ Class class$com$metamatrix$modeler$webservice$ui$util$WebServiceNotificationListener;
    static /* synthetic */ Class class$com$metamatrix$metamodels$webservice$Input;
    static /* synthetic */ Class class$com$metamatrix$metamodels$webservice$Output;

    private void handleNotifications(Collection notifications, Object transactionSource) {
        Iterator noteIter = notifications.iterator();
        block5: while (noteIter.hasNext()) {
            Notification note = (Notification)noteIter.next();
            Object src = note.getNotifier();
            Object newVal = note.getNewValue();
            Object oldVal = note.getOldValue();
            switch (note.getEventType()) {
                case 3: {
                    if (src instanceof Interface && newVal instanceof Operation) {
                        WebServiceUiUtil.initializeProcedure((Operation)newVal, transactionSource, false);
                        break;
                    }
                    this.processChangedXmlDocumentAsSource(src, newVal, true, transactionSource);
                    break;
                }
                case 4: {
                    this.processChangedXmlDocumentAsSource(src, oldVal, false, transactionSource);
                    break;
                }
                case 1: {
                    String sql;
                    SqlTransformationMappingRoot mappingRoot;
                    EObject target;
                    if (src instanceof Input && note.getFeatureID(class$com$metamatrix$metamodels$webservice$Input == null ? WebServiceNotificationListener.class$("com.metamatrix.metamodels.webservice.Input") : class$com$metamatrix$metamodels$webservice$Input) == 1) {
                        boolean shouldReplace = true;
                        if (!(transactionSource instanceof OperationObjectEditorPage.MySqlPanelDropTargetListener) && !(transactionSource instanceof SqlEditorPanel)) {
                            shouldReplace = this.confirmReplaceProcedure();
                        }
                        if (transactionSource instanceof SqlEditorPanel) continue block5;
                        WebServiceUiUtil.initializeProcedure(((Input)src).getOperation(), transactionSource, shouldReplace);
                        break;
                    }
                    if (src instanceof Output && note.getFeatureID(class$com$metamatrix$metamodels$webservice$Output == null ? WebServiceNotificationListener.class$("com.metamatrix.metamodels.webservice.Output") : class$com$metamatrix$metamodels$webservice$Output) == 6) {
                        boolean shouldReplace = true;
                        if (!(transactionSource instanceof OperationObjectEditorPage.MySqlPanelDropTargetListener) && !(transactionSource instanceof SqlEditorPanel)) {
                            shouldReplace = this.confirmReplaceProcedure();
                        }
                        if (transactionSource instanceof SqlEditorPanel) continue block5;
                        WebServiceUiUtil.initializeProcedure(((Output)src).getOperation(), transactionSource, shouldReplace);
                        break;
                    }
                    if (!(transactionSource instanceof SqlEditorPanel) || !(src instanceof SqlTransformation) || newVal != null || (target = (mappingRoot = (SqlTransformationMappingRoot)((EObject)src).eContainer()).getTarget()) == null || !TransformationHelper.isOperation((Object)target) || (sql = SqlMappingRootCache.getSelectSql((EObject)mappingRoot)) != null && sql.trim().length() != 0) break;
                    WebServiceUiUtil.clearXmlDocumentAsSource(mappingRoot, true, transactionSource);
                }
            }
        }
    }

    private boolean confirmReplaceProcedure() {
        boolean replaceProc = false;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
        if (!disableCallbacks) {
            replaceProc = MessageDialog.openQuestion(null, (String)CONFIRM_SQLUPDATE_TITLE, (String)CONFIRM_SQLUPDATE_MSG);
        }
        return replaceProc;
    }

    private void handleUndo(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            // empty if block
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification instanceof SourcedNotification) {
            SourcedNotification note = (SourcedNotification)notification;
            Object src = note.getSource();
            if (src == null || !src.equals(this)) {
                if (src == null) {
                    src = notification.getNotifier();
                }
                if (src instanceof ModelerUndoManager) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleUndo(notifications, src);
                } else {
                    ModelObjectNotificationHelper helper = new ModelObjectNotificationHelper(notification);
                    boolean webServiceModelsChanged = false;
                    Iterator iter = helper.getModifiedResources().iterator();
                    while (iter.hasNext()) {
                        if (!ModelIdentifier.isWebServicesViewModel((IResource)((IResource)iter.next()))) continue;
                        webServiceModelsChanged = true;
                        break;
                    }
                    if (webServiceModelsChanged) {
                        Collection notifications = ((SourcedNotification)notification).getNotifications();
                        this.handleNotifications(notifications, src);
                    }
                }
            }
        } else {
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, notification.getNotifier());
        }
    }

    private void processChangedXmlDocumentAsSource(Object source, Object value, boolean add, Object transactionSource) {
        if (!TransformationHelper.isSqlTransformationMappingRoot((Object)source)) {
            return;
        }
        EObject target = ((SqlTransformationMappingRoot)source).getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        Operation operation = add ? (Operation)target : null;
        XmlDocument xmlDocument = null;
        if (value instanceof List) {
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof XmlDocument)) continue;
                if (xmlDocument == null) {
                    xmlDocument = (XmlDocument)obj;
                    continue;
                }
                xmlDocument = null;
                break;
            }
        } else if (value instanceof XmlDocument) {
            xmlDocument = (XmlDocument)value;
        }
        if (xmlDocument != null && operation != null && operation.getOutput() != null) {
            WebServiceUiUtil.addXmlDocumentAsSource((SqlTransformationMappingRoot)source, xmlDocument, transactionSource);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

