/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.xa;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.DefaultConnectionListener;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCSingleIdentityConnectionFactory;
import com.metamatrix.connector.jdbc.JDBCSourceConnection;
import com.metamatrix.connector.jdbc.xa.JDBCSourceXAConnection;
import com.metamatrix.connector.jdbc.xa.XAConnectionWrapper;
import com.metamatrix.connector.jdbc.xa.XADataSourceWrapper;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.jdbcx.base.BaseDataSource;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class JDBCSingleIdentityDSConnectionFactory
extends JDBCSingleIdentityConnectionFactory {
    private DataSource ds;
    private boolean isXA;
    private String resourceName;
    private TransactionalResource transactionalResource;
    private boolean useExclusiveMode;
    protected ConnectionListener connectionListener = new DefaultConnectionListener();
    static /* synthetic */ Class class$java$lang$String;

    protected void verifyConnectionProperties(Properties connectionProps) throws ConnectorException {
        BaseDataSource baseDs;
        String isXAValue = connectionProps.getProperty("isXA");
        if (isXAValue != null) {
            this.isXA = Boolean.valueOf(isXAValue);
        }
        String useExclusiveModeStr = connectionProps.getProperty("UseConnectionExclusive".toLowerCase(), "true");
        this.useExclusiveMode = Boolean.valueOf(useExclusiveModeStr);
        String dataSourceClassName = connectionProps.getProperty("Driver");
        String username = connectionProps.getProperty("user");
        String password = connectionProps.getProperty("password");
        String serverName = connectionProps.getProperty("serverName");
        String serverPort = connectionProps.getProperty("portNumber");
        StringBuffer dataSourceResourceName = new StringBuffer(connectionProps.getProperty("dataSourceName", "XADS"));
        dataSourceResourceName.append('_');
        dataSourceResourceName.append(serverName);
        dataSourceResourceName.append('_');
        dataSourceResourceName.append(connectionProps.getProperty("ConnectorID"));
        this.resourceName = dataSourceResourceName.toString();
        connectionProps.setProperty("dataSourceName", this.resourceName);
        if (dataSourceClassName == null || dataSourceClassName.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Missing_JDBC_driver_class_name_1"));
        }
        dataSourceClassName = dataSourceClassName.trim();
        if (serverName == null || serverName.trim().length() == 0) {
            serverName = serverName.trim();
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.MissingProp", (Object)"serverName"));
        }
        serverName = serverName.trim();
        if (serverPort == null || serverPort.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.MissingProp", (Object)"portNumber"));
        }
        serverPort = serverPort.trim();
        if (username == null || username.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.MissingProp", (Object)"user"));
        }
        username = username.trim();
        if (password == null || password.trim().length() == 0) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.MissingProp", (Object)"password"));
        }
        password = password.trim();
        try {
            baseDs = (BaseDataSource)Class.forName(dataSourceClassName).newInstance();
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e, JDBCPlugin.Util.getString("JDBCSourceConnectionFactory.Unable_to_load_the_JDBC_driver_class_6", (Object)dataSourceClassName));
        }
        this.setDSProperties(connectionProps, (DataSource)baseDs);
        this.ds = baseDs;
    }

    public SourceConnection createConnection(ConnectorIdentity id) throws ConnectorException {
        try {
            if (this.isXA) {
                XAConnection conn = ((XADataSource)((Object)this.ds)).getXAConnection();
                if (this.getTransactionIsolation() != Integer.MIN_VALUE && this.getTransactionIsolation() != 0) {
                    conn.getConnection().setTransactionIsolation(this.getTransactionIsolation());
                }
                JDBCSourceXAConnection jConn = null;
                if (this.useExclusiveMode) {
                    jConn = new JDBCSourceXAConnection(conn.getConnection(), this.getConnectorEnvironment(), this.useExclusiveMode, this.createConnectionStrategy(), this.getConnectionListener());
                    XAConnectionWrapper wrapper = new XAConnectionWrapper(conn, jConn, this.resourceName);
                    wrapper.getXAResource();
                    jConn.setXAConnection((XAConnection)wrapper);
                } else {
                    jConn = new JDBCSourceXAConnection(conn.getConnection(), this.getConnectorEnvironment(), this.useExclusiveMode, this.createConnectionStrategy(), this.getConnectionListener());
                }
                return jConn;
            }
            Connection conn = this.ds.getConnection();
            if (this.getTransactionIsolation() != Integer.MIN_VALUE && this.getTransactionIsolation() != 0) {
                conn.setTransactionIsolation(this.getTransactionIsolation());
            }
            return new JDBCSourceConnection(conn, this.getConnectorEnvironment(), this.createConnectionStrategy(), this.getConnectionListener());
        }
        catch (SQLException se) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)se));
        }
    }

    protected synchronized Object getRecoverableResource() {
        if (this.transactionalResource == null) {
            try {
                if (this.useExclusiveMode) {
                    JDBCSourceXAConnection xaConn = (JDBCSourceXAConnection)this.createConnection(null);
                    this.transactionalResource = new JdbcTransactionalResource(this.resourceName + "_" + xaConn.hashCode(), (XADataSource)new XADataSourceWrapper((XADataSource)((Object)this.ds), xaConn, this.resourceName));
                } else {
                    this.transactionalResource = new JdbcTransactionalResource(this.resourceName + "_" + this.ds.hashCode(), (XADataSource)((Object)this.ds));
                }
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
        }
        return this.transactionalResource;
    }

    protected void setDSProperties(Properties props, DataSource dataSource) throws ConnectorException {
        Properties connProps = this.lowerCaseAllPropNames(props);
        Method[] methods = dataSource.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            String propertyValue;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || (propertyValue = (String)connProps.get((propertyName = methodName.substring(3)).toLowerCase())) == null) continue;
            Class<?> argType = method.getParameterTypes()[0];
            Object[] params = new Object[1];
            if (argType == Integer.TYPE) {
                params[0] = Integer.decode(propertyValue);
            } else if (argType == Boolean.TYPE) {
                params[0] = Boolean.valueOf(propertyValue);
            } else if (argType == (class$java$lang$String == null ? JDBCSingleIdentityDSConnectionFactory.class$("java.lang.String") : class$java$lang$String)) {
                params[0] = propertyValue;
            }
            try {
                method.invoke((Object)dataSource, params);
                continue;
            }
            catch (Throwable e) {
                Object[] msgParams = new Object[]{propertyName, propertyValue};
                String msg = JDBCPlugin.Util.getString("JDBCSingleIdentityDSConnectionFactory.Unable_to_set_DataSource_property", msgParams);
                throw new ConnectorException(msg);
            }
        }
    }

    private Properties lowerCaseAllPropNames(Properties connectionProps) {
        Properties lcProps = new Properties();
        Iterator<Object> itr = connectionProps.keySet().iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            Object propValue = connectionProps.get(name);
            if (!(propValue instanceof String)) continue;
            lcProps.setProperty(name.toLowerCase(), (String)propValue);
        }
        return lcProps;
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

