/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolverUtil {
    private ResolverUtil() {
    }

    public static String getCommonType(String[] typeNames) {
        int i;
        if (typeNames == null || typeNames.length == 0) {
            return null;
        }
        if (typeNames.length == 1) {
            return typeNames[0];
        }
        ArrayList<String> commonConversions = new ArrayList<String>(DataTypeManager.getImplicitConversions((String)typeNames[0]));
        commonConversions.add(typeNames[0]);
        ArrayList<String> conversions = null;
        for (i = 1; i < typeNames.length; ++i) {
            conversions = new ArrayList<String>(DataTypeManager.getImplicitConversions((String)typeNames[i]));
            conversions.add(typeNames[i]);
            commonConversions.retainAll(conversions);
        }
        if (commonConversions.size() > 0) {
            for (i = 0; i < typeNames.length; ++i) {
                if (!commonConversions.contains(typeNames[i])) continue;
                return typeNames[i];
            }
            return (String)commonConversions.get(commonConversions.size() - 1);
        }
        return null;
    }

    public static boolean canImplicitlyConvert(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        List implicitConversions = DataTypeManager.getImplicitConversions((String)fromType);
        return implicitConversions.contains(toType);
    }

    public static Function resolveExpressionOfType(Expression expression, String tgtType) throws QueryResolverException {
        String srcType = DataTypeManager.getDataTypeName((Class)expression.getType());
        if (ResolverUtil.canImplicitlyConvert(srcType, tgtType)) {
            return ResolverUtil.getConversion(srcType, tgtType, expression);
        }
        throw new QueryResolverException("ERR.015.008.0041", QueryPlugin.Util.getString("ERR.015.008.0041", new Object[]{tgtType, expression, srcType}));
    }

    public static Expression convertExpression(Expression sourceExpression, String targetTypeName) {
        return ResolverUtil.convertExpression(sourceExpression, DataTypeManager.getDataTypeName((Class)sourceExpression.getType()), targetTypeName);
    }

    public static Expression convertExpression(Expression sourceExpression, String sourceTypeName, String targetTypeName) {
        if (sourceTypeName.equals(targetTypeName)) {
            return sourceExpression;
        }
        return ResolverUtil.getConversion(sourceTypeName, targetTypeName, sourceExpression);
    }

    public static Function getConversion(String srcTypeName, String tgtTypeName, Expression expression) {
        Class srcType = DataTypeManager.getDataTypeClass((String)srcTypeName);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)tgtTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)tgtTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        return conversion;
    }

    public static void setTypeIfReference(Expression expression, Class targetType) throws QueryResolverException {
        if (expression.getType() == null) {
            if (expression instanceof Reference && targetType != null) {
                ResolverUtil.setType((Reference)expression, targetType);
            } else {
                throw new QueryResolverException("ERR.015.008.0026", QueryPlugin.Util.getString("ERR.015.008.0026", (Object)expression));
            }
        }
    }

    public static void setTypeToHintIfReference(Expression expression, Class alternateType) throws QueryResolverException {
        if (expression.getType() == null && expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.getTypeHint() != null) {
                ResolverUtil.setType(ref, ref.getTypeHint());
            } else if (alternateType != null) {
                ResolverUtil.setType(ref, alternateType);
            } else {
                throw new QueryResolverException("ERR.015.008.0026", QueryPlugin.Util.getString("ERR.015.008.0026", (Object)expression));
            }
        }
    }

    public static void setType(Reference ref, Class type) {
        Constant dummy = new Constant(null, type);
        ref.setExpression((Expression)dummy);
    }

    public static GroupSymbol findGroup(Set groups, String groupName) {
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            int suffixStart;
            String suffixMatch;
            GroupSymbol group = (GroupSymbol)iter.next();
            String name = group.getName();
            if (!(name.length() == groupName.length() ? name.equalsIgnoreCase(groupName) : name.length() > groupName.length() + 1 && (suffixMatch = name.substring(suffixStart = name.length() - groupName.length())).equalsIgnoreCase(groupName) && name.charAt(suffixStart - 1) == '.')) continue;
            return group;
        }
        return null;
    }

    public static void resolveOrderBy(OrderBy orderBy, List fromClauseGroups, List knownElements, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        String[] knownShortNames = null;
        ArrayList<SingleElementSymbol> newElements = new ArrayList<SingleElementSymbol>();
        List elements = orderBy.getVariables();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol symbol = (ElementSymbol)elementIter.next();
            Object matchedSymbol = null;
            String symbolName = symbol.getName();
            String groupPart = metadata.getGroupName(symbolName);
            if (groupPart != null) {
                String elementPart = metadata.getShortElementName(symbolName);
                matchedSymbol = ResolverUtil.findMatchingElementByName(groupPart, elementPart, knownElements);
            } else {
                int elementOrder;
                if (knownShortNames == null) {
                    knownShortNames = new String[knownElements.size()];
                    for (int i = 0; i < knownElements.size(); ++i) {
                        SingleElementSymbol knownSymbol = (SingleElementSymbol)knownElements.get(i);
                        knownShortNames[i] = knownSymbol.getShortName();
                    }
                }
                for (int i = 0; i < knownShortNames.length; ++i) {
                    if (!knownShortNames[i].equalsIgnoreCase(symbolName)) continue;
                    if (matchedSymbol != null) {
                        throw new QueryResolverException("ERR.015.008.0042", QueryPlugin.Util.getString("ERR.015.008.0042", (Object)symbolName));
                    }
                    matchedSymbol = knownElements.get(i);
                }
                if (matchedSymbol == null && StringUtil.isDigits((String)symbolName) && (elementOrder = Integer.valueOf(symbolName).intValue()) <= knownElements.size() && elementOrder > 0) {
                    matchedSymbol = knownElements.get(elementOrder - 1);
                }
            }
            if (matchedSymbol == null) {
                try {
                    ResolveElementsVisitor.resolveElements((LanguageObject)symbol, (Collection)fromClauseGroups, (QueryMetadataInterface)metadata);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object metadataID = symbol.getMetadataID();
                if (metadataID == null) {
                    throw new QueryResolverException("ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbolName));
                }
                matchedSymbol = ResolverUtil.findMatchingElementByID(symbol, knownElements);
            }
            if (matchedSymbol == null) {
                throw new QueryResolverException("ERR.015.008.0043", QueryPlugin.Util.getString("ERR.015.008.0043", (Object)symbolName));
            }
            newElements.add((SingleElementSymbol)matchedSymbol);
        }
        orderBy.replaceVariables(newElements);
    }

    private static SingleElementSymbol findMatchingElementByName(String groupName, String shortName, List knownElements) {
        for (int i = 0; i < knownElements.size(); ++i) {
            GroupSymbol group;
            ElementSymbol knownElement;
            String knownShortName;
            Object knownSymbol = knownElements.get(i);
            if (!(knownSymbol instanceof ElementSymbol) || !shortName.equalsIgnoreCase(knownShortName = (knownElement = (ElementSymbol)knownSymbol).getShortName()) || !(group = knownElement.getGroupSymbol()).getName().equalsIgnoreCase(groupName)) continue;
            return knownElement;
        }
        return null;
    }

    private static SingleElementSymbol findMatchingElementByID(ElementSymbol symbol, List knownElements) {
        Object elementID = symbol.getMetadataID();
        Object groupID = symbol.getGroupSymbol().getMetadataID();
        for (int i = 0; i < knownElements.size(); ++i) {
            Object knownGroupID;
            ElementSymbol knownElement;
            Object knownElementID;
            Object knownSymbol = knownElements.get(i);
            if (!(knownSymbol instanceof ElementSymbol) || !elementID.equals(knownElementID = (knownElement = (ElementSymbol)knownSymbol).getMetadataID()) || !groupID.equals(knownGroupID = knownElement.getGroupSymbol().getMetadataID())) continue;
            return knownElement;
        }
        return null;
    }

    public static Constant convertConstant(Expression source, Class targetType) {
        String targetTypeName = DataTypeManager.getDataTypeName((Class)targetType);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{source.getType(), DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{source, new Constant((Object)targetTypeName)});
        conversion.setFunctionDescriptor(fd);
        Constant constant = null;
        try {
            Object result = ExpressionEvaluator.evaluate(conversion, null, null);
            constant = new Constant(result, targetType);
        }
        catch (Exception e) {
            return null;
        }
        return constant;
    }

    public static Expression getDefault(ElementSymbol symbol, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException, QueryResolverException {
        Object mid = symbol.getMetadataID();
        Class type = symbol.getType();
        String name = symbol.getCanonicalName();
        Object defaultValue = metadata.getDefaultValue(mid);
        if (defaultValue == null && !metadata.elementSupports(mid, 4)) {
            throw new QueryResolverException(QueryPlugin.Util.getString("ResolverUtil.required_param", (Object)name));
        }
        return ResolverUtil.getProperlyTypedConstant(defaultValue, type);
    }

    /*
     * WARNING - void declaration
     */
    private static Constant getProperlyTypedConstant(Object defaultValue, Class parameterType) throws QueryResolverException {
        void var3_3;
        Object newValue;
        if (defaultValue == null) {
            return new Constant(null, parameterType);
        }
        Transform transform = DataTypeManager.getTransform(defaultValue.getClass(), (Class)parameterType);
        if (transform == null) {
            newValue = defaultValue;
        } else {
            try {
                newValue = transform.transform(defaultValue);
            }
            catch (TransformationException e) {
                throw new QueryResolverException((Throwable)e, QueryPlugin.Util.getString("ExecResolver.param_default_value_type", defaultValue, defaultValue.getClass(), (Object)parameterType));
            }
        }
        return new Constant((Object)var3_3, parameterType);
    }

    public static List resolveElementsInGroup(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        if (group.getResolvedElements() == null) {
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            if (elementIDs == null) {
                throw new QueryResolverException("ERR.015.008.0044", QueryPlugin.Util.getString("ERR.015.008.0044", (Object)group));
            }
            group.setResolvedElements(ResolverUtil.resolveElements(group, metadata, elementIDs));
        }
        return group.getResolvedElements();
    }

    public static List resolveElements(GroupSymbol group, QueryMetadataInterface metadata, List elementIDs) throws MetaMatrixComponentException, QueryMetadataException {
        boolean groupIsAliased;
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        Iterator elementIter = elementIDs.iterator();
        boolean bl = groupIsAliased = group.getDefinition() != null;
        while (elementIter.hasNext()) {
            String elementName;
            Object elementID = elementIter.next();
            String fullName = elementName = metadata.getFullName(elementID);
            if (groupIsAliased) {
                String shortName = metadata.getShortElementName(elementName);
                fullName = metadata.getFullElementName(group.getName(), shortName);
            }
            ElementSymbol element = new ElementSymbol(fullName);
            element.setGroupSymbol(group);
            element.setMetadataID(elementID);
            element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(element.getMetadataID())));
            elements.add(element);
        }
        return elements;
    }

    public static void addProcedureMetadataToStore(GroupSymbol virtualGroup, TempMetadataStore metadataStore, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        List elements = ResolverUtil.resolveElementsInGroup(virtualGroup, metadata);
        metadataStore.addTempGroup(virtualGroup.getName(), elements);
        externalGroups.add(new GroupSymbol(virtualGroup.getName()));
        ArrayList<ElementSymbol> inputElments = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = (ElementSymbol)elements.get(i);
            ElementSymbol inputElement = (ElementSymbol)virtualElmnt.clone();
            inputElments.add(inputElement);
        }
        metadataStore.addTempGroup("INPUT", elements);
        externalGroups.add(new GroupSymbol("INPUT"));
        ArrayList<ElementSymbol> changingElments = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = (ElementSymbol)elements.get(i);
            ElementSymbol changeElement = (ElementSymbol)virtualElmnt.clone();
            changeElement.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            changingElments.add(changeElement);
        }
        metadataStore.addTempGroup("CHANGING", changingElments);
        externalGroups.add(new GroupSymbol("CHANGING"));
    }

    public static boolean autoConvertCheck(String type1, String type2) {
        boolean autoConvert = false;
        if (type1.equals("integer")) {
            if (type2.equals("short") || type2.equals("byte")) {
                autoConvert = true;
            }
        } else if (type1.equals("double") && type2.equals("float")) {
            autoConvert = true;
        }
        return autoConvert;
    }

    public static void resolveElementsInQueryWithoutOrderBy(Query query, Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryResolverException {
        ResolveElementsVisitor.resolveElements((LanguageObject)query.getSelect(), (Collection)groups, (Collection)externalGroups, (QueryMetadataInterface)metadata);
        ResolveElementsVisitor.resolveElements((LanguageObject)query.getFrom(), (Collection)groups, (Collection)externalGroups, (QueryMetadataInterface)metadata);
        ResolveElementsVisitor.resolveElements((LanguageObject)query.getCriteria(), (Collection)groups, (Collection)externalGroups, (QueryMetadataInterface)metadata);
        ResolveElementsVisitor.resolveElements((LanguageObject)query.getGroupBy(), (Collection)groups, (Collection)externalGroups, (QueryMetadataInterface)metadata);
        ResolveElementsVisitor.resolveElements((LanguageObject)query.getHaving(), (Collection)groups, (Collection)externalGroups, (QueryMetadataInterface)metadata);
    }

    public static Collection getAccessPatternElementsInGroups(QueryMetadataInterface metadata, Collection groups, boolean resolve) throws MetaMatrixComponentException, QueryMetadataException {
        return ResolverUtil.getAccessPatternElementsInGroups(metadata, groups, resolve, false);
    }

    public static Collection getAccessPatternElementsInGroups(QueryMetadataInterface metadata, Collection groups, boolean resolve, boolean flatten) throws MetaMatrixComponentException, QueryMetadataException {
        ArrayList<List> patternElements = null;
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            GroupSymbol group = (GroupSymbol)i.next();
            Collection accessPatternIDs = metadata.getAccessPatternsInGroup(group.getMetadataID());
            if (accessPatternIDs == null || accessPatternIDs.size() <= 0) continue;
            Iterator j = accessPatternIDs.iterator();
            if (patternElements == null) {
                patternElements = new ArrayList<List>();
            }
            while (j.hasNext()) {
                List elements = metadata.getElementIDsInAccessPattern(j.next());
                if (resolve) {
                    elements = ResolverUtil.resolveElements(group, metadata, elements);
                }
                if (flatten) {
                    patternElements.addAll(elements);
                    continue;
                }
                patternElements.add(elements);
            }
        }
        return patternElements;
    }

    public static Map getQueryDefaults(Query query, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        return ResolverUtil.getInputMap(query, metadata, true);
    }

    public static Map getInputMap(GroupSymbol group, QueryMetadataInterface metadata, boolean removeAPElements) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        ElementSymbol symbol;
        Collection apElements;
        HashMap<ElementSymbol, Expression> values = new HashMap<ElementSymbol, Expression>();
        ArrayList optionalElements = new ArrayList();
        ArrayList elementIDs = new ArrayList(metadata.getElementIDsInGroupID(group.getMetadataID()));
        Iterator elems = elementIDs.iterator();
        while (elems.hasNext()) {
            Object mid = elems.next();
            if (metadata.isProcedureInputElement(mid)) continue;
            elems.remove();
        }
        if (elementIDs.size() > 0) {
            List resolveElements = ResolverUtil.resolveElements(group, metadata, elementIDs);
            optionalElements.addAll(resolveElements);
        }
        if ((apElements = ResolverUtil.getAccessPatternElementsInGroups(metadata, Arrays.asList(group), true, true)) != null) {
            Iterator apElems = apElements.iterator();
            while (apElems.hasNext()) {
                symbol = (ElementSymbol)elems.next();
                if (!metadata.elementSupports(symbol.getMetadataID(), 0)) continue;
                elems.remove();
            }
            optionalElements.removeAll(apElements);
        }
        Iterator i = optionalElements.iterator();
        while (i.hasNext()) {
            symbol = (ElementSymbol)i.next();
            Expression value = ResolverUtil.getDefault(symbol, metadata);
            values.put(symbol, value);
        }
        if (!removeAPElements && apElements != null) {
            Iterator apElems = apElements.iterator();
            while (apElems.hasNext()) {
                ElementSymbol symbol2 = (ElementSymbol)apElems.next();
                if (!metadata.isProcedureInputElement(symbol2.getMetadataID())) continue;
                values.put(symbol2, null);
            }
        }
        return values;
    }

    public static Map getInputMap(Query query, QueryMetadataInterface metadata, boolean removeAPElements) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        ElementSymbol symbol;
        HashMap<ElementSymbol, Expression> values = new HashMap<ElementSymbol, Expression>();
        if (query.getFrom() == null) {
            return values;
        }
        List groupSymbols = query.getFrom().getGroups();
        if (groupSymbols == null) {
            return values;
        }
        Iterator groupIter = groupSymbols.iterator();
        ArrayList optionalElements = new ArrayList();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            ArrayList elementIDs = new ArrayList(metadata.getElementIDsInGroupID(group.getMetadataID()));
            Iterator elems = elementIDs.iterator();
            while (elems.hasNext()) {
                Object mid = elems.next();
                if (metadata.isProcedureInputElement(mid)) continue;
                elems.remove();
            }
            if (elementIDs.size() <= 0) continue;
            List resolveElements = ResolverUtil.resolveElements(group, metadata, elementIDs);
            optionalElements.addAll(resolveElements);
        }
        Collection apElements = ResolverUtil.getAccessPatternElementsInGroups(metadata, groupSymbols, true, true);
        if (apElements != null) {
            Iterator elems = apElements.iterator();
            while (elems.hasNext()) {
                symbol = (ElementSymbol)elems.next();
                if (!metadata.elementSupports(symbol.getMetadataID(), 0)) continue;
                elems.remove();
            }
            optionalElements.removeAll(apElements);
        }
        Iterator i = optionalElements.iterator();
        while (i.hasNext()) {
            symbol = (ElementSymbol)i.next();
            Expression value = ResolverUtil.getDefault(symbol, metadata);
            values.put(symbol, value);
        }
        if (!removeAPElements && apElements != null) {
            Iterator apElems = apElements.iterator();
            while (apElems.hasNext()) {
                ElementSymbol symbol2 = (ElementSymbol)apElems.next();
                if (!metadata.isProcedureInputElement(symbol2.getMetadataID())) continue;
                values.put(symbol2, null);
            }
        }
        return values;
    }

    public static void resolveLimit(Limit limit) throws QueryResolverException {
        if (limit.getOffset() != null) {
            ResolverUtil.setTypeIfReference(limit.getOffset(), DataTypeManager.DefaultDataClasses.INTEGER);
        }
        ResolverUtil.setTypeIfReference(limit.getRowLimit(), DataTypeManager.DefaultDataClasses.INTEGER);
    }
}

