/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnionQueryResolver
implements CommandResolver {
    static /* synthetic */ Class class$com$metamatrix$common$types$NullType;
    static /* synthetic */ Class class$java$lang$String;

    public void expandCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        SetQuery setQuery = (SetQuery)command;
        Iterator queryIter = setQuery.getQueries().iterator();
        while (queryIter.hasNext()) {
            Command innerCommand = (Command)queryIter.next();
            setQuery.addSubCommand(innerCommand);
        }
    }

    public void findCommandMetadata(Command command, TempMetadataStore discoveredMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
    }

    public void findChildCommandMetadata(Command command, TempMetadataStore childMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
    }

    public void resolveCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        SetQuery setQuery = (SetQuery)command;
        if (setQuery.getOrderBy() != null) {
            List validGroups = Collections.EMPTY_LIST;
            Object firstQueryCommand = setQuery.getSubCommands().iterator().next();
            if (firstQueryCommand instanceof Query) {
                validGroups = ((Query)firstQueryCommand).getFrom().getGroups();
            }
            ResolverUtil.resolveOrderBy(setQuery.getOrderBy(), validGroups, setQuery.getProjectedSymbols(), metadata);
        }
        if (setQuery.getLimit() != null) {
            ResolverUtil.resolveLimit(setQuery.getLimit());
        }
        Iterator queryIter = setQuery.getQueries().iterator();
        ArrayList replacementSubCommands = new ArrayList();
        while (queryIter.hasNext()) {
            Command innerCommand = (Command)queryIter.next();
            replacementSubCommands.addAll(innerCommand.getSubCommands());
            innerCommand.getSubCommands().clear();
            Map mdStore = innerCommand.getTemporaryMetadata();
            if (mdStore == null) continue;
            HashMap setQueryStore = setQuery.getTemporaryMetadata();
            if (setQueryStore == null) {
                setQueryStore = new HashMap();
                setQuery.setTemporaryMetadata(setQueryStore);
            }
            setQueryStore.putAll(mdStore);
        }
        setQuery.getSubCommands().clear();
        setQuery.addSubCommands(replacementSubCommands);
        List setQueries = setQuery.getQueries();
        int setQueriesSize = setQueries.size();
        ArrayList<List> setQueryProjSymbols = new ArrayList<List>();
        for (int i = 0; i < setQueriesSize; ++i) {
            Object query = setQueries.get(i);
            if (!(query instanceof Query)) continue;
            setQueryProjSymbols.add(((Query)query).getSelect().getSymbols());
        }
        if (setQueryProjSymbols.size() > 1) {
            UnionQueryResolver.checkSymbolsTypes(setQueryProjSymbols);
        }
    }

    public Map getVariableValues(Command command, QueryMetadataInterface metadata) {
        return null;
    }

    static void checkSymbolsTypes(List setQueryProjSymbols) throws QueryResolverException {
        int setQueriesSize = setQueryProjSymbols.size();
        int projSymbolsSize = ((List)setQueryProjSymbols.get(0)).size();
        for (int i = 0; i < projSymbolsSize; ++i) {
            ArrayList symbolsToCompare = new ArrayList();
            boolean needTypeConversion = false;
            for (int j = 0; j < setQueriesSize; ++j) {
                List projSymbols = (List)setQueryProjSymbols.get(j);
                if (i == projSymbols.size()) {
                    return;
                }
                Object projSymbol = projSymbols.get(i);
                if (projSymbol instanceof AliasSymbol) {
                    projSymbol = ((AliasSymbol)projSymbol).getSymbol();
                }
                if (projSymbol instanceof ElementSymbol || projSymbol instanceof ExpressionSymbol && !(projSymbol instanceof AggregateSymbol)) {
                    Constant constant;
                    ExpressionSymbol exprSymbol;
                    Expression expr;
                    if (projSymbol instanceof ExpressionSymbol && (expr = (exprSymbol = (ExpressionSymbol)projSymbol).getExpression()) instanceof Constant && (constant = (Constant)expr).getValue() == null) {
                        exprSymbol.setExpression((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.NULL));
                    }
                    if (!needTypeConversion && !symbolsToCompare.isEmpty()) {
                        Class projSymbolType = ((SingleElementSymbol)projSymbol).getType();
                        if (projSymbolType.equals(class$com$metamatrix$common$types$NullType == null ? UnionQueryResolver.class$("com.metamatrix.common.types.NullType") : class$com$metamatrix$common$types$NullType)) {
                            needTypeConversion = true;
                        } else {
                            Iterator iter = symbolsToCompare.iterator();
                            while (iter.hasNext()) {
                                SingleElementSymbol ses = (SingleElementSymbol)iter.next();
                                if (ses == null || ses.getType().equals(projSymbolType)) continue;
                                needTypeConversion = true;
                                break;
                            }
                        }
                    }
                    symbolsToCompare.add(projSymbol);
                    continue;
                }
                symbolsToCompare.add(null);
            }
            if (!needTypeConversion) continue;
            List convertedSymbols = UnionQueryResolver.performTypeConversion(symbolsToCompare);
            for (int j = 0; j < setQueriesSize; ++j) {
                Object convertedSymbol = convertedSymbols.get(j);
                if (convertedSymbol == null) continue;
                List projSymbols = (List)setQueryProjSymbols.get(j);
                Object oriProjSymbol = projSymbols.get(i);
                if (oriProjSymbol instanceof AliasSymbol) {
                    AliasSymbol oriProjSymbolAlias = (AliasSymbol)oriProjSymbol;
                    oriProjSymbolAlias.setSymbol((SingleElementSymbol)convertedSymbol);
                    continue;
                }
                projSymbols.remove(i);
                projSymbols.add(i, convertedSymbol);
            }
        }
    }

    static List performTypeConversion(List symbolsToCompare) throws QueryResolverException {
        ArrayList<Object> convertedSymbols = new ArrayList<Object>();
        boolean gotValidTypeConverson = false;
        for (int i = 0; i < symbolsToCompare.size(); ++i) {
            Object symbolToCompare = symbolsToCompare.get(i);
            if (symbolToCompare == null) continue;
            Class typeToConvert = ((SingleElementSymbol)symbolToCompare).getType();
            if (typeToConvert.equals(class$com$metamatrix$common$types$NullType == null ? UnionQueryResolver.class$("com.metamatrix.common.types.NullType") : class$com$metamatrix$common$types$NullType)) {
                if (i < symbolsToCompare.size() - 1) continue;
                typeToConvert = class$java$lang$String == null ? UnionQueryResolver.class$("java.lang.String") : class$java$lang$String;
            }
            String targetTypeName = DataTypeManager.getDataTypeName((Class)typeToConvert);
            Iterator iter = symbolsToCompare.iterator();
            while (iter.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)iter.next();
                if (ses == null || typeToConvert.equals(ses.getType())) continue;
                String sourceTypeName = DataTypeManager.getDataTypeName((Class)ses.getType());
                if (DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)targetTypeName)) {
                    gotValidTypeConverson = true;
                    continue;
                }
                gotValidTypeConverson = false;
                break;
            }
            if (!gotValidTypeConverson) continue;
            FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
            iter = symbolsToCompare.iterator();
            while (iter.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)iter.next();
                if (ses == null) {
                    convertedSymbols.add(null);
                    continue;
                }
                if (!typeToConvert.equals(ses.getType())) {
                    SingleElementSymbol expr = ses;
                    if (ses instanceof ExpressionSymbol) {
                        expr = ((ExpressionSymbol)ses).getExpression();
                    }
                    FunctionDescriptor fd = library.findFunction("convert", new Class[]{ses.getType(), class$java$lang$String == null ? UnionQueryResolver.class$("java.lang.String") : class$java$lang$String});
                    Function conversion = new Function(fd.getName(), new Expression[]{expr, new Constant((Object)targetTypeName)});
                    conversion.setType(typeToConvert);
                    conversion.setFunctionDescriptor(fd);
                    conversion.makeImplicit();
                    convertedSymbols.add(new ExpressionSymbol(ses.getShortName(), (Expression)conversion));
                    continue;
                }
                convertedSymbols.add(ses);
            }
            break;
        }
        if (!gotValidTypeConverson) {
            throw new QueryResolverException(QueryPlugin.Util.getString("UnionQueryResolver.Implicit_type_conversion_fail", new Object[]{symbolsToCompare}));
        }
        return convertedSymbols;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

