/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRDatabaseCatalog;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRIndexMember;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRType;
import MITI.sdk.MIRTypeValue;
import MITI.util.MIRIterator;
import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.io.BridgeEntityFactory;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.metamodels.relational.Catalog;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.MultiplicityKind;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.View;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Property;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDVariety;

public class BridgeFeatureHelper
implements BridgeConstants {
    private final BridgeEntityFactory entityFactory;
    private final DatatypeManager dtMgr;
    private final XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    private final BridgeImporter importer;
    public static boolean HEADLESS;

    public BridgeFeatureHelper(BridgeEntityFactory entityFactory, BridgeImporter importer) {
        this.entityFactory = entityFactory;
        this.importer = importer;
        this.dtMgr = HEADLESS ? null : ModelerCore.getWorkspaceDatatypeManager();
    }

    public void setValues(Catalog relCat, MIRDatabaseCatalog mirCat) {
        this.doCommon((MIRElement)mirCat, (EObject)relCat);
        if (mirCat.getMajorVersion() != -1) {
            this.entityFactory.addTag((EObject)relCat, "majorVersion", String.valueOf(mirCat.getMajorVersion()), 1);
        }
        if (mirCat.getMinorVersion() != -1) {
            this.entityFactory.addTag((EObject)relCat, "minorVersion", String.valueOf(mirCat.getMinorVersion()), 1);
        }
        if (mirCat.getTertiaryVersion() != -1) {
            this.entityFactory.addTag((EObject)relCat, "tertiaryVersion", String.valueOf(mirCat.getTertiaryVersion()), 1);
        }
        this.entityFactory.addTag((EObject)relCat, "systemType", mirCat.getSystemType(), 1);
    }

    public void setValues(Index relIndex, MIRIndex mirIndex) {
        this.doCommon((MIRElement)mirIndex, (EObject)relIndex);
        if (mirIndex.getDescription() != null) {
            this.entityFactory.addAnnotation((EObject)relIndex, mirIndex.getDescription(), 1);
        }
        MIRIterator indexMembers = mirIndex.getIndexMemberIterator();
        while (indexMembers.hasNext()) {
            MIRIndexMember member = (MIRIndexMember)indexMembers.next();
            MIRAttribute mirAttr = member.getAttribute();
            Object col = this.entityFactory.getPhysicalObject(mirAttr.getUUID());
            if (col == null) {
                String msg;
                StringBuffer attrName = new StringBuffer();
                attrName.append(this.entityFactory.getPhysicalName(mirAttr.getParent()));
                attrName.append(".");
                attrName.append(this.entityFactory.getPhysicalName((MIRObject)mirAttr));
                byte dl = mirAttr.getDesignLevel();
                if (1 == dl) {
                    msg = BridgesPlugin.Util.getString("BridgeEntityFactory.badIndexMember", (Object)relIndex.getName(), (Object)attrName.toString());
                    this.importer.log(msg, 4, null);
                    continue;
                }
                msg = BridgesPlugin.Util.getString("BridgeEntityFactory.badIndexMember2", (Object)attrName.toString(), (Object)relIndex.getName());
                this.importer.log(msg, 4, null);
                continue;
            }
            relIndex.getColumns().add(col);
        }
        this.entityFactory.addTag((EObject)relIndex, "generate", String.valueOf(mirIndex.getGenerate()), 1);
        this.entityFactory.addTag((EObject)relIndex, "unique", String.valueOf(mirIndex.getUnique()), 1);
        this.entityFactory.addTag((EObject)relIndex, "clustered", String.valueOf(mirIndex.getClustered()), 1);
    }

    public void setValues(Column relCol, MIRAttribute mirAttribute) {
        this.doCommon((MIRElement)mirAttribute, (EObject)relCol);
        relCol.setDefaultValue(mirAttribute.getInitialValue());
        relCol.setLength(mirAttribute.getType().getLength());
        if (mirAttribute.getType() != null) {
            relCol.setNativeType(mirAttribute.getType().getNativeDataType());
        }
        this.entityFactory.addTag((EObject)relCol, "initialValue", mirAttribute.getInitialValue(), 1);
        this.entityFactory.addTag((EObject)relCol, "extraConstraint", mirAttribute.getExtraConstraint(), 1);
        this.entityFactory.addTag((EObject)relCol, "optional", String.valueOf(mirAttribute.getOptional()), 1);
    }

    public void setValues(Column relCol, MIRSQLViewAttribute mirAttribute) {
        this.doCommon((MIRElement)mirAttribute, (EObject)relCol);
        relCol.setDefaultValue(mirAttribute.getInitialValue());
        if (mirAttribute.getType() != null) {
            relCol.setLength(mirAttribute.getType().getLength());
            relCol.setNativeType(mirAttribute.getType().getNativeDataType());
        }
        this.entityFactory.addTag((EObject)relCol, "initialValue", mirAttribute.getInitialValue(), 1);
        this.entityFactory.addTag((EObject)relCol, "expression", mirAttribute.getExpression(), 1);
        this.entityFactory.addTag((EObject)relCol, "optional", String.valueOf(mirAttribute.getOptional()), 1);
    }

    public void setValues(View relView, MIRSQLViewEntity mirView) {
        this.doCommon((MIRElement)mirView, (EObject)relView);
        this.entityFactory.addTag((EObject)relView, "ViewStatement", mirView.getViewStatement(), 1);
        this.entityFactory.addTag((EObject)relView, "WhereClause", String.valueOf(mirView.getWhereClause()), 1);
        this.entityFactory.addTag((EObject)relView, "OrderByClause", String.valueOf(mirView.getOrderByClause()), 1);
        this.entityFactory.addTag((EObject)relView, "GroupByClause", String.valueOf(mirView.getGroupByClause()), 1);
        this.entityFactory.addTag((EObject)relView, "HavingClause", String.valueOf(mirView.getHavingClause()), 1);
    }

    public void setValues(UniqueKey uk, MIRCandidateKey mirKey) {
        this.doCommon((MIRElement)mirKey, (EObject)uk);
        MIRIterator fks = mirKey.getForeignKeyIterator();
        while (fks.hasNext()) {
            MIRForeignKey next = (MIRForeignKey)fks.next();
            ForeignKey mmFK = (ForeignKey)this.entityFactory.getPhysicalObject(next.getUUID());
            if (mmFK == null) continue;
            mmFK.setUniqueKey(uk);
        }
        MIRIterator cols = mirKey.getAttributeIterator();
        while (cols.hasNext()) {
            MIRAttribute next = (MIRAttribute)cols.next();
            Column col = (Column)this.entityFactory.getPhysicalObject(next.getUUID());
            if (col == null) continue;
            uk.getColumns().add((Object)col);
            col.setNullable(NullableType.NO_NULLS_LITERAL);
        }
    }

    public void setValues(ForeignKey fk, MIRForeignKey mirKey) {
        this.doCommon((MIRElement)mirKey, (EObject)fk);
        MIRCandidateKey ck = mirKey.getCandidateKey();
        UniqueKey uk = (UniqueKey)this.entityFactory.getPhysicalObject(ck.getUUID());
        if (uk != null) {
            fk.setUniqueKey(uk);
        }
        fk.setForeignKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
        fk.setPrimaryKeyMultiplicity(MultiplicityKind.UNSPECIFIED_LITERAL);
        MIRIterator cols = mirKey.getAttributeIterator();
        while (cols.hasNext()) {
            MIRAttribute next = (MIRAttribute)cols.next();
            Column col = (Column)this.entityFactory.getPhysicalObject(next.getUUID());
            if (col == null) continue;
            fk.getColumns().add((Object)col);
        }
    }

    public void setValues(Property umlProp, MIRAttribute mirAttribute) {
        this.doCommon((MIRElement)mirAttribute, (EObject)umlProp);
        this.entityFactory.addTag((EObject)umlProp, "initialValue", mirAttribute.getInitialValue(), 0);
        this.entityFactory.addTag((EObject)umlProp, "extraConstraint", mirAttribute.getExtraConstraint(), 0);
        this.entityFactory.addTag((EObject)umlProp, "optional", String.valueOf(mirAttribute.getOptional()), 0);
    }

    public void setValues(Class umlClazz, MIRClass mirClass) {
        this.doCommon((MIRElement)mirClass, (EObject)umlClazz);
        if (!mirClass.getCppMultiplicity().equals("0")) {
            this.entityFactory.addTag((EObject)umlClazz, "cppMultiplicity", mirClass.getCppMultiplicity(), 0);
        }
        if (!String.valueOf(mirClass.getCppSpace()).equals("0")) {
            this.entityFactory.addTag((EObject)umlClazz, "cppSpace", String.valueOf(mirClass.getCppSpace()), 0);
        }
        if (!mirClass.getCppPersistent()) {
            this.entityFactory.addTag((EObject)umlClazz, "cppPersistent", String.valueOf(mirClass.getCppPersistent()), 0);
        }
        if (!String.valueOf(mirClass.getCppClassType()).equals("0")) {
            this.entityFactory.addTag((EObject)umlClazz, "cppClassType", String.valueOf(mirClass.getCppClassType()), 0);
        }
        if (!String.valueOf(mirClass.getCppScope()).equals("0")) {
            this.entityFactory.addTag((EObject)umlClazz, "cppScope", String.valueOf(mirClass.getCppScope()), 0);
        }
        if (!String.valueOf(mirClass.getCppConcurrency()).equals("0")) {
            this.entityFactory.addTag((EObject)umlClazz, "cppConcurrency", String.valueOf(mirClass.getCppConcurrency()), 0);
        }
    }

    public void setValues(DataType umlType, MIRType mirType) {
        this.doCommon((MIRElement)mirType, (EObject)umlType);
    }

    public void setValues(XSDSimpleTypeDefinition xsdType, MIRType mirType) {
        this.doCommon((MIRElement)mirType, (EObject)xsdType);
        xsdType.setVariety(XSDVariety.ATOMIC_LITERAL);
        EnterpriseDatatypeInfo edi = this.getEDIForType(xsdType);
        ModelerCore.getModelEditor().setEnterpriseDatatypePropertyValue((EObject)xsdType, (Object)edi);
        this.setLowerBound(xsdType, mirType.getLowerBound());
        this.setUpperBound(xsdType, mirType.getUpperBound());
        this.setScale(xsdType, String.valueOf(mirType.getScale()));
        this.setLength(xsdType, String.valueOf(mirType.getLength()));
        Iterator typeValues = mirType.getTypeValueByPosition().iterator();
        while (typeValues.hasNext()) {
            MIRTypeValue nextVal = (MIRTypeValue)typeValues.next();
            XSDEnumerationFacet enumFacet = this.xsdFactory.createXSDEnumerationFacet();
            enumFacet.setLexicalValue(nextVal.getName());
            xsdType.getFacetContents().add((Object)enumFacet);
        }
        this.entityFactory.addTag((EObject)xsdType, "initialValue", mirType.getInitialValue(), 3);
        this.entityFactory.addTag((EObject)xsdType, "nativeType", mirType.getDataType(), 3);
        this.entityFactory.addTag((EObject)xsdType, "nativeDataType", mirType.getNativeDataType(), 3);
        this.entityFactory.addTag((EObject)xsdType, "nativeLogicalDataType", mirType.getNativeLogicalDataType(), 3);
        this.entityFactory.addTag((EObject)xsdType, "physicalName", mirType.getPhysicalName(), 3);
        this.entityFactory.addTag((EObject)xsdType, "userDefined", String.valueOf(mirType.getUserDefined()), 3);
        this.entityFactory.addTag((EObject)xsdType, "userDataType", String.valueOf(mirType.getUserDataType()), 3);
    }

    private EnterpriseDatatypeInfo getEDIForType(XSDSimpleTypeDefinition type) {
        EnterpriseDatatypeInfo edi = new EnterpriseDatatypeInfo();
        XSDSimpleTypeDefinition superType = type;
        XSDSimpleTypeDefinition enterpriseParent = null;
        while (superType != null && enterpriseParent == null) {
            if (this.dtMgr.isEnterpriseDatatype((EObject)superType)) {
                enterpriseParent = superType;
                continue;
            }
            XSDSimpleTypeDefinition tmp = superType.getBaseTypeDefinition();
            if (tmp != superType) {
                superType = superType.getBaseTypeDefinition();
                continue;
            }
            superType = null;
        }
        if (enterpriseParent != null) {
            edi.setRuntimeTypeFixed(this.dtMgr.getRuntimeTypeFixed(enterpriseParent));
            edi.setRuntimeType(this.dtMgr.getRuntimeTypeName((EObject)enterpriseParent));
        }
        edi.fillWithDefaultValues(type);
        return edi;
    }

    public void setValues(EObject mmEntity, MIRElement mirElement) {
        this.doCommon(mirElement, mmEntity);
    }

    private void doCommon(MIRElement mirElement, EObject mmEntity) {
        if (mirElement == null || mmEntity == null) {
            return;
        }
        int rsrcType = this.entityFactory.getResourceType((Object)mmEntity);
        if (mirElement instanceof MIRModelObject) {
            this.doModelObjectCommon((MIRModelObject)mirElement, mmEntity, rsrcType);
        }
        Iterator notes = mirElement.getNoteByPosition().iterator();
        while (notes.hasNext()) {
            MIRNote nextNote = (MIRNote)notes.next();
            String msg = nextNote.getValue();
            if (msg == null || msg.trim().length() <= 0) continue;
            String tagName = "Note" + nextNote.getPosition();
            this.entityFactory.addTag(mmEntity, tagName, msg);
        }
        if (mirElement.getDescription() != null) {
            this.entityFactory.addAnnotation(mmEntity, mirElement.getDescription(), rsrcType);
        }
        Iterator propertyVals = mirElement.getPropertyValueByPosition().iterator();
        while (propertyVals.hasNext()) {
            MIRPropertyValue pv = (MIRPropertyValue)propertyVals.next();
            String propertyName = pv.getName();
            String propertyValue = pv.getValue();
            MIRPropertyType mirPropType = pv.getPropertyType();
            this.entityFactory.processPropertyType(mmEntity, mirPropType);
            if (propertyName == null || propertyValue == null) continue;
            this.entityFactory.addTag(mmEntity, propertyName, propertyValue, rsrcType);
        }
    }

    private void doModelObjectCommon(MIRModelObject mirMO, EObject mmEntity, int rsrcType) {
        String comment = mirMO.getComment();
        if (comment != null) {
            this.entityFactory.addAnnotation(mmEntity, comment, rsrcType);
        }
        if (!String.valueOf(mirMO.getStatus()).equals("2")) {
            this.entityFactory.addTag(mmEntity, "status", String.valueOf(mirMO.getStatus()), rsrcType);
        }
        MIRIterator synonyms = mirMO.getSynonymIterator();
        int count = 1;
        while (synonyms.hasNext()) {
            MIRSynonym next = (MIRSynonym)synonyms.next();
            String name = next.getName() + count++;
            this.entityFactory.addTag(mmEntity, "synonym", name, rsrcType);
        }
    }

    private void setLength(XSDSimpleTypeDefinition type, String length) {
        if (HEADLESS) {
            return;
        }
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDTotalDigitsFacet facet = type.getTotalDigitsFacet() == null ? this.xsdFactory.createXSDTotalDigitsFacet() : type.getTotalDigitsFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(length);
        } else {
            XSDLengthFacet facet = type.getLengthFacet() == null ? this.xsdFactory.createXSDLengthFacet() : type.getLengthFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(length);
        }
    }

    private void setUpperBound(XSDSimpleTypeDefinition type, String upperBound) {
        if (HEADLESS) {
            return;
        }
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDMaxInclusiveFacet facet = type.getMaxInclusiveFacet() == null ? this.xsdFactory.createXSDMaxInclusiveFacet() : type.getMaxInclusiveFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(upperBound);
        }
    }

    private void setLowerBound(XSDSimpleTypeDefinition type, String lowerBound) {
        if (HEADLESS) {
            return;
        }
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDMinInclusiveFacet facet = type.getMinInclusiveFacet() == null ? this.xsdFactory.createXSDMinInclusiveFacet() : type.getMinInclusiveFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(lowerBound);
        }
    }

    private void setScale(XSDSimpleTypeDefinition type, String scale) {
        if (HEADLESS) {
            return;
        }
        boolean isNumeric = this.dtMgr.isNumeric((EObject)type);
        if (isNumeric) {
            XSDFractionDigitsFacet facet = type.getFractionDigitsFacet() == null ? this.xsdFactory.createXSDFractionDigitsFacet() : type.getFractionDigitsFacet();
            type.getFacetContents().add((Object)facet);
            facet.setLexicalValue(scale);
        }
    }
}

